!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: obssymbolkeyvaluedict.gs,v 1.4 2008-01-09 22:50:13 stever Exp $
!
! Superclass Hierarchy:
!   ObsoleteSymbolKeyValueDictionary, StringKeyValueDictionary, 
!   KeyValueDictionary, AbstractDictionary, Collection, Object.
!
!=========================================================================

removeallmethods ObsoleteSymbolKeyValueDictionary
removeallclassmethods ObsoleteSymbolKeyValueDictionary

category: 'For Documentation Installation only'
classmethod: ObsoleteSymbolKeyValueDictionary
installDocumentation

| doc txt |

doc := GsClassDocumentation _newForObsoleteGsClass: self asOfGsVersion: '5.0'.

txt := (GsDocText new) details:
'Existing instances should be migrated to SymbolKeyValueDictionary or otherwise
 processed as required, and then should be removed.' .
doc documentClassWith: txt.

self description: doc.
%

category: 'Updating'
method: ObsoleteSymbolKeyValueDictionary
at: aKey put: aValue

"Stores the aKey/aValue pair in the receiver.  If aKey is a CharacterCollection
 but not an obsolete symbol, an obsolete symbol of equal value is created for 
 the key.  Rebuilds
 the hash table if the addition causes the number of collisions to exceed the
 limit allowed.  Returns aValue.

 If aKey is being added for the first time, an invariant copy of it is stored
 as the key."

| tempKey |

(aKey _isSymbol) 
  ifTrue: [ tempKey := aKey ]
  ifFalse: [ tempKey := aKey asObsoleteSymbol ].

self _stringAt: tempKey put: aValue caseSensitive: true.
(numCollisions > collisionLimit)
   ifTrue: [self rebuildTable: tableSize * 2].
^self
%

category: 'Storing and Loading'
classmethod: ObsoleteSymbolKeyValueDictionary
loadFrom: passiveObj

"Reads from passiveObj the passive form of an object with named instance
 variable format.  Converts the object to its active form by loading the
 information into a new instance of the receiver.  Returns the new instance."

^ self loadFrom: passiveObj mappingToClass: SymbolKeyValueDictionary
%

category: 'Repository Conversion'
method: ObsoleteSymbolKeyValueDictionary
convertToSymbolKeyValDict

"Private. Converts the receiver to be an instance of SymbolKeyValueDictionary."

<primitive: 484>
self _primitiveFailed: #convertToSymbolKeyValDict
%

category: 'Repository Conversion'
method: ObsoleteSymbolKeyValueDictionary
convertToStringKeyValDict

"Private. Converts the receiver to be an instance of StringKeyValueDictionary."

<primitive: 484>
self _primitiveFailed: #convertToStringKeyValDict
%

category: 'Repository Conversion'
method: ObsoleteSymbolKeyValueDictionary
containsOnlySymbols

"Private. Checks to see if all its keys are Symbols (and not ObsoleteSymbols)"

self keysDo: [ :aKey |
  (aKey _isSymbol) ifFalse: [ ^ false ]
  ].

^ true.
%

category: 'Repository Conversion'
method: ObsoleteSymbolKeyValueDictionary
rehashForConversion

"Private. Rehashes the receiver because the hash values of some of its keys
 may have changed."

| newSize |

(self _class == ObsoleteSymbolKeyValueDictionary) 
  ifTrue: [
    (self containsOnlySymbols)
      ifTrue:  [ self convertToSymbolKeyValDict ]
      ifFalse: [ self convertToStringKeyValDict ].
    ].

newSize := (Integer _selectedPrimeGreaterThan: numElements) max: tableSize.
self rebuildTable: newSize.
%

category: 'Repository Conversion'
classmethod: ObsoleteSymbolKeyValueDictionary
_correspondingNewClass

"The class all instances of receiver are converted to during conversion."

(self == ObsoleteSymbolKeyValueDictionary)
  ifTrue: [ ^ SymbolKeyValueDictionary ].

^ self.
%

