!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: obssymbolassn.gs,v 1.4 2008-01-09 22:50:13 stever Exp $
!
! Superclass Hierarchy:
!   ObsoleteSymbolAssociation, Association, Object.
!
!=========================================================================

removeallmethods ObsoleteSymbolAssociation
removeallclassmethods ObsoleteSymbolAssociation

category: 'For Documentation Installation only'
classmethod: ObsoleteSymbolAssociation
installDocumentation

| doc txt |

doc := GsClassDocumentation _newForObsoleteGsClass: self asOfGsVersion: '5.0'.

txt := (GsDocText new) details:
'Existing instances should be migrated to SymbolAssociation or otherwise
 processed as required, and then should be removed.' .
doc documentClassWith: txt.

self description: doc.
%

category: 'Private'
method: ObsoleteSymbolAssociation
_resolveRcConflictsWith: conflictObjects

"A logical write-write conflict has occurred on the receiver.  This
 may have occurred due to artificially placing the receiver in the write
 set when a subclass re-implemented this method (this is done to maintain
 cache coherency. See if the state has changed in this transaction.  If
 so, then it is a valid conflict (and returns false); otherwise returns true."

| preAbortValue |
preAbortValue := value.
self _selectiveAbort.
^ value == preAbortValue
%

category: 'Repository Conversion'
method: ObsoleteSymbolAssociation
convertTo5

"Converts the receiver from an instance of ObsoleteSymbolAssociation 
 to an instance of SymbolAssociation without changing its identity.
 Returns the converted receiver."

<primitive: 472>

self _primitiveFailed: #convertTo5.
%

category: 'Repository Conversion'
classmethod: ObsoleteSymbolAssociation
_correspondingNewClass

"The class all instances of receiver are converted to during conversion."

(self == ObsoleteSymbolAssociation)
  ifTrue: [ ^ SymbolAssociation ].

^ self.
%

