!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: obssymbol.gs,v 1.4 2008-01-09 22:50:13 stever Exp $
!
! Superclass Hierarchy:
!   ObsoleteSymbol, InvariantString, String, CharacterCollection,
!   SequenceableCollection, Collection, Object.
!
!=========================================================================

removeallmethods ObsoleteSymbol
removeallclassmethods ObsoleteSymbol

category: 'For Documentation Installation only'
classmethod: ObsoleteSymbol
installDocumentation

| doc txt |

doc := GsClassDocumentation _newForObsoleteGsClass: self asOfGsVersion: '5.0'.

txt := (GsDocText new) details:
'Existing instances should be migrated to String or Symbol or otherwise
 processed as required, and then should be removed.

 An ObsoleteSymbol is a GemStone 4.1 Symbol.  It is not canonicalized.' .
doc documentClassWith: txt.

doc documentCategory: #'Instance Creation' with: txt.

self description: doc.
%

category: 'Storing and Loading'
classmethod: ObsoleteSymbol
loadFrom: passiveObj

"Reads from passiveObj the passive form of an object.  Converts the object to
 its active form by loading the information into a new instance of the receiver.
 Returns the new instance."

| inst |

"since ObsoleteSymbols can't refer to other objects, the 'hasRead:' message
 may be sent after values have been filled in.  Subclasses of ObsoleteSymbol
 that contain pointer variables must reimplement this method"

inst := String new .
inst size: passiveObj readSize.
inst loadFrom: passiveObj .
inst changeClassTo: self.
^inst
%

category: 'Testing'
method: ObsoleteSymbol
isObsoleteSymbol

"Returns true."

 ^true
%

category: 'Converting'
method: ObsoleteSymbol
asObsoleteSymbol

"Returns the receiver."

^ self
%

category: 'Converting'
method: ObsoleteSymbol
asObsoleteSymbolKind

"Equivalent to asObsoleteSymbol."

 ^self
%

category: 'Converting'
method: ObsoleteSymbol
copy

"Returns a copy of the receiver."

^ ObsoleteSymbol withAll: self
%

category: 'Formatting'
method: ObsoleteSymbol
printOn: aStream

"Puts a displayable representation of the receiver on the given stream.
 That representation conforms to GemStone Smalltalk parsing rules."

| mySize |
(mySize := self size) == 0 ifTrue:[
  aStream nextPut: $# .
  aStream nextPut: $' .
  aStream nextPut: $' .
  ]
ifFalse:[
  mySize < 50 ifTrue:[
    self containsSeparator   "containsSeparator is expensive"
    ifFalse:[
      aStream nextPut: $# .
      aStream nextPutAll: self 
      ]
    ifTrue:[
      aStream nextPut: $# .
      super printOn: aStream 
      ]
    ]
  ifFalse:[
    "do it the efficient way for large ObsoleteSymbols"
    aStream nextPut: $# .
    super printOn: aStream 
    ]
  ]
%

category: 'Formatting'
method: ObsoleteSymbol
withNoColons

"Returns a copy of the receiver with all colons removed."

^self copyWithout: $:
%

category: 'Converting'
method: ObsoleteSymbol
asString

"Returns a copy of the receiver as an instance of class String."

^ String withAll: self
%

category: 'Converting'
method: ObsoleteSymbol
asSymbol

"Returns a copy of the receiver as an instance of class Symbol."

^ Symbol withAll: self
%

category: 'Repository Conversion'
method: ObsoleteSymbol
convertTo5

"Returns a copy of the receiver as an instance of class Symbol."

^ Symbol withAll: self
%

category: 'Repository Conversion'
method: ObsoleteSymbol
transformIntoSymbol

"Private. Attempts to transform the receiver from an ObsoleteSymbol to a 
 Symbol while keeping its identity the same. If retaining the identity is not 
 possible, returns a Symbol with the same contents."

<primitive: 479>
self _primitiveFailed: #transformIntoSymbol
%

category: 'Repository Conversion'
method: ObsoleteSymbol
transformIntoString

"Private. Transforms the receiver from an ObsoleteSymbol to a 
 String while keeping its identity the same."

<primitive: 488>
self _primitiveFailed: #transformIntoString
%


category: 'Comparing'
method: ObsoleteSymbol
= aCharCollection

"Returns true if the receiver is equivalent to the argument, returns false
 otherwise."

aCharCollection _class == Symbol ifTrue:[
  "Use the primitive in Symbol for special behavior of ObsoleteSymbols."
  ^ aCharCollection = self
  ].
^ super = aCharCollection
%

category: 'Repository Conversion'
classmethod: ObsoleteSymbol
_correspondingNewClass

"The class all instances of receiver are converted to during conversion."

(self == ObsoleteSymbol)
  ifTrue: [ ^ Symbol ].

^ self.
%

