!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: nameless.gs,v 1.10 2008-01-09 22:50:12 stever Exp $
!
! Description - Create the Nameless user account.
! 
! Repository conversion - this file is used
!
!=======================================================================

! login as SystemUser
set user SystemUser pass swordfish
iferror exit
login 
iferror

expectvalue %String
run
   "Expect a four element Array of user IDs: SystemUser, DataCurator,
    GcUser and Nameless "
| nameless newUser userGlbl seg8 report lf |

nameless := AllUsers detect: [ :x | x userId = 'Nameless' ] ifNone: [nil].
seg8 := (Globals at:#SystemRepository) at: 8 .
report := String new .
lf := Character lf .
nameless ~~ nil ifTrue: [ | defSeg |
    "Nameless already exists. Set its password."
    nameless password: 'swordfish'.
    defSeg := nameless defaultSegment .
    defSeg == seg8 ifFalse:[  
      nameless defaultSegment: seg8 .
    ].
    report addAll: 'Nameless already exists ' ; add: lf .
    seg8 isInvariant ifFalse:[
      seg8 owner: nameless  ;
          ownerAuthorization: #write ;
          worldAuthorization: #read .  
    ] ifTrue:[
      report addAll:'seg8 isInvariant' ; add: lf .
    ].
] ifFalse: [
    "Create a new Nameless user account"
    newUser := UserProfile newWithUserId: 'Nameless'
                         password: #swordfish
                         defaultSegment: seg8
                         privileges: #()
                         inGroups: #()
                         compilerLanguage: #ASCII.

    seg8 owner: newUser ;
       ownerAuthorization: #write;
       worldAuthorization: #write .

    " AllUsers add: newUser. --- no longer needed "

    " Put Nameless in SystemUser's UserGlobals "
    UserGlobals at: #Nameless put: newUser.

    " Put Nameless in DataCurator's UserGlobals"
    ((AllUsers userWithId: #DataCurator) resolveSymbol: #UserGlobals) value at: 
       #Nameless put: newUser.

    " Put Nameless in its own UserGlobals"
    userGlbl := (newUser resolveSymbol: #UserGlobals) value.
    userGlbl at: #Nameless put: newUser.

    report addAll: 'created Nameless' ; add: lf .
].
^ report
%

commit

logout

