!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: logentry.gs,v 1.5 2008-01-09 22:50:12 stever Exp $
!
! Superclass Hierarchy:
!   LogEntry, Object.
!
!=========================================================================

! Create the class LogEntry, if it does not already exist

expectvalue %String
run
Object _newKernelSubclass: 'LogEntry'
  instVarNames: #('receiver' 'selector' 'argArray')
  classVars: #()
  classInstVars: #()
  poolDictionaries: #[]
  inDictionary: Globals
  constraints: #[  ]
  instancesInvariant: false
  isModifiable: false
  reservedOop: 721
%

removeallmethods LogEntry
removeallclassmethods LogEntry

category: 'For Documentation Installation only'
classmethod: LogEntry
installDocumentation

| doc |
doc := GsClassDocumentation _newForPrivateGsClass: self.

doc documentClassWith: (GsDocText new).

self description: doc.
%

! ------------------- Class methods for LogEntry
! ------------------- Instance methods for LogEntry
category: 'Accessing'
method: LogEntry
argArray

"Returns the value of the instance variable 'argArray'."

^argArray
%

category: 'Updating'
method: LogEntry
argArray: newValue

"Modify the value of the instance variable 'argArray'."

argArray := newValue
%

category: 'Accessing'
method: LogEntry
receiver

"Returns the value of the instance variable 'receiver'."

^receiver
%

category: 'Updating'
method: LogEntry
receiver: newValue

"Modify the value of the instance variable 'receiver'."

receiver := newValue
%

category: 'Replaying'
method: LogEntry
redo

"Replays the message send for the receiver log entry."

^ receiver perform: selector withArguments: argArray
%

category: 'Accessing'
method: LogEntry
selector

"Returns the value of the instance variable 'selector'."

^selector
%

category: 'Updating'
method: LogEntry
selector: newValue

"Modifies the value of the instance variable 'selector'."

selector := newValue
%

category: 'Formatting'
method: LogEntry
printOn: aStream

"Puts a displayable representation of the receiver on the given stream."

aStream tab; nextPutAll: '(', selector printString, ' withArgs: '; cr.
argArray do: [:obj | 
    aStream tab; tab; nextPutAll: ' [', obj class printString, ', ', obj asOop printString, '] '; cr.
].
aStream tab; nextPutAll: ')'; cr.
%
