!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: langdict.gs,v 1.4 2008-01-09 22:50:12 stever Exp $
!
! Superclass Hierarchy:
!    LanguageDictionary, SymbolDictionary, IdentityDictionary,
!    IdentityKeyValueDictionary, KeyValueDictionary, AbstractDictionary,
!    Collection, Object
!
!=========================================================================

removeallmethods LanguageDictionary
removeallclassmethods LanguageDictionary

category: 'For Documentation Installation only'
classmethod: LanguageDictionary
installDocumentation

| doc txt |
doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details:
'A LanguageDictionary is a SymbolDictionary designed to hold language-dependent
 objects.  Language symbols are used as keys, so that a user''s language symbol
 (see UserProfile | nativeLanguage) can be used to find the appropriate object
 for the native language.' .
doc documentClassWith: txt.

self description: doc.
%

category: 'Accessing'
method: LanguageDictionary
value

"Returns the value associated with the user's native language Symbol.  That
 Symbol is taken from the user's UserProfile object.  If there is no entry for
 the given language, an error is generated."

|myLanguage "the Symbol representing the user's native language"|

myLanguage := System myUserProfile nativeLanguage.
^ self at: myLanguage
       ifAbsent: [^ self _errorKeyNotFound: myLanguage]
%

