!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: gcuser.gs 19139 2008-05-30 23:48:14Z stever $
!
! Description - Create the GcUser and SymbolUser accounts
! 
! Repository conversion - this file is used
!
!=======================================================================

! login as SystemUser
set user SystemUser pass swordfish
iferr 1 exit
login 
iferr 1 stk
iferr 2 stack

! for repository conversion, fixup default segment of DataCurator
!  if needed

expectvalue %String
run
| dc seg2 convFromPrevious64bit report lf |
report := String new .
lf := Character lf .
convFromPrevious64bit := false .
seg2 := (Globals at:#SystemRepository) at: 2 .
dc := AllUsers detect: [ :x | x userId asString = 'DataCurator' ] .

"reset the DataCurator password so the sessionmethods.topaz step 
 can login as DataCurator ."
dc password:'swordfish' .
report addAll:'reset DataCurator password'; add: lf .

(dc defaultSegment isNil or:[dc defaultSegment segmentId == 1]) ifTrue:[
  convFromPrevious64bit := true .
  dc defaultSegment: seg2 .
  report addAll:'changed DataCurator defaultSegment to Segment with segmentId 2';
 	add: lf .
] ifFalse:[
  report addAll:'no change to DataCurator defaultSegment'; add: lf .
].
convFromPrevious64bit ifTrue:[
  AllUsers do:[:up |
    (UserProfile isSpecialUserId: up userId) ifFalse:[
      report addAll:'changed ', up userId , ' defaultSegment to nil '; add: lf .
      "set for world-write to new objects per previous Gs64 release."
      up defaultSegment: nil . 
    ].
  ].
].
^ report
%

expectvalue %String
run
  " create GcUser account"
| gcUser newUser gcUserGlobals seg7 report lf |

gcUser := AllUsers detect: [ :x | x userId asString = 'GcUser' ] ifNone: [nil].
seg7 := (Globals at:#SystemRepository) at: 7 .
report := String new .
lf := Character lf .
gcUser ~~ nil ifTrue: [ | defSeg |
    "GcUser already exists. Set its password."
    gcUser password: 'swordfish'.
    defSeg := gcUser defaultSegment .
    defSeg == seg7 ifFalse:[ 
      gcUser defaultSegment: seg7 .
    ].
    seg7 isInvariant ifFalse:[
      seg7 owner: gcUser  .
    ].
    report addAll: 'GcUser already exists' ; add: lf .
] ifFalse: [
    "Create a new GcUser"
    newUser := UserProfile newWithUserId: 'GcUser'
                         password: #swordfish
                         defaultSegment: seg7 
                         privileges: #( #GarbageCollection)
                         inGroups: #()
                         compilerLanguage: #ASCII.

     seg7 owner: newUser  ;
	ownerAuthorization: #write ;
        worldAuthorization: #read . 

    " AllUsers add: newUser. --- no longer needed "

    " Put GcUser in SystemUser's UserGlobals "
    UserGlobals at: #GcUser put: newUser.

    " Put GcUser in DataCurator's UserGlobals"
    ((AllUsers userWithId: #DataCurator) resolveSymbol: #UserGlobals) value at: 
       #GcUser put: newUser.

    " Put GcUser in its own UserGlobals"
    gcUserGlobals := (newUser resolveSymbol: #UserGlobals) value.
    gcUserGlobals at: #GcUser put: newUser.
    report addAll: 'created GcUser' ; add: lf .
].
seg7 isInvariant ifFalse:[
  seg7 ownerAuthorization: #write ;
    worldAuthorization: #read .

  "Gs64 v2.2, DataCurator needs permission to modify associations in 
   GcUser's userGlobals for running reclaimAll, etc. "
  seg7 group: (AllGroups at:'System') authorization: #write .
] ifTrue:[
   report addAll:'seg7 isInvariant, could not add System group write ';
	add: lf .
].
^ report
%

expectvalue %String
run
  " create SymbolUser account"
| symUser newUser theUg |

symUser := AllUsers detect: [ :x | x userId = 'SymbolUser' ] ifNone: [nil].
symUser ~~ nil
  ifTrue: [
    "SymbolUser created in bom.c  or previous version"
    symUser password: 'swordfish';
      defaultSegment: SystemSegment ;
      privileges: #( #GarbageCollection) .
    ^ 'SymbolUser already exists, adjusted.'
    ]
  ifFalse: [
    "Create a new SymbolUser profile " 
    newUser := UserProfile newWithUserId: 'SymbolUser'
                         password: #swordfish
                         defaultSegment: SystemSegment 
                         privileges: #( #GarbageCollection)
                         inGroups: #( )
                         compilerLanguage: #ASCII.

    " AllUsers add: newUser. --- no longer needed "

    " Put SymbolUser in its own UserGlobals"
    theUg := (newUser resolveSymbol: #UserGlobals) value.
    theUg at: #SymbolUser put: newUser.

    ^ 'created SymbolUser'
    ]
%
commit

logout

set user GcUser pass swordfish
iferr 1 exit
login 
iferr 1 stk
iferr 2 stack

! edited epochGcTimeLimit to fix 34388 
run
UserGlobals at:#defaultValues put:

'
"This String documents the default values for the garbage collector.
 Execute this GemStone Smalltalk source and commit to reset all default values"

UserGlobals at: #reclaimSleepTime  put:   10.  "must be >= 1"
"The maximum amount of time (in seconds) that the process should sleep.
 The garbage collector always makes sure that there is no work scheduled for
 it to do before it goes to sleep."

"Maximum and minimum number of pages to process in a single reclaim."
UserGlobals at: #reclaimMinPages put:   40.  "must be >= 1" 

UserGlobals at: #sleepTimeBetweenReclaimMs put: 0.
  "Amount of time (in milliseconds) to sleep after a reclaim that did work."

UserGlobals at: #reclaimDeadEnabled  put: true.
  "Controls whether the reclaim will try to clean up dead objects."

UserGlobals at: #autoRefreshGcGemConfig put: true.
  "Controls whether GcGems search their symbol lists for new GcUser
   settings at each transaction boundary."

UserGlobals at: #objsMovedPerCommitThreshold put: 20000.
   "Controls the approximate number of object table updates to be performed
    per transaction.  Reclaim gems will commit when at least this many
    live objects have been moved to new data pages."

UserGlobals at: #verboseLogging put: false.
   "Controls the amount of logging information written to the log file.
    If set to false, normal logging information will be written.  If set to
    true, extra logging information will be written at startup and at each
    commit."

UserGlobals at: #maxTransactionDuration put: 300.
   "Controls the approximate maximum lenght of a reclaim transaction in
    seconds.  If the Reclaim gem has been in transaction longer than
    this duration, it will commit even if the #objsMovedPerCommitThreshold
    condition has not been satisfied.  Minimum value is 10"

UserGlobals at: #dataPageBufferSize put: 16.
   "Specifies the buffer size (in pages) used to hold data pages to be
    reclaimed.  Effectively this parameter controls the maximum number
    of pages read per single disk read.  The minimum allowed value is
    10 pages and the maximum value allowed is 128 pages.  Changes to
    this parameter do not take effect until the Reclaim gem is 
    restarted." 

UserGlobals at: #reclaimDeadShadowPageThreshold put: 1000.
   "Specifies the number of shadow pages avaliable to reclaim by this 
    session which will preclude dead object reclamation.  If the number
    of shadow pages available to reclaim is more than this value, then
    only dead objects on these shadow pages will be reclaim in this
    transaction.  If the number of shadow pages available to reclaim is
    equal to or less than this value, then the dead objects list will be
    scanned and pages containing dead objects will also be reclaimed."

UserGlobals at: #deferReclaimCacheDirtyThreshold put: 75.
   "Specifies a threshold percentage of dirty pages in the stones shared
    page cache.  If more than this percentage of pages in the stones
    shared cache are local dirty pages, page reclaims will be deferred until 
    the local dirty percentage drops below of the threshold minus 5%.  While
    waiting in this mode, reclaim gems will run outside of a transaction
    and will respond to SigAborts from stone.  Setting the value to 100
    disables this feature."

UserGlobals at: #enableDebugging put: false.
   "Activates various consistency checks and debugging algorithms in GcGems
    at the expense of performance."

UserGlobals at: #epochGcTimeLimit put: 3600.
   "#epochGcTimeLimit controls the maximum frequency of epochs, in seconds.
    For example, the default value set here does not allow more than 
    one epoch every 60 minutes.
    It is recommended that this value not be less than 1800 (i.e. 30 minutes),
    since the aging of objects faulted into gem memory uses 5 minute aging for
    each of 10 subspaces of the pom generation.  Ideally epochGcTimeLimit should
    be several hours."

UserGlobals at: #epochGcTransLimit put: 5000.
   "Minimum number of commits that must have occurred in order to start an
    epoch garbage collection."

UserGlobals at: #epochGcPageBufferSize put: 150.
   "Size in pages of the mark/sweep buffer used for epoch GC.
    Minimum: 8
    Maximum: 5000"

UserGlobals at: #deadObjsReclaimedCommitThreshold put: 10000.
   "Maximum number of dead objects to reclaim in a single transaction.
    Minimum: 32"

"sleepTimeBetweenTranlogWritesMs no longer used, reclaimed oops handled
 by lower log priority ."

"NOTE: values which exceed the specified limits (min or max) will be
  cause the garbage collector to ignore the value stored in UserGlobals,
  and the documented limit will be silently used."

'  .
^ true
%

! remove all obsolete keys present

expectvalue true
run
UserGlobals removeKey: #jetReclaimMinDeadObjs ifAbsent: [].
UserGlobals removeKey: #reclaimMaxPages ifAbsent: [].
UserGlobals removeKey: #preheatCacheBeforeCommit ifAbsent: [].
UserGlobals removeKey: #GemIOLimit ifAbsent: [].
UserGlobals removeKey: #epochGcByteLimit ifAbsent: [].
UserGlobals removeKey: #epochGcStatsEnabled ifAbsent: [].
UserGlobals removeKey: #deferEpochReclaimThreshold ifAbsent: [].
UserGlobals removeKey: #reclaimStatsEnabled ifAbsent: [].
UserGlobals removeKey: #reclaimStats ifAbsent: [].
UserGlobals removeKey: #epochGcEnabled ifAbsent: [].
UserGlobals removeKey: #epochGcStats ifAbsent: [].
UserGlobals removeKey: #reclaimDeadCommitLimit ifAbsent: [].
UserGlobals removeKey: #promoteDeadLimit ifAbsent: [].
UserGlobals removeKey: #deferPromoteDeadReclaimThreshold ifAbsent: [].
UserGlobals removeKey: #coordinateJetGemCommits ifAbsent: [].
UserGlobals removeKey: #sleepTimeBetweenTranlogWritesMs ifAbsent:[].
^true
%

expectvalue true
run
| oldValueInSeconds |
oldValueInSeconds := UserGlobals at: #sleepTimeBetweenReclaim ifAbsent:[0].
oldValueInSeconds _isSmallInteger
  ifFalse:[oldValueInSeconds := 0].
UserGlobals at: #sleepTimeBetweenReclaimMs put: (oldValueInSeconds * 1000).
UserGlobals removeKey: #sleepTimeBetweenReclaim ifAbsent:[].
^true
%

! Now install default values for all new keys, leave old values alone.
!   changed default for epochGcTimeLimit with fix 34388 
expectvalue true
run
UserGlobals at: #reclaimSleepTime  ifAbsentPut: [10].  
UserGlobals at: #reclaimMinPages ifAbsentPut: [40]. 
UserGlobals at: #sleepTimeBetweenReclaimMs ifAbsentPut: [0].
UserGlobals at: #reclaimDeadEnabled  ifAbsentPut: [true].
UserGlobals at: #autoRefreshGcGemConfig ifAbsentPut: [true].
UserGlobals at: #objsMovedPerCommitThreshold ifAbsentPut: [20000].
UserGlobals at: #verboseLogging ifAbsentPut: [false].
UserGlobals at: #maxTransactionDuration ifAbsentPut: [300].
UserGlobals at: #dataPageBufferSize ifAbsentPut: [16].
UserGlobals at: #reclaimDeadShadowPageThreshold ifAbsentPut: [1000].
UserGlobals at: #enableDebugging ifAbsentPut: [false].
UserGlobals at: #deferReclaimCacheDirtyThreshold ifAbsentPut: [75].
UserGlobals at: #epochGcTimeLimit ifAbsentPut: [ 3600 ]. 
UserGlobals at: #epochGcTransLimit ifAbsentPut: [5000]. 
UserGlobals at: #epochGcPageBufferSize ifAbsentPut: [150]. 
UserGlobals at: #deadObjsReclaimedCommitThreshold ifAbsentPut: [10000]. 
^ true
%

stack
commit

logout
