!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: collisionbucket.gs,v 1.5 2008-01-09 22:50:09 stever Exp $
!
! Superclass Hierarchy:
!   CollisionBucket, AbstractCollisionBucket, Array, SequenceableCollection,
!   Collection, Object.
!
!=========================================================================

removeallmethods CollisionBucket
removeallclassmethods CollisionBucket

category: 'For Documentation Installation only'
classmethod: CollisionBucket
installDocumentation

| doc txt |
doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details:
'A CollisionBucket is an Array that is used in a KeyValueDictionary to store
 a collection of key/value pairs for which the keys hash to the same value.' .
doc documentClassWith: txt.

txt := (GsDocText new) details:
'An AbstractDictionary.  For GemStone internal use.' .
doc documentInstVar: #keyValueDictionary with: txt.

self description: doc.
%

category 'Accessing'
method: CollisionBucket
keyValueDictionary

"Returns the value of the instance variable."

^keyValueDictionary
%

category 'Updating'
method: CollisionBucket
keyValueDictionary: aDict

"Updates the value of the keyValueDictionary instance variable."

keyValueDictionary := aDict
%

category: 'Private'
method: CollisionBucket
_removeAll

"Dereferences the receiver from its parent and shrinks the receiver.
 Used while rebuilding a KeyValueDictionary."

keyValueDictionary := nil.
numElements := 0.
self size: 0
%

category: 'Repository Conversion'
method: CollisionBucket
fixRefsAfterConversion

"Default method for fixing references LargePositiveInteger 
 and LargeNegativeInteger instances that can now be represented
 as a SmallInteger and Floats and SmallFloats which can now be 
 represented as a SmallDouble.  For collision buckets, we send
 the message to our parent Dictionary and let him do the fix up."

|dict result|
(System _testIf: self isIn: 45)
	ifTrue:[^false]. "already fixed this one"
dict := self keyValueDictionary.
result := false.
dict ~~ nil
	ifTrue:[result := dict fixRefsAfterConversion].
System _add: self to: 45.
^result
