#set -vx
#=========================================================================
# Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
#
# Name - setconfig.sh
#
# Purpose - Set GemStone configuration values
#
# Inputs: $systemDir, $comid, $exeConfig, $systemConfig,
#	   $runpgsvrSpec $netldiSpec, $appName
#
# $Id: setconfig.sh,v 1.5 2008-01-09 22:50:53 stever Exp $
#
#=========================================================================

# required directories
if [ "x$GEMSTONE" = "x" ]; then
  echo "$comid[Error]:    internal error -- \$GEMSTONE is empty"
  exit 1
fi
if [ ! -d $GEMSTONE ]; then
  echo "$comid[Error]:    Directory $GEMSTONE does not exist"
  exit 1
fi
if [ ! -d $GEMSTONE/bin ]; then
  echo "$comid[Error]:    required directory \"${GEMSTONE}/bin\" is missing."
  exit 1
fi

if [ "$GEMSTONE_VERSION" = "" ]; then
  . $GEMSTONE/bin/misc.sh
fi

# we need a GEMSTONE_SYS_CONF
if [ "x$systemConfig" = "x" ]; then
  # nothing passed as option
  if [ "x$GEMSTONE_SYS_CONF" = "x" ]; then
    systemConfig="$GEMSTONE/data"
  else
    systemConfig="$GEMSTONE_SYS_CONF"
  fi
fi
# emulate cfgopt.c noise
if [ -d $systemConfig ]; then
  if [ -f $systemConfig/`/bin/uname -n`.conf ]; then
    systemConfig=$systemConfig/`/bin/uname -n`.conf
  else # default to shipped config file
    systemConfig=$systemConfig/system.conf
  fi
elif [ ! -f $systemConfig ]; then
  systemConfig=$GEMSTONE/data/system.conf
fi
if [ ! -f $systemConfig ]; then
  # no system config file
  echo "${comid}[Warning]:  GEMSTONE_SYS_CONF file $systemConfig does not exist."
fi
GEMSTONE_SYS_CONF=$systemConfig; export GEMSTONE_SYS_CONF

# We need a GEMSTONE_EXE_CONF
if [ "x$exeConfig" = "x" ]; then
  # nothing passed as option
  if [ "x$GEMSTONE_EXE_CONF" = "x" ]; then
    exeConfig=`pwd`
  else
    exeConfig="$GEMSTONE_EXE_CONF"
  fi
fi
# emulate cfgopt.c noise
if [ -d $exeConfig ]; then
  if [ "x$appName" != "x" ]; then
    if [ -f $exeConfig/${appName}.conf ]; then
      exeConfig=$exeConfig/${appName}.conf
    else
      exeConfig=
    fi
  fi
elif [ ! -f $exeConfig ]; then
  exeConfig=
fi
#if [ ! -d $exeConfig -a ! -f $exeConfig ]; then
#  say setconfig.noexe $comid $exeConfig
#fi
if [ "x$exeConfig" != "x" ]; then
  GEMSTONE_EXE_CONF=$exeConfig; export GEMSTONE_EXE_CONF
fi

# Determine the netldi
if [ "x$netldiSpec" != "x" ]; then
  eval "netldi${GEMSTONE_VERSION}=$netldiSpec"
  export netldi${GEMSTONE_VERSION}
#else
#  bar=netldi${GEMSTONE_VERSION}
#  eval "foo=\$${bar}"
#  if [ "x$foo" != "x" ]; then
     # warn about default netldi
#    say setconfig.netldi $comid netldi${GEMSTONE_VERSION} $foo
#  fi
fi

# Determine runpgsvr
if [ "x$runpgsvrSpec" = "x" ]; then
  if [ "x$runpgsvr" != "x" ]; then
    # warn about default runpgsvr
    echo "${comid}[Warning]:  Using runpgsvr  $runpgsvr"
  fi
else
  runpgsvr="$runpgsvrSpec"
  export runpgsvr
fi
