!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: symbolkeyvaluedict.gs,v 1.4 2008-01-09 22:50:19 stever Exp $
!
! Superclass Hierarchy:
!   SymbolKeyValueDictionary, IdentityKeyValueDictionary, KeyValueDictionary, 
!   AbstractDictionary, Collection, Object.
!
!=========================================================================

removeallmethods SymbolKeyValueDictionary
removeallclassmethods SymbolKeyValueDictionary

category: 'For Documentation Installation only'
classmethod: SymbolKeyValueDictionary
installDocumentation

| doc txt |
doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details:
'A SymbolKeyValueDictionary is an IdentityKeyValueDictionary in which the keys
 are canonical symbols (Symbols or DoubleByteSymbols).  The separate
 implementation is necessary in order to support canonicalization of the symbols
 that are used as keys.

 SymbolKeyValueDictionaries cannot be used in symbol lists.' .
doc documentClassWith: txt.

self description: doc.
%

! clusterDepthFirst inherited.

category: 'Updating'
method: SymbolKeyValueDictionary
at: aKey put: aValue

"Stores the aKey/aValue pair in the hash dictionary.   
 aKey must be convertible to a Symbol.

 Rebuilds the hash table if the addition caused the number of collisions 
 to exceed the limit allowed."

^ super at: (aKey asSymbol) put: aValue
%

category: 'Accessing'
method: SymbolKeyValueDictionary
keys

"Returns a SymbolSet containing the receiver's keys."

| result |
result := SymbolSet new .
self keysAndValuesDo:[ :aKey :aValue | result add: aKey ].
^ result
%

