!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: rcqentry.gs,v 1.5 2008-01-09 22:50:14 stever Exp $
!
! Superclass Hierarchy:
!   RcQueueEntry, RcQueueElement, Object.
!
!=========================================================================

expectvalue %String
run
^RcQueueElement _newKernelSubclass: 'RcQueueEntry'
        instVarNames: #( 'createTimeUs' )
        classVars: #()
        classInstVars: #()
        poolDictionaries: #[]
        inDictionary: Globals
        constraints: #[ #[ #createTimeUs, SmallInteger] ]
        instancesInvariant: false
        isModifiable: false
        reservedOop: 975
%

removeallmethods RcQueueEntry
removeallclassmethods RcQueueEntry

category: 'For Documentation Installation only'
classmethod: RcQueueEntry
installDocumentation

| doc txt |
doc := GsClassDocumentation _newForPrivateGsClass: self.

txt := (GsDocText new) details:
'RcQueueEntry describes an individual entry in a reduced-conflict queue.' .
doc documentClassWith: txt.

txt := (GsDocText new) details:
'The object (any kind) stored in the queue.'.
doc documentInstVar: #value with: txt.

txt := (GsDocText new) details:
'A SmallInteger that indicates this entry''s retrieval position.'.
doc documentInstVar: #sequenceNumber with: txt.

txt := (GsDocText new) details:
'A SmallInteger that represents a timestamp in gmt2005 format, indicating the time at which the
 RcQueue | add: method was invoked to add this entry to the queue.'.
doc documentInstVar: #createTime with: txt.

txt := (GsDocText new) details:
'A SmallInteger that represents a microsecond timestamp, indicating the time at which the
 RcQueue | add: method was invoked to add this entry to the queue.'.
doc documentInstVar: #createTimeUs with: txt.

self description: doc.
%

category: 'Accessing'
method: RcQueueEntry
createTimeUs

"Returns the value of the entry's microsecond timestamp, the createTimeUs instance
 variable."

^createTimeUs
%

category: 'Updating'
method: RcQueueEntry
createTimeUs: newValue

"Modifies the value of the microsecond timestamp, the createTimeUs instance variable."

createTimeUs := newValue
%

category: 'Comparing'
method: RcQueueEntry
createTimeAsGmt95

"Return the create time in gmt95 format.  We add a constant to our
 create time, which is always in gmt2005 format."
^createTime + 315619200.
%

category: 'Comparing'
method: RcQueueEntry
createTimeAsGmt2005

"Return the create time in gmt2005 format, 
 which we always use for createTime."
^createTime
%

category: 'Comparing'
method: RcQueueEntry
isOlderThan: anotherElementOrEntry

"Compare the creation time of this object to that of anotherElementOrEntry,
 which must be an instance of RcQueueElement or RcQueueEntry object.  
 Answers true if this object is older than anotherElementOrEntry or 
 if anotherElementOrEntry is nil.   Answers false otherwise."

anotherElementOrEntry == nil
  ifTrue:[^true].

^(createTime == anotherElementOrEntry createTimeAsGmt2005)
  ifTrue:[createTimeUs < anotherElementOrEntry createTimeUs]
  ifFalse:[createTime < anotherElementOrEntry createTimeAsGmt2005].
%

category: 'Instance Creation'
classmethod: RcQueueEntry
newWithValue: anObject sequenceNumber: aSmallInt inSegmentOf: parentObj
"Return a new instance of the receiver containing anObject as the value and
 aSmallInt as the sequence number.  This method also fills in the createTime
 and createTimeUs instance variables with the current time."

<primitive: 616>
aSmallInt _validateClass: SmallInteger .
^self _primitiveFailed: #newWithValue:sequenceNumber:inSegment: .
%

