!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: obsgsfile.gs,v 1.4 2008-01-09 22:50:12 stever Exp $
!
! Superclass Hierarchy:
!   ObsoleteGsFile, Object.
!
!=========================================================================

! Repository conversion will rename GsFile in 4.1 file to ObsoleteGsFile .
! When bootstrapping a 5.0 repository we create ObsoleteGsFile here.

expectvalue %String
run
^ Object _newKernelSubclass: #ObsoleteGsFile
    instVarNames:
        #(#id "0 is undefined,
               negative = 1-based server file ID,
               positive = 1-based client file ID
               1, -1 are used for unopened files"
          #pathName  "a String, directory plus file name"
          #mode      "a String"
          #errorCode "an Integer"
          #errorMessage "a String")
    classVars: #()
    classInstVars: #()
    poolDictionaries: #()
    inDictionary: Globals
    constraints: #()
    instancesInvariant: false
    isModifiable: false 
    reservedOop: 863.
%

! Remove existing behavior from GsFile
removeallmethods ObsoleteGsFile
removeallclassmethods ObsoleteGsFile

category: 'For Documentation Installation only'
classmethod: ObsoleteGsFile
installDocumentation

| doc txt |

doc := GsClassDocumentation _newForObsoleteGsClass: self asOfGsVersion: '5.0'.

txt := (GsDocText new) details:
'It does not make sense for instances of ObsoleteGsFile to be persistent.
 Existing instances should be removed.' .
doc documentClassWith: txt.

self description: doc.
%

category: 'Instance Creation'
classmethod: ObsoleteGsFile
new

"Disallowed.  This class is obsolete."

self shouldNotImplement: #new
%

category: 'Accessing'
method: ObsoleteGsFile
pathName

"Return the pathName instance variable."
^ pathName
%
category: 'Accessing'
method: ObsoleteGsFile
mode

"Return the mode instance variable."
^ mode
%

