!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: mappinginfo.gs,v 1.6 2008-01-09 22:50:12 stever Exp $
!
! Superclass Hierarchy:
!   MappingInfo, Array, SequenceableCollection, Collection, Object.
!
!=========================================================================

! Create the class MappingInfo, if it does not already exist

expectvalue %String
run
  Array _newKernelSubclass: 'MappingInfo'
    instVarNames: #(#object #pathTerm #dependencyList #ivOffset)
    classVars: #()
    classInstVars: #()
    poolDictionaries: #[]
    inDictionary: Globals
    constraints: #[ #[ #pathTerm, PathTerm],
                    #[ #dependencyList, DependencyList],
                    #[ #ivOffset, Integer] ]
    instancesInvariant: false
    isModifiable: false
    reservedOop: 705
%

removeallmethods MappingInfo
removeallclassmethods MappingInfo

category: 'For Documentation Installation only'
classmethod: MappingInfo
installDocumentation

| doc txt |
doc := GsClassDocumentation _newForPrivateGsClass: self.

txt := (GsDocText new) details:
''.

doc documentClassWith: txt.

self description: doc.
%

! ------------------- Class methods for MappingInfo
! ------------------- Instance methods for MappingInfo
category: 'Accessing'
method: MappingInfo
dependencyList

"Returns the value of the instance variable 'dependencyList'."

^dependencyList
%

category: 'Updating'
method: MappingInfo
dependencyList: newValue

"Modify the value of the instance variable 'dependencyList'."

dependencyList := newValue
%

category: 'Accessing'
method: MappingInfo
ivOffset

"Returns the value of the instance variable 'ivOffset'."

^ivOffset
%

category: 'Updating'
method: MappingInfo
ivOffset: newValue

"Modify the value of the instance variable 'ivOffset'."

ivOffset := newValue
%

category: 'Accessing'
method: MappingInfo
object

"Returns the value of the instance variable 'object'."

^object
%

category: 'Updating'
method: MappingInfo
object: newValue

"Modify the value of the instance variable 'object'."

object := newValue
%

category: 'Accessing'
method: MappingInfo
pathTerm

"Returns the value of the instance variable 'pathTerm'."

^pathTerm
%

category: 'Updating'
method: MappingInfo
pathTerm: newValue

"Modify the value of the instance variable 'pathTerm'."

pathTerm := newValue
%

