!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: largepo.gs,v 1.7 2008-01-09 22:50:12 stever Exp $
!
! Superclass Hierarchy:
!   LargePositiveInteger, Integer, Number, Magnitude, Object.
!
!=========================================================================

removeallmethods LargePositiveInteger
removeallclassmethods LargePositiveInteger

category: 'For Documentation Installation only'
classmethod: LargePositiveInteger
installDocumentation

| doc txt |
doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details:
'Instances of LargePositiveInteger represent positive integers whose values are
 greater than the maximum SmallInteger (2 to the 29th power minus 1).  Each
 instance of LargePositiveInteger is stored as an Array of bytes, where each
 double-byte pair represents a base 32768 digit.  The first two bytes in that
 Array constitute the least significant base 32768 digit, and the last two 
 bytes are the most significant base 32768 digit.  Within each digit, the
 least significant byte is first, followed by the more significant byte.

 Coercion between LargePositiveInteger and SmallInteger occurs automatically.'.
doc documentClassWith: txt.

self description: doc.
%

category: 'Accessing'
method: LargePositiveInteger
at: anIndex

"Disallowed."

self shouldNotImplement: #at:
%

category: 'Accessing'
method: LargePositiveInteger
at: anIndex put: aNumber

"Disallowed.  You may not change the value of a LargePositiveInteger."

self shouldNotImplement: #at:put:
%

category: 'Testing'
method: LargePositiveInteger
negative

"Returns false."

^false
%

category: 'Testing'
method: LargePositiveInteger
positive

"Returns true."

^true
%

category: 'Truncation and Rounding'
method: LargePositiveInteger
truncated

"Returns the receiver, truncated to a SmallInteger if possible."

<primitive: 599>
self _primitiveFailed: #truncated .
self _uncontinuableError
%


category: 'Arithmetic'
method: LargePositiveInteger
abs

"Returns a LargePositiveInteger that is the absolute value of the receiver."

^ self
%

! Gs64 v2.0, delete method  negated  , now inherited from Number

category: 'Bit Manipulation'
method: LargePositiveInteger
highBit

"Returns the index of the high-order bit that is set in the binary
 representation of the receiver."

^self _lastDigit highBit + (15 * (self _digitLength - 1))
%

! following calls to prim 599 added to handle sub-normal large integers
category: 'Converting'
method: LargePositiveInteger
asInteger

"Returns the receiver, truncated to a SmallInteger if possible."

<primitive: 599>
self _primitiveFailed: #truncated .
self _uncontinuableError
%

category: 'Truncation and Rounding'
method: LargePositiveInteger
ceiling

"Returns the receiver, truncated to a SmallInteger if possible."

<primitive: 599>
self _primitiveFailed: #truncated .
self _uncontinuableError
%
category: 'Truncation and Rounding'
method: LargePositiveInteger
floor

"Returns the receiver, truncated to a SmallInteger if possible."

<primitive: 599>
self _primitiveFailed: #truncated .
self _uncontinuableError
%

category: 'Truncation and Rounding'
method: LargePositiveInteger
rounded

"Returns the receiver, truncated to a SmallInteger if possible."

<primitive: 599>
self _primitiveFailed: #truncated .
self _uncontinuableError
%

category: 'Repository Conversion'
method: LargePositiveInteger
needsFixingAfterConversion
	^true
%
