!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: istring.gs,v 1.4 2008-01-09 22:50:12 stever Exp $
!
! Superclass Hierarchy:
!   InvariantString, String, CharacterCollection, SequenceableCollection,
!   Collection, Object.
!
!=========================================================================

removeallmethods InvariantString
removeallclassmethods InvariantString

category: 'For Documentation Installation only'
classmethod: InvariantString
installDocumentation

| doc txt |
doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details:
'InvariantString is a subclass of String for which all instances are
 immutable after they are committed.'.
doc documentClassWith: txt.

self description: doc.
%

category: 'Formatting'
method: InvariantString
asString

"Returns a copy of the receiver as an instance of class String."

^ String withAll: self
%

category: 'Formatting'
method: InvariantString
_quoted

"Returns a copy of the receiver enclosed in single-quote marks, with contained
 single-quote Characters doubled.  The copy will be of class String.  This is
 usually done to prepare a storable version of the receiver."

| result c rs sz |

sz := self size.
result := String new: sz + 2.
result at: 1 put: $'.
rs := 1.
1 to: sz do: [:i |
  (c := self at: i) == $' ifTrue: [
    rs := rs + 1.
    result at: rs put: $'.
  ].
  rs := rs + 1.
  result at: rs put: c.
].
rs := rs + 1.
result at: rs put: $'.
^result
%


