!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: intkeyvaluedict.gs,v 1.4 2008-01-09 22:50:12 stever Exp $
!
! Superclass Hierarchy:
!   IntegerKeyValueDictionary, KeyValueDictionary, AbstractDictionary,
!   Collection, Object.
!
!=========================================================================

removeallmethods IntegerKeyValueDictionary
removeallclassmethods IntegerKeyValueDictionary

category: 'For Documentation Installation only'
classmethod: IntegerKeyValueDictionary
installDocumentation

| doc txt |
doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details:
'An IntegerKeyValueDictionary is a KeyValueDictionary in which the keys are
 Integers.

 One useful application of IntegerKeyValueDictionary is as an implementation of
 a sparse Array.  If the keys to the dictionary are normal Array indexes and the
 Array indexes used are sparsely scattered over the range of the Array, then
 IntegerKeyValueDictionary can provide a fast implementation that has much lower
 storage costs.'.
doc documentClassWith: txt.

self description: doc.
%

category: 'Updating'
method: IntegerKeyValueDictionary
at: aKey put: aValue

"Stores the aKey/aValue pair in the KeyValueDictionary.  Generates an error if
 aKey is not a kind of Integer."

aKey _isInteger ifFalse: [ ^ aKey _error: #rtErrBadArgKind args: #[Integer]].

^super at: aKey put: aValue
%

category: 'Repository Conversion'
method: IntegerKeyValueDictionary
rehashForConversion

"(R) Private. Rehashes the receiver because the hash values of some of its keys
 may have changed.  Returns true if the rehashing is successful.  Returns false
 otherwise.

 Nothing needs to be done for IntegerKeyValueDictionary the hash values for
 Integers have not changed from 4.1 to 5.0."

^ true.
%


