!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: gspackagelib.gs,v 1.5.2.2 2008-02-20 21:44:06 normg Exp $
!
! Superclass Hierarchy:
!   GsPackageLibrary, Object
!
!=========================================================================

! Fix 38326
expectvalue %String
doit
| oldClass expectedInstVars newClass |
expectedInstVars := #().
oldClass := Globals at: #GsPackageLibrary otherwise: nil.
(oldClass notNil and: [oldClass instVarNames = expectedInstVars]) ifTrue: [
	^'Found expected class'.
].
newClass := Object subclass: 'GsPackageLibrary'
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: #[]
  inDictionary: Globals
  constraints: #[  ]
  instancesInvariant: false
  isModifiable: false.
  ^(oldClass isNil ifTrue: ['Created new class: '] 
                   ifFalse: ['Replaced old class with: ']) , newClass definition.
%

! Remove existing behavior from GsPackageLibrary
expectvalue true
doit
GsPackageLibrary removeAllMethods.
GsPackageLibrary class removeAllMethods.
true
%
! ------------------- Class methods for GsPackageLibrary
category: 'Operations'
classmethod: GsPackageLibrary
uninstallPackageAndPrereqs: aPackage

    "Recursively uninstall the package and it's prereqs"

    | symDict pkg |
    symDict := aPackage symbolDict.
    aPackage prereqs do: [:symbolDict |
        pkg := symbolDict at: GsPackage globalName otherwise: nil.
        pkg ~~ nil ifTrue: [ GsPackageLibrary uninstallPackageAndPrereqs: pkg ].
    ].
    self userSymbolList remove: symDict ifAbsent: [].
    self sessionSymbolList remove: symDict ifAbsent: [].
%
category: 'Operations'
classmethod: GsPackageLibrary
uninstallPackage: aPackage

    self userSymbolList remove: aPackage symbolDict ifAbsent: [].
    self sessionSymbolList remove: aPackage symbolDict ifAbsent: [].
%
category: 'Operations'
classmethod: GsPackageLibrary
installPackageNamed: aSymbol

    	^self installPackage: (self packageNamed: aSymbol)
%
category: 'Operations'
classmethod: GsPackageLibrary
installPackage: aPackage

    	self installPackage: aPackage enable: true
%
category: 'Operations'
classmethod: GsPackageLibrary
installPackage: aPackage enable: aBool

    	| symDict pkgDict |
    	symDict := aPackage symbolDict.
	pkgDict := Globals.
    	aPackage prereqs do: [:symbolDict |  | p |
     		p := symbolDict at: aPackage class globalName otherwise: nil.
        	p ~~ nil 
			ifTrue: [ self installPackage: p  enable: false ].
		(self userSymbolList indexOf: symbolDict) < (self userSymbolList indexOf: pkgDict) 
			ifTrue: [ pkgDict := p symbolDict ].
    	].
	(self userSymbolList objectNamed: symDict name) == nil
		ifTrue: [ self userSymbolList add: symDict before: pkgDict ].
	(self sessionSymbolList objectNamed: symDict name) == nil
		ifTrue: [ self  sessionSymbolList add: symDict before: pkgDict ].
	aBool
		ifTrue: [ | policy |
			policy := GsPackagePolicy current.
			policy enable.
			policy homeSymbolDict:  aPackage symbolDict.
			policy externalSymbolList: (GsSession currentSession symbolList asArray copyWithout: aPackage symbolDict).
		].
%
category: 'Operations'
classmethod: GsPackageLibrary
createPackageNamed: aSymbol

    | package packageLibrary |
    package := self packageNamed: aSymbol.
    package ~~ nil ifTrue: [ ^package ].
    packageLibrary := self packageLibrary.
    packageLibrary createDictionaryNamed: aSymbol at: 1.
    ^GsPackage installIn: (packageLibrary objectNamed: aSymbol).
%
category: 'Searching'
classmethod: GsPackageLibrary
packageNamed: aSymbol

    	| symDict |
	symDict := self packageLibrary objectNamed: aSymbol.
	symDict == nil ifTrue: [ ^nil ].
	^symDict at: GsPackage globalName ifAbsent: [nil]
%
category: 'Accessing'
classmethod: GsPackageLibrary
packageLibraryUserName

    ^'DataCurator'
%
category: 'Accessing'
classmethod: GsPackageLibrary
packageLibraryName

    ^#PackageLibrary
%
category: 'Accessing'
classmethod: GsPackageLibrary
packageLibrary

    | packageLibrary |
    packageLibrary := (AllUsers userWithId: self packageLibraryUserName ifAbsent: []) symbolList objectNamed: self packageLibraryName.
    packageLibrary == nil
        ifTrue: [
            packageLibrary := SymbolList new.
            self userGlobals at: self packageLibraryName put: packageLibrary.
        ].
    ^packageLibrary
%
category: 'Accessing'
classmethod: GsPackageLibrary
userGlobals

    ^self userSymbolList objectNamed: #UserGlobals
%
category: 'Accessing'
classmethod: GsPackageLibrary
userSymbolList

    ^System myUserProfile symbolList
%
category: 'Accessing'
classmethod: GsPackageLibrary
sessionSymbolList

    ^GsSession currentSession symbolList
%
category: 'Private - Installation Support'
classmethod: GsPackageLibrary
getSeasideDirectory
| basePath |
basePath := System gemEnvironmentVariable: 'SEASIDE'.
basePath == nil
 ifTrue:[
   basePath := System gemEnvironmentVariable: 'GEMSTONE'.
   basePath == nil
     ifTrue:[^nil]
     ifFalse:[basePath addAll: '/seaside/'].
  ]
  ifFalse:[
    basePath last == $/
      ifFalse: [ basePath add: $/ ].
  ].
^basePath
%
category: 'Private - Installation Support'
classmethod: GsPackageLibrary
getMonticelloRepositoryDirectory
| basePath |
basePath := self getSeasideDirectory .
basePath ==  nil
  ifTrue:[ ^nil ] .
basePath addAll: 'monticello/repository/' .
^ basePath
%


! ------------------- Instance methods for GsPackageLibrary

!
! force definition of restrictedClasses during filein
!
doit
GsPackagePolicy restrictedClasses.
^true
%

