! ========================================================================
! Copyright (C) by VMware, Inc. 1991-2011.  All Rights Reserved
!
! $Id: errordesc.gs,v 1.6 2008-01-09 22:50:10 stever Exp $
!
! ========================================================================

expectvalue %String
run
Array _newKernelSubclass: #ErrorDescription
  instVarNames: #(#categoryOop #number #contextOop #message #fatal 
                  #gciInterface)
  classVars: #()
  classInstVars: #()
  poolDictionaries: #[]
  inDictionary: Globals
  constraints: #[
	#[#categoryOop, Integer],
	#[#number, Integer],
	#[#contextOop, Object],
	#[#message, String],
	#[#fatal, Boolean]
	", #[#gciInterface, GciInterface]"
	]
  instancesInvariant: false
  isModifiable: false
  reservedOop: 921
%

# Forward reference needed to GciInterface
run
Globals at: #GciInterface ifAbsent: [Globals at: #GciInterface put: nil].
true
%

! Remove existing behavior from ErrorDescription
removeallmethods ErrorDescription
removeallclassmethods ErrorDescription

! ------------------- Class methods for ErrorDescription
! ------------------- Instance methods for ErrorDescription
category: 'Accessing'
method: ErrorDescription
categoryOop

   "Return the value of the instance variable 'categoryOop'."
   ^categoryOop
%
category: 'Accessing'
method: ErrorDescription
contextOop

   "Return the value of the instance variable 'contextOop'."
   ^contextOop
%
category: 'Accessing'
method: ErrorDescription
fatal

   "Return the value of the instance variable 'fatal'."
   ^fatal
%
category: 'Testing'
method: ErrorDescription
isBreakPoint

"Return whether the error is due to a breakpoint."

categoryOop == nil
  ifTrue: [^false].
GemStoneError == (GciInterface _objectForOop: categoryOop)
  ifFalse: [^false].
^ (number == (ErrorSymbols at: #rtErrStackBreakpoint) _or:
  [number == (ErrorSymbols at: #rtErrStep) _or:
  [number == (ErrorSymbols at: #rtErrCodeBreakpoint)]])
%
category: 'Testing'
method: ErrorDescription
isSoftBreak

"Return whether the error is due to a soft break."

categoryOop == nil
  ifTrue: [^false].
GemStoneError == (GciInterface _objectForOop: categoryOop)
  ifFalse: [^false].
^ number == (ErrorSymbols at: #rtErrSoftBreak)
%
category: 'Testing'
method: ErrorDescription
isPause

"Return whether the error is due to a soft break."

categoryOop == nil
  ifTrue: [^false].
GemStoneError == (GciInterface _objectForOop: categoryOop)
  ifFalse: [^false].
^ number == (ErrorSymbols at: #rtErrPause)
%
category: 'Accessing'
method: ErrorDescription
message

   "Return the value of the instance variable 'message'."
   ^message
%
category: 'Accessing'
method: ErrorDescription
number

   "Return the value of the instance variable 'number'."
   ^number
%
category: 'Accessing'
method: ErrorDescription
printString
  "Display the receiver"

| s |

s := String new.
s add: self class name.
s add: '('.

s add: 'category=' ; add: categoryOop printString ; add: ', '.
s add: 'number=' ; add: number printString ; add: ', '.
s add: 'context=' ; add: contextOop printString ; add: ', '.

message == nil ifTrue:[s add: 'message=none' ]
	ifFalse: [s add: 'message="' ; add: message printString ; add: '", '].
s add: 'fatal=' ; add: fatal printString.

s add: ')'.
^s
%
