!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: clusterbarray.gs,v 1.5 2008-01-09 22:50:09 stever Exp $
!
! Superclass Hierarchy:
!   ClusterBucketArray, Array, SequenceableCollection, Collection, Object.
!
!=========================================================================

removeallmethods ClusterBucketArray
removeallclassmethods ClusterBucketArray

category: 'For Documentation Installation only'
classmethod: ClusterBucketArray
installDocumentation

| doc txt |
doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details:
'A ClusterBucketArray is an Array whose elements are instances of ClusterBucket.

 There is one instance of ClusterBucketArray in a fresh GemStone repository.  It
 can be accessed via the Globals dictionary using the following GemStone
 Smalltalk statement:

 Globals at: #AllClusterBuckets.

 GemStone uses AllClusterBuckets to translate clusterIds to cluster bucket
 objects:

 classmethod: ClusterBucket
 bucketWithId: aSmallPositiveInt
   ^ AllClusterBuckets at: aSmallPositiveInt
 %

 AllClusterBuckets has a reserved object identifier, to facilitate efficient
 access of the Array from within the object manager.  Therefore, a special C
 constant, OOP_ALL_CLUSTER_BUCKETS, is defined in the gcioop.ht header file to
 permit access to it from C.'.
doc documentClassWith: txt.

self description: doc.
%

category: 'Clustering'
method: ClusterBucketArray
clusterInBucket: aClusterBucketOrId

"Instances of ClusterBucketArray, especially AllClusterBuckets
 must always be clustered in the default bucket."

^ super clusterInBucket: 1
%

category: 'Clustering'
method: ClusterBucketArray
cluster

"Instances of ClusterBucketArray, especially AllClusterBuckets
 must always be clustered in the default bucket."

^ super clusterInBucket: 1
%

