!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: classset.gs,v 1.4 2008-01-09 22:50:09 stever Exp $
!
! Superclass Hierarchy:
!   ClassSet, IdentitySet, IdentityBag, UnorderedCollection, Collection,
!   Object.
!
!=========================================================================

! Create the class ClassSet, if it does not already exist

expectvalue %String
run
  IdentitySet _newKernelSubclass: 'ClassSet'
    instVarNames: #()
    classVars: #()
    classInstVars: #()
    poolDictionaries: #[]
    inDictionary: Globals
    constraints: Class
    instancesInvariant: false
    isModifiable: false
    reservedOop: 733 
%

removeallmethods ClassSet
removeallclassmethods ClassSet

category: 'For Documentation Installation only'
classmethod: ClassSet
installDocumentation

| doc txt |
doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details:
'A ClassSet is an IdentitySet that holds only Class objects.' .
doc documentClassWith: txt.

self description: doc.
%

! ------------------- Instance methods for ClassSet
category: 'Sorting'
method: ClassSet
sortAscending

"Returns an Array with the same (Class) elements as the receiver,
 in ascending order by class name."

^ self _sortPaths: #(#name) directions: #(true).
%

