!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: blockclosure.gs,v 1.6 2008-01-09 22:50:08 stever Exp $
!
! Superclass Hierarchy:
!   BlockClosure, Object.
!
!=========================================================================

removeallmethods BlockClosure
removeallclassmethods BlockClosure

category: 'For Documentation Installation only'
classmethod: BlockClosure
installDocumentation

| doc txt |
doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details:
'BlockClosure is an abstract superclass for all the different kinds of blocks
 of GemStone Smalltalk code.' .
doc documentClassWith: txt.

self description: doc.
%

category: 'Copying'
method: BlockClosure
copy

"Returns the receiver. Copies of blocks are not made."

^ self.
%

category: 'Continuations'
method: BlockClosure
callCC
   "Evaluate the receiver, which must be a one-argument block. 
   The argument to the block will be a newly created continuation, 
   which is an instance of GsProcess that contains a copy of the 
   active process. Unless control flow is otherwise interrupted, 
   return the result of evaluating the last expression in the block.

   If a reference is retained to the continuation that is created 
   during the execution of this method, it may later be evaluated 
   using the continuation's value: or value methods (distinct from 
   the BlockClosure's value: and value methods). When the continuation 
   value: is evaluated, it is effectively a GOTO to the point in 
   execution that the original call to callCC returned, (optionally) 
   returning a different value. The actual callCC block is only 
   executed once; later evaluations of the continuation return from 
   the block, but do not re-execute the block."

   ^ self value: (GsProcess continuationFromLevel: 2) 
%


category: 'Private'
method: BlockClosure
_deepCopyWith: copiedObjDict

"Private.  Used internally to implement deepCopy."

^ self.
%

category: 'Instance Creation'
classmethod: BlockClosure
new

"Disallowed."

self shouldNotImplement: #new
%

category: 'Reloading Decompiled Methods'
classmethod: BlockClosure
_new

"Private."

^ super new .
%

category: 'Updating'
method: BlockClosure
instVarAt: anIndex put: aValue

"Disallowed."

self shouldNotImplement: #instVarAt:put:
%

category: 'Testing'
method: BlockClosure
isSimple

"Returns the default answer, false."

^ false
%

category: 'Storing and Loading'
method: BlockClosure
writeTo: aPassiveObject

"Instances of BlockClosure cannot be converted to passive form.  This method
 writes nil to aPassiveObject and stops GemStone Smalltalk execution with a
 notifier."

aPassiveObject writeObject: nil.
self _error: #rtErrAttemptToPassivateInvalidObject.
%

