
expectvalue %String
run
Object _newKernelSubclass: 'SUnitNameResolver'
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: #[]
  inDictionary: Globals
  constraints: #[  ]
  instancesInvariant: false
  isModifiable: false
  reservedOop: nil
%
expectvalue %String
run
Delay _newKernelSubclass: 'SUnitDelay'
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: #[]
  inDictionary: Globals
  constraints: #[  ]
  instancesInvariant: false
  isModifiable: false
  reservedOop: nil
%
expectvalue %String
run
ExceptionA _newKernelSubclass: 'TestFailure'
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: #[]
  inDictionary: Globals
  constraints: #[  ]
  instancesInvariant: false
  isModifiable: false
  reservedOop: nil
%
expectvalue %String
run
TestFailure _newKernelSubclass: 'ResumableTestFailure'
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: #[]
  inDictionary: Globals
  constraints: #[  ]
  instancesInvariant: false
  isModifiable: false
  reservedOop: nil
%
category: 'For Documentation Installation only'
classmethod: SUnitNameResolver
installDocumentation

| doc txt |
doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details:
'This is part of the SUnitPreload package and provides
dialect-specific support for the remaining portable code.
This class supports global name lookup.'.
doc documentClassWith: txt.

self description: doc.
%
category: 'For Documentation Installation only'
classmethod: SUnitDelay
installDocumentation

| doc txt |
doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details:
'This is part of the SUnitPreload package and provides
dialect-specific support for the remaining portable code.
This class supports delay timing.'.
doc documentClassWith: txt.

self description: doc.
%
category: 'For Documentation Installation only'
classmethod: TestFailure
installDocumentation

| doc txt |
doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details:
'This is part of the SUnitPreload package and provides
dialect-specific support for the remaining portable code.
This class supports exception handling.'.
doc documentClassWith: txt.

self description: doc.
%
category: 'For Documentation Installation only'
classmethod: ResumableTestFailure
installDocumentation

| doc txt |
doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details:
'This is part of the SUnitPreload package and provides
dialect-specific support for the remaining portable code.
This class supports exception handling.'.
doc documentClassWith: txt.

self description: doc.
%
category: 'SUnit'
method: Behavior
sunitAllSelectors
	^self allSelectors asSortedCollection asOrderedCollection
%
category: 'SUnit'
method: Behavior
sunitSelectors
	^self selectors asSortedCollection asOrderedCollection
%
category: 'SUnit'
method: BlockClosure
sunitEnsure: aBlock 
	^self ensure: aBlock
%
category: 'SUnit'
method: BlockClosure
sunitOn: aSignal do: anExceptionBlock 
	^self on: aSignal do: anExceptionBlock
%
category: 'SUnit'
method: Class
sunitName
	^self name
%
category: 'SUnit'
classmethod: ExceptionA
sunitSignalWith: aString
	^self signal: aString
%
category: 'SUnit'
method: ExceptionA
sunitExitWith: aValue
	^self return: aValue
%
category: 'SUnit'
method: ExceptionA
sunitSignalWith: aString
	^self signal: aString
%
category: 'SUnit'
method: Object
sunitAddDependent: anObject
%
category: 'SUnit'
method: Object
sunitChanged: aspect
%
category: 'SUnit'
method: Object
sunitRemoveDependent: anObject
%
category: 'SUnit'
method: ResumableTestFailure
isResumable

	^true.
%
category: 'SUnit'
method: ResumableTestFailure
sunitExitWith: aValue
	^self resume: aValue
%
category: 'SUnit'
method: String
sunitAsSymbol
	^self asSymbol
%
category: 'SUnit'
method: String
sunitMatch: aString

	| pattern |
	pattern := OrderedCollection new.
	(self notEmpty _and: [self first = $*]) ifTrue: [
		pattern add: $*.
	].
	(self subStrings: $*) do: [:each | 
		pattern
			add: each;
			add: $*.
	].
	(self notEmpty _and: [self last ~= $*]) ifTrue: [
		pattern removeLast.
	].
	^aString matchPattern: pattern asArray.
%
category: 'SUnit'
method: String
sunitSubStrings
	| stream answer index |
	answer := OrderedCollection new.
	stream := ReadStream on: self.
	[stream atEnd]
		whileFalse: 
			[[stream atEnd ifTrue: [^answer asArray].
			stream peek > (Character space)]
				whileFalse: [stream next].
			index := stream position + 1.
			[stream atEnd _or: [stream peek <= (Character space)]]
				whileFalse: [stream next].
			answer add: (self copyFrom: index to: stream position)].
	^answer asArray
%
category: 'SUnit'
classmethod: SUnitNameResolver
classNamed: aSymbol

	| assoc |
	(assoc := System myUserProfile resolveSymbol: aSymbol) == nil ifTrue: [^nil].
	^assoc value.
%
category: 'SUnit'
classmethod: SUnitNameResolver
defaultLogDevice

	^WriteStream on: String new.
%
category: 'SUnit'
classmethod: SUnitNameResolver
errorObject
	^Error
%
category: 'SUnit'
classmethod: SUnitNameResolver
mnuExceptionObject
	^MessageNotUnderstood
%
category: 'SUnit'
classmethod: SUnitNameResolver
notificationObject
	^Notification
%
category: 'SUnit'
method: Symbol
sunitAsClass
	^SUnitNameResolver classNamed: self
%
