category: 'ANSI'
classmethod: Character
codePoint: anInteger

	^self withValue: anInteger.
%
category: 'ANSI'
method: Character
codePoint

	^self asciiValue.
%
category: 'Queries'
method: Class
allSubclasses

	^ClassOrganizer new allSubclassesOf: self.
%
category: 'Queries'
method: Class
subclasses

	^ClassOrganizer new subclassesOf: self.
%
category: 'Accessing'
method: PositionableStream
nextLine

| result cr lf char |
result := itsCollection species new.
cr := Character cr.
lf := Character lf.
[self atEnd not _and: [(char := self peek) ~~ cr _and: [char ~~ lf]]] whileTrue: [
  result add: self next
].
self atEnd not ifTrue: [
  self next.
  (self atEnd not _and: [char == cr _and: [self peek == lf]]) ifTrue: [
    self next.
  ].
].

^result
%
category: 'Accessing'
method: PositionableStream
peekFor: anObject

self peek = anObject ifTrue: [
  self next.
  ^true.
].
^false.
%
category: 'Enumerating'
method: Collection
anySatisfy: aBlock

	self do: [:each | 
		(aBlock value: each) ifTrue: [^true].
	].
	^false.
%
category: 'Enumerating'
method: Collection
allSatisfy: aBlock

	self do: [:each | 
		(aBlock value: each) ifFalse: [^false].
	].
	^true.
%
