/*========================================================================
 * Written by D. Jason Penney, 1991.  Rights to this program are as follows:
 * you may not receive any compensation for distribution of this program
 * except for an optional fee for the distribution medium.  This program
 * must be accompanied by this source code.  This notice may not be removed.
 * Modifications to this program must be clearly noted and marked as such.
 * Since this program is provided free of charge, there is ABSOLUTELY NO
 * WARRANTY.
 *
 * Name - getdtablesize.c
 *
 * Description - Program to return max number of file descriptors, e.g.,
 *               by the getdtablesize(2) call.
 *
 * Compile with:
 *   cc -o getdtablesize getdtablesize.c
 *   chmod 555 getdtablesize
 *
 *
 * $Id: getdtablesize.c,v 1.2 2007-04-12 06:52:42 otisa Exp $
 *
 *========================================================================
 */

#if defined(__hpux)
#if !defined(_HPUX_SOURCE)
#define _HPUX_SOURCE
#endif /* !defined(_HPUX_SOURCE) */
#include <sys/stdsyms.h> /* Pick up the other related #defs */
#endif

#include <stdio.h>
#include <errno.h>

/* following for setrlimit call */
#include <sys/time.h>
#include <sys/resource.h>

#include <unistd.h>
#if defined(hpux) || defined(__hpux) || defined(sparcSolaris) || defined(i386)
#define getdtablesize() sysconf(_SC_OPEN_MAX)
#endif

#include <stdlib.h>

#include <sys/types.h>

int main(int argc, char *argv[])
{
if (argc != 1) {
  printf("Usage: %s\n", argv[0]);
  exit(1);
  }
#if defined(RLIMIT_NOFILE)
{ 
struct rlimit rl, saveRl;

if (getrlimit(RLIMIT_NOFILE, &rl) != 0) {
  fprintf(stderr, "getrlimit failure,  errno = %d\n", errno);
  exit(1);
  }
saveRl = rl;
rl.rlim_cur = RLIM_INFINITY;
rl.rlim_max = RLIM_INFINITY;
if (setrlimit(RLIMIT_NOFILE, &rl) != 0) {
  rl = saveRl;
  rl.rlim_cur = rl.rlim_max;
  if (setrlimit(RLIMIT_NOFILE, &rl) != 0) {
    fprintf(stderr, "setrlimit failure, errno = %d\n", errno);
    }
  }
}
#endif

printf("%d", getdtablesize());

/* Little nicety: make friendlier for interactive use */
if (isatty(fileno(stdout)))
  printf("\n");
return 0; /* for lint */
}
