/**========================================================================
 * Copyright (C) VMware Inc. 1986-2011.  All Rights Reserved.
 *
 *  Name - gcicpp.hc
 *
 * $Id: gcicpp.hc,v 1.7 2008-01-09 22:51:03 stever Exp $
 *
 *   implementations of C++ functions that are declared dllexport when
 *   building GCI and   dllimport by customer  .
 *
 *   These functions are needed in both gcirpc.so and  executables
 *   containing gcirtl.o .
 * ========================================================================
 */

GciTravBufType* GciTravBufType::malloc(size_t allocationSize, int lineNum, const char* fileName)
{
  GciTravBufType *result = NULL;
  size_t allocSize = UTL_ALIGN(allocationSize, 8);
  size_t totalSize = sizeof(*result) - sizeof(result->body) + allocSize;
  if (fileName == NULL) {
    fileName = "traBuf:" ;
  }
  result = (GciTravBufType*)GciUtlMalloc_(totalSize, fileName, lineNum);
  if (result == NULL) {
    return NULL;
  }
  result->allocatedBytes = allocSize;
  result->usedBytes = 0;
  return result;
}

void GciTravBufType::free() 
{
  this->usedBytes = -1;
  this->allocatedBytes = -1;
  GciFree(this);
}

GciTravBufType::GciTravBufType(size_t allocationSize)
{
  printf("illegal use of GciTravBufType::GciTravBufType()\n  use GciTravBufType::malloc() instead \n");
  GciHostCallDebuggerMsg("illegal use of GciTravBufType::GciTravBufType()");  
}

GciTravBufHolder::GciTravBufHolder(size_t allocationSize) 
{
  buf = GciTravBufType::malloc(allocationSize);
}

GciTravBufHolder::GciTravBufHolder(GciTravBufType *aBuffer) 
{
  buf = aBuffer;
}

GciTravBufHolder:: ~ GciTravBufHolder() 
{
  buf->free();
  buf = NULL;
}

