#set -xv
#=========================================================================
# Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
#
# Name - gemsetup.sh
#
# Purpose - This is a POSIX-compliant shell "." file that explicitly defines
#	    your GemStone environment.
#
#	    It performs the following steps:
#
#	    a) It adds $GEMSTONE/bin to the end of your PATH.  This is "safe"
#	       in the sense that it will avoids breaking existing user commands
#	       and applications.  It is "unsafe" in the sense that an existing
#	       user command may silently supersede a GemStone-defined command,
#	       such as "topazl".
#
#           b) It adds $GEMSTONE/doc to the end of your MANPATH.  This will
#	       not work with Ultrix and DG/UX man commands, which are not
#	       POSIX compliant.
#
# Note that this script requires a GEMSTONE environment variable that points
# to a valid GemStone directory.
#
# $Id: gemsetup.sh,v 1.4 2008-01-09 22:50:52 stever Exp $
#
#=========================================================================

# maintenance symbols
GEMSTONE_VERSION=10

ok=1

# Set GEMSTONE environment variable
if [ "x$GEMSTONE" = "x" ]; then
    echo "gemsetup[Error]: Do not know the location of the GemStone files."
    echo "   Please set the GEMSTONE environment variable, and rerun this script."
    ok=0
else
# echo "gemsetup[Warning]:  Using default GEMSTONE $GEMSTONE"
  export GEMSTONE # just in case
fi

# Make test so that -d doesn't crash
if [ $ok -eq 1 ]; then
  if [ x$GEMSTONE = x ]; then
    echo "gemsetup[Error]:    GEMSTONE definition is empty"
    ok=0
  fi
fi

# Verify existence of directory
if [ $ok -eq 1 ]; then
  if [ ! -d $GEMSTONE ]; then
    echo "gemsetup[Error]:    directory GEMSTONE does not exist"
    echo "    GEMSTONE=$GEMSTONE"
    ok=0
  fi
fi

# Set path, manpath, etc.
if [ $ok -eq 1 ]; then
  export GEMSTONE
  gs_savepath=$PATH
  PATH=$PATH:$GEMSTONE/bin;    	     export PATH
  defaultManPath=/usr/man
  gsuHOSTTYPE=`uname -s`
  case "x$gsuHOSTTYPE" in
    xAIX) # IBM RIOS/AIX 
      defaultManPath=/usr/share/man
      ;;
    xHP-UX) # HP Snake
      # peculiar defaults...
      defaultManPath=/usr/man:/usr/contrib/man:/usr/local/man
      ;;
    *)
      # do nothing special...
      defaultManPath=/usr/man
      ;;
    esac
  if [ "x$MANPATH" = "x" ]; then
    MANPATH=${defaultManPath}:$GEMSTONE/doc
  else
    MANPATH=${MANPATH}:$GEMSTONE/doc
  fi
  unset defaultManPath
  export MANPATH
else
  echo "gemsetup[Warning]:  GemStone version $GEMSTONE_VERSION setup aborted."
  ok=1
fi
