!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: simpleblock.gs,v 1.5 2008-01-09 22:50:17 stever Exp $
!
! Superclass Hierarchy:
!   SimpleBlock, ExecutableBlock, BlockClosure, Object.
!
!=========================================================================

removeallmethods SimpleBlock
removeallclassmethods SimpleBlock

category: 'For Documentation Installation only'
classmethod: SimpleBlock
installDocumentation

| doc txt |
doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details:
'A SimpleBlock is an ExecutableBlock that does not refer to any enclosing scope
 variables.  Thus, unlike complex blocks, it needs no variable context at any
 time.

 The GemStone Smalltalk compiler creates all simple blocks.' .
doc documentClassWith: txt.

self description: doc.
%
category: 'Block Evaluation'
method: SimpleBlock
value

"Return the value of the receiver evaluated with no arguments.
 If the block expects any arguments, an error is generated."

<primitive: 910>  "special bytecode"
^ self _primitiveFailed: #value
%

category: 'Block Evaluation'
method: SimpleBlock
value: anObject

"Return the value of the receiver evaluated with anObject as its argument.  If
 the block expects a different number of arguments, an error is generated."

<primitive: 910>  "special bytecode"
^ self _primitiveFailed: #value:
%

category: 'Block Evaluation'
method: SimpleBlock
value: firstObject value: secondObject

"Return the value of the receiver evaluated with the two objects as its
 arguments.  If the block expects a different number of arguments, an error is
 generated."

<primitive: 910>  "special bytecode"
^ self _primitiveFailed: #value:value:
%

category: 'Block Evaluation'
method: SimpleBlock
value: firstObject value: secondObject value: thirdObject

"Return the value of the receiver evaluated with the three objects as its
 arguments.  If the block expects a different number of arguments, an error is
 generated."

<primitive: 910>  "special bytecode"
^ self _primitiveFailed: #value:value:value:
%

category: 'Block Evaluation'
method: SimpleBlock
value: first value: second value: third value: fourth

"Return the value of the receiver evaluated with the four objects as
 its arguments.  If the block expects a different number of arguments,
 an error is generated."

<primitive: 910>  "special bytecode"
^ self _primitiveFailed: #value:value:value:value:
%

category: 'Block Evaluation'
method: SimpleBlock
value: first value: second value: third value: fourth value: fifth

"Return the value of the receiver evaluated with the five objects as
 its arguments.  If the block expects a different number of arguments,
 an error is generated."

<primitive: 910>  "special bytecode"
^ self _primitiveFailed: #value:value:value:value:value:
%

category: 'Block Evaluation'
method: SimpleBlock
valueWithArguments: argList

"Return the value of the receiver evaluated with the elements of the Array
 argList as arguments.  If the block expects a different number of arguments,
 an error is generated."

<primitive: 911>  "special bytecode"
^ self _primitiveFailed: #valueWithArguments: 
%


category: 'Accessing'
method: SimpleBlock
_sourceString

"Return a string that will create a block similar to the receiver when
 the string is compiled."

| result |
result := String new.
result add: $^ .
method _sourceString
  copyFrom: firstSourceOffset 
  to: lastSourceOffset
  into: result
  startingAt: 2.

^result
%

category: 'Repository Conversion'
method: SimpleBlock
_sourceStringForConversion

"Returns a string that will create a block similar to the receiver when
 the string is compiled.  Fixes up the string appropriately since the 
 source string comes from a CompiledMethod rather than a GsMethod."

| src |

src := self _sourceString.

((src at: 2) == ${)
  ifTrue: [
    src add: $}.
    ]
  ifFalse: [
    ((src at: 2) == $[)
      ifFalse: [
        src copyFrom: 2 to: src size
            into: src startingAt: 3.
        src at: 2 put: $[
        ].
    src add: $].
    ].

^ src.
%

category: 'Testing'
method: SimpleBlock
isSimple

"Return true.  The receiver is a simple block."

^ true
%

! deleted convertTo5With: symbolList oldNamesDict: oldNamesDict

category: 'Disassembly'
classmethod: SimpleBlock
_cost

^ 1

%
