!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: sessiontemps.gs,v 1.2 2008-01-09 22:50:15 stever Exp $
!
! Superclass Hierarchy:
!    SessionTemps, SymbolDictionary, IdentityDictionary, IdentityKeyValueDictionary, 
!    KeyValueDictionary, AbstractDictionary, Collection, Object
!
!=========================================================================

expectvalue %String
run
| oldCls newCls |
oldCls := Globals at:#SessionTemps otherwise: nil .
oldCls == nil ifTrue:[
  SymbolDictionary _newKernelSubclass: #SessionTemps
    instVarNames: #()
    classVars: #()
    classInstVars: #()
    poolDictionaries: #()
    inDictionary: Globals
    constraints: #[ ]
    instancesInvariant: false
    isModifiable: true
    reservedOop: nil.
  (Globals at:#SessionTemps) makeInstancesNonPersistent.
  (Globals at:#SessionTemps) immediateInvariant.
  newCls := (Globals at:#SessionTemps) .
  ^ 'created new class: ' + newCls definition
  ]
ifFalse:[
  ^ 'existing class: ' + oldCls definition
  ]
%

removeallmethods SessionTemps
removeallclassmethods SessionTemps

category: 'For Documentation Installation only'
classmethod: SessionTemps
installDocumentation

| doc txt |
doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details:
'Instances of SessionTemps may not be committed. The primary use of this class
 is via the class method #current, which returns an instance of SessionTemps
 that is stored in Transient Session State.' .
doc documentClassWith: txt.

self description: doc.
%

! ------------------- Class methods for SessionTemps
category: 'Session Temporaries'
classmethod: SessionTemps
current
 | d |
d := System _sessionStateAt: 1.
d == nil 
  ifTrue: [
    d := SessionTemps new.
    System _sessionStateAt: 1 put: d.
  ].
^d
%
