!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: selectblock.gs,v 1.7 2008-01-09 22:50:14 stever Exp $
!
! Superclass Hierarchy:
!   SelectBlock, BlockClosure, Object.
!
!=========================================================================

removeallmethods SelectBlock
removeallclassmethods SelectBlock

category: 'For Documentation Installation only'
classmethod: SelectBlock
installDocumentation

| doc txt |
doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details:
'SelectBlock is a concrete subclass of BlockClosure that supports selection
 blocks for associative access.' .
doc documentClassWith: txt.

txt := (GsDocText new) details:
'An ExecutableBlock.  The firstPC instance variable of this block refers to the
 first bytecode to execute to begin an associative access query, and the lastPC
 instance variable refers to the last bytecode of the associative access
 query.'.
doc documentInstVar: #queryBlock with: txt.

txt := (GsDocText new) details:
'An ExecutableBlock.  The firstPC instance variable of this block refers to the
 first bytecode to execute to begin execution of this block in GemStone 
 Smalltalk (no associative access), and the lastPC instance variable refers 
 to the last bytecode of the block''s GemStone Smalltalk execution.'.
doc documentInstVar: #iterationBlock with: txt.

self description: doc.
%

category: 'Accessing'
method: SelectBlock
queryBlock

"Returns the value of the queryBlock instance variable."

^queryBlock
%

category: 'Accessing'
method: SelectBlock
iterationBlock

"Returns the value of the iterationBlock instance variable."

^iterationBlock
%

category: 'Block Evaluation'
method: SelectBlock
value: anObject

"Returns the value of the receiver evaluated with anObject as its
 argument.  A SelectBlock can only take one argument."

^iterationBlock value: anObject
%

category: 'Repository Conversion'
method: SelectBlock
convertTo5With: symbolList oldNamesDict: oldNamesDict

"If the receiver is a SelectBlock from an earlier release, convert it to
 the new form. This method is to be used only for converting SelectBlocks
 from GemStone 4.1 to the current release."

| result |

(iterationBlock _class == SelectBlock)
  ifFalse: [
    result := iterationBlock convertTo5With: symbolList 
			     oldNamesDict: oldNamesDict
    ].

(iterationBlock _class == SelectBlock)
  ifTrue: [
    self _primitiveBecome: iterationBlock.
    ].

^ result.
%
