!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: removeemptycateg.gs,v 1.8 2008-01-09 22:50:14 stever Exp $
!
!========================================================================


level 2
expectvalue %Array
run

"Removes empty categories from all Classes and Metaclasses in Globals.
 Returns an Array describing the categories removed."

| result |
result := Array new .

Globals associationsDo: [ :globalsAssoc | | aClass emptyCategoryNames theClass |
  aClass := globalsAssoc value .

  (aClass isKindOf: Behavior) ifTrue:[ 
    theClass := aClass .

    2 timesRepeat:[
      emptyCategoryNames := Array new .
      theClass _categories associationsDo: [ :categAssoc |
        categAssoc value size == 0 ifTrue:[
          emptyCategoryNames add: categAssoc key
          ].
        ].
      emptyCategoryNames do:[ :aName |
        theClass removeCategory: aName .
        result add: #[ theClass, aName ] .
        ].
      theClass := theClass class . "handle the Metaclass on second pass"
      ].

    ].
  ].  
^ result
%
level 0

! remove the _unsafeSetOop: method
!
expectvalue %String
run
(Object includesSelector: #_unsafeSet11Oop:) ifTrue:[
  Object removeSelector: #_unsafeSet11Oop: .
  ^ 'removed'
  ].
^ 'not found'
% 

expectvalue %String
run
(Object includesSelector: #_unsafeSetOop:) ifTrue:[
  Object removeSelector: #_unsafeSetOop: .
  ^ 'removed'
  ].
^ 'not found'
% 

! do not remove Object(C)>>_objectForOop: method , fix 32731

