!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: readstr.gs,v 1.4 2008-01-09 22:50:14 stever Exp $
!
! Superclass Hierarchy:
!   ReadStream, PositionableStream, Stream, Object.
!
!=========================================================================

removeallmethods ReadStream
removeallclassmethods ReadStream

category: 'For Documentation Installation only'
classmethod: ReadStream
installDocumentation

| doc txt |
doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details:
'A ReadStream is a PositionableStream that allows its objects to be read but
 not written.'.
doc documentClassWith: txt.

self description: doc.
%

category: 'Instance Creation'
classmethod: ReadStream
new

"Disallowed.  To create a new ReadStream, use the class method on: instead."

self shouldNotImplement: #new
%

category: 'Accessing'
method: ReadStream
next

"Returns the next object that the receiver can access for reading.  Generates
 an error if an attempt is made to read beyond the end of the stream."

(self atEnd)
   ifTrue: [ ^ self _error: #rtErrEofOnReadStream].
position := position + 1.
^ itsCollection at: (position - 1)
%

category: 'Accessing'
method: ReadStream
nextElements: count into: anObject

"Stores the next count elements that the receiver can access for reading
 into anObject.  The receiver's collection and anObject must be compatible
 SequenceableCollections.  Returns the count of elements read.

 Generates an error if an attempt is made to read beyond the end of the stream."

"Used by PassiveObject."

count <= 0 ifTrue:[ ^ 0 ].
(self atEnd)
   ifTrue: [ ^ self _error: #rtErrEofOnReadStream].
itsCollection copyFrom: position to: position + count - 1 into: anObject
   startingAt: 1 .
position := position + count.
^ count
%

category: 'Adding'
method: ReadStream
nextPut: anObject

"Disallowed.  You cannot write to a ReadStream."

self shouldNotImplement: #nextPut:
%

category: 'Accessing'
method: ReadStream
_fastNext

"Returns the next item on the input stream without end of stream checks.
 This may result in a bad access error instead of an end of stream error."

| res |
res := itsCollection at: position.
position := position + 1.
^res
%

category: 'Positioning'
method: ReadStream
_fastPosition: pos

"Sets the position of the receiver without checking the validity of the
 argument 'pos'.  This may result in bad index errors instead of end
 of stream errors in subsequent access of the stream."

position := pos
%

