!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: rcbtreebasicleaf.gs,v 1.5 2008-01-09 22:50:13 stever Exp $
!
! Superclass Hierarchy:
!   RcBtreeBasicLeafNode, BtreeBasicLeafNode, BtreeLeafNode, BtreeNode, Array,
!   SequenceableCollection, Collection, Object.
!
!=========================================================================

! class created in idxclasses.topaz

removeallmethods RcBtreeBasicLeafNode
removeallclassmethods RcBtreeBasicLeafNode

category: 'For Documentation Installation only'
classmethod: RcBtreeBasicLeafNode
installDocumentation

| doc txt |
doc := GsClassDocumentation _newForPrivateGsClass: self.

txt := (GsDocText new) details:
'A RcBtreeBasicLeafNode represents an exterior node of a B-tree for which a binary
 search can be done for a key. Updates to instances of this class are logged and 
 can  be replayed in the case of commit conflicts.' .
doc documentClassWith: txt.

self description: doc.
%

! ------------------- Class methods for RcBtreeBasicLeafNode
! ------------------- Instance methods for RcBtreeBasicLeafNode
category: 'Updating'
method: RcBtreeBasicLeafNode
at: aKey put: aValue

self shouldNotImplement: #at:put:
%
category: 'Updating'
method: RcBtreeBasicLeafNode
btreeAt: aKey put: aValue

""

self shouldNotImplement: #btreeAt:put:
%
category: 'Updating'
method: RcBtreeBasicLeafNode
btreeAt: aKey put: aValue for: anIndexObj logging: aBoolean

| res |
res := super at: aKey put: aValue.
System _addRootObjectToRcReadSet: self.
System redoLog addConflictObject: self for: anIndexObj.
res ~~ self
  ifTrue: [
    System redoLog addConflictObject: res for: anIndexObj.
    System _addRootObjectToRcReadSet: res.
  ].
^res
%
category: 'Constants'
method: RcBtreeBasicLeafNode
parentNodeClass

"Returns the class of node to be created as the parent when a split occurs."

^ RcBtreeBasicInteriorNode
%
category: 'Removing'
method: RcBtreeBasicLeafNode
removeKey: aKey value: aValue

self shouldNotImplement: #removeKey:value:
%
category: 'Removing'
method: RcBtreeBasicLeafNode
removeKey: aKey value: aValue for: anIndexObj logging: aBoolean

| res |
res := super removeKey: aKey value: aValue.
System _addRootObjectToRcReadSet: self.
System redoLog addConflictObject: self for: anIndexObj.
^res
%
