!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: obssymbolset.gs,v 1.4 2008-01-09 22:50:13 stever Exp $
!
! Superclass Hierarchy:
!   ObsoleteSymbolSet, IdentitySet, IdentityBag, UnorderedCollection,
!   Collection, Object.
!
!=========================================================================

removeallmethods ObsoleteSymbolSet
removeallclassmethods ObsoleteSymbolSet

category: 'For Documentation Installation only'
classmethod: ObsoleteSymbolSet
installDocumentation

| doc txt |

doc := GsClassDocumentation _newForObsoleteGsClass: self asOfGsVersion: '5.0'.

txt := (GsDocText new) details:
'Existing instances should be migrated to SymbolSet or otherwise processed as
 required, and then should be removed.' .
doc documentClassWith: txt.

self description: doc.
%

! remove: inherited from IdentitySet
! remove: aSymbol ifAbsent: aBlock  inherited from IdentitySet

category: 'Accessing'
method: ObsoleteSymbolSet
_returnValueOf: anObject

"Returns the element of the receiver whose value is the same as the argument.
 If the argument is not equal to any value in the receiver, then add the
 argument to the receiver."

|symbolizedObject|

symbolizedObject := anObject asObsoleteSymbol.
self add: symbolizedObject.
^ symbolizedObject
%

! add: inherited from IdentitySet
! addAll:  inherited from IdentitySet

category: 'Adding'
method: ObsoleteSymbolSet
_addSymbol: aSymbol

"Obsolete, provided for compatibility.
 Same functionality as IdentitySet | add: "

^ self add: aSymbol
%

category: 'Repository Conversion'
method: ObsoleteSymbolSet
convertToSymbolSet

"Private. Changes the receiver from being an instance of ObsoleteSymbolSet to
 an instance of SymbolSet. Used in Repository Conversion."

<primitive: 487>
self _primitiveFailed: #convertToSymbolSet
%

category: 'Repository Conversion'
method: ObsoleteSymbolSet
rehashForConversion

"Private. Rebuilds an NSC to fix up internal sort order of the elements.
 Returns the receiver."

| contentClassSet |

contentClassSet := IdentitySet new.
self do: [ :anElement |
  contentClassSet add: (anElement _class)
  ].

(contentClassSet includes: ObsoleteSymbol)
  ifFalse: [ self convertToSymbolSet ].

^ self. 
%

category: 'Repository Conversion'
classmethod: ObsoleteSymbolSet
_correspondingNewClass

"The class all instances of receiver are converted to during conversion."

(self == ObsoleteSymbolSet)
  ifTrue: [ ^ SymbolSet ].

^ self.
%

