!=========================================================================
! Copyright (C) VMware, Inc. 2003-2011.  All Rights Reserved.
! Name -  migratesyms.gs
!   
!  $Id: migratesyms.gs,v 1.3 2008-01-09 22:50:12 stever Exp $
!
! Code to migrate AllSymbols from pre-Gs64 format to current format
!=======================================================================
expectvalue true
run
| oldBlk saveSeg |
Segment setCurrent: (Globals at:#DataCuratorSegment ) while:[
  oldBlk := Globals at:#MigrateAllSymbolsBlock otherwise:nil .
  oldBlk ~~ nil ifTrue:[ ^ 'error, key exists' ].
  Globals at:#MigrateAllSymbolsBlock put:[
    | newAllSyms oldDict oldSize newSize |
    System currentSegment: SystemSegment .
    newAllSyms := CanonSymbolDict 
	  _new: 2017 "prime less than  (2024 - CanonSymbolDict instSize) " .
    oldDict := Globals at:#AllSymbols .
    oldSize := oldDict size .
    oldDict keysDo:[:aKey | newAllSyms addKey: aKey ].
    oldDict _basicSize: 0 .
    oldDict _initializeWithoutClear: 0 .
    newAllSyms _unsafeSetOop: 240385 .
    System currentSegment: Globals segment .
    Globals at: #AllSymbols put: newAllSyms .
    newSize := newAllSyms size .  
    "note that oldSize may be understated, bug 31353 "
    newSize < oldSize ifTrue:[
      nil error:'error size mismatch old ' + oldSize asString + ' new '
				  + newSize asString
    ].
    System commitTransaction ifFalse:[ nil error:'commit failed' ].
    'AllSymbols converted to a CanonSymbolDict'.
  ].
].
^ true
%
commit

