!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: identryholder.gs,v 1.7 2008-01-09 22:50:11 stever Exp $
!
! Superclass Hierarchy:
!   IndexDictionaryEntryHolder, Array, SequenceableCollection, Collection,
!   Object.
!
!=========================================================================

! class created in idxclasses.topaz

removeallmethods IndexDictionaryEntryHolder
removeallclassmethods IndexDictionaryEntryHolder

category: 'For Documentation Installation only'
classmethod: IndexDictionaryEntryHolder
installDocumentation

| doc txt |

doc := GsClassDocumentation _newForPrivateGsClass: self.

txt := (GsDocText new) details:
''.

doc documentClassWith: txt.

self description: doc.
%

! ------------------- Class methods for IndexDictionaryEntryHolder

category: 'Instance Creation'
classmethod: IndexDictionaryEntryHolder
new

"Returns a new instance of the receiver."

^ (super new: 2001) initialize
%

! ------------------- Instance methods for IndexDictionaryEntryHolder

category: 'Initialization'
method: IndexDictionaryEntryHolder
initialize

"Initializes the receiver."

offset := 1.
count := 1.
%

category: 'pdating'
method: IndexDictionaryEntryHolder
addKey: aKey value: aValue term: pathTerm from: array at: index

"Adds the given triplet to the receiver."

" see if the receiver is getting too large "
offset > 2001
  ifTrue: [ | newOne |

    " see if we've linked too many together "
    count == 10
      ifTrue: [
        " cause index dictionary to be updated "
        self update.
        self at: 1 put: aKey.
        self at: 2 put: aValue.
        self at: 3 put: pathTerm.
        offset := 4.
        link := nil.
        ^ self
      ].

    " create a new holder and link it to this one "
    newOne := self class new.
    newOne addKey: aKey value: aValue term: pathTerm from: array at: index.
    newOne link: self.
    newOne indexDictionary: indexDictionary.
    newOne count: count + 1.
    array at: index put: newOne.
    ^ newOne
  ].
self at: offset put: aKey.
self at: offset + 1 put: aValue.
self at: offset + 2 put: pathTerm.
offset := offset + 3.
%

category: 'pdating'
method: IndexDictionaryEntryHolder
update

"Updates the given index dictionary with all entries in the receiver."

" indicate that it is ok to update the dictionary "
indexDictionary okToUpdate: true.
1 to: offset - 1 by: 3 do: [ :i |
  indexDictionary _at: (self at: i)
    put: (self at: i + 1)
    term: (self at: i + 2)
    logging: false
].
link ~~ nil
  ifTrue: [ link update ].
" indicate that it is not ok to update the dictionary "
indexDictionary okToUpdate: false.
%

category: 'Updating'
method: IndexDictionaryEntryHolder
link: aValue

"Sets the value of the 'link' instance variable."

link := aValue
%

category: 'Updating'
method: IndexDictionaryEntryHolder
count: aValue

"Sets the value of the 'count' instance variable."

count := aValue
%

category: 'Updating'
method: IndexDictionaryEntryHolder
indexDictionary: aValue

"Sets the value of the 'indexDictionary' instance variable."

indexDictionary := aValue
%
