! ObsoleteIDX - This class will become Obsolete in the next release of GSS64.
!
!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: idbtreenode.gs,v 1.7 2008-01-09 22:50:11 stever Exp $
!
! Superclass Hierarchy:
!   IdentityBtreeNode, BtreeLeafNode, BtreeNode, Array,
!   SequenceableCollection, Collection, Object.
!
!=========================================================================

! class created in idxclasses.topaz

removeallmethods IdentityBtreeNode
removeallclassmethods IdentityBtreeNode
protectmethods

category: 'For Documentation Installation only'
classmethod: IdentityBtreeNode
installDocumentation

<unprotected>

| doc txt |

doc := GsClassDocumentation _newForPrivateGsClass: self.

txt := (GsDocText new) details:
'ObsoleteIDX: This class will become Obsolete in the next release of GSS64.

 An IdentityBtreeNode is a BtreeLeafNode that supports identity comparisons on
 its keys.' .
doc documentClassWith: txt.

txt := GsDocText new.
doc documentClassWith: txt.

self description: doc.
%

category: 'ObsoleteIDX - Searching'
method: IdentityBtreeNode
_binarySearchCoveringKey: aKey

"Returns the index for the first entry in which aKey is found utilizing a
 binary search.  This is the first entry whose key >= aKey."

<protected primitive: 356>

self _primitiveFailed: #_binarySearchCoveringKey: .
self _uncontinuableError
%

category: 'ObsoleteIDX - Searching'
method: IdentityBtreeNode
_binarySearchForKey: aKey

"Returns the 'value' index whose key is identical to aKey.  If no match is
 found, returns zero.  Uses a binary search."

<protected primitive: 357>

self _primitiveFailed: #_binarySearchForKey: .
self _uncontinuableError
%

category: 'ObsoleteIDX - Updating'
method: IdentityBtreeNode
at: aKey put: aValue

"Adds the key/value pair to the node.  If the node is full, raises an error."

<unprotected primitive: 901>

| index |

" determine if full "
numElements == self class maxNumberOfElements
  ifTrue: [
    ^ self _error: #objErrMaxSize
        args: #[ numElements + 1, self class maxNumberOfElements ]
  ]
  ifFalse: [ " entry will fit in leaf node "
    numElements == 0
      ifTrue: [ index := 1 ]
      ifFalse: [ index := self _binarySearchCoveringKey: aKey ].
    self _insertKey: aKey value: aValue atIndex: index
  ].
System _disableProtectedMode.
%

category: 'ObsoleteIDX - Removing'
method: IdentityBtreeNode
removeKey: aKey ifAbsent: block

"Removes the key/value pair.  Finds the index for the given key and then shifts
 any following entries to the left."

<unprotected primitive: 901>

| valueIndex result |

valueIndex := self _binarySearchForKey: aKey.

valueIndex == 0
  ifTrue: [
    System _disableProtectedMode.
    ^ block value
  ].

result := self _at: valueIndex.

self _deleteNoShrinkFrom: valueIndex to: valueIndex + self entrySize - 1 .
numElements := numElements - 1.

System _disableProtectedMode.
^ result
%

category: 'ObsoleteIDX - Removing'
method: IdentityBtreeNode
removeKey: aKey otherwise: otherVal

"Removes the key/value pair.  Finds the index for the given key and then shifts
 any following entries to the left."

<unprotected primitive: 901>

| valueIndex result |

valueIndex := self _binarySearchForKey: aKey.

valueIndex == 0
  ifTrue: [
    System _disableProtectedMode.
    ^ otherVal
  ].

result := self _at: valueIndex.

self _deleteNoShrinkFrom: valueIndex to: valueIndex + self entrySize - 1 .
numElements := numElements - 1.

System _disableProtectedMode.
^ result
%

category: 'ObsoleteIDX - Accessing'
method: IdentityBtreeNode
at: aKey otherwise: otherValue

"Returns the value that corresponds to aKey by searching the elements in the
 bucket.  If no such key/value pair exists, returns the given alternate value."

<unprotected primitive: 901>

| valueIndex |

valueIndex := self _binarySearchForKey: aKey.

valueIndex == 0
  ifTrue: [
    System _disableProtectedMode.
    ^ otherValue
  ].

System _disableProtectedMode.
^ self _at: valueIndex
%

category: 'ObsoleteIDX - Private'
method: IdentityBtreeNode
parent

"Returns the back pointer to the parent."

<unprotected>
" Stored in the tag slot so that we do not disturb binary search in C."
^ self tagAt: 1
%

category: 'ObsoleteIDX - Private'
method: IdentityBtreeNode
parent: anObj

"Sets the parent of the receiver."

<unprotected>
" Stored in the tag slot so that we do not disturb binary search in C."
self tagAt: 1 put: anObj
%

! deleted _canonicalizeSymbolAt: offset oldSymbol: oldSym newSymbol: newSym


unprotectmethods

