!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: iarray.gs,v 1.6 2008-01-09 22:50:11 stever Exp $
!
! Superclass Hierarchy:
!   InvariantArray, Array, SequenceableCollection, Collection, Object.
!
!=========================================================================

removeallmethods InvariantArray
removeallclassmethods InvariantArray

category: 'For Documentation Installation only'
classmethod: InvariantArray
installDocumentation

| doc txt |

doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details:
'An InvariantArray is an Array that is made to be invariant (immutable) when it
 is committed, if it is not already invariant before then.  Unless otherwise
 handled explicitly, an InvariantArray that has not yet been committed is still
 modifiable.  Array literals are always invariant; if you assign one to a
 variable, then the object to which the variable refers cannot be changed.

 Immutability implies that the Array''s size, ordering of elements, and
 element membership cannot be changed.  Thus, if an object is an element of the
 Array, that same object must remain an element of the Array, and it must remain
 located at its current index.  Immutability does not imply that the element
 object itself cannot be changed, but only that its relation to the Array is
 immutable.' .
doc documentClassWith: txt.

self description: doc.
%

category: 'Repository Conversion'
method: InvariantArray
convertTo5

"Returns an Array with the contents of the receiver.  The contents are also sent
 the method convertTo5.  There could be an infinite recursion if the receiver
 contained itself."

| newArray selfSize |

selfSize := self size.
newArray := Array new: (selfSize).
newArray assignToSegment: self segment .

1 to: selfSize do: [ :i |
  newArray at: i put: ((self at: i) convertTo5).
  ].

^ newArray.
%

category: 'Repository Conversion'
method: InvariantArray
convertConstraints

"Returns an Array with the contents of the receiver."

| newArray selfSize |

selfSize := self size.
newArray := Array new: (selfSize).
newArray assignToSegment: self segment .

1 to: selfSize do: [ :i |
  newArray at: i put: (self at: i) 
  ].

^ newArray.
%

category: 'Repository Conversion'
method: InvariantArray
convertPoolDictionaries

"Converts the contents of the InvariantArray to those required in GemStone 5.0.
 Replaces each element of the receiver with the result of sending
 convertPoolDictionary to that element.  (The receiver in this case is always
 the pool dictionaries Array).  Returns the receiver."

1 to: self size do: [ :i |
  (self at: i) convertPoolDictionary.
  ].
%
