! ========================================================================
! Copyright (C) by VMware, Inc. 1991-2011.  All Rights Reserved
!
! $Id: gsparams.gs,v 1.6 2008-01-09 22:50:11 stever Exp $
!
! ========================================================================

expectvalue %String
run
  ^ Object _newKernelSubclass: #GemStoneParameters
  instVarNames: #(#gemStoneName #username #password
		#hostUsername #hostPassword #gemService)
  classVars: #()
  classInstVars: #()
  poolDictionaries: #[]
  inDictionary: Globals
  constraints: #[#[#username, String],
                  #[#password, String],
                  #[#gemStoneName, String],
                  #[#hostUsername, String],
                  #[#hostPassword, String],
                  #[#gemService, String]]
  instancesInvariant: false
  isModifiable: false
  reservedOop: 919
%

! Remove existing behavior from GemStoneParameters
removeallmethods GemStoneParameters
removeallclassmethods GemStoneParameters

! ------------------- Class methods for GemStoneParameters
classmethod: GemStoneParameters
new

"Create a new initialized instance."

^ self basicNew initialize.
%

! ------------------- Instance methods for GemStoneParameters
method: GemStoneParameters
initialize

"Initialize the instance variables of the receiver."

%
category: 'Updating'
method: GemStoneParameters
_encrypt: aString

"Return a new, encrypted string from the given string. ."

^ self _oneArgPrim: 24 with: aString
%
category: 'Error Handling'
method: GemStoneParameters
_errorBadPassword

"Raise an error because could encrypt and store a password."

self _error: #rtErrPasswordNotVariant args: #()
%
category: 'Private'
method: GemStoneParameters
_getArg: ivOffset key: key

"Obsolete method"


<protected primitive: 485>

^ nil
%
category: 'Private'
method: GemStoneParameters
_secureArg: ivOffset key: key

"Obsolete method"


<protected primitive: 490>

^ nil
%
category: 'Private'
method: GemStoneParameters
_zeroArgPrim: opcode

"Primitive dispatch.  Legal values:
    40: GemStoneParameters | _securePasswords
"

<primitive: 197>

^self primitiveFailed: #_zeroArgPrim:
%
method: GemStoneParameters
_oneArgPrim: opcode with: arg

"Primitive dispatch. Legal values:
    24 GemStoneParameters | _encrypt:
"

<primitive: 198>

^self primitiveFailed: #_oneArgPrim:
%
method: GemStoneParameters
_securePasswords
"Do not allow anyone to read passwords."

| result |

result := self _zeroArgPrim: 40.
^ result
%
category: 'Accessing'
method: GemStoneParameters
gemService

   "Return the value of the instance variable 'gemService'."
   ^gemService
%
category: 'Updating'
method: GemStoneParameters
gemService: newValue

   "Modify the value of the instance variable 'gemService'."
   gemService := newValue
%
category: 'Accessing'
method: GemStoneParameters
gemStoneName

   "Return the value of the instance variable 'gemStoneName'."

^ gemStoneName
%
category: 'Accessing'
method: GemStoneParameters
gemStoneName: aName

"Set the gemStone name."

gemStoneName := aName.
%
category: 'Accessing'
method: GemStoneParameters
hostPassword

   "Return the value of the instance variable 'hostPassword'."
   ^hostPassword
%
category: 'Updating'
method: GemStoneParameters
hostPassword: pword

"Set the host password for the receiver.  The password must be a variant
string (not a symbol or invariant).  The password is encrypted.
The given password's size is set to zero."

pword isInvariant
  ifTrue: [ self _errorBadPassword ].

hostPassword := self _encrypt: pword.
hostPassword immediateInvariant.
self _securePasswords.

pword size: 0.
^ pword
%
category: 'Accessing'
method: GemStoneParameters
hostUsername

   "Return the value of the instance variable 'hostUsername'."
   ^hostUsername
%
category: 'Updating'
method: GemStoneParameters
hostUsername: newValue

   "Modify the value of the instance variable 'hostUsername'."
   hostUsername := newValue
%
category: 'Accessing'
method: GemStoneParameters
password

   "Return the value of the instance variable 'password'."
   ^password
%
category: 'Updating'
method: GemStoneParameters
password: pword

"Set the password for the receiver.  The password must be a variant string (not
a symbol or invariant).  The password is encrypted.
The given password's size is set to zero."

pword isInvariant
  ifTrue: [ self _errorBadPassword ].

password := self _encrypt: pword.
password immediateInvariant.
self _securePasswords.

pword size: 0.
^ pword
%
category: 'Accessing'
method: GemStoneParameters
username

   "Return the value of the instance variable 'username'."
   ^username
%
category: 'Updating'
method: GemStoneParameters
username: newValue

   "Modify the value of the instance variable 'username'."
   username := newValue
%
category: 'Accessing'
method: GemStoneParameters
remoteRepository

"Return nil to indicate no remote repository."

^ nil
%

