!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: gsdoctext.gs,v 1.4 2008-01-09 22:50:11 stever Exp $
!
! Superclass Hierarchy:
!   GsDocText, Object.
!
!=========================================================================

!  Create the class if it does not already exist

expectvalue %String
run
  Object _newKernelSubclass: 'GsDocText'
    instVarNames: #('sketch' 'details')
    classVars: #()
    classInstVars: #()
    poolDictionaries: #[]
    inDictionary: Globals
    constraints: #[ #[ #sketch, CharacterCollection],
                    #[ #details, CharacterCollection] ]
    instancesInvariant: false
    isModifiable: false
    reservedOop: 747
%

!========================================================================
!  Remove all existing behavior from the class

removeallmethods GsDocText
removeallclassmethods GsDocText

!========================================================================
!  Instance and class methods used only while creating the GemStone image.
!  These methods are not present in the final image.

category: 'For Documentation Installation only'
classmethod: GsDocText
installDocumentation

| doc txt |
doc := GsClassDocumentation _newForPrivateGsClass: self.

txt := (GsDocText new) details:
'A GsDocText is a unit of textual documentation.  It retains information
 about only one thing.  That thing may, however, be a single item of any kind,
 or it may be a group of items considered as an aggregate.' .
doc documentClassWith: txt.

txt := (GsDocText new) details:
'Text that gives terse, abbreviated descriptive information about the item that
 this instance documents, such as an introduction or a summary.' .
doc documentInstVar: #sketch with: txt.

txt := (GsDocText new) details:
'Text that gives complete, detailed descriptive information about the item that
 this instance documents.' .
doc documentInstVar: #details with: txt.

self description: doc.
%

!========================================================================
!  Class methods

!========================================================================
!  Instance methods

category: 'Updating'
method: GsDocText
details: aCharColl

"Update the instance variable 'details'."

details := aCharColl.
%

category: 'Updating'
method: GsDocText
sketch: aCharColl

"Update the instance variable 'sketch'."

sketch := aCharColl.
%

category: 'Accessing'
method: GsDocText
details

"Returns the instance variable `details'."

^details
%

category: 'Accessing'
method: GsDocText
sketch

"Returns the instance variable `sketch'."

^sketch
%

