!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: btreebasicinter.gs,v 1.10 2008-01-09 22:50:08 stever Exp $
!
! Superclass Hierarchy:
!   BtreeBasicInteriorNode, BtreeInteriorNode, BtreeNode, Array,
!   SequenceableCollection, Collection, Object.
!
!=========================================================================

! class created in idxclasses.topaz

removeallmethods BtreeBasicInteriorNode
removeallclassmethods BtreeBasicInteriorNode

category: 'For Documentation Installation only'
classmethod: BtreeBasicInteriorNode
installDocumentation

| doc txt |
doc := GsClassDocumentation _newForPrivateGsClass: self.

txt := (GsDocText new) details:
'A BtreeBasicInteriorNode represents an interior node of a B-tree for which a
 binary search can be done for a key.' .
doc documentClassWith: txt.

self description: doc.
%

category: 'Searching'
method: BtreeBasicInteriorNode
_binarySearchCoveringKey: aKey totalOrder: aBoolean 

"Returns the index for the first entry in which aKey is found utilizing a
 binary search.  This is the first entry whose key >= aKey."

<primitive: 206>
self _primitiveFailed: #_binarySearchCoveringKey:totalOrder: .
self _uncontinuableError
%

category: 'Searching'
method: BtreeBasicInteriorNode
_binarySearchCoveringKey: aKey value: aValue 

"Returns the index for the entry in which aKey/aValue would be inserted.  This
 is the first entry which has its key >= aKey.  If multiple entries have the
 same key (key = aKey), then aValue is used (since entries with duplicate keys 
 are inserted by the value's OOP ordering).  If the receiver is empty, returns 
 1.  Uses a binary search."

<primitive: 85>
self _primitiveFailed: #_binarySearchCoveringKey:value: .
self _uncontinuableError
%

category: 'Constants'
method: BtreeBasicInteriorNode
_encryptionSize

"Two slots are used for encryption."

^ 2
%

category: 'Constants'
method: BtreeBasicInteriorNode
entrySize

"Returns the size of an entry (with 2 slots for encryption)."

^ 4 "2 + self _encryptionSize"
%

category: 'Constants'
classmethod: BtreeBasicInteriorNode
entrySize

"Returns the size of an entry (with 2 slots for encryption)."

^ 4 "2 + self _encryptionSize"
%

category: 'Constants'
classmethod: BtreeBasicInteriorNode
maxNumberOfElements

"Returns the number of entries that are allowed in a leaf node."

^ 500 "2000 / self entrySize"
%

category: 'Constants'
method: BtreeBasicInteriorNode
mergeThreshold

"Returns the threshold such that if an entry has less than this number, it must
 have elements added from its sibling or be merged with its sibling.  This
 amount is usually the same as the result of the message
 'self maxNumberOfElements quo: 2'."

^ 250
%

category: 'Constants'
method: BtreeBasicInteriorNode
parentNodeClass

"Returns the class of node to be created as the parent when a split occurs."

^ BtreeBasicInteriorNode
%

category: 'Testing'
method: BtreeBasicInteriorNode
_canCompare: aKey withClass: aClass

"Returns true if the receiver can make comparisons with the given key, and
 false otherwise."

^ self _basicCanCompare: aKey withClass: aClass
%

category: 'Accessing'
method: BtreeBasicInteriorNode
_lastIndex

"Returns the index of the last used slot in the node."

^ numElements * 4
%

category: 'Accessing'
method: BtreeBasicInteriorNode
_lastKeyIndex

"Returns the index of the key of the last entry, or zero if the node is empty."

^ numElements == 0
    ifTrue: [ 0 ]
    ifFalse: [ numElements * 4 - 2 ]
%

category: 'Comparison Operators'
method: BtreeBasicInteriorNode
_compareKey: aKey equalToEntryAt: index 

"Performs an equality comparison between aKey and the entry whose key is at the
 given index.  Use encryption to make the comparison faster."

<primitive: 40>
self _primitiveFailed: #_compareKey:equalToEntryAt: .
self _uncontinuableError
%

