!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: abstractuserset.gs,v 1.5 2008-01-09 22:50:07 stever Exp $
!
! Superclass Hierarchy:
!   AbstractUserProfileSet, IdentitySet, IdentityBag, UnorderedCollection,
!   Collection, Object.
!
!=========================================================================

removeallmethods AbstractUserProfileSet
removeallclassmethods AbstractUserProfileSet

category: 'For Documentation Installation only'
classmethod: AbstractUserProfileSet
installDocumentation

| doc txt |
doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details:
'An AbstractUserProfileSet is an IdentitySet whose elements must be instances of
 class UserProfile.  You may not create subclasses or instances of 
 AbstractUserProfileSet.  Only one instance of AbstractUserProfileSet is
 permitted in a GemStone repository that was upgraded from GemStone v4.1.'.
doc documentClassWith: txt.

self description: doc.
%

category: 'Accessing'
method: AbstractUserProfileSet
userWithId: aString 

"Searches the receiver for a UserProfile whose userId is equal to aString, and
 returns that UserProfile.  Generates an error if no userId is equal to
 aString."

^ self userWithId: aString 
         ifAbsent:[ self _error: #objErrNotInColl args: #[aString]]
%

! fix bug 8249
category: 'Accessing'
method: AbstractUserProfileSet
userWithId: aString ifAbsent: aBlock

"Searches the receiver for a UserProfile whose userId is equal to aString, and
 returns that UserProfile.  Evaluates the argument aBlock if no userId
 is equal to aString."

"Example: (AllUsers userWithId: 'DataCurator') "

| keyValueDict aUserProfile aStr |
aStr := aString asString .
(keyValueDict := self tagAt: 1) class == StringKeyValueDictionary ifTrue:[
  ^ keyValueDict at: aStr ifAbsent: aBlock
  ].
aUserProfile:=
   self detect: [:aUserPro | aUserPro.userId = aStr] ifNone: aBlock .

^aUserProfile "Should only be one as UserId are unique"
%

category: 'Adding'
method: AbstractUserProfileSet
add: aUserProfile

"(Subclass responsibility.)  Adds aUserProfile to the receiver."

AbstractUserProfileSet subclassResponsibility: #add:
%

category: 'Adding'
method: AbstractUserProfileSet
_add: aUserProfile

AbstractUserProfileSet subclassResponsibility: #_add:
%

category: 'Adding'
method: AbstractUserProfileSet
addAll: aCollection

"Reimplemented to maintain KeyValueDictionary on AllUsers."

AbstractUserProfileSet subclassResponsibility: #addAll:
%

category: 'Removing'
method: AbstractUserProfileSet
remove: anObject ifAbsent: aBlock

"Reimplemented to maintain KeyValueDictionary on AllUsers."

| keyValueDict |
(anObject isKindOf: UserProfile) ifTrue:[
  (keyValueDict := self tagAt: 1) class == StringKeyValueDictionary ifTrue:[
    keyValueDict removeKey: anObject userId ifAbsent: aBlock  "fix 11936"
    ].
  ].
^ super remove: anObject ifAbsent: aBlock
%

category: 'Removing'
method: AbstractUserProfileSet
remove: anObject 

"Reimplemented to maintain KeyValueDictionary on AllUsers."

^ self remove: anObject ifAbsent:[ self _errorNotFound: anObject ]
%

category: 'Removing'
method: AbstractUserProfileSet
removeIfPresent: anObject

"Reimplemented to maintain KeyValueDictionary on AllUsers."

^ self remove: anObject ifAbsent: [ nil ]
%

category: 'Removing'
method: AbstractUserProfileSet
removeAllPresent: aCollection

"Reimplemented to maintain KeyValueDictionary on AllUsers."

aCollection == self ifTrue:[ ^ self removeAll: aCollection ].

aCollection do:[ :element | self removeIfPresent: element ].
^ aCollection
%

category: 'Removing'
method: AbstractUserProfileSet
removeAll: aCollection

"Reimplemented to maintain KeyValueDictionary on AllUsers."

| aColl tmpArr|
aColl := aCollection.
aColl == self ifTrue:[
  aColl == AllUsers ifTrue:[ 
    self _halt: 'Attempt to remove all elements of AllUsers'  .
    self _uncontinuableError
    ].
  tmpArr := Array withAll: aColl .
  aColl := tmpArr .
  ]. 
aColl do:[ :element | self remove: element ].
				"deleted   'reduce garbage' code"
^ aCollection
%

category: 'Removing'
method: AbstractUserProfileSet
_removeAll: aCollection errIfAbsent: aBool

"Reimplemented to maintain KeyValueDictionary on AllUsers."

aBool ifTrue:[ self removeAll: aCollection]
     ifFalse:[ self removeAllPresent: aCollection ]
%

! new: deleted

! methods removed

