#define GETOPT_C TRUE
/*========================================================================
 *
 * Description: getopt() for GNU.  
 *              Copyright (C) 1987-1998 Free Software Foundation, Inc.
 *
 * Modified by David MacKenzie to use malloc and free instead of alloca,
 * and memcpy instead of bcopy under System V.
 *
 *  Changed- Nov 89 by D. Jason Penney, moved externally accessed declarations
 *           to getopt.h.  Fixed ordering of arguments to memcpy() in
 *           this module, and after some consideration, commented out
 *           memcpy() entirely -- doesn't every C have this?
 *
 *           Dec 89 by D. Jason Penney, to run under HP-UX
 *
 *	     July 91 by djp -- Fix RETURN_IN_ORDER to return '-' for the option
 *	     instead of '\0'; thus, result can be printed by ggetopt.
 *
 * $Id: getopt.c,v 1.7 2005-11-22 18:33:44 otisa Exp $
 *========================================================================
 */

/* Getopt for GNU.
   Copyright (C) 1987 Free Software Foundation, Inc.

               NO WARRANTY

  BECAUSE THIS PROGRAM IS LICENSED FREE OF CHARGE, WE PROVIDE ABSOLUTELY
NO WARRANTY, TO THE EXTENT PERMITTED BY APPLICABLE STATE LAW.  EXCEPT
WHEN OTHERWISE STATED IN WRITING, FREE SOFTWARE FOUNDATION, INC,
RICHARD M. STALLMAN AND/OR OTHER PARTIES PROVIDE THIS PROGRAM "AS IS"
WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY
AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE PROGRAM PROVE
DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR
CORRECTION.

 IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL RICHARD M.
STALLMAN, THE FREE SOFTWARE FOUNDATION, INC., AND/OR ANY OTHER PARTY
WHO MAY MODIFY AND REDISTRIBUTE THIS PROGRAM AS PERMITTED BELOW, BE
LIABLE TO YOU FOR DAMAGES, INCLUDING ANY LOST PROFITS, LOST MONIES, OR
OTHER SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE
USE OR INABILITY TO USE (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR
DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY THIRD PARTIES OR
A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS) THIS
PROGRAM, EVEN IF YOU HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
DAMAGES, OR FOR ANY CLAIM BY ANY OTHER PARTY.

        GENERAL PUBLIC LICENSE TO COPY

  1. You may copy and distribute verbatim copies of this source file
as you receive it, in any medium, provided that you conspicuously and
appropriately publish on each copy a valid copyright notice "Copyright
 (C) 1987 Free Software Foundation, Inc."; and include following the
copyright notice a verbatim copy of the above disclaimer of warranty
and of this License.  You may charge a distribution fee for the
physical act of transferring a copy.

  2. You may modify your copy or copies of this source file or
any portion of it, and copy and distribute such modifications under
the terms of Paragraph 1 above, provided that you also do the following:

    a) cause the modified files to carry prominent notices stating
    that you changed the files and the date of any change; and

    b) cause the whole of any work that you distribute or publish,
    that in whole or in part contains or is a derivative of this
    program or any part thereof, to be licensed at no charge to all
    third parties on terms identical to those contained in this
    License Agreement (except that you may choose to grant more
    extensive warranty protection to third parties, at your option).

    c) You may charge a distribution fee for the physical act of
    transferring a copy, and you may at your option offer warranty
    protection in exchange for a fee.

  3. You may copy and distribute this program or any portion of it in
compiled, executable or object code form under the terms of Paragraphs
1 and 2 above provided that you do the following:

    a) cause each such copy to be accompanied by the
    corresponding machine-readable source code, which must
    be distributed under the terms of Paragraphs 1 and 2 above; or,

    b) cause each such copy to be accompanied by a
    written offer, with no time limit, to give any third party
    free (except for a nominal shipping charge) a machine readable
    copy of the corresponding source code, to be distributed
    under the terms of Paragraphs 1 and 2 above; or,

    c) in the case of a recipient of this program in compiled, executable
    or object code form (without the corresponding source code) you
    shall cause copies you distribute to be accompanied by a copy
    of the written offer of source code which you received along
    with the copy you received.

  4. You may not copy, sublicense, distribute or transfer this program
except as expressly provided under this License Agreement.  Any attempt
otherwise to copy, sublicense, distribute or transfer this program is void and
your rights to use the program under this License agreement shall be
automatically terminated.  However, parties who have received computer
software programs from you with this License Agreement will not have
their licenses terminated so long as such parties remain in full compliance.

  5. If you wish to incorporate parts of this program into other free
programs whose distribution conditions are different, write to the Free
Software Foundation at 675 Mass Ave, Cambridge, MA 02139.  We have not yet
worked out a simple rule that can be stated here, but we will often permit
this.  We will be guided by the two goals of preserving the free status of
all derivatives of our free software and of promoting the sharing and reuse of
software.


In other words, you are welcome to use, share and improve this program.
You are forbidden to forbid anyone else to use, share and improve
what you give them.   Help stamp out software-hoarding!  */

/* This version of `getopt' appears to the caller like standard Unix `getopt'
   but it behaves differently for the user, since it allows the user
   to intersperse the options with the other arguments.

   As `getopt' works, it permutes the elements of `argv' so that,
   when it is done, all the options precede everything else.  Thus
   all application programs are extended to handle flexible argument order.

   Setting the environment variable _POSIX_OPTION_ORDER disables permutation.
   Then the behavior is completely standard.

   GNU application programs can use a third alternative mode in which
   they can distinguish the relative order of options and other arguments.  */

#include "flag.ht"

#if defined(FLG_LINUX_UNIX)
#include <stdio.h>
#endif

#ifdef FLG_MSWIN32
#include <windows.h>
#include <stdio.h>
#endif

#include "l2unix.hf"
#include "utl.hf"

#ifdef FLG_SHORT_FILENAMES
#include "gnugetop.h" /* 8+3 atrocity */
#else
#include "gnugetopt.h"
#endif

/* no more includes. KEEP THIS LINE */

#ifdef _POSIX_OPTION_ORDER
#undef _POSIX_OPTION_ORDER
#endif


#if defined(SYSV) || defined(SYSVR3) || defined(FLG_HPUX_UNIX) || defined(MSDOS) \
    || defined(THINK_C) || defined(_SEQUENT_) || defined(VMS) || \
       defined(__STDC__) || defined(__OS2__) || defined(WIN32)
#define bcopy(s, d, l) memcpy((d), (s), (l))
#define index strchr
#endif

/* The next char to be scanned in the option-element
   in which the last option character we returned was found.
   This allows us to pick up the scan where we left off.

   If this is zero, or a null string, it means resume the scan
   by advancing to the next ARGV-element.  */

static const char *nextchar;

/* If SLASH_OPT is defined then recognize options that start with
 * a slash '/' as well as a dash '-'.
 */
#ifdef WIN32
#define SLASH_OPT
#endif

/* Describe how to deal with options that follow non-option ARGV-elements.

   REQUIRE_ORDER means don't recognize them as options.
   Stop option processing when the first non-option is seen.
   This is what Unix does.  If the environment variable
   _POSIX_OPTION_ORDER is set, this sets this mode.

   PERMUTE is the default.  We permute the contents of `argv' as we scan,
   so that eventually all the options are at the end.  This allows options
   to be given in any order, even with programs that were not written to
   expect this.

   RETURN_IN_ORDER is an option available to programs that were written
   to expect options and other ARGV-elements in any order and that care about
   the ordering of the two.  We describe each non-option ARGV-element
   as if it were the argument of an option with character code '-'.
   Using `-' as the first character of the list of option characters
   requests this mode of operation.

   The special argument `--' forces an end of option-scanning regardless
   of the value of `ordering'.  In the case of RETURN_IN_ORDER, only
   `--' can cause `getopt' to return EOF with `gnu_optind' != ARGC.  */

static enum { REQUIRE_ORDER, PERMUTE, RETURN_IN_ORDER } ordering;

/* Allocate memory dynamically, with error checking.  */

#if defined(USE_GCI_INTERFACE) && !defined(FLG_MSWIN32)
#include "gci.hf"
#define DO_MALLOC GciUtlMalloc
#define DO_FREE GciFree
#else
#define DO_MALLOC UtlMalloc
#define DO_FREE UtlFree
#endif

static char *xMalloc(unsigned n)
{
char *p;

p = (char*)DO_MALLOC(n, "getopt.c");
if (p == NULL) {
  fprintf (stderr, "Virtual memory exhausted\n");
  exit(1);
  }
return p;
}

/* Handle permutation of arguments.  */

/* Describe the part of ARGV that contains non-options that have
   been skipped.  `first_nonopt' is the index in ARGV of the first of them;
   `last_nonopt' is the index after the last of them.  */

static int first_nonopt;
static int last_nonopt;

/* Exchange two adjacent subsequences of ARGV.
   One subsequence is elements [first_nonopt,last_nonopt)
    which contains all the non-options that have been skipped so far.
   The other is elements [last_nonopt,gnu_optind), which contains all
    the options processed since those non-options were skipped.

   `first_nonopt' and `last_nonopt' are relocated so that they describe
    the new indices of the non-options in ARGV after they are moved.  */

static void exchange(const char **argv)
{
unsigned int nonopts_size = (unsigned int)
    (last_nonopt - first_nonopt) * sizeof (char *);
char **temp = (char **)xMalloc(nonopts_size);

/* Interchange the two blocks of data in argv.  */

bcopy(&argv[first_nonopt], temp, nonopts_size);
bcopy(&argv[last_nonopt], (char*)&argv[first_nonopt],
   (gnu_optind - last_nonopt) * sizeof (char *));
bcopy(temp, (char*)&argv[first_nonopt + gnu_optind - last_nonopt], nonopts_size);

DO_FREE((char *)temp);

/* Update records for the slots the non-options now occupy.  */
first_nonopt += (gnu_optind - last_nonopt);
last_nonopt = gnu_optind;
}

/* Scan elements of ARGV (whose length is ARGC) for option characters
   given in OPTSTRING.

   If an element of ARGV starts with '-', and is not exactly "-" or "--",
   then it is an option element.  The characters of this element
   (aside from the initial '-') are option characters.  If `getopt'
   is called repeatedly, it returns successively each of the option characters
   from each of the option elements.

   If `getopt' finds another option character, it returns that character,
   updating `gnu_optind' and `nextchar' so that the next call to `getopt' can
   resume the scan with the following option character or ARGV-element.

   If there are no more option characters, `getopt' returns `EOF'.
   Then `gnu_optind' is the index in ARGV of the first ARGV-element
   that is not an option.  (The ARGV-elements have been permuted
   so that those that are not options now come last.)

   OPTSTRING is a string containing the legitimate option characters.
   A colon in OPTSTRING means that the previous character is an option
   that wants an argument.  The argument is taken from the rest of the
   current ARGV-element, or from the following ARGV-element,
   and returned in `gnu_optarg'.

   If an option character is seen that is not listed in OPTSTRING,
   return '?' after printing an error message.  If you set `gnu_opterr' to
   zero, the error message is suppressed but we still return '?'.

   If a char in OPTSTRING is followed by a colon, that means it wants an arg,
   so the following text in the same ARGV-element, or the text of the following
   ARGV-element, is returned in `gnu_optarg.  Two colons mean an option that
   wants an optional arg; if there is text in the current ARGV-element,
   it is returned in `gnu_optarg'.

   If OPTSTRING starts with `-', it requests a different method of handling the
   non-option ARGV-elements.  See the comments about RETURN_IN_ORDER, above.
 */

int gnu_getopt(int argc, const char **argv, const char *optstring)
{
/* Initialize the internal data when the first call is made.
   Start processing options with ARGV-element 1 (since ARGV-element 0
   is the program name); the sequence of previously skipped
   non-option ARGV-elements is empty.  */

gnu_optarg = NULL; /* added by djp */
if (gnu_optind == 0) {
  first_nonopt = last_nonopt = gnu_optind = 1;

  nextchar = NULL;

  /* Determine how to handle the ordering of options and nonoptions.  */

  if (optstring[0] == '-')
    ordering = RETURN_IN_ORDER;
  else
  if (getenv("_POSIX_OPTION_ORDER") != NULL)
    ordering = REQUIRE_ORDER;
  else
    ordering = PERMUTE;
  }

if (nextchar == NULL || *nextchar == '\0') {
  if (ordering == PERMUTE) {
    /* If we have just processed some options following some non-options,
       exchange them so that the options come first.  */

    if (first_nonopt != last_nonopt && last_nonopt != gnu_optind)
      exchange(argv);
    else
    if (last_nonopt != gnu_optind)
      first_nonopt = gnu_optind;

    /* Now skip any additional non-options
       and extend the range of non-options previously skipped.  */

#ifdef SLASH_OPT
#define ISOPTCHAR(c) (c == '-' || c == '/')
/* Note that // is not an option. It could start a UNC file name */
#define IS_NOT_OPTION(p) ((p[0] != '-' && p[0] != '/') || p[1] == '\0' ||  \
			  (p[0] == '/' && p[1] == '/'))
#else
#define ISOPTCHAR(c) (c == '-')
#define IS_NOT_OPTION(p) (p[0] != '-' || p[1] == '\0')
#endif


    while (gnu_optind < argc && IS_NOT_OPTION(argv[gnu_optind]))
      gnu_optind++;
    last_nonopt = gnu_optind;
    }

  /* Special ARGV-element `--' means premature end of options.
     Skip it like a null option,
     then exchange with previous non-options as if it were an option,
     then skip everything else like a non-option.  */

  if (gnu_optind < argc && strcmp(argv[gnu_optind], "--") == 0) {
    gnu_optind++;

    if (first_nonopt != last_nonopt && last_nonopt != gnu_optind)
      exchange(argv);
    else
    if (first_nonopt == last_nonopt)
      first_nonopt = gnu_optind;
    last_nonopt = argc;

    gnu_optind = argc;
    }

  /* If we have done all the ARGV-elements, stop the scan
     and back over any non-options that we skipped and permuted.  */
  if (gnu_optind >= argc) {
    /* Set the next-arg-index to point at the non-options
       that we previously skipped, so the caller will digest them.  */
    if (first_nonopt != last_nonopt)
      gnu_optind = first_nonopt;
    return EOF;
    }

  /* If we have come to a non-option and did not permute it,
     either stop the scan or describe it to the caller and pass it by.  */
  if (IS_NOT_OPTION(argv[gnu_optind])) {
    if (ordering == REQUIRE_ORDER)
      return EOF;
    /* must be RETURN_IN_ORDER ordering? -- djp */
    gnu_optarg = argv[gnu_optind++];
    return '-';		/* change from '\0' by djp */
    }

  /* We have found another option-ARGV-element.
     Start decoding its characters.  */
  nextchar = &argv[gnu_optind][1];
  }

/* Look at and handle the next option-character.  */
  {
  char c = *nextchar++;
  char *temp = (char *)index(optstring, c);

  /* Increment `gnu_optind' when we start to process its last character.  */
  if (*nextchar == '\0')
    gnu_optind++;

  if (temp == 0 || c == ':') {
    if (gnu_opterr != 0) {
      if (c < 040 || c >= 0177)
	fprintf(stderr, "%s: unrecognized option, character code 0%o\n",
	    argv[0], c);
      else
	fprintf(stderr, "%s: unrecognized option `-%c'\n", argv[0], c);
      }
    return '?';
    }
  if (temp[1] == ':') {
    if (temp[2] == ':') {
      /* This is an option that accepts an argument optionally.  */
      if (*nextchar != '\0') {
	gnu_optarg = nextchar;
        gnu_optind++;
	}
      else
	gnu_optarg = 0;
      nextchar = 0;
      }
    else {
      /* This is an option that requires an argument.  */
      if (*nextchar != '\0') {
        gnu_optarg = nextchar;
        /* If we end this ARGV-element by taking the rest as an arg,
           we must advance to the next element now.  */
        gnu_optind++;
	}
      else
      if (gnu_optind == argc) {
        if (gnu_opterr != 0)
          fprintf (stderr, "%s: no argument for `-%c' option\n", argv[0], c);
        c = '?';
	}
      else
	/* We already incremented `gnu_optind' once;
       increment it again when taking next ARGV-elt as argument.  */
       gnu_optarg = argv[gnu_optind++];
      nextchar = NULL;
      }
    }
  return c;
  }
}
