!=========================================================================
! Copyright (C) GemTalk Systems 1986-2025.  All Rights Reserved.
!
! Description - Create the Nameless user account.
! 
! Repository conversion - this file is used
!
!=======================================================================

! login as SystemUser
set user SystemUser pass swordfish
iferr 1 exit
login 
iferr 1 where

expectvalue %String
run
   "Expect a four element Array of user IDs: SystemUser, DataCurator,
    GcUser and Nameless "
| nameless newUser userGlbl seg8 report lf |

nameless := AllUsers detect: [ :x | x userId = 'Nameless' ] ifNone: [nil].
seg8 := (Globals at:#SystemRepository) at: 8 .
report := String new .
lf := Character lf .
nameless ~~ nil ifTrue: [ | defSeg |
    "Nameless already exists. Set its password."
    nameless password: 'swordfish'.
    defSeg := nameless defaultObjectSecurityPolicy .
    defSeg == seg8 ifFalse:[  
      nameless defaultObjectSecurityPolicy: seg8 .
    ].
    report addAll: 'Nameless already exists ' ; add: lf .
    seg8 isInvariant ifFalse:[
      seg8 owner: nameless  ;
          ownerAuthorization: #write ;
          worldAuthorization: #write .  
    ] ifTrue:[
      report addAll:'seg8 isInvariant' ; add: lf .
    ].
] ifFalse: [
    "Create a new Nameless user account"
    newUser := UserProfile newWithUserId: 'Nameless'
                         password: 'swordfish'
                         defaultObjectSecurityPolicy: seg8
                         privileges: #()
                         inGroups: #() .

    seg8 owner: newUser ;
       ownerAuthorization: #write;
       worldAuthorization: #write .

    " AllUsers add: newUser. --- no longer needed "

    " Put Nameless in SystemUser's UserGlobals "
    UserGlobals at: #Nameless put: newUser.

    " Put Nameless in DataCurator's UserGlobals"
    ((AllUsers userWithId: #DataCurator) resolveSymbol: #UserGlobals) value at: 
       #Nameless put: newUser.

    " Put Nameless in its own UserGlobals"
    userGlbl := (newUser resolveSymbol: #UserGlobals) value.
    userGlbl at: #Nameless put: newUser.

    report addAll: 'created Nameless' ; add: lf .
].
seg8 isInvariant ifFalse:[
  seg8 _name ifNil:[ seg8 name: 'NamelessObjectSecurityPolicy' ].
].
^ report
%
commit
logout

