category: '*gsmonticello'
method: WriteStream
size

	^itsCollection size max: position - 1.
%

category: '*gsmonticello'
method: WriteStream
nextChunkPut: aString
	"Append the argument, aString, to the receiver, doubling embedded terminators."

	| i remainder terminator |
	terminator := $!.
	remainder := aString.
	[(i := remainder indexOf: terminator) = 0] whileFalse:
		[self nextPutAll: (remainder copyFrom: 1 to: i).
		self nextPut: terminator.  "double imbedded terminators"
		remainder := remainder copyFrom: i+1 to: remainder size].
	self nextPutAll: remainder.
	self nextPut: terminator.
%

category: '*gsmonticello'
method: WriteStream
_writeLimit

    ^itsCollection size
%

category: '*gsmonticello'
method: WriteStream
nextNumber: n put: v 
    "Append to the receiver the argument, v, which is a positive 
    Integer, as the next n bytes.
    Possibly pad with leading zeros."

    v < 0 ifTrue:[ ArgumentError signal:'expected a positive Integer'].
    1 to: n do: [:i | self nextPut: (v digitAt: n+1-i)].
    ^ v
%

category: '*gsmonticello'
method: WriteStream
nextStringPut: s 
	"Append the string, s, to the receiver.  Only used by DataStream.  Max size of 64*256*256*256."

	| length |
	(length := s size) < 192
		ifTrue: [self nextPut: length]
		ifFalse: 
			[self nextPut: (length digitAt: 4)+192.
			self nextPut: (length digitAt: 3).
			self nextPut: (length digitAt: 2).
			self nextPut: (length digitAt: 1)].
	self nextPutAll: s asByteArray.
	^s
%

category: '*gsmonticello'
method: WriteStream
nextInt32Put: int32
	"Write a signed integer to the next 4 bytes"
	| pos |
	pos := int32 < 0
		ifTrue: [(0-int32) bitInvert32 + 1]
		ifFalse: [int32].
	1 to: 4 do: [:i | self nextPut: (pos digitAt: 5-i)].
	^ int32
%

