category: '*gsmonticello'
method: OrderedCollection
storeDataOn: aDataStream
	"OrderedCollection in Squeak is a different shape. First iv is an array, second iv is firstIndex and second iv is lastIndex."

	aDataStream
		beginInstance: self class
		size: 3.
	"array"
	aDataStream nextPut: self asArray.
	"firstIndex"
	aDataStream nextPut: 1.
	"lastIndex"
	aDataStream nextPut: self size.
%

category: '*gsmonticello'
method: OrderedCollection
readDataFrom: aDataStream size: varsOnDisk
  "OrderedCollection in Squeak is a different shape. First iv is an array, second iv is firstIndex and second iv is lastIndex."

  | cntInstVars cntIndexedVars ar firstIndex lastIndex |
  cntInstVars := self class instSize.
  self class isVariable
    ifTrue: [ 
      cntIndexedVars := varsOnDisk - cntInstVars.
      cntIndexedVars < 0
        ifTrue: [ self error: 'Class has changed too much.  Define a convertxxx method' ] ]
    ifFalse: [ 
      cntIndexedVars := 0.
      cntInstVars := varsOnDisk ].	"OK if fewer than now"
  aDataStream beginReference: self.
  ar := aDataStream next.
  firstIndex := aDataStream next.
  lastIndex := aDataStream next.
  firstIndex <= lastIndex
    ifTrue: [ 
      | newSize |
      "reset size to correct value"
      self size: (newSize := lastIndex - firstIndex + 1).
      self
        replaceFrom: 1
        to: newSize
        with: ar
        startingAt: firstIndex ]
    ifFalse: [ 
      "empty OrderedCollection"
      self size: 0 ].
  ^ self
%
