category: '*gsmonticello'
method: Object
isTrait
    ^false
%

category: '*gsmonticello'
method: Object
notify: aString

    GsFile gciLogServer: aString.
    Warning signal: aString.
%

category: '*gsmonticello'
method: Object
isStream

    ^false
%

category: '*gsmonticello'
method: Object
objectForDataStream: refStrm
    "Return an object to store on an external data stream."

    ^ self
%

category: '*gsmonticello'
method: Object
storeDataOn: aDataStream
	"Store myself on a DataStream.  Answer self.  This is a low-level DataStream/ReferenceStream method. See also objectToStoreOnDataStream.  NOTE: This method must send 'aDataStream beginInstance:size:' and then (nextPut:/nextPutWeak:) its subobjects.  readDataFrom:size: reads back what we write here."
	| cntInstVars cntIndexedVars |

	cntInstVars := self class instSize.
	cntIndexedVars := self basicSize - cntInstVars.
	aDataStream
		beginInstance: self class
		size: cntInstVars + cntIndexedVars.
	1 to: cntInstVars do:
		[:i | aDataStream nextPut: (self instVarAt: i)].

	"Write fields of a variable length object."
	1 to: cntIndexedVars do:
		[:i | aDataStream nextPut: (self basicAt: i)].
%

category: '*gsmonticello'
method: Object
isString

    ^false
%

category: '*gsmonticello'
method: Object
isCharacter

    ^false
%

category: '*gsmonticello'
method: Object
isDictionary

    ^false
%

category: '*gsmonticello'
method: Object
isInteger

    ^false
%

category: '*gsmonticello'
method: Object
isArray

    ^false
%

category: '*gsmonticello'
method: Object
name
	"Answer a name for the receiver.  This is used generically in the title of certain inspectors, such as the referred-to inspector, and specificially by various subsystems.  By default, we let the object just print itself out..  "

	^ self printString
%

category: '*gsmonticello'
method: Object
comeFullyUpOnReload: smartRefStream
	"Normally this read-in object is exactly what we want to store. 7/26/96 tk"

	^ self
%

category: '*gsmonticello'
method: Object
readDataFrom: aDataStream size: varsOnDisk
	"Fill in the fields of self based on the contents of aDataStream.  Return self.
	 Read in the instance-variables written by Object>>storeDataOn:.
	 NOTE: This method must send beginReference: before reading any objects from aDataStream that might reference it.
	 Allow aDataStream to have fewer inst vars.  See SmartRefStream."
	| cntInstVars cntIndexedVars |

	cntInstVars := self class instSize.
	self class isVariable
		ifTrue: [cntIndexedVars := varsOnDisk - cntInstVars.
				cntIndexedVars < 0 ifTrue: [
					self error: 'Class has changed too much.  Define a convertxxx method']]
		ifFalse: [cntIndexedVars := 0.
				cntInstVars := varsOnDisk]. 	"OK if fewer than now"

	aDataStream beginReference: self.
	1 to: cntInstVars do:
		[:i | self instVarAt: i put: aDataStream next].
	1 to: cntIndexedVars do:
		[:i | self basicAt: i put: aDataStream next].
	"Total number read MUST be equal to varsOnDisk!"
	^ self	"If we ever return something other than self, fix calls 
			on (super readDataFrom: aDataStream size: anInteger)"
%

category: '*gsmonticello'
method: Object
instVarNamed: aString put: aValue
	"Store into the value of the instance variable in me of that name.  Slow and unclean, but very useful. "

	^ self instVarAt: (self class allInstVarNames indexOfIdentical: aString asSymbol) put: aValue
%

