expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSFilesystemError otherwise: nil.
oldCls == nil ifTrue: [
	Error subclass: 'FSFilesystemError'
	instVarNames: #( reference )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSFilesystemError'.
	newCls category: 'Filesystem-Exceptions'.newCls classComment: 'I am an abstract superclass for errors that may occur during filesystem operations.' stamp: 'cwp 11/18/2009 12:32'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSFilesystemError
removeallclassmethods FSFilesystemError

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSDirectoryDoesNotExist otherwise: nil.
oldCls == nil ifTrue: [
	FSFilesystemError subclass: 'FSDirectoryDoesNotExist'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSDirectoryDoesNotExist'.
	newCls category: 'Filesystem-Exceptions'.newCls classComment: 'I am raised when I an operation is attempted inside a directory that does not exist. ' stamp: 'cwp 11/18/2009 12:33'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSDirectoryDoesNotExist
removeallclassmethods FSDirectoryDoesNotExist

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSDirectoryExists otherwise: nil.
oldCls == nil ifTrue: [
	FSFilesystemError subclass: 'FSDirectoryExists'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSDirectoryExists'.
	newCls category: 'Filesystem-Exceptions'.newCls classComment: 'I am raised on an attempt to create a directory that already exists.' stamp: 'cwp 11/18/2009 12:35'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSDirectoryExists
removeallclassmethods FSDirectoryExists

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSFileDoesNotExist otherwise: nil.
oldCls == nil ifTrue: [
	FSFilesystemError subclass: 'FSFileDoesNotExist'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSFileDoesNotExist'.
	newCls category: 'Filesystem-Exceptions'.newCls classComment: 'I am raised when an operation is attempted on a file that does not exist. This includes cases where a file operation is attempted on a directory.' stamp: 'cwp 11/18/2009 12:35'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSFileDoesNotExist
removeallclassmethods FSFileDoesNotExist

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSFileExists otherwise: nil.
oldCls == nil ifTrue: [
	FSFilesystemError subclass: 'FSFileExists'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSFileExists'.
	newCls category: 'Filesystem-Exceptions'.newCls classComment: 'I am raised on an attempt to create a file or directory over top of an existing file.' stamp: 'cwp 11/18/2009 12:37'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSFileExists
removeallclassmethods FSFileExists

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSResolutionRequest otherwise: nil.
oldCls == nil ifTrue: [
	Notification subclass: 'FSResolutionRequest'
	instVarNames: #( origin )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSResolutionRequest'.
	newCls category: 'Filesystem-Resolvers'.newCls classComment: 'I represent a request for user assistance in resolving an origin. I am a resumable exception that gets raised when there is no way of automatically resolving a particular origin. ' stamp: 'cwp 11/18/2009 11:38'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSResolutionRequest
removeallclassmethods FSResolutionRequest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSDirectoryEntry otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'FSDirectoryEntry'
	instVarNames: #( reference creation modification isDirectory size )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSDirectoryEntry'.
	newCls category: 'Filesystem-Core'.newCls classComment: 'I am a cache for metadata about a file or directory. The information I hold is as follows:

reference
	A reference to the file or directory to which my data pertains.
	
creation
	The creation date and time, stored as number seconds since the 
	Smalltalk epoch.
	
modification
	The modification date and time, number seconds since the Smalltalk epoch.
	
isDirectory 
	True if my data pertains to a directory, false if a file.
	
size
	Size in bytes for a file, 0 for a directory.
' stamp: 'cwp 11/18/2009 11:09'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSDirectoryEntry
removeallclassmethods FSDirectoryEntry

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSFilePluginPrims otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'FSFilePluginPrims'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSFilePluginPrims'.
	newCls category: 'FilesystemGemStone-Disk'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSFilePluginPrims
removeallclassmethods FSFilePluginPrims

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSFilesystem otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'FSFilesystem'
	instVarNames: #( workingDirectory )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSFilesystem'.
	newCls category: 'Filesystem-Core'.newCls classComment: 'I am an abstract super class for filesystem implementations. ' stamp: 'cwp 11/18/2009 11:09'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSFilesystem
removeallclassmethods FSFilesystem

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSDiskFilesystem otherwise: nil.
oldCls == nil ifTrue: [
	FSFilesystem subclass: 'FSDiskFilesystem'
	instVarNames: #(  )
	classVars: #( Primitives )
	classInstVars: #( default )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSDiskFilesystem'.
	newCls category: 'Filesystem-Disk'.newCls classComment: 'I am an abstract superclass for operating-system-provided filesystems. Though I am abstract, I provide most of the functionality for my subclasses, since all platforms use the same primitives. ' stamp: 'cwp 11/18/2009 12:44'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSDiskFilesystem
removeallclassmethods FSDiskFilesystem

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSUnixFilesystem otherwise: nil.
oldCls == nil ifTrue: [
	FSDiskFilesystem subclass: 'FSUnixFilesystem'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSUnixFilesystem'.
	newCls category: 'Filesystem-Disk'.newCls classComment: 'I provide an interfact to Unix filesystems. By default, my working directory is the directory that contains the image file. I use the standard unix path delimiter, $/.' stamp: 'cwp 11/18/2009 12:49'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSUnixFilesystem
removeallclassmethods FSUnixFilesystem

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSWindowsFilesystem otherwise: nil.
oldCls == nil ifTrue: [
	FSDiskFilesystem subclass: 'FSWindowsFilesystem'
	instVarNames: #( disk )
	classVars: #( Disks )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSWindowsFilesystem'.
	newCls category: 'Filesystem-Disk'.newCls classComment: 'I provide an interface to Windows filesystems. My instances represent specific drives, such as C: or D:. A typical Windows system will have more than one filesystem, so I keep track of the "current" filesystem as well as the current directory in each filesystem. ' stamp: 'cwp 11/18/2009 12:57'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSWindowsFilesystem
removeallclassmethods FSWindowsFilesystem

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSMemoryFilesystem otherwise: nil.
oldCls == nil ifTrue: [
	FSFilesystem subclass: 'FSMemoryFilesystem'
	instVarNames: #( root )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSMemoryFilesystem'.
	newCls category: 'Filesystem-Memory'.newCls classComment: 'I implement the filesystem protocol, but store data within the image, rather than on disk. I model Directories as Dictionaries, and files as ByteArrays. 

root
	A Dictionary that represents the root of the filesystem. ' stamp: 'cwp 11/18/2009 23:58'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSMemoryFilesystem
removeallclassmethods FSMemoryFilesystem

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSZipFilesystem otherwise: nil.
oldCls == nil ifTrue: [
	FSMemoryFilesystem subclass: 'FSZipFilesystem'
	instVarNames: #( reference )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSZipFilesystem'.
	newCls category: 'Filesystem-Zip'.newCls classComment: 'I am a filesystem interface to a ZipArchive. ' stamp: 'cwp 11/19/2009 00:05'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSZipFilesystem
removeallclassmethods FSZipFilesystem

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSGuide otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'FSGuide'
	instVarNames: #( visitor work )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSGuide'.
	newCls category: 'Filesystem-Enumeration'.newCls classComment: 'I am an abstract superclass for objects that fulfill the Guide role in the Guide/Visitor pattern. My subclasses know how to traverse a filesystem in a specific order, "showing" the files and directories they encounter to a visitor.

visitor
	An object that fulfills the Visitor role and implements the visitor protocol.
	
work
	An OrderedCollection, used to keep track of filesystem nodes that have not yet been visited' stamp: 'cwp 11/18/2009 12:09'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSGuide
removeallclassmethods FSGuide

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSBreadthFirstGuide otherwise: nil.
oldCls == nil ifTrue: [
	FSGuide subclass: 'FSBreadthFirstGuide'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSBreadthFirstGuide'.
	newCls category: 'Filesystem-Enumeration'.newCls classComment: 'I traverse the filesystem in breadth-first order. Given this hierarchy:

alpha
	beta
	gamma
delta
	epsilon

I would visit the nodes in the following order:  alpha, delta, beta, gamma, epsilon.

I use my work instance variable as a queue, adding nodes to be visited to the end and retrieving them from the beginning.
' stamp: 'cwp 11/18/2009 12:13'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSBreadthFirstGuide
removeallclassmethods FSBreadthFirstGuide

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSPostorderGuide otherwise: nil.
oldCls == nil ifTrue: [
	FSGuide subclass: 'FSPostorderGuide'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSPostorderGuide'.
	newCls category: 'Filesystem-Enumeration'.newCls classComment: 'I traverse the filesystem in depth-first post order. Given this hierarchy:

alpha
	beta
	gamma
delta
	epsilon

I would visit the nodes in the following order:  beta, gamma, alpha, epsilon, delta.

I use my work instance variable as a stack. I push messages that cause nodes to be traversed or visited, and execute them in reverse order.' stamp: 'cwp 11/18/2009 12:16'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSPostorderGuide
removeallclassmethods FSPostorderGuide

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSPreorderGuide otherwise: nil.
oldCls == nil ifTrue: [
	FSGuide subclass: 'FSPreorderGuide'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSPreorderGuide'.
	newCls category: 'Filesystem-Enumeration'.newCls classComment: 'I traverse the filesystem in depth-first pre order. Given this hierarchy:

alpha
	beta
	gamma
delta
	epsilon

I would visit the nodes in the following order: alpha, beta, gamma, delta, epsilon.

I use my work instance variable as a stack. I push nodes to be visited and visit them in reverse order.' stamp: 'cwp 11/18/2009 12:18'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSPreorderGuide
removeallclassmethods FSPreorderGuide

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSHandle otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'FSHandle'
	instVarNames: #( reference writable )
	classVars: #( Primitives )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSHandle'.
	newCls category: 'Filesystem-Core'.newCls classComment: 'I am an abstract superclass for file handle implementations. I provide a uniform interface that streams can use for read and write operations on a file regardless of the filesystem. I encapsulate the actual IO primitives.' stamp: 'cwp 11/18/2009 11:11'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSHandle
removeallclassmethods FSHandle

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSFileHandle otherwise: nil.
oldCls == nil ifTrue: [
	FSHandle subclass: 'FSFileHandle'
	instVarNames: #( id mode )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSFileHandle'.
	newCls category: 'Filesystem-Disk'.newCls classComment: 'I provide an interface for doing IO on an open file. I keep an id, which as an opaque identifier used by the FilePlugin primitives. I translate positions from the 1-based indexes used in Smalltalk to the 0-based offsets used by the primitives.

I do not implement the primitives myself, instead delegating those to an instance of FilePluginPrimitives.' stamp: 'cwp 11/18/2009 13:02'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSFileHandle
removeallclassmethods FSFileHandle

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSMemoryHandle otherwise: nil.
oldCls == nil ifTrue: [
	FSHandle subclass: 'FSMemoryHandle'
	instVarNames: #( bytes size )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSMemoryHandle'.
	newCls category: 'Filesystem-Memory'.newCls classComment: 'I provide "primitives" for doing IO on files in a FSMemoryFilesystem. I buffer writes until the stream is flushed or closed. ' stamp: 'cwp 11/19/2009 00:01'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSMemoryHandle
removeallclassmethods FSMemoryHandle

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSLocator otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'FSLocator'
	instVarNames: #( origin path )
	classVars: #(  )
	classInstVars: #( resolver )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSLocator'.
	newCls category: 'Filesystem-Core'.newCls classComment: 'I am a late-bound reference. I refer to a file or directory in relation to a well-known location on the filesystem, called an origin. When asked to perform concrete operation, I look up the current location of my origin, and resolve my path against it. 

origin 
	A symbolic name for base reference I use to resolve myself.

path
	A relative path that is resolved against my origin' stamp: 'cwp 11/18/2009 11:16'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSLocator
removeallclassmethods FSLocator

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSGciLocator otherwise: nil.
oldCls == nil ifTrue: [
	FSLocator subclass: 'FSGciLocator'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSGciLocator'.
	newCls category: 'FilesystemGemStone-Core'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSGciLocator
removeallclassmethods FSGciLocator

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSPath otherwise: nil.
oldCls == nil ifTrue: [
	Object indexableSubclass: 'FSPath'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSPath'.
	newCls category: 'Filesystem-Core'.newCls classComment: 'I an abstract filesystem path, independent of the string representation used to describe paths on a specific filesystem. I provide methods for navigating the filesystem hierarchy and working with absolute and relative paths. I only refer to a concrete file or directory with regard to a specific filesystem.' stamp: 'cwp 11/18/2009 11:19'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSPath
removeallclassmethods FSPath

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSGciPath otherwise: nil.
oldCls == nil ifTrue: [
	FSPath subclass: 'FSGciPath'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSGciPath'.
	newCls category: 'FilesystemGemStone-Core'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSGciPath
removeallclassmethods FSGciPath

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSReference otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'FSReference'
	instVarNames: #( filesystem path )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSReference'.
	newCls category: 'Filesystem-Core'.newCls classComment: 'I combine a filesystem and path, which is sufficient to refer to a concrete file or directory. I provide methods for navigating my filesystem, performing filesystem operations and opening and closing files.  I am the primary mechanism for working with files and directories. ' stamp: 'cwp 11/18/2009 11:22'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSReference
removeallclassmethods FSReference

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSReleaseInfo otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'FSReleaseInfo'
	instVarNames: #( version )
	classVars: #( Current )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSReleaseInfo'.
	newCls category: 'Filesystem-Release'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSReleaseInfo
removeallclassmethods FSReleaseInfo

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSResolver otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'FSResolver'
	instVarNames: #( next )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSResolver'.
	newCls category: 'Filesystem-Resolvers'.newCls classComment: 'I am an abstract super class for objects that can resolve origins into references. Such objects form a linked list, and when unable to resolve a particular origin, delegate that resolution request to the next resolver in the list.

next
	The next resolver in the list, or nil
' stamp: 'cwp 11/18/2009 11:52'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSResolver
removeallclassmethods FSResolver

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSInteractiveResolver otherwise: nil.
oldCls == nil ifTrue: [
	FSResolver subclass: 'FSInteractiveResolver'
	instVarNames: #( cache )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSInteractiveResolver'.
	newCls category: 'Filesystem-Resolvers'.newCls classComment: 'I resolve origins by consulting the user. I maintain a cache of the user''s responses.' stamp: 'cwp 11/18/2009 11:56'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSInteractiveResolver
removeallclassmethods FSInteractiveResolver

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSPlatformResolver otherwise: nil.
oldCls == nil ifTrue: [
	FSResolver subclass: 'FSPlatformResolver'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSPlatformResolver'.
	newCls category: 'Filesystem-Resolvers'.newCls classComment: 'I am an abstract superclass for platform-specific resolvers.' stamp: 'cwp 11/18/2009 11:56'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSPlatformResolver
removeallclassmethods FSPlatformResolver

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSMacOSResolver otherwise: nil.
oldCls == nil ifTrue: [
	FSPlatformResolver subclass: 'FSMacOSResolver'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSMacOSResolver'.
	newCls category: 'Filesystem-Resolvers'.newCls classComment: 'I am an expert on Mac OS X filesystem conventions. I resolve origins according to these conventions.' stamp: 'cwp 11/18/2009 11:57'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSMacOSResolver
removeallclassmethods FSMacOSResolver

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSUnixResolver otherwise: nil.
oldCls == nil ifTrue: [
	FSPlatformResolver subclass: 'FSUnixResolver'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSUnixResolver'.
	newCls category: 'Filesystem-Resolvers'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSUnixResolver
removeallclassmethods FSUnixResolver

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSWindowsResolver otherwise: nil.
oldCls == nil ifTrue: [
	FSPlatformResolver subclass: 'FSWindowsResolver'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSWindowsResolver'.
	newCls category: 'Filesystem-Resolvers'.newCls classComment: 'I am an expert on Windows filesystem conventions. I resolve origins according to these conventions.' stamp: 'cwp 11/18/2009 11:57'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSWindowsResolver
removeallclassmethods FSWindowsResolver

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSTestResolver otherwise: nil.
oldCls == nil ifTrue: [
	FSResolver subclass: 'FSTestResolver'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSTestResolver'.
	newCls category: 'Filesystem-Resolvers'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSTestResolver
removeallclassmethods FSTestResolver

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSStream otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'FSStream'
	instVarNames: #( handle position )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSStream'.
	newCls category: 'Filesystem-Streams'.newCls classComment: 'I am an abstract superclass for read- and write-streams that perform IO via a handle rather than by calling primitives directly. My subclasses'' provide a cursor on a collection, so that sequences of IO messages can be position independent.

handle
	A subclass of FSHandle. All IO goes through this object.
	
position
	An integer describing the next index to be accessed.' stamp: 'cwp 11/18/2009 11:34'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSStream
removeallclassmethods FSStream

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSReadStream otherwise: nil.
oldCls == nil ifTrue: [
	FSStream subclass: 'FSReadStream'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSReadStream'.
	newCls category: 'Filesystem-Streams'.newCls classComment: 'I implement (more or less) the ANSI <FileReadStream> protocol. I provide methods for reading data from a file. ' stamp: 'cwp 11/18/2009 11:36'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSReadStream
removeallclassmethods FSReadStream

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSWriteStream otherwise: nil.
oldCls == nil ifTrue: [
	FSStream subclass: 'FSWriteStream'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSWriteStream'.
	newCls category: 'Filesystem-Streams'.newCls classComment: 'I implement (more or less) the ANSI <FileWriteStream> protocol. I provide methods for writing data to a file.' stamp: 'cwp 11/18/2009 11:36'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSWriteStream
removeallclassmethods FSWriteStream

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSReadWriteStream otherwise: nil.
oldCls == nil ifTrue: [
	FSWriteStream subclass: 'FSReadWriteStream'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSReadWriteStream'.
	newCls category: 'Filesystem-Streams'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSReadWriteStream
removeallclassmethods FSReadWriteStream

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSVisitor otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'FSVisitor'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSVisitor'.
	newCls category: 'Filesystem-Enumeration'.newCls classComment: 'I am an abstract superclass for objects that can perform operations on directory trees. My subclasses implement the visitor protocol, and process filesystem nodes shown to them by guides.' stamp: 'cwp 11/18/2009 12:25'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSVisitor
removeallclassmethods FSVisitor

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSCollectVisitor otherwise: nil.
oldCls == nil ifTrue: [
	FSVisitor subclass: 'FSCollectVisitor'
	instVarNames: #( out block )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSCollectVisitor'.
	newCls category: 'Filesystem-Enumeration'.newCls classComment: 'I am a visitor that collects objects from the nodes I visit. I take a block similar to those passed to Collection>>collect:. I evaluate the block with DirectoryEntries for the nodes I visit, and collect the objects answered into an array.

I can use any guide, and the objects in the array I produce will reflect the order imposed by the guide.' stamp: 'cwp 11/18/2009 12:32'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSCollectVisitor
removeallclassmethods FSCollectVisitor

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSCopyVisitor otherwise: nil.
oldCls == nil ifTrue: [
	FSVisitor subclass: 'FSCopyVisitor'
	instVarNames: #( source dest )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSCopyVisitor'.
	newCls category: 'Filesystem-Enumeration'.newCls classComment: 'I create a copy of the directory tree that I visit. I use the PreorderGuide so that I can create directories before creating their contents. ' stamp: 'cwp 11/18/2009 12:30'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSCopyVisitor
removeallclassmethods FSCopyVisitor

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSDeleteVisitor otherwise: nil.
oldCls == nil ifTrue: [
	FSVisitor subclass: 'FSDeleteVisitor'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSDeleteVisitor'.
	newCls category: 'Filesystem-Enumeration'.newCls classComment: 'I delete the directory tree that I visit. I use the PostorderGuide so that I can delete files before deleting their containing directories.' stamp: 'cwp 11/18/2009 12:30'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSDeleteVisitor
removeallclassmethods FSDeleteVisitor

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MessageSend otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'MessageSend'
	instVarNames: #( receiver selector arguments )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MessageSend'.
	newCls category: 'MessageSend'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MessageSend
removeallclassmethods MessageSend

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSFileStream otherwise: nil.
oldCls == nil ifTrue: [
	RWBinaryOrTextStream subclass: 'FSFileStream'
	instVarNames: #( reference )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSFileStream'.
	newCls category: 'Filesystem-Streams'.newCls classComment: 'I am an abstract superclass for classes that provide FileStream-compatible streams, for using alternate filesystems from legacy code.' stamp: 'cwp 11/18/2009 11:24'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSFileStream
removeallclassmethods FSFileStream

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSMemoryFileStream otherwise: nil.
oldCls == nil ifTrue: [
	FSFileStream subclass: 'FSMemoryFileStream'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSMemoryFileStream'.
	newCls category: 'Filesystem-Memory'.newCls classComment: 'I am a legacy-compatibility stream. I am protocol compatible with StandardFileStream, but I operate on an in-memory file in a MemoryFilesystem.' stamp: 'cwp 11/18/2009 13:04'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSMemoryFileStream
removeallclassmethods FSMemoryFileStream

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSDirectoryEntryTest otherwise: nil.
oldCls == nil ifTrue: [
	TestCase subclass: 'FSDirectoryEntryTest'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSDirectoryEntryTest'.
	newCls category: 'Filesystem-Tests'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSDirectoryEntryTest
removeallclassmethods FSDirectoryEntryTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSFilesystemTest otherwise: nil.
oldCls == nil ifTrue: [
	TestCase subclass: 'FSFilesystemTest'
	instVarNames: #( filesystem toDelete )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSFilesystemTest'.
	newCls category: 'Filesystem-Tests'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSFilesystemTest
removeallclassmethods FSFilesystemTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSDiskFilesystemTest otherwise: nil.
oldCls == nil ifTrue: [
	FSFilesystemTest subclass: 'FSDiskFilesystemTest'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSDiskFilesystemTest'.
	newCls category: 'Filesystem-Tests'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSDiskFilesystemTest
removeallclassmethods FSDiskFilesystemTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSMemoryFilesystemTest otherwise: nil.
oldCls == nil ifTrue: [
	FSFilesystemTest subclass: 'FSMemoryFilesystemTest'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSMemoryFilesystemTest'.
	newCls category: 'Filesystem-Tests'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSMemoryFilesystemTest
removeallclassmethods FSMemoryFilesystemTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSZipFilesystemTest otherwise: nil.
oldCls == nil ifTrue: [
	FSFilesystemTest subclass: 'FSZipFilesystemTest'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSZipFilesystemTest'.
	newCls category: 'Filesystem-Tests'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSZipFilesystemTest
removeallclassmethods FSZipFilesystemTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSHandleTest otherwise: nil.
oldCls == nil ifTrue: [
	TestCase subclass: 'FSHandleTest'
	instVarNames: #( filesystem handle reference )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSHandleTest'.
	newCls category: 'Filesystem-Tests'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSHandleTest
removeallclassmethods FSHandleTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSFileHandleTest otherwise: nil.
oldCls == nil ifTrue: [
	FSHandleTest subclass: 'FSFileHandleTest'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSFileHandleTest'.
	newCls category: 'Filesystem-Tests'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSFileHandleTest
removeallclassmethods FSFileHandleTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSMemoryHandleTest otherwise: nil.
oldCls == nil ifTrue: [
	FSHandleTest subclass: 'FSMemoryHandleTest'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSMemoryHandleTest'.
	newCls category: 'Filesystem-Tests'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSMemoryHandleTest
removeallclassmethods FSMemoryHandleTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSLocatorTest otherwise: nil.
oldCls == nil ifTrue: [
	TestCase subclass: 'FSLocatorTest'
	instVarNames: #( locator )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSLocatorTest'.
	newCls category: 'Filesystem-Tests'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSLocatorTest
removeallclassmethods FSLocatorTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSPathTest otherwise: nil.
oldCls == nil ifTrue: [
	TestCase indexableSubclass: 'FSPathTest'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSPathTest'.
	newCls category: 'Filesystem-Tests'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSPathTest
removeallclassmethods FSPathTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSReadStreamTest otherwise: nil.
oldCls == nil ifTrue: [
	TestCase subclass: 'FSReadStreamTest'
	instVarNames: #( filesystem stream )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSReadStreamTest'.
	newCls category: 'Filesystem-Tests'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSReadStreamTest
removeallclassmethods FSReadStreamTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSReferenceCreationTest otherwise: nil.
oldCls == nil ifTrue: [
	TestCase indexableSubclass: 'FSReferenceCreationTest'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSReferenceCreationTest'.
	newCls category: 'Filesystem-Tests'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSReferenceCreationTest
removeallclassmethods FSReferenceCreationTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSReferenceTest otherwise: nil.
oldCls == nil ifTrue: [
	TestCase indexableSubclass: 'FSReferenceTest'
	instVarNames: #( filesystem )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSReferenceTest'.
	newCls category: 'Filesystem-Tests'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSReferenceTest
removeallclassmethods FSReferenceTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSResolverTest otherwise: nil.
oldCls == nil ifTrue: [
	TestCase subclass: 'FSResolverTest'
	instVarNames: #( resolver )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSResolverTest'.
	newCls category: 'Filesystem-Tests'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSResolverTest
removeallclassmethods FSResolverTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSInteractiveResolverTest otherwise: nil.
oldCls == nil ifTrue: [
	FSResolverTest subclass: 'FSInteractiveResolverTest'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSInteractiveResolverTest'.
	newCls category: 'Filesystem-Tests'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSInteractiveResolverTest
removeallclassmethods FSInteractiveResolverTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSPlatformResolverTest otherwise: nil.
oldCls == nil ifTrue: [
	FSResolverTest subclass: 'FSPlatformResolverTest'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSPlatformResolverTest'.
	newCls category: 'Filesystem-Tests'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSPlatformResolverTest
removeallclassmethods FSPlatformResolverTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSTestResolverTest otherwise: nil.
oldCls == nil ifTrue: [
	FSResolverTest subclass: 'FSTestResolverTest'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSTestResolverTest'.
	newCls category: 'Filesystem-Tests'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSTestResolverTest
removeallclassmethods FSTestResolverTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSTreeTest otherwise: nil.
oldCls == nil ifTrue: [
	TestCase subclass: 'FSTreeTest'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSTreeTest'.
	newCls category: 'Filesystem-Tests'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSTreeTest
removeallclassmethods FSTreeTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSCopyVisitorTest otherwise: nil.
oldCls == nil ifTrue: [
	FSTreeTest subclass: 'FSCopyVisitorTest'
	instVarNames: #( source dest )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSCopyVisitorTest'.
	newCls category: 'Filesystem-Tests'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSCopyVisitorTest
removeallclassmethods FSCopyVisitorTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSSingleTreeTest otherwise: nil.
oldCls == nil ifTrue: [
	FSTreeTest subclass: 'FSSingleTreeTest'
	instVarNames: #( filesystem )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSSingleTreeTest'.
	newCls category: 'Filesystem-Tests'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSSingleTreeTest
removeallclassmethods FSSingleTreeTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSCollectVisitorTest otherwise: nil.
oldCls == nil ifTrue: [
	FSSingleTreeTest subclass: 'FSCollectVisitorTest'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSCollectVisitorTest'.
	newCls category: 'Filesystem-Tests'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSCollectVisitorTest
removeallclassmethods FSCollectVisitorTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSDeleteVisitorTest otherwise: nil.
oldCls == nil ifTrue: [
	FSSingleTreeTest subclass: 'FSDeleteVisitorTest'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSDeleteVisitorTest'.
	newCls category: 'Filesystem-Tests'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSDeleteVisitorTest
removeallclassmethods FSDeleteVisitorTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSGuideTest otherwise: nil.
oldCls == nil ifTrue: [
	FSSingleTreeTest subclass: 'FSGuideTest'
	instVarNames: #( guide visited )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSGuideTest'.
	newCls category: 'Filesystem-Tests'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSGuideTest
removeallclassmethods FSGuideTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSBreadthFirstGuideTest otherwise: nil.
oldCls == nil ifTrue: [
	FSGuideTest subclass: 'FSBreadthFirstGuideTest'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSBreadthFirstGuideTest'.
	newCls category: 'Filesystem-Tests'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSBreadthFirstGuideTest
removeallclassmethods FSBreadthFirstGuideTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSPostorderGuideTest otherwise: nil.
oldCls == nil ifTrue: [
	FSGuideTest subclass: 'FSPostorderGuideTest'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSPostorderGuideTest'.
	newCls category: 'Filesystem-Tests'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSPostorderGuideTest
removeallclassmethods FSPostorderGuideTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSPreorderGuideTest otherwise: nil.
oldCls == nil ifTrue: [
	FSGuideTest subclass: 'FSPreorderGuideTest'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSPreorderGuideTest'.
	newCls category: 'Filesystem-Tests'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSPreorderGuideTest
removeallclassmethods FSPreorderGuideTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #FSWriteStreamTest otherwise: nil.
oldCls == nil ifTrue: [
	TestCase subclass: 'FSWriteStreamTest'
	instVarNames: #( filesystem stream )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'FSWriteStreamTest'.
	newCls category: 'Filesystem-Tests'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FSWriteStreamTest
removeallclassmethods FSWriteStreamTest


category: 'instance creation'
classmethod: FSFilesystemError
reference: aReference
	^ self basicNew initializeWithReference: aReference
%
run
FSFilesystemError class setStamp: 'cwp 11/14/2009 23:32' forMethod: #'reference:'.
true
%

category: 'instance creation'
classmethod: FSFilesystemError
signalWith: aReference
	^ (self reference: aReference) signal
%
run
FSFilesystemError class setStamp: 'cwp 11/14/2009 23:31' forMethod: #'signalWith:'.
true
%

category: 'initialize-release'
method: FSFilesystemError
initializeWithReference: aReference
	reference := aReference.
	messageText := aReference printString
%
run
FSFilesystemError setStamp: 'lr 8/16/2010 16:00' forMethod: #'initializeWithReference:'.
true
%

category: 'testing'
method: FSFilesystemError
isResumable
	^ true
%
run
FSFilesystemError setStamp: 'lr 8/16/2010 16:00' forMethod: #'isResumable'.
true
%

category: 'accessing'
method: FSFilesystemError
reference
	^ reference
%
run
FSFilesystemError setStamp: 'lr 7/13/2010 15:31' forMethod: #'reference'.
true
%

category: 'instance creation'
classmethod: FSResolutionRequest
for: origin
	^ self new
		origin: origin;
		signal
%
run
FSResolutionRequest class setStamp: 'cwp 10/27/2009 10:13' forMethod: #'for:'.
true
%

category: '*filesystemgemstone- exceptionDescription'
method: FSResolutionRequest
defaultAction

	"| pathString |
	OBGemStonePlatform canConfirm ifFalse: [ ^self error: 'Cannot find ', origin printString, '.' ].
	pathString := OBTextRequest prompt: 'Enter full path to directory' template: ''.
	self resume: (pathString == nil 
		ifTrue: [ nil ] 
		ifFalse:  [ FSDiskFilesystem current referenceTo: pathString ])"
	self error: 'no interaction right now'
%
run
FSResolutionRequest setStamp: 'DaleHenrichs 10/18/2010 14:53' forMethod: #'defaultAction'.
true
%

category: 'accessing'
method: FSResolutionRequest
origin: aSymbol
	origin := aSymbol
%
run
FSResolutionRequest setStamp: 'cwp 10/27/2009 10:22' forMethod: #'origin:'.
true
%

category: '*filesystem-converting'
method: String
asPathWith: anObject 
	^ anObject pathFromString: self
%
run
String setStamp: 'cwp 11/21/2009 11:30' forMethod: #'asPathWith:'.
true
%

category: '*filesystem-converting'
method: String
asResolvedBy: anObject
	^ anObject resolveString: self
%
run
String setStamp: 'cwp 10/10/2009 17:29' forMethod: #'asResolvedBy:'.
true
%

category: 'instance creation'
classmethod: FSDirectoryEntry
filesystem: fs path: path array: array
	^ self 
		filesystem: fs
		path: path
		creation: (array at: 2)
		modification: (array at: 3)
		isDir: (array at: 4)
		size: (array at: 5)
%
run
FSDirectoryEntry class setStamp: 'cwp 11/15/2009 22:03' forMethod: #'filesystem:path:array:'.
true
%

category: 'instance creation'
classmethod: FSDirectoryEntry
filesystem: fs path: p creation: ct modification: mt isDir: d size: s
	^ self 
		reference: (fs referenceTo: p)
		creation: ct
		modification: mt
		isDir: d
		size:s
%
run
FSDirectoryEntry class setStamp: 'cwp 11/15/2009 21:48' forMethod: #'filesystem:path:creation:modification:isDir:size:'.
true
%

category: 'instance creation'
classmethod: FSDirectoryEntry
reference: ref creation: cTime modification: mTime isDir: aBoolean size: anInteger
	^ self basicNew
		initializeWithRef: ref
		creation: cTime
		modification: mTime
		isDir: aBoolean
		size: anInteger
%
run
FSDirectoryEntry class setStamp: 'cwp 11/15/2009 21:50' forMethod: #'reference:creation:modification:isDir:size:'.
true
%

category: 'accessing'
method: FSDirectoryEntry
basename
	^ reference basename
%
run
FSDirectoryEntry setStamp: 'cwp 11/16/2009 10:49' forMethod: #'basename'.
true
%

category: 'accessing'
method: FSDirectoryEntry
creation
	^ DateAndTime fromSeconds: creation
%
run
FSDirectoryEntry setStamp: 'cwp 11/15/2009 22:06' forMethod: #'creation'.
true
%

category: 'accessing'
method: FSDirectoryEntry
creationSeconds
	^ creation
%
run
FSDirectoryEntry setStamp: 'cwp 11/15/2009 22:06' forMethod: #'creationSeconds'.
true
%

category: 'initialize-release'
method: FSDirectoryEntry
initializeWithRef: ref creation: cTime modification: mTime isDir: bool size: bytes
	
	reference := ref.
	creation := cTime.
	modification := mTime.
	isDirectory := bool.
	size := bytes
%
run
FSDirectoryEntry setStamp: 'cwp 11/15/2009 21:52' forMethod: #'initializeWithRef:creation:modification:isDir:size:'.
true
%

category: 'testing'
method: FSDirectoryEntry
isDirectory
	^ isDirectory
%
run
FSDirectoryEntry setStamp: 'cwp 11/15/2009 21:54' forMethod: #'isDirectory'.
true
%

category: 'testing'
method: FSDirectoryEntry
isFile
	^ isDirectory not
%
run
FSDirectoryEntry setStamp: 'cwp 11/15/2009 22:01' forMethod: #'isFile'.
true
%

category: 'accessing'
method: FSDirectoryEntry
modification
	^ DateAndTime fromSeconds: modification
%
run
FSDirectoryEntry setStamp: 'cwp 11/15/2009 22:06' forMethod: #'modification'.
true
%

category: 'accessing'
method: FSDirectoryEntry
modificationSeconds
	^ modification
%
run
FSDirectoryEntry setStamp: 'cwp 11/15/2009 22:06' forMethod: #'modificationSeconds'.
true
%

category: 'accessing'
method: FSDirectoryEntry
reference
	^ reference
%
run
FSDirectoryEntry setStamp: 'cwp 11/15/2009 21:54' forMethod: #'reference'.
true
%

category: 'accessing'
method: FSDirectoryEntry
size
	^ size
%
run
FSDirectoryEntry setStamp: 'cwp 11/15/2009 21:54' forMethod: #'size'.
true
%

category: 'file primitives'
method: FSFilePluginPrims
atEnd: aGsFile
	"Answer true if the file position is at the end of the file."

	| res |
	(res := aGsFile atEnd) == nil
		ifTrue: [ self throwErrorFor: aGsFile ].
	^res
%
run
FSFilePluginPrims setStamp: 'DaleHenrichs 10/14/2010 15:48' forMethod: #'atEnd:'.
true
%

category: 'file primitives'
method: FSFilePluginPrims
close: aGsFile
	"Close this file."

	aGsFile == nil ifTrue: [ ^self ].
	aGsFile close == nil
		ifTrue: [ self throwErrorFor: aGsFile ].
%
run
FSFilePluginPrims setStamp: 'DaleHenrichs 10/15/2010 16:13' forMethod: #'close:'.
true
%

category: 'path primitives'
method: FSFilePluginPrims
createDirectory: fullPath onClient: onClient
	"Create a directory named by the given path. 
	Fail if the path is bad or if a file or directory by that name already exists."

	(GsFile _exists: fullPath onClient: onClient) == false ifFalse: [ ^nil ].
	^GsFile _createDirectory: fullPath onClient: onClient mode: nil

%
run
FSFilePluginPrims setStamp: 'DaleHenrichs 10/14/2010 16:01' forMethod: #'createDirectory:onClient:'.
true
%

category: 'encoding primitives'
method: FSFilePluginPrims
decode: aString
	^ aString decodeFromUTF8 asString
%
run
FSFilePluginPrims setStamp: 'DaleHenrichs 10/15/2010 13:38' forMethod: #'decode:'.
true
%

category: 'path primitives'
method: FSFilePluginPrims
deleteDirectory: fullPath onClient: onClient
	"Delete the directory named by the given path. 
	Fail if the path is bad or if a directory by that name does not exist."

	| res |
	(res := GsFile _exists: fullPath onClient: onClient) == true 
		ifFalse: [ 
			res == nil
				ifTrue: [ self throwError: onClient ]
				ifFalse: [ ^self error: 'directory does not exist' ]].
	(GsFile _removeDirectory: fullPath onClient: onClient) == nil
		ifTrue: [ self throwError: onClient ]

%
run
FSFilePluginPrims setStamp: 'DaleHenrichs 10/14/2010 16:09' forMethod: #'deleteDirectory:onClient:'.
true
%

category: 'path primitives'
method: FSFilePluginPrims
deleteFile: fullPath onClient: onClient
	"Delete the file of the given name. 
	Return self if the primitive succeeds, nil otherwise."

	(GsFile _exists: fullPath onClient: onClient) == true ifFalse: [ ^nil ].
	(GsFile _removeFile: fullPath onClient: onClient) == nil
		ifTrue: [ ^nil ]

%
run
FSFilePluginPrims setStamp: 'DaleHenrichs 10/14/2010 16:07' forMethod: #'deleteFile:onClient:'.
true
%

category: 'encoding primitives'
method: FSFilePluginPrims
encode: aString
  "Let GsFile methods encode as needed, after fix 47720"
  ^ aString

%
run
FSFilePluginPrims setStamp: 'DaleHenrichs 10/15/2010 13:37' forMethod: #'encode:'.
true
%

category: 'file primitives'
method: FSFilePluginPrims
flush: aGsFile
	"Flush pending changes to the disk"

	aGsFile flush == nil
		ifTrue: [ self throwErrorFor: aGsFile ].

%
run
FSFilePluginPrims setStamp: 'DaleHenrichs 10/14/2010 15:49' forMethod: #'flush:'.
true
%

category: 'file primitives'
method: FSFilePluginPrims
getPosition: aGsFile
	"Get this files current position."

	| res |
	(res := aGsFile position) == nil
		ifTrue: [ self throwErrorFor: aGsFile ].
	^res
%
run
FSFilePluginPrims setStamp: 'DaleHenrichs 10/14/2010 15:49' forMethod: #'getPosition:'.
true
%

category: 'path primitives'
method: FSFilePluginPrims
lookupEntryIn: fullPath onClient: onClient do: aBlock 
	| contents path nm dirFlag modTime sz prefix |
  onClient ifFalse:[
    contents := GsFile _contentsOfServerDirectory: fullPath expandPath: false utf8Results: true.
    prefix := fullPath copy . 
    prefix last == $/ ifFalse:[ prefix add: $/ ].
    1 to: contents size do:[ :index | | st |
      nm := contents at: index .
      (((nm at: 1) ~~ $. ) or:[ 
        ((nm ~= '.') _and: [nm ~= '..'])])  ifTrue:[ 
        st := GsFile stat:  prefix , nm   isLstat: false .
        modTime := st mtimeUtcSeconds * 1000 . 
        aBlock value: { nm . modTime. modTime.  
									      st isDirectory . st size }
      ]
    ]
  ] ifTrue: [
	  contents := GsFile contentsAndTypesOfDirectory: fullPath onClient: true.
	  contents ifNil: [ ^aBlock value: #badDirectoryPath].
	  1 to: contents size by: 2 do: [:index | 
		  path := contents at: index.
		  dirFlag := (contents at: index + 1) not.
		  nm := (path findTokens: '/\') last.
		  ((nm ~= '.') _and: [nm ~= '..']) ifTrue: [
				  (modTime := GsFile _fileModTime: path onClient: true) ~~ nil
					  ifTrue: [ modTime := modTime asMillisecondsGmt ]
					  ifFalse: [ modTime := 0 ].
				  (sz := GsFile _sizeOf: path onClient: true) == nil
					  ifTrue: [ sz := 0 ].
				  aBlock value: {nm. modTime. modTime. dirFlag. sz.} 
      ]
    ]
  ]
%
run
FSFilePluginPrims setStamp: 'DaleHenrichs 10/18/2010 18:12' forMethod: #'lookupEntryIn:onClient:do:'.
true
%

category: 'file primitives'
method: FSFilePluginPrims
open: fileName mode: mode onClient: onClient

	| aGsFile |
	((mode beginsWith: 'r') and: [ ((GsFile _exists: fileName onClient: onClient) == true) not ]) ifTrue: [ ^nil ].
	aGsFile := GsFile 
		open: fileName 
		mode: mode 
		onClient: onClient.
	aGsFile == nil ifTrue: [ self throwError: onClient ].
	^aGsFile
%

category: 'file primitives'
method: FSFilePluginPrims
open: fileName writable: writableFlag onClient: onClient
	"Open a file of the given name, and return the GsFile instance obtained.
	If writableFlag is true, then
		if there is none with this name, then create one
		else prepare to overwrite the existing from the beginning
	otherwise
		if the file exists, open it read-only
		else return nil"

	| mode |
	mode := writableFlag 
		ifTrue: [ 'w' ] 
		ifFalse: [ 'r' ].
	^self open: fileName mode: mode onClient: onClient
%
run
FSFilePluginPrims setStamp: 'DaleHenrichs 10/19/2010 16:59' forMethod: #'open:writable:onClient:'.
true
%

category: 'file primitives'
method: FSFilePluginPrims
read: aGsFile into: stringOrByteArray startingAt: startIndex count: count
	"Read up to count bytes of data from this file into the given string or byte array starting at the given index. Answer the number of bytes actually read."

	| res |
	startIndex > 1
		ifTrue: [ | index read byte |
			index := startIndex.
			read := 0.
			count timesRepeat: [
				(byte := aGsFile next) == nil
					ifTrue: [ ^read ].
				stringOrByteArray byteAt: index put: byte.
				read := read + 1.
				index := index + 1].
			^read].
	(res := aGsFile read: count into: stringOrByteArray) == nil
		ifTrue: [ self throwErrorFor: aGsFile ].
	^res
%
run
FSFilePluginPrims setStamp: 'DaleHenrichs 10/18/2010 18:25' forMethod: #'read:into:startingAt:count:'.
true
%

category: 'path primitives'
method: FSFilePluginPrims
rename: oldFileFullName to: newFileFullName onClient: onClient
	"Rename the file of the given name to the new name. Fail if there is no file of the old name 
	or if there is an existing file with the new name."

	(GsFile classUserAction: #GsfRename onClient: onClient with: oldFileFullName with: newFileFullName) ~~ 0
		ifTrue: [ ^nil ]

%
run
FSFilePluginPrims setStamp: 'DaleHenrichs 10/14/2010 16:36' forMethod: #'rename:to:onClient:'.
true
%

category: 'file primitives'
method: FSFilePluginPrims
setPosition: aGsFile to: anInteger
	"Set this file to the given position."

	(aGsFile position: anInteger) == nil
		ifTrue: [ self throwErrorFor: aGsFile ].

%
run
FSFilePluginPrims setStamp: 'DaleHenrichs 10/14/2010 15:51' forMethod: #'setPosition:to:'.
true
%

category: 'file primitives'
method: FSFilePluginPrims
size: aGsFile
	"Answer the size of this file."
	
	| res |
	(res := GsFile _sizeOf: aGsFile pathName onClient: aGsFile isClient) == nil
		ifTrue: [ self throwErrorFor: aGsFile ].
	^res
%
run
FSFilePluginPrims setStamp: 'DaleHenrichs 10/14/2010 15:50' forMethod: #'size:'.
true
%

category: 'file primitives'
method: FSFilePluginPrims
sizeOrNil: aGsFile
	"Answer the size of this file."
	
	| res |
	aGsFile == nil ifTrue: [ ^nil ].
	(res := GsFile _sizeOf: aGsFile pathName onClient: aGsFile isClient) == nil
		ifTrue: [ ^nil ].
	^res
%
run
FSFilePluginPrims setStamp: 'DaleHenrichs 10/15/2010 16:13' forMethod: #'sizeOrNil:'.
true
%

category: 'private'
method: FSFilePluginPrims
throwError: onClient

	 self error: (GsFile classUserAction: #GsfClassError onClient: onClient with: nil)
%
run
FSFilePluginPrims setStamp: 'DaleHenrichs 10/15/2010 14:00' forMethod: #'throwError:'.
true
%

category: 'private'
method: FSFilePluginPrims
throwErrorFor: aGsFile

	 self error: aGsFile lastErrorString
%
run
FSFilePluginPrims setStamp: 'DaleHenrichs 10/14/2010 15:48' forMethod: #'throwErrorFor:'.
true
%

category: 'file primitives'
method: FSFilePluginPrims
truncate: aGsFile to: anInteger
	"Truncate this file to the given position."
	
	self setPosition: aGsFile to: anInteger.
	aGsFile flush.
	self close: aGsFile.
	aGsFile open == nil ifTrue: [ self throwError: aGsFile isClient ].
	self setPosition: aGsFile to: anInteger.
	
%
run
FSFilePluginPrims setStamp: 'DaleHenrichs 10/18/2010 14:32' forMethod: #'truncate:to:'.
true
%

category: 'file primitives'
method: FSFilePluginPrims
write: aGsFile from: stringOrByteArray startingAt: startIndex count: count
	"Write count bytes onto this file from the given string or byte array starting at the given index. 	Answer the number of bytes written."


	| res soba |
	soba := startIndex > 1
		ifTrue: [ stringOrByteArray copyFrom: startIndex to: startIndex + 1 - 1 ]
		ifFalse: [ stringOrByteArray ].
	(res := aGsFile write: count from: soba) == nil
		ifTrue: [ self throwErrorFor: aGsFile ].
	^res
%
run
FSFilePluginPrims setStamp: 'DaleHenrichs 10/18/2010 14:20' forMethod: #'write:from:startingAt:count:'.
true
%

category: 'accessing'
classmethod: FSDiskFilesystem
/ anObject
	^ self current root / anObject
%
run
FSDiskFilesystem class setStamp: 'cwp 9/22/2009 09:41' forMethod: #'/'.
true
%

category: 'instance creation'
classmethod: FSDiskFilesystem
createDefault
	^ self new
%
run
FSDiskFilesystem class setStamp: 'cwp 10/10/2009 18:25' forMethod: #'createDefault'.
true
%

category: '*filesystemgemstone-instance creation'
classmethod: FSDiskFilesystem
current

	^self defaultFor: #gem
%
run
FSDiskFilesystem class setStamp: 'DaleHenrichs 10/20/2010 15:39' forMethod: #'current'.
true
%

category: '*filesystemgemstone-private'
classmethod: FSDiskFilesystem
currentClass
	"gem"
	
	| osName |
	osName := System gemVersionAt: 'osName'.
	^(osName beginsWith: 'Windows')
		ifTrue: [ FSWindowsFilesystem ]
		ifFalse: [ FSUnixFilesystem ].

%
run
FSDiskFilesystem class setStamp: 'DaleHenrichs 10/15/2010 09:59' forMethod: #'currentClass'.
true
%

category: '*filesystemgemstone-private'
classmethod: FSDiskFilesystem
currentFsPathClass
	"gem"
	
	^FSPath
%
run
FSDiskFilesystem class setStamp: 'DaleHenrichs 10/15/2010 14:08' forMethod: #'currentFsPathClass'.
true
%

category: '*filesystemgemstone-private'
classmethod: FSDiskFilesystem
defaultDict
	| dict |
	dict := SessionTemps current at: #DEFAULT_DICT_FOR_FSDiskFilesystem otherwise: nil.
	dict == nil 
		ifTrue: [
			dict :=Dictionary new.
			SessionTemps current at: #DEFAULT_DICT_FOR_FSDiskFilesystem put: dict].
	^dict
%

category: '*filesystemgemstone-private'
classmethod: FSDiskFilesystem
defaultFor: aSymbol
	"#gci or #gem"

	| defaultDict |
        defaultDict := self defaultDict.
	^defaultDict 
		at: aSymbol 
		ifAbsent: [ | fileSystemClass fsPathClass fileSystem osName path |
			osName := aSymbol == #gem
				ifTrue: [ 					
					fsPathClass := FSPath.
					System gemVersionAt: 'osName' ]
				ifFalse: [ 
					fsPathClass := FSGciPath.
					System clientVersionAt: 'osName' ].
			fileSystemClass := (osName beginsWith: 'Windows')
				ifTrue: [ FSWindowsFilesystem ]
				ifFalse: [ FSUnixFilesystem ].
			fileSystem := fileSystemClass createDefault.
			path := GsFile _expandEnvVariable: 'HOME' isClient: fsPathClass onClient.
			fileSystem workingDirectory: 
				(fsPathClass 
					readFrom: (ReadStream on: path)
					delimiter: fileSystem delimiter).
			defaultDict at: aSymbol put: fileSystem.
			fileSystem]
%
run
FSDiskFilesystem class setStamp: 'DaleHenrichs 10/20/2010 15:40' forMethod: #'defaultFor:'.
true
%

category: '*filesystemgemstone-references'
classmethod: FSDiskFilesystem
gci
	^(self defaultFor: #gci) workingDirectory asReference
%
run
FSDiskFilesystem class setStamp: 'DaleHenrichs 10/20/2010 15:45' forMethod: #'gci'.
true
%

category: '*filesystemgemstone-references'
classmethod: FSDiskFilesystem
gem
	^(self defaultFor: #gem) workingDirectory asReference
%
run
FSDiskFilesystem class setStamp: 'DaleHenrichs 10/20/2010 15:44' forMethod: #'gem'.
true
%

category: '*filesystemgemstone-initialize-release'
classmethod: FSDiskFilesystem
initialize
	"self initialize"

	self useFilePlugin.
%
run
FSDiskFilesystem class setStamp: 'DaleHenrichs 10/15/2010 13:39' forMethod: #'initialize'.
true
%

category: 'testing'
classmethod: FSDiskFilesystem
isCurrentClass
	^ FSDiskFilesystem currentClass = self
%
run
FSDiskFilesystem class setStamp: 'cwp 11/21/2009 12:22' forMethod: #'isCurrentClass'.
true
%

category: 'accessing'
classmethod: FSDiskFilesystem
pathFromString: aString 

	^self current pathFromString: aString 

%
run
FSDiskFilesystem class setStamp: 'DaleHenrichs 10/20/2010 10:48' forMethod: #'pathFromString:'.
true
%

category: '*filesystemgemstone-references'
classmethod: FSDiskFilesystem
pwd
	^self current referenceFromString: (GsFile _expandEnvVariable: 'PWD' isClient: false)
%
run
FSDiskFilesystem class setStamp: 'DaleHenrichs 10/20/2010 15:43' forMethod: #'pwd'.
true
%

category: '*filesystemgemstone-instance creation'
classmethod: FSDiskFilesystem
reset
	 SessionTemps current removeKey: #DEFAULT_DICT_FOR_FSDiskFilesystem ifAbsent: []
%
run
FSDiskFilesystem class setStamp: 'lr 4/24/2010 14:03' forMethod: #'reset'.
true
%

category: 'accessing'
classmethod: FSDiskFilesystem
root
	^ self current root
%
run
FSDiskFilesystem class setStamp: 'cwp 10/11/2009 11:11' forMethod: #'root'.
true
%

category: 'references'
classmethod: FSDiskFilesystem
testDirectory
	^ self testFile parent
%
run
FSDiskFilesystem class setStamp: 'DaleHenrichs 10/15/2010 16:56' forMethod: #'testDirectory'.
true
%

category: '*filesystemgemstone-references'
classmethod: FSDiskFilesystem
testFile

	| testPath |
	testPath := (GsFile _expandEnvVariable: 'HOME' isClient: false), '/filesystemTestFile.txt'.
	(GsFile existsOnServer: testPath) 
		ifFalse: [ | result |
			result := GsFile openWriteOnServer: testPath.
			result == nil 
				ifTrue: [ self error: (GsFile classUserAction: #GsfClassError onClient: false with: nil) ].
			result close ].
	^self current referenceFromString: testPath
%
run
FSDiskFilesystem class setStamp: 'DaleHenrichs 10/18/2010 11:52' forMethod: #'testFile'.
true
%

category: 'initialize-release'
classmethod: FSDiskFilesystem
useFilePlugin
	Primitives := FSFilePluginPrims new
%
run
FSDiskFilesystem class setStamp: 'cwp 7/20/2009 17:39' forMethod: #'useFilePlugin'.
true
%

category: 'comparing'
method: FSDiskFilesystem
= other
	^ self species = other species
%
run
FSDiskFilesystem setStamp: 'cwp 7/24/2009 00:41' forMethod: #'='.
true
%

category: 'private'
method: FSDiskFilesystem
basicIsDirectory: anEntry
	^ anEntry at: 4
%
run
FSDiskFilesystem setStamp: 'cwp 7/18/2009 01:26' forMethod: #'basicIsDirectory:'.
true
%

category: 'private'
method: FSDiskFilesystem
basicIsFile: anEntry 
	^ (anEntry at: 4) not
%
run
FSDiskFilesystem setStamp: 'cwp 7/18/2009 01:29' forMethod: #'basicIsFile:'.
true
%

category: '*filesystemgemstone-public'
method: FSDiskFilesystem
openFileStream: aPath mode: mode
	"modes:
		'r'
		'w'
		'r+'
		'w+'
	"
	| handle |
	handle := self open: aPath mode: mode.
	mode = 'w'
		ifTrue: [ ^FSWriteStream onHandle: handle ].
	mode = 'r'
		ifTrue: [ ^FSReadStream onHandle: handle ].
	(mode = 'w+' or: [ mode = 'r+' ])
		ifTrue: [ ^FSReadWriteStream onHandle: handle ].
	self error: 'Unknown mode: ', mode printString
%

category: 'public'
method: FSDiskFilesystem
open: anObject mode: modeString
	| path |
	path := self resolve: anObject.
	^ FSFileHandle 
		open: (FSReference filesystem: self path: path) 
		mode: modeString
%

category: '*filesystemgemstone-public'
method: FSDiskFilesystem
basicOpen: aPath mode: aString
	^ Primitives 
		open: (Primitives encode: (self stringFromPath: aPath))
		mode: aString
		onClient: self onClient
%

category: '*filesystemgemstone-public'
method: FSDiskFilesystem
basicOpen: aPath writable: aBoolean
	^ Primitives 
		open: (Primitives encode: (self stringFromPath: aPath))
		writable: aBoolean
		onClient: self onClient
%
run
FSDiskFilesystem setStamp: 'DaleHenrichs 10/15/2010 13:58' forMethod: #'basicOpen:writable:'.
true
%

category: 'public'
method: FSDiskFilesystem
childrenAt: anObject 
	| path |
	path := self resolve: anObject.
	^ Array streamContents: 
		[ :out | 
		self 
			directoryAt: path
			ifAbsent: [ self directoryDoesNotExist: path ]
			nodesDo: [ :entry | out nextPut: (self referenceTo: path / entry first) ] ]
%
run
FSDiskFilesystem setStamp: 'cwp 11/17/2009 19:46' forMethod: #'childrenAt:'.
true
%

category: '*filesystemgemstone-public'
method: FSDiskFilesystem
createDirectory: anObject 
	| path pathString encodedPathString result parent |
	path := self resolve: anObject.
	pathString := self stringFromPath: path.
	encodedPathString := Primitives encode: pathString.
	result := Primitives createDirectory: encodedPathString onClient: self onClient.
	result ifNil: [ 
		parent := path parent.
		(self exists: path) ifTrue: [ ^ self nodeExists: path ].
		(self isDirectory: parent) ifFalse: [ ^ self directoryDoesNotExist: parent ].
		self primitiveFailed ]
%
run
FSDiskFilesystem setStamp: 'DaleHenrichs 10/15/2010 13:59' forMethod: #'createDirectory:'.
true
%

category: '*filesystemgemstone-public'
method: FSDiskFilesystem
createFile: anObject 
	| path pathString encodedPathString result parent |
	path := self resolve: anObject.
	pathString := self stringFromPath: path.
	encodedPathString := Primitives encode: pathString.
	result := Primitives open: encodedPathString writable: true onClient: self onClient.
	result ~~ nil
		ifTrue: [ result close ]
		ifFalse: [ 
			parent := path parent.
			(self exists: path) ifTrue: [ ^ self nodeExists: path ].
			(self isDirectory: parent) ifFalse: [ ^ self directoryDoesNotExist: parent ].
			self primitiveFailed ]
%
run
FSDiskFilesystem setStamp: 'DaleHenrichs 10/18/2010 17:20' forMethod: #'createFile:'.
true
%

category: '*filesystemgemstone-public'
method: FSDiskFilesystem
delete: anObject 
	| path pathString encodedPathString |
	path := self resolve: anObject.
	pathString := self stringFromPath: path.
	encodedPathString := Primitives encode: pathString.
	(self isDirectory: path) 
		ifTrue: [ Primitives deleteDirectory: encodedPathString onClient: self onClient ]
		ifFalse: [ Primitives deleteFile: encodedPathString onClient: self onClient  ]
%
run
FSDiskFilesystem setStamp: 'DaleHenrichs 10/15/2010 13:59' forMethod: #'delete:'.
true
%

category: '*filesystemgemstone-public'
method: FSDiskFilesystem
directoryAt: aPath ifAbsent: absentBlock nodesDo: aBlock 
	Primitives 
		lookupEntryIn: (Primitives encode: (self stringFromPath: aPath))
		onClient: self onClient
		do: [:entry |
			entry == #badDirectoryPath
				ifTrue: [ ^ absentBlock value ].
			entry at: 1 put: (Primitives decode: (entry at: 1)).
			aBlock value: entry ]
%
run
FSDiskFilesystem setStamp: 'DaleHenrichs 10/15/2010 16:33' forMethod: #'directoryAt:ifAbsent:nodesDo:'.
true
%

category: 'public'
method: FSDiskFilesystem
entriesAt: anObject 
	| path entry |
	path := self resolve: anObject.
	^ Array streamContents: 
		[ :out | 
		self 
			directoryAt: path
			ifAbsent: [ self directoryDoesNotExist: path ]
			nodesDo: 
				[ :node | 
				entry := self 
					entryFromNode: node
					atPath: path / (node at: 1).
				out nextPut: entry ] ]
%
run
FSDiskFilesystem setStamp: 'cwp 11/17/2009 19:46' forMethod: #'entriesAt:'.
true
%

category: 'private'
method: FSDiskFilesystem
entryFromNode: node atPath: path 
	^ FSDirectoryEntry 
		filesystem: self
		path: path
		array: node
%
run
FSDiskFilesystem setStamp: 'cwp 11/16/2009 00:19' forMethod: #'entryFromNode:atPath:'.
true
%

category: 'comparing'
method: FSDiskFilesystem
hash
	^ self species hash
%
run
FSDiskFilesystem setStamp: 'cwp 7/24/2009 00:41' forMethod: #'hash'.
true
%

category: '*filesystemgemstone-private'
method: FSDiskFilesystem
initialize
	"don't send super initialize"
%
run
FSDiskFilesystem setStamp: 'DaleHenrichs 10/18/2010 12:23' forMethod: #'initialize'.
true
%

category: 'private'
method: FSDiskFilesystem
nodeAt: aPath ifPresent: presentBlock ifAbsent: absentBlock 
	| name |
	aPath isRoot ifTrue: [ ^ presentBlock value: self rootNode ].
	name := aPath basename.
	self 
		directoryAt: aPath parent
		ifAbsent: absentBlock
		nodesDo: 
			[ :entry | 
			(self 
				filenname: (entry at: 1)
				matches: name) ifTrue: [ ^ presentBlock value: entry ] ].
	^ absentBlock value
%
run
FSDiskFilesystem setStamp: 'cwp 11/15/2009 21:40' forMethod: #'nodeAt:ifPresent:ifAbsent:'.
true
%

category: '*filesystemgemstone-private'
method: FSDiskFilesystem
onClient

	^self workingDirectory onClient
%
run
FSDiskFilesystem setStamp: 'DaleHenrichs 10/15/2010 13:58' forMethod: #'onClient'.
true
%

category: 'public'
method: FSDiskFilesystem
open: anObject writable: aBoolean 
	| path |
	path := self resolve: anObject.
	^ FSFileHandle 
		open: (FSReference filesystem: self path: path) 
		writable: aBoolean
		
%
run
FSDiskFilesystem setStamp: 'cwp 10/11/2009 21:21' forMethod: #'open:writable:'.
true
%

category: '*filesystemgemstone-public'
method: FSDiskFilesystem
openFileStream: aPath writable: aBoolean 

	| forWrite |
	forWrite := (self exists: aPath) not.
	^aBoolean
		ifTrue: [ FSReadWriteStream onHandle: (self open: aPath writable: forWrite) ]
		ifFalse: [ FSReadStream onHandle: (self open: aPath writable: forWrite) ]

%
run
FSDiskFilesystem setStamp: 'DaleHenrichs 10/19/2010 16:34' forMethod: #'openFileStream:writable:'.
true
%

category: 'private'
method: FSDiskFilesystem
rootNode
	^ #('' 0 0 true 0 )
%
run
FSDiskFilesystem setStamp: 'cwp 11/15/2009 21:40' forMethod: #'rootNode'.
true
%

category: '*filesystemgemstone-private'
classmethod: FSUnixFilesystem
putRootsOn: aStream 
	self isCurrentClass ifTrue: [ aStream nextPut: self current root ]
%
run
FSUnixFilesystem class setStamp: 'DaleHenrichs 10/14/2010 16:33' forMethod: #'putRootsOn:'.
true
%

category: 'public'
method: FSUnixFilesystem
delimiter
	^ $/
%
run
FSUnixFilesystem setStamp: 'cwp 1/13/2009 21:35' forMethod: #'delimiter'.
true
%

category: 'private'
method: FSUnixFilesystem
forReferencePrintOn: aStream
	
%
run
FSUnixFilesystem setStamp: 'cwp 10/11/2009 22:33' forMethod: #'forReferencePrintOn:'.
true
%

category: '*filesystemgemstone-private'
method: FSUnixFilesystem
initialize
	super initialize.
	workingDirectory := self class currentFsPathClass 
		readFrom: (ReadStream on: (GsFile _expandEnvVariable: 'HOME' isClient: self class currentFsPathClass onClient))
		delimiter: self delimiter
%
run
FSUnixFilesystem setStamp: 'DaleHenrichs 10/18/2010 12:09' forMethod: #'initialize'.
true
%

category: '*filesystemgemstone-instance creation'
classmethod: FSWindowsFilesystem
changeDisk: aString
	self defaultDict at: #gem put: self disk: aString
%
run
FSWindowsFilesystem class setStamp: 'DaleHenrichs 10/14/2010 16:31' forMethod: #'changeDisk:'.
true
%

category: '*filesystemgemstone-instance creation'
classmethod: FSWindowsFilesystem
currentDisksDo: aBlock
	| index entry |
	index := 1.
	[entry := Primitives decode: (Primitives lookupEntryIn: '' index: index).
	entry isNil] whileFalse: 
		[aBlock value: entry first allButLast.
		index := index + 1]
%
run
FSWindowsFilesystem class setStamp: 'DaleHenrichs 10/14/2010 16:31' forMethod: #'currentDisksDo:'.
true
%

category: 'instance creation'
classmethod: FSWindowsFilesystem
disk: aString 
	^ Disks 
		at: aString
		ifAbsentPut: [ self newForDisk: aString ]
%
run
FSWindowsFilesystem class setStamp: 'cwp 11/20/2009 20:55' forMethod: #'disk:'.
true
%

category: 'instance creation'
classmethod: FSWindowsFilesystem
disks
	^ Disks values asArray sort: [:a :b | a printString < b printString]
%
run
FSWindowsFilesystem class setStamp: 'cwp 11/21/2009 09:11' forMethod: #'disks'.
true
%

category: 'initialize-release'
classmethod: FSWindowsFilesystem
initialize
	Disks := Dictionary new.
	
%
run
FSWindowsFilesystem class setStamp: 'cwp 11/20/2009 20:51' forMethod: #'initialize'.
true
%

category: 'instance creation'
classmethod: FSWindowsFilesystem
newForDisk: aString 
	^ super createDefault initializeWithDisk: aString
%
run
FSWindowsFilesystem class setStamp: 'DaleHenrichs 10/15/2010 12:44' forMethod: #'newForDisk:'.
true
%

category: '*filesystemgemstone-private'
classmethod: FSWindowsFilesystem
putRootsOn: aStream
	self isCurrentClass ifTrue:
		[self currentDisksDo:
			[:disk | aStream nextPut: (self disk: disk) root]]
%
run
FSWindowsFilesystem class setStamp: 'DaleHenrichs 10/14/2010 16:32' forMethod: #'putRootsOn:'.
true
%

category: 'navigating'
method: FSWindowsFilesystem
/ anObject
	^ self root / anObject
%
run
FSWindowsFilesystem setStamp: 'cwp 10/27/2009 20:54' forMethod: #'/'.
true
%

category: 'comparing'
method: FSWindowsFilesystem
= other
	^ self species = other species
		and: [disk = other disk]
%
run
FSWindowsFilesystem setStamp: 'cwp 11/21/2009 12:29' forMethod: #'='.
true
%

category: 'public'
method: FSWindowsFilesystem
delimiter
	^ $\
%
run
FSWindowsFilesystem setStamp: 'cwp 7/17/2009 19:19' forMethod: #'delimiter'.
true
%

category: 'accessing'
method: FSWindowsFilesystem
disk
	^ disk
%
run
FSWindowsFilesystem setStamp: 'cwp 11/21/2009 11:57' forMethod: #'disk'.
true
%

category: 'printing'
method: FSWindowsFilesystem
forReferencePrintOn: aStream 
	aStream 
		nextPutAll: disk;
		nextPut: $:
%
run
FSWindowsFilesystem setStamp: 'cwp 10/11/2009 22:33' forMethod: #'forReferencePrintOn:'.
true
%

category: 'comparing'
method: FSWindowsFilesystem
hash
	^ disk hash
%
run
FSWindowsFilesystem setStamp: 'cwp 11/21/2009 12:29' forMethod: #'hash'.
true
%

category: '*filesystemgemstone-initialize-release'
method: FSWindowsFilesystem
initializeWithDisk: aString
	| pathString |
	disk := aString.
	workingDirectory == nil
		ifTrue: [ workingDirectory := self class currentFsPathClass root ]
		ifFalse: [ 
			pathString := workingDirectory printString.
			workingDirectory := (pathString at: 1) = disk
				ifTrue: [ (self pathFromString: pathString) parent ]
				ifFalse: [ workingDirectory class root ]]
%
run
FSWindowsFilesystem setStamp: 'DaleHenrichs 10/18/2010 19:18' forMethod: #'initializeWithDisk:'.
true
%

category: 'converting'
method: FSWindowsFilesystem
pathFromString: aString 
	| in |
	in := aString readStream.
	(aString at: 2) = $: ifTrue: [ in skip: 2 ].
	^ FSPath 
		readFrom: in
		delimiter: self delimiter
%
run
FSWindowsFilesystem setStamp: 'cwp 11/21/2009 11:30' forMethod: #'pathFromString:'.
true
%

category: 'printing'
method: FSWindowsFilesystem
printOn: aStream 
	aStream nextPutAll: disk.
	aStream nextPut: $:
%
run
FSWindowsFilesystem setStamp: 'cwp 10/11/2009 12:49' forMethod: #'printOn:'.
true
%

category: 'converting'
method: FSWindowsFilesystem
referenceFromString: aString 
	| in fs letter |
	in := aString readStream.
	(aString at: 2) = $: 
		ifFalse: [ fs := self ]
		ifTrue: 
			[ letter := in next: 1.
			in skip: 1.
			fs := Disks 
				at: letter
				ifAbsentPut: [ self class newForDisk: letter ] ].
	^ FSReference 
		filesystem: fs
		path: (FSPath 
				readFrom: in
				delimiter: self delimiter)
%
run
FSWindowsFilesystem setStamp: 'cwp 11/21/2009 11:30' forMethod: #'referenceFromString:'.
true
%

category: 'converting'
method: FSWindowsFilesystem
stringFromPath: aPath 
	^ String streamContents: 
		[ :out | 
		out
			nextPutAll: disk;
			nextPut: $:.
		aPath 
			printOn: out
			delimiter: self delimiter ]
%
run
FSWindowsFilesystem setStamp: 'cwp 11/21/2009 11:31' forMethod: #'stringFromPath:'.
true
%

category: 'instance creation'
classmethod: FSFilesystem
/ anObject
	^ self new root / anObject
%
run
FSFilesystem class setStamp: 'cwp 9/22/2009 09:41' forMethod: #'/'.
true
%

category: '*filesystemgemstone-instance creation'
classmethod: FSFilesystem
new

	^self basicNew initialize
%
run
FSFilesystem class setStamp: 'DaleHenrichs 10/18/2010 12:18' forMethod: #'new'.
true
%

category: 'private'
classmethod: FSFilesystem
putAllRootsOn: aStream
	self putRootsOn: aStream.
	self subclasses do: [:class | class putAllRootsOn: aStream]
%
run
FSFilesystem class setStamp: 'DaleHenrichs 10/18/2010 19:33' forMethod: #'putAllRootsOn:'.
true
%

category: 'private'
classmethod: FSFilesystem
putRootsOn: aStream

%
run
FSFilesystem class setStamp: 'cwp 11/21/2009 12:20' forMethod: #'putRootsOn:'.
true
%

category: 'private'
method: FSFilesystem
basicCopy: source ifAbsent: aBlock to: destination ifPresent: pBlock
	| in out buffer |
	[in := self readStreamOn: source.
	in ifNil: [aBlock value].
	(self exists: destination) ifTrue: [ pBlock value ].
	out := self writeStreamOn: destination.
	buffer := ByteArray new: 1024.
	[in atEnd] whileFalse:
		[buffer := in nextInto: buffer.
		out nextPutAll: buffer]]
			ensure:
				[in ifNotNil: [in close].
				out ifNotNil: [out close]]
%
run
FSFilesystem setStamp: 'lr 7/13/2010 15:36' forMethod: #'basicCopy:ifAbsent:to:ifPresent:'.
true
%

category: 'private'
method: FSFilesystem
basicIsDirectory: anEntry
	self subclassResponsibility
%
run
FSFilesystem setStamp: 'MaxLeske 7/9/2010 12:07' forMethod: #'basicIsDirectory:'.
true
%

category: 'private'
method: FSFilesystem
basicIsFile: entry
	self subclassResponsibility
%
run
FSFilesystem setStamp: 'MaxLeske 7/9/2010 12:09' forMethod: #'basicIsFile:'.
true
%

category: 'accessing'
method: FSFilesystem
changeDirectory: aPath
	self workingDirectory: (self resolve: aPath)
%
run
FSFilesystem setStamp: 'cwp 7/18/2009 00:53' forMethod: #'changeDirectory:'.
true
%

category: 'public'
method: FSFilesystem
childrenAt: anObject 
	self subclassResponsibility
%
run
FSFilesystem setStamp: 'cwp 11/15/2009 21:25' forMethod: #'childrenAt:'.
true
%

category: 'public'
method: FSFilesystem
close
	"Some kinds of filesystems need to open connections to external resources"
%
run
FSFilesystem setStamp: 'cwp 9/21/2009 15:18' forMethod: #'close'.
true
%

category: 'public'
method: FSFilesystem
copy: sourcePath ifAbsent: aBlock to: destPath ifPresent: pBlock
	| source destination |
	source := self resolve: sourcePath.
	destination := self resolve: destPath.
	self basicCopy: source ifAbsent: aBlock to: destination ifPresent: pBlock
%
run
FSFilesystem setStamp: 'cwp 10/10/2009 17:34' forMethod: #'copy:ifAbsent:to:ifPresent:'.
true
%

category: 'public'
method: FSFilesystem
copy: sourcePath to: destPath
	self
		copy: sourcePath
		ifAbsent: [self fileDoesNotExist: sourcePath]
		to: destPath
		ifPresent: [self fileExists: destPath]
%
run
FSFilesystem setStamp: 'cwp 7/24/2009 00:27' forMethod: #'copy:to:'.
true
%

category: 'public'
method: FSFilesystem
createDirectory: aPath
	self subclassResponsibility
%
run
FSFilesystem setStamp: 'cwp 7/18/2009 01:15' forMethod: #'createDirectory:'.
true
%

category: 'public'
method: FSFilesystem
delete: aPath
	self subclassResponsibility
%
run
FSFilesystem setStamp: 'cwp 7/20/2009 08:39' forMethod: #'delete:'.
true
%

category: 'public'
method: FSFilesystem
delimiter
	self subclassResponsibility
%
run
FSFilesystem setStamp: 'cwp 7/17/2009 19:20' forMethod: #'delimiter'.
true
%

category: 'private'
method: FSFilesystem
directoryAt: aPath ifAbsent: absentBlock nodesDo: aBlock 
	self subclassResponsibility
%
run
FSFilesystem setStamp: 'cwp 11/15/2009 21:32' forMethod: #'directoryAt:ifAbsent:nodesDo:'.
true
%

category: 'error handling'
method: FSFilesystem
directoryDoesNotExist: path 
	^ FSDirectoryDoesNotExist signalWith: (self referenceTo: path)
%
run
FSFilesystem setStamp: 'lr 8/16/2010 16:17' forMethod: #'directoryDoesNotExist:'.
true
%

category: 'error handling'
method: FSFilesystem
directoryExists: path 
	^ FSDirectoryExists signalWith: (self referenceTo: path)
%
run
FSFilesystem setStamp: 'lr 8/16/2010 16:17' forMethod: #'directoryExists:'.
true
%

category: 'public'
method: FSFilesystem
ensureDirectory: aPath
	(self isDirectory: aPath)
		ifTrue: [ ^ self ].
	self ensureDirectory: aPath parent.
	self createDirectory: aPath
%
run
FSFilesystem setStamp: 'lr 7/13/2010 15:19' forMethod: #'ensureDirectory:'.
true
%

category: 'public'
method: FSFilesystem
entryAt: anObject 
	| path |
	path := self resolve: anObject.
	^ self 
		nodeAt: path
		ifPresent:  [:node | self entryFromNode: node atPath: path]
		ifAbsent: [self fileDoesNotExist: path]
%
run
FSFilesystem setStamp: 'cwp 11/15/2009 22:43' forMethod: #'entryAt:'.
true
%

category: 'private'
method: FSFilesystem
entryFromNode: node atPath: path 
	self subclassResponsibility
%
run
FSFilesystem setStamp: 'cwp 11/15/2009 22:21' forMethod: #'entryFromNode:atPath:'.
true
%

category: 'public'
method: FSFilesystem
exists: anObject 
	| path |
	path := self resolve: anObject.
	self 
		nodeAt: path
		ifPresent: [ :entry | ^ true ]
		ifAbsent: [ ^ false ]
%
run
FSFilesystem setStamp: 'cwp 11/15/2009 21:31' forMethod: #'exists:'.
true
%

category: 'error handling'
method: FSFilesystem
fileDoesNotExist: path 
	^ FSFileDoesNotExist signalWith: (self referenceTo: path)
%
run
FSFilesystem setStamp: 'lr 8/16/2010 16:17' forMethod: #'fileDoesNotExist:'.
true
%

category: 'error handling'
method: FSFilesystem
fileExists: path 
	^ FSFileExists signalWith: (self referenceTo: path)
%
run
FSFilesystem setStamp: 'lr 8/16/2010 16:18' forMethod: #'fileExists:'.
true
%

category: 'private'
method: FSFilesystem
filenname: aByteString matches: aByteString2 
	^ aByteString = aByteString2
%
run
FSFilesystem setStamp: 'cwp 11/15/2009 21:31' forMethod: #'filenname:matches:'.
true
%

category: 'printing'
method: FSFilesystem
forReferencePrintOn: aStream
	self subclassResponsibility
%
run
FSFilesystem setStamp: 'cwp 7/17/2009 19:20' forMethod: #'forReferencePrintOn:'.
true
%

category: 'initialize-release'
method: FSFilesystem
initialize
	workingDirectory := FSPath root
%
run
FSFilesystem setStamp: 'cwp 7/18/2009 00:54' forMethod: #'initialize'.
true
%

category: 'public'
method: FSFilesystem
isDirectory: anObject 
	| path |
	path := self resolve: anObject.
	path isRoot ifTrue: [ ^ true ].
	self 
		nodeAt: path
		ifPresent: [ :entry | ^ self basicIsDirectory: entry ]
		ifAbsent: [ ^ false ]
%
run
FSFilesystem setStamp: 'cwp 11/15/2009 21:31' forMethod: #'isDirectory:'.
true
%

category: 'public'
method: FSFilesystem
isFile: anObject 
	| path |
	path := self resolve: anObject.
	self 
		nodeAt: path
		ifPresent: [ :entry | ^ self basicIsFile: entry ]
		ifAbsent: [ ^ false ]
%
run
FSFilesystem setStamp: 'cwp 11/15/2009 21:31' forMethod: #'isFile:'.
true
%

category: 'private'
method: FSFilesystem
nodeAt: aPath ifPresent: presentBlock ifAbsent: absentBlock 
	self subclassResponsibility
%
run
FSFilesystem setStamp: 'cwp 11/15/2009 21:31' forMethod: #'nodeAt:ifPresent:ifAbsent:'.
true
%

category: 'error handling'
method: FSFilesystem
nodeExists: aPath
	(self isFile: aPath) 
		ifTrue: [self fileExists: aPath]
		ifFalse: [self directoryExists: aPath]
%
run
FSFilesystem setStamp: 'cwp 11/17/2009 19:46' forMethod: #'nodeExists:'.
true
%

category: 'public'
method: FSFilesystem
open
	"Some kinds of filesystems need to open connections to external resources"
%
run
FSFilesystem setStamp: 'cwp 9/21/2009 15:17' forMethod: #'open'.
true
%

category: 'public'
method: FSFilesystem
open: aPath mode: modeString

	^self open: aPath writable: (modeString beginsWith: 'w') 
%

category: 'public'
method: FSFilesystem
open: aPath writable: aBoolean 
	self subclassResponsibility
%
run
FSFilesystem setStamp: 'cwp 7/22/2009 08:21' forMethod: #'open:writable:'.
true
%

category: 'converting'
method: FSFilesystem
pathFromObject: anObject 
	^ anObject asPathWith: self
%
run
FSFilesystem setStamp: 'cwp 11/21/2009 11:30' forMethod: #'pathFromObject:'.
true
%

category: 'converting'
method: FSFilesystem
pathFromString: aString 
	^ FSPath 
		readFrom: aString readStream
		delimiter: self delimiter
%
run
FSFilesystem setStamp: 'cwp 11/21/2009 11:30' forMethod: #'pathFromString:'.
true
%

category: 'printing'
method: FSFilesystem
printPath: aPath on: aStream
	aPath printOn: aStream delimiter: self delimiter
%
run
FSFilesystem setStamp: 'cwp 7/17/2009 19:21' forMethod: #'printPath:on:'.
true
%

category: 'public'
method: FSFilesystem
readOnlyStreamOn: anObject
	^ (self open: anObject mode: 'r') readStream.
%

category: 'public'
method: FSFilesystem
readStreamOn: anObject
	^ (self open: anObject writable: false) readStream.
%
run
FSFilesystem setStamp: 'cwp 7/31/2009 00:26' forMethod: #'readStreamOn:'.
true
%

category: 'converting'
method: FSFilesystem
referenceFromString: aString 
	^ FSReference 
		filesystem: self
		path: (self pathFromString: aString)
%
run
FSFilesystem setStamp: 'cwp 11/21/2009 11:30' forMethod: #'referenceFromString:'.
true
%

category: 'public'
method: FSFilesystem
referenceTo: anObject 
	^ FSReference 
		filesystem: self
		path: (self pathFromObject: anObject)
%
run
FSFilesystem setStamp: 'cwp 11/21/2009 11:30' forMethod: #'referenceTo:'.
true
%

category: 'public'
method: FSFilesystem
resolve: anObject
	^ anObject asResolvedBy: self
%
run
FSFilesystem setStamp: 'cwp 10/10/2009 17:28' forMethod: #'resolve:'.
true
%

category: 'navigating'
method: FSFilesystem
resolvePath: aPath
	^ workingDirectory resolve: aPath
%
run
FSFilesystem setStamp: 'cwp 10/10/2009 17:29' forMethod: #'resolvePath:'.
true
%

category: 'navigating'
method: FSFilesystem
resolveReference: aReference
	^ aReference filesystem = self ifTrue:
		[workingDirectory resolvePath: aReference path]
%
run
FSFilesystem setStamp: 'cwp 10/10/2009 17:32' forMethod: #'resolveReference:'.
true
%

category: 'navigating'
method: FSFilesystem
resolveString: aString 
	^ workingDirectory resolvePath: (self pathFromString: aString)
%
run
FSFilesystem setStamp: 'cwp 11/21/2009 11:30' forMethod: #'resolveString:'.
true
%

category: 'accessing'
method: FSFilesystem
root
	^ self referenceTo: FSPath root
%
run
FSFilesystem setStamp: 'cwp 9/20/2009 22:27' forMethod: #'root'.
true
%

category: 'converting'
method: FSFilesystem
stringFromPath: aPath 
	^ aPath printWithDelimiter: self delimiter
%
run
FSFilesystem setStamp: 'cwp 11/21/2009 11:31' forMethod: #'stringFromPath:'.
true
%

category: 'accessing'
method: FSFilesystem
working
	^ self referenceTo: self workingDirectory
%
run
FSFilesystem setStamp: 'lr 2/14/2010 09:48' forMethod: #'working'.
true
%

category: 'accessing'
method: FSFilesystem
workingDirectory
	^ workingDirectory
%
run
FSFilesystem setStamp: 'cwp 7/18/2009 00:53' forMethod: #'workingDirectory'.
true
%

category: 'accessing'
method: FSFilesystem
workingDirectory: aPath
	aPath isAbsolute ifFalse: [self error: 'Cannot set the working directory to a relative path'].
	workingDirectory := aPath
%
run
FSFilesystem setStamp: 'cwp 7/18/2009 00:59' forMethod: #'workingDirectory:'.
true
%

category: 'public'
method: FSFilesystem
writeStreamOn: anObject
	^ (self open: anObject writable: true) writeStream.
%
run
FSFilesystem setStamp: 'cwp 7/28/2009 22:59' forMethod: #'writeStreamOn:'.
true
%

category: 'private'
method: FSMemoryFilesystem
basicCopy: source ifAbsent: aBlock to: destination ifPresent: pBlock 
	self 
		nodeAt: source
		ifPresent: 
			[ :bytes | 
			(self basicIsFile: bytes) ifFalse: [ aBlock value ].
			self 
				nodeAt: destination parent
				ifPresent: 
					[ :dict | 
					(self basicIsDirectory: dict) ifFalse: [ self directoryDoesNotExist: destination parent ].
					(dict includesKey: destination basename) ifTrue: [ pBlock value ].
					dict 
						at: destination basename
						put: bytes copy ]
				ifAbsent: [ self directoryDoesNotExist: destination parent ] ]
		ifAbsent: aBlock
%
run
FSMemoryFilesystem setStamp: 'lr 7/13/2010 15:36' forMethod: #'basicCopy:ifAbsent:to:ifPresent:'.
true
%

category: 'private'
method: FSMemoryFilesystem
basicIsDirectory: entry 
	^ entry isDictionary
%
run
FSMemoryFilesystem setStamp: 'cwp 7/18/2009 01:31' forMethod: #'basicIsDirectory:'.
true
%

category: 'private'
method: FSMemoryFilesystem
basicIsFile: entry 
	^ entry isDictionary not
%
run
FSMemoryFilesystem setStamp: 'cwp 7/18/2009 01:31' forMethod: #'basicIsFile:'.
true
%

category: 'private'
method: FSMemoryFilesystem
basicOpen: anObject writable: aBoolean 
	| path |
	path := self resolve: anObject.
	^ self 
		nodeAt: path
		ifPresent: [ :bytes | bytes ]
		ifAbsent: 
			[ aBoolean 
				ifFalse: [ self fileDoesNotExist: path ]
				ifTrue: [ self createFile: path ] ]
%
run
FSMemoryFilesystem setStamp: 'cwp 11/15/2009 21:31' forMethod: #'basicOpen:writable:'.
true
%

category: 'public'
method: FSMemoryFilesystem
childrenAt: anObject 
	| path ref |
	path := self resolve: anObject.
	^ Array streamContents: 
		[ :out | 
		self 
			directoryAt: path
			ifAbsent: [ self directoryDoesNotExist: path ]
			nodesDo: 
				[ :association | 
				ref := self referenceTo: path / association key.
				out nextPut: ref ] ]
%
run
FSMemoryFilesystem setStamp: 'cwp 11/17/2009 19:46' forMethod: #'childrenAt:'.
true
%

category: 'public'
method: FSMemoryFilesystem
createDirectory: anObject 
	| parent path |
	path := self resolve: anObject.
	parent := path parent.
	self 
		nodeAt: parent 
		ifPresent: 
			[:dict | 
			dict at: path basename ifPresent: 
				[:node | 
				(node isDictionary ifTrue: [FSDirectoryExists] ifFalse: [FSFileExists]) 
					signalWith: path].
			dict at: path basename put: Dictionary new]
		ifAbsent: [self directoryDoesNotExist: parent]
%
run
FSMemoryFilesystem setStamp: 'lr 7/13/2010 13:55' forMethod: #'createDirectory:'.
true
%

category: 'private'
method: FSMemoryFilesystem
createFile: path 
	^ self 
		nodeAt: path parent
		ifPresent: 
			[ :dict | 
			(self basicIsDirectory: dict) ifTrue: 
				[ dict 
					at: path basename
					put: ByteArray new ] ]
		ifAbsent: [ self directoryDoesNotExist: path parent ]
%
run
FSMemoryFilesystem setStamp: 'cwp 11/17/2009 19:46' forMethod: #'createFile:'.
true
%

category: 'public'
method: FSMemoryFilesystem
delete: anObject 
	| path |
	path := self resolve: anObject.
	self 
		nodeAt: path parent
		ifPresent: [ :dict | dict removeKey: path basename ]
		ifAbsent: [  ]
%
run
FSMemoryFilesystem setStamp: 'cwp 11/15/2009 21:31' forMethod: #'delete:'.
true
%

category: 'public'
method: FSMemoryFilesystem
delimiter
	^ $/
%
run
FSMemoryFilesystem setStamp: 'cwp 7/17/2009 19:29' forMethod: #'delimiter'.
true
%

category: 'private'
method: FSMemoryFilesystem
directoryAt: aPath ifAbsent: absentBlock nodesDo: aBlock 
	self 
		nodeAt: aPath
		ifPresent: [ :directory | 
			directory isDictionary
				ifFalse: [ ^ absentBlock value ].
			(directory associations asArray sortBy: [:a :b | a <= b ])
				do: aBlock ]
		ifAbsent: absentBlock
%
run
FSMemoryFilesystem setStamp: 'DaleHenrichs 10/15/2010 13:32' forMethod: #'directoryAt:ifAbsent:nodesDo:'.
true
%

category: 'public'
method: FSMemoryFilesystem
entriesAt: anObject 
	| path entry |
	path := self resolve: anObject.
	^ Array streamContents: 
		[ :out | 
		self 
			directoryAt: path
			ifAbsent: [ self directoryDoesNotExist: path ]
			nodesDo: 
				[ :association | 
				entry := self 
					entryFromNode: association value
					atPath: path / association key.
				out nextPut: entry ] ]
%
run
FSMemoryFilesystem setStamp: 'cwp 11/17/2009 19:46' forMethod: #'entriesAt:'.
true
%

category: 'private'
method: FSMemoryFilesystem
entryFromNode: node atPath: aPath

	^ FSDirectoryEntry
		filesystem: self
		path: aPath
		creation: 0
		modification: 0
		isDir: node isDictionary
		size: (node isDictionary ifTrue: [0] ifFalse: [node size])
%
run
FSMemoryFilesystem setStamp: 'cwp 11/15/2009 22:59' forMethod: #'entryFromNode:atPath:'.
true
%

category: 'printing'
method: FSMemoryFilesystem
forReferencePrintOn: aStream 
	aStream nextPutAll: 'memory:'
%
run
FSMemoryFilesystem setStamp: 'cwp 10/11/2009 22:37' forMethod: #'forReferencePrintOn:'.
true
%

category: 'private'
method: FSMemoryFilesystem
growFile: anObject to: anInteger 
	^ self replaceFile: anObject in:
		[:bytes |
		(bytes class new: anInteger)
			replaceFrom: 1 to: bytes size with: bytes startingAt: 1;
			yourself]
%
run
FSMemoryFilesystem setStamp: 'cwp 7/19/2009 22:12' forMethod: #'growFile:to:'.
true
%

category: 'initialize-release'
method: FSMemoryFilesystem
initialize
	super initialize.
	root := Dictionary new
%
run
FSMemoryFilesystem setStamp: 'lr 7/13/2010 13:54' forMethod: #'initialize'.
true
%

category: 'private'
method: FSMemoryFilesystem
nodeAt: aPath ifPresent: presentBlock ifAbsent: absentBlock 
	| current |
	current := root.
	aPath do: 
		[ :segment | 
		current isDictionary 
			ifTrue: 
				[ current := current 
					at: segment
					ifAbsent: [ ^ absentBlock value ] ]
			ifFalse: [ ^ absentBlock value ] ].
	^ presentBlock value: current
%
run
FSMemoryFilesystem setStamp: 'cwp 11/15/2009 21:31' forMethod: #'nodeAt:ifPresent:ifAbsent:'.
true
%

category: 'public'
method: FSMemoryFilesystem
open: anObject writable: aBoolean 
	| path |
	path := self resolve: anObject.
	^ FSMemoryHandle 
		open: (self referenceTo: path) 
		writable: aBoolean
		
%
run
FSMemoryFilesystem setStamp: 'cwp 8/29/2009 10:15' forMethod: #'open:writable:'.
true
%

category: 'public'
method: FSMemoryFilesystem
openFileStream: aPath mode: mode
	"modes:
		'r'
		'w'
		'r+'
		'w+'
	"
	^self openFileStream: aPath writable: (mode beginsWith: 'w')
%

category: 'public'
method: FSMemoryFilesystem
openFileStream: aPath writable: aBoolean 
	| path bytes |
	path := self resolve: aPath.
	bytes := self 
		nodeAt: path
		ifPresent: [ :array | array ]
		ifAbsent: [ self createFile: path ].
	^ FSMemoryFileStream 
		on: bytes
		filesystem: self
		path: path
%
run
FSMemoryFilesystem setStamp: 'cwp 11/15/2009 21:31' forMethod: #'openFileStream:writable:'.
true
%

category: 'private'
method: FSMemoryFilesystem
replaceFile: anObject in: aBlock 
	| path |
	path := self resolve: anObject.
	^ self 
		nodeAt: path parent
		ifPresent: 
			[ :dict | 
			| old new |
			(self basicIsDirectory: dict) ifFalse: [ self fileDoesNotExist: path ].
			old := dict 
				at: path basename
				ifAbsent: [ self fileDoesNotExist: path ].
			new := aBlock value: old.
			dict 
				at: path basename
				put: new ]
		ifAbsent: [ self fileDoesNotExist: path ]
%
run
FSMemoryFilesystem setStamp: 'cwp 11/15/2009 21:31' forMethod: #'replaceFile:in:'.
true
%

category: 'private'
method: FSMemoryFilesystem
truncateFile: anObject to: anInteger 
	^ self 
		replaceFile: anObject
		in: [ :bytes | bytes copyFrom: 1 to: anInteger ]
%
run
FSMemoryFilesystem setStamp: 'DaleHenrichs 10/18/2010 15:56' forMethod: #'truncateFile:to:'.
true
%

category: 'private'
method: FSMemoryFilesystem
truncateFile: anObject to: anInteger using: aByteArray
	^ self 
		replaceFile: anObject
		in: [ :bytes | aByteArray copyFrom: 1 to: anInteger ]
%
run
FSMemoryFilesystem setStamp: 'DaleHenrichs 10/19/2010 15:48' forMethod: #'truncateFile:to:using:'.
true
%

category: 'instance creation'
classmethod: FSZipFilesystem
atReference: aReference
	^ self basicNew initializeWithReference: aReference
%
run
FSZipFilesystem class setStamp: 'cwp 11/17/2009 16:42' forMethod: #'atReference:'.
true
%

category: 'public'
method: FSZipFilesystem
close
	| archive stream |
	archive := ZipArchive new.
	self root allChildren do: [ :each |
		each isFile ifTrue: [
			each readStreamDo: [ :output |
				archive 
					addString: output contents 
					as: each path printString ] ] ].
	archive writeTo: (stream := WriteStream on: ByteArray new); close.
	reference writeStreamDo: [ :output | output nextPutAll: stream contents ]
%
run
FSZipFilesystem setStamp: 'lr 2/20/2010 23:49' forMethod: #'close'.
true
%

category: 'initialize-release'
method: FSZipFilesystem
initializeWithReference: aReference
	self initialize.
	reference := aReference
%
run
FSZipFilesystem setStamp: 'lr 2/20/2010 22:55' forMethod: #'initializeWithReference:'.
true
%

category: '*filesystemgemstone-public'
method: FSZipFilesystem
open
	| archive |
	reference exists
		ifFalse: [ ^ self ].
	archive := ZipArchive new.
	reference readStreamDo: [ :input |
		archive readFrom: (AnsiReadStream on:  input contents).
		archive members do: [ :member |
			| ref |
			ref := self referenceTo: (self pathFromMember: member).
			member isDirectory
				ifTrue: [ ref ensureDirectory ]
				ifFalse: [
					ref parent ensureDirectory.
					ref writeStreamDo: [ :stream | member rewindData; copyRawDataTo: stream ] ] ] ]
%
run
FSZipFilesystem setStamp: 'DaleHenrichs 10/18/2010 19:09' forMethod: #'open'.
true
%

category: 'private'
method: FSZipFilesystem
pathFromMember: anArchiveMember
	| path |
	path := FSPath root resolve: anArchiveMember fileName.
	^ path basename isEmpty
		ifTrue: [path parent]
		ifFalse: [path]
%
run
FSZipFilesystem setStamp: 'cwp 9/22/2009 23:29' forMethod: #'pathFromMember:'.
true
%

category: 'accessing'
method: FSZipFilesystem
reference
	^ reference
%
run
FSZipFilesystem setStamp: 'cwp 9/21/2009 17:48' forMethod: #'reference'.
true
%

category: 'showing'
method: FSBreadthFirstGuide
show: aReference 
	| entry |
	work add: aReference entry.
	self whileNotDoneDo: 
		[entry := work removeFirst.
		entry isFile 
			ifTrue: [ visitor visitFile: entry]
			ifFalse: 
				[visitor visitDirectory: entry.
				work addAll: entry reference entries]]
%
run
FSBreadthFirstGuide setStamp: 'cwp 11/16/2009 10:42' forMethod: #'show:'.
true
%

category: 'instance creation'
classmethod: FSGuide
for: aVisitor
	^ self basicNew initializeWithVisitor: aVisitor
%
run
FSGuide class setStamp: 'cwp 10/29/2009 19:27' forMethod: #'for:'.
true
%

category: '*filesystemgemstone-instance creation'
classmethod: FSGuide
new

	^self basicNew initialize
%
run
FSGuide class setStamp: 'DaleHenrichs 10/18/2010 18:17' forMethod: #'new'.
true
%

category: 'instance creation'
classmethod: FSGuide
show: aReference to: aVisitor
	^ (self for: aVisitor) show: aReference
%
run
FSGuide class setStamp: 'cwp 11/17/2009 11:58' forMethod: #'show:to:'.
true
%

category: 'initialize-release'
method: FSGuide
initialize
	work := OrderedCollection new
%
run
FSGuide setStamp: 'cwp 10/29/2009 23:51' forMethod: #'initialize'.
true
%

category: 'initialize-release'
method: FSGuide
initializeWithVisitor: aVisitor
	self initialize.
	visitor := aVisitor.
	
%
run
FSGuide setStamp: 'cwp 10/29/2009 23:48' forMethod: #'initializeWithVisitor:'.
true
%

category: 'showing'
method: FSGuide
show: aReference
	self subclassResponsibility
%
run
FSGuide setStamp: 'cwp 10/29/2009 23:21' forMethod: #'show:'.
true
%

category: 'showing'
method: FSGuide
whileNotDoneDo: aBlock
	[ work isEmpty ] whileFalse: [ aBlock value ]
%
run
FSGuide setStamp: 'lr 7/13/2010 15:36' forMethod: #'whileNotDoneDo:'.
true
%

category: 'showing'
method: FSPostorderGuide
pop
	^ work removeLast
%
run
FSPostorderGuide setStamp: 'cwp 10/29/2009 23:51' forMethod: #'pop'.
true
%

category: 'showing'
method: FSPostorderGuide
pushTraverse: aReference 
	work add: (MessageSend
				receiver: self
				selector: #traverse:
				argument: aReference)
%
run
FSPostorderGuide setStamp: 'DaleHenrichs 10/15/2010 09:53' forMethod: #'pushTraverse:'.
true
%

category: 'showing'
method: FSPostorderGuide
pushVisit: aReference 
	work add: (MessageSend
				receiver: self 
				selector: #visit:
				argument: aReference)
%
run
FSPostorderGuide setStamp: 'DaleHenrichs 10/15/2010 09:53' forMethod: #'pushVisit:'.
true
%

category: 'showing'
method: FSPostorderGuide
show: aReference 
	self pushTraverse: aReference entry.
	self whileNotDoneDo: [self pop value ]
%
run
FSPostorderGuide setStamp: 'DaleHenrichs 10/15/2010 09:53' forMethod: #'show:'.
true
%

category: 'showing'
method: FSPostorderGuide
traverse: anEntry 
	self pushVisit: anEntry.
	anEntry isDirectory ifTrue: 
		[anEntry reference entries reverseDo: 
			[:ea | self pushTraverse: ea]]
%
run
FSPostorderGuide setStamp: 'cwp 11/16/2009 21:57' forMethod: #'traverse:'.
true
%

category: 'showing'
method: FSPostorderGuide
visit: anEntry
	anEntry isDirectory
		ifTrue: [visitor visitDirectory: anEntry]
		ifFalse: [visitor visitFile: anEntry]
	
%
run
FSPostorderGuide setStamp: 'cwp 11/16/2009 10:50' forMethod: #'visit:'.
true
%

category: 'showing'
method: FSPreorderGuide
pop
	^ work removeLast
%
run
FSPreorderGuide setStamp: 'cwp 10/29/2009 23:51' forMethod: #'pop'.
true
%

category: 'showing'
method: FSPreorderGuide
push: anObject
	work add: anObject
%
run
FSPreorderGuide setStamp: 'cwp 11/15/2009 22:24' forMethod: #'push:'.
true
%

category: 'showing'
method: FSPreorderGuide
pushAll: aCollection 
	aCollection reverseDo: [ :ea | work add: ea ]
%
run
FSPreorderGuide setStamp: 'cwp 10/29/2009 23:51' forMethod: #'pushAll:'.
true
%

category: 'showing'
method: FSPreorderGuide
show: aReference 
	self push: aReference entry.
	self whileNotDoneDo: 
		[| entry |
		entry := self pop.
		entry isFile 
			ifTrue: [visitor visitFile: entry]
			ifFalse: 
				[visitor visitDirectory: entry.
				self pushAll: entry reference entries]]
%
run
FSPreorderGuide setStamp: 'cwp 11/16/2009 10:47' forMethod: #'show:'.
true
%

category: 'instance creation'
classmethod: FSFileHandle
open: aReference mode: modeString
	^ (self on: aReference mode: modeString) open
%
category: 'instance creation'
classmethod: FSFileHandle
on: aReference mode: modeString
	^ self new setReference: aReference mode: modeString
%
category: 'class initialization'
classmethod: FSFileHandle
initialize
	self useFilePlugin.

%
run
FSFileHandle class setStamp: 'cwp 11/20/2009 16:16' forMethod: #'initialize'.
true
%

category: 'class initialization'
classmethod: FSFileHandle
useFilePlugin
	Primitives := FSFilePluginPrims new
%
run
FSFileHandle class setStamp: 'cwp 7/22/2009 07:11' forMethod: #'useFilePlugin'.
true
%

category: 'public'
method: FSFileHandle
at: index read: buffer startingAt: start count: count
	^ Primitives 
		setPosition: id to: index - 1;
		read: id into: buffer startingAt: start count: count

%
run
FSFileHandle setStamp: 'cwp 7/31/2009 00:05' forMethod: #'at:read:startingAt:count:'.
true
%

category: 'public'
method: FSFileHandle
at: index write: buffer startingAt: start count: count
	Primitives 
		setPosition: id to: index - 1;
		write: id from: buffer startingAt: start count: count

%
run
FSFileHandle setStamp: 'cwp 7/26/2009 14:15' forMethod: #'at:write:startingAt:count:'.
true
%

category: 'private'
method: FSFileHandle
basicOpen
	id := reference filesystem 
		basicOpen: reference path
		mode: mode
%
run
FSFileHandle setStamp: 'cwp 11/20/2009 14:38' forMethod: #'basicOpen'.
true
%

category: 'public'
method: FSFileHandle
close
	Primitives close: id.
	id := nil
%
run
FSFileHandle setStamp: 'cwp 11/20/2009 14:59' forMethod: #'close'.
true
%

category: 'public'
method: FSFileHandle
flush
	Primitives flush: id
%
run
FSFileHandle setStamp: 'cwp 7/22/2009 07:49' forMethod: #'flush'.
true
%

category: 'testing'
method: FSFileHandle
isOpen
	^ (Primitives sizeOrNil: id) notNil
%
run
FSFileHandle setStamp: 'cwp 7/22/2009 07:10' forMethod: #'isOpen'.
true
%

category: 'public'
method: FSFileHandle
open
	self basicOpen.
	id ifNil: 
		[(writable or: [reference exists]) 
			ifTrue: [self error: 'Unable to open file ' , reference printString]
			ifFalse: [FSFileDoesNotExist signalWith: reference]]
%
run
FSFileHandle setStamp: 'cwp 11/20/2009 14:38' forMethod: #'open'.
true
%

category: 'public'
method: FSFileHandle
size
	^ Primitives size: id
%
run
FSFileHandle setStamp: 'cwp 7/22/2009 07:44' forMethod: #'size'.
true
%

category: 'private'
method: FSFileHandle
startUp
	"This functionality is disabled for now, to avoid doing lots of processing
	on start up."
	
	"We're starting up in a new OS process, so the file id will be invalid.
	Try to reopen the file, but fail silently: just leave the id as nil. #isOpen will
	answer false, and we'll raise an error if anyone tries to do IO."
	
	self basicOpen
%
run
FSFileHandle setStamp: 'cwp 11/20/2009 16:48' forMethod: #'startUp'.
true
%

category: 'public'
method: FSFileHandle
truncateTo: anInteger
	Primitives truncate: id to: anInteger.
	self reopen
%
run
FSFileHandle setStamp: 'cwp 7/22/2009 08:17' forMethod: #'truncateTo:'.
true
%

category: 'instance creation'
classmethod: FSHandle
on: aReference writable: aBoolean
	^ self new setReference: aReference writable: aBoolean
%
run
FSHandle class setStamp: 'cwp 7/26/2009 12:52' forMethod: #'on:writable:'.
true
%

category: 'instance creation'
classmethod: FSHandle
open: aReference writable: aBoolean
	^ (self on: aReference writable: aBoolean) open
%
run
FSHandle class setStamp: 'cwp 7/26/2009 12:52' forMethod: #'open:writable:'.
true
%

category: 'public'
method: FSHandle
at: index
	| buffer |
	buffer := ByteArray new: 1.
	self at: index read: buffer startingAt: 1 count: 1.
	^ buffer at: 1
%
run
FSHandle setStamp: 'cwp 7/29/2009 22:19' forMethod: #'at:'.
true
%

category: 'public'
method: FSHandle
at: index put: anObject
	| buffer |
	buffer := ByteArray with: (anObject isCharacter
		ifTrue: [ anObject codePoint ]
		ifFalse: [ anObject ]).
	self at: index write: buffer startingAt: 1 count: 1.
	
%
run
FSHandle setStamp: 'lr 4/13/2010 16:10' forMethod: #'at:put:'.
true
%

category: 'public'
method: FSHandle
at: offset read: buffer startingAt: start count: count
	self subclassResponsibility
%
run
FSHandle setStamp: 'cwp 7/26/2009 12:50' forMethod: #'at:read:startingAt:count:'.
true
%

category: 'public'
method: FSHandle
at: offset write: buffer startingAt: start count: count
	self subclassResponsibility
%
run
FSHandle setStamp: 'cwp 7/26/2009 12:50' forMethod: #'at:write:startingAt:count:'.
true
%

category: 'public'
method: FSHandle
close
	self subclassResponsibility
%
run
FSHandle setStamp: 'cwp 7/26/2009 12:50' forMethod: #'close'.
true
%

category: 'public'
method: FSHandle
flush
	self subclassResponsibility
%
run
FSHandle setStamp: 'cwp 7/26/2009 12:50' forMethod: #'flush'.
true
%

category: 'testing'
method: FSHandle
isOpen
	self subclassResponsibility
%
run
FSHandle setStamp: 'cwp 7/26/2009 12:50' forMethod: #'isOpen'.
true
%

category: 'public'
method: FSHandle
open
	self subclassResponsibility
%
run
FSHandle setStamp: 'cwp 7/26/2009 12:50' forMethod: #'open'.
true
%

category: 'public'
method: FSHandle
readStream
	^ self isOpen ifTrue: [FSReadStream onHandle: self]
%
run
FSHandle setStamp: 'cwp 7/31/2009 00:32' forMethod: #'readStream'.
true
%

category: 'accessing'
method: FSHandle
reference
	^ reference
%
run
FSHandle setStamp: 'cwp 7/26/2009 12:51' forMethod: #'reference'.
true
%

category: 'public'
method: FSHandle
reopen
	self close.
	self open
%
run
FSHandle setStamp: 'cwp 7/26/2009 12:51' forMethod: #'reopen'.
true
%

category: 'initialize-release'
method: FSHandle
setReference: aReference writable: aBoolean
	reference := aReference resolve.
	writable := aBoolean
%
run
FSHandle setStamp: 'cwp 11/20/2009 14:56' forMethod: #'setReference:writable:'.
true
%

category: 'public'
method: FSHandle
truncateTo: anInteger
	self subclassResponsibility
%
run
FSHandle setStamp: 'cwp 7/26/2009 12:50' forMethod: #'truncateTo:'.
true
%

category: 'public'
method: FSHandle
writeStream
	^ FSWriteStream onHandle: self
%
run
FSHandle setStamp: 'cwp 7/28/2009 23:06' forMethod: #'writeStream'.
true
%

category: 'public'
method: FSMemoryHandle
at: index
	^ bytes at: index
%
run
FSMemoryHandle setStamp: 'cwp 7/29/2009 22:07' forMethod: #'at:'.
true
%

category: 'public'
method: FSMemoryHandle
at: index put: anObject
	index > bytes size ifTrue: [self grow].
	bytes at: index put: (anObject isCharacter
		ifTrue: [ anObject codePoint ]
		ifFalse: [ anObject ]).
	size := size max: index
%
run
FSMemoryHandle setStamp: 'lr 4/13/2010 16:12' forMethod: #'at:put:'.
true
%

category: 'public'
method: FSMemoryHandle
at: index read: aCollection startingAt: start count: count 
	| max stop |
	max := size - index + 1 min: count.
	stop := start + max - 1.
	aCollection 
		replaceFrom: start
		to: stop
		with: bytes
		startingAt: index.
	^ stop - start + 1
%
run
FSMemoryHandle setStamp: 'lr 2/15/2010 20:54' forMethod: #'at:read:startingAt:count:'.
true
%

category: 'public'
method: FSMemoryHandle
at: first write: aCollection startingAt: start count: count 
	| last |
	writable ifFalse: [ self primitiveFailed ].
	last := first + count - 1.
	last > bytes size ifTrue: [self growTo: last].
	bytes 
		replaceFrom: first
		to: last
		with: aCollection asByteArray
		startingAt: start.
	size := last
%
run
FSMemoryHandle setStamp: 'DaleHenrichs 10/18/2010 17:08' forMethod: #'at:write:startingAt:count:'.
true
%

category: 'public'
method: FSMemoryHandle
close
	self truncateTo: size.
	bytes := nil
%
run
FSMemoryHandle setStamp: 'cwp 7/28/2009 23:10' forMethod: #'close'.
true
%

category: 'public'
method: FSMemoryHandle
flush
	self truncateTo: size
%
run
FSMemoryHandle setStamp: 'cwp 7/29/2009 22:23' forMethod: #'flush'.
true
%

category: 'private'
method: FSMemoryHandle
grow
	^ self growTo: bytes size + 1
%
run
FSMemoryHandle setStamp: 'cwp 1/31/2010 22:45' forMethod: #'grow'.
true
%

category: 'private'
method: FSMemoryHandle
growTo: anInteger
	bytes := reference filesystem 
		growFile: reference path
		to: (anInteger + self sizeIncrement)
%
run
FSMemoryHandle setStamp: 'cwp 1/31/2010 22:43' forMethod: #'growTo:'.
true
%

category: 'testing'
method: FSMemoryHandle
isOpen
	^ bytes notNil
%
run
FSMemoryHandle setStamp: 'cwp 7/26/2009 14:08' forMethod: #'isOpen'.
true
%

category: 'public'
method: FSMemoryHandle
open

	bytes := reference filesystem basicOpen: reference path writable: writable.
	size := bytes size.
%
run
FSMemoryHandle setStamp: 'cwp 7/26/2009 14:26' forMethod: #'open'.
true
%

category: 'public'
method: FSMemoryHandle
size
	^ size
%
run
FSMemoryHandle setStamp: 'cwp 7/26/2009 14:27' forMethod: #'size'.
true
%

category: 'private'
method: FSMemoryHandle
sizeIncrement
	^ (bytes size min: 20) max: 1024
%
run
FSMemoryHandle setStamp: 'cwp 1/31/2010 22:40' forMethod: #'sizeIncrement'.
true
%

category: 'public'
method: FSMemoryHandle
truncateTo: anInteger
	bytes := reference filesystem truncateFile: reference path to: anInteger.
	size := anInteger
%
run
FSMemoryHandle setStamp: 'cwp 7/26/2009 14:29' forMethod: #'truncateTo:'.
true
%

category: '*filesystemgemstone-instance creation'
classmethod: FSGciLocator
createNew

	^self basicNew
%
run
FSGciLocator class setStamp: 'DaleHenrichs 10/14/2010 10:25' forMethod: #'createNew'.
true
%

category: '*filesystemgemstone-accessing'
classmethod: FSGciLocator
defaultClass

	^self
%
run
FSGciLocator class setStamp: 'DaleHenrichs 10/18/2010 11:36' forMethod: #'defaultClass'.
true
%

category: '*filesystemgemstone-accessing'
classmethod: FSGciLocator
fsPathClass

	^FSGciPath
%
run
FSGciLocator class setStamp: 'DaleHenrichs 10/13/2010 17:13' forMethod: #'fsPathClass'.
true
%

category: '*filesystemgemstone-accessing'
classmethod: FSGciLocator
platformOsName

	^System clientVersionAt: 'osName'
%
run
FSGciLocator class setStamp: 'DaleHenrichs 10/13/2010 17:06' forMethod: #'platformOsName'.
true
%

category: 'class initialization'
classmethod: FSLocator
addResolver: aResolver
	self resolver addResolver: aResolver
%
run
FSLocator class setStamp: 'DaleHenrichs 10/14/2010 10:31' forMethod: #'addResolver:'.
true
%

category: '*filesystemgemstone-instance creation'
classmethod: FSLocator
createNew
	
	^self defaultClass basicNew
%
run
FSLocator class setStamp: 'DaleHenrichs 10/18/2010 11:42' forMethod: #'createNew'.
true
%

category: '*filesystemgemstone-accessing'
classmethod: FSLocator
defaultClass

	^self
%
run
FSLocator class setStamp: 'DaleHenrichs 10/18/2010 11:41' forMethod: #'defaultClass'.
true
%

category: 'origins'
classmethod: FSLocator
desktop
	^ self origin: #desktop
%
run
FSLocator class setStamp: 'cwp 10/27/2009 10:24' forMethod: #'desktop'.
true
%

category: 'class initialization'
classmethod: FSLocator
flushCaches
	self resolver flushCaches
%
run
FSLocator class setStamp: 'DaleHenrichs 10/14/2010 10:31' forMethod: #'flushCaches'.
true
%

category: '*filesystemgemstone-accessing'
classmethod: FSLocator
fsPathClass

	^FSPath
%
run
FSLocator class setStamp: 'DaleHenrichs 10/18/2010 11:32' forMethod: #'fsPathClass'.
true
%

category: '*filesystemgemstone-accessing'
classmethod: FSLocator
gci

	^FSGciLocator
%
run
FSLocator class setStamp: 'DaleHenrichs 10/13/2010 16:57' forMethod: #'gci'.
true
%

category: '*filesystemgemstone-accessing'
classmethod: FSLocator
gem

	^self
%
run
FSLocator class setStamp: 'DaleHenrichs 10/14/2010 10:29' forMethod: #'gem'.
true
%

category: 'origins'
classmethod: FSLocator
home
	^ self origin: #home
%
run
FSLocator class setStamp: 'cwp 10/27/2009 09:34' forMethod: #'home'.
true
%

category: '*filesystemgemstone-instance creation'
classmethod: FSLocator
origin: aSymbol 
	^ self defaultClass origin: aSymbol path: self fsPathClass empty

%
run
FSLocator class setStamp: 'DaleHenrichs 10/18/2010 11:39' forMethod: #'origin:'.
true
%

category: '*filesystemgemstone-instance creation'
classmethod: FSLocator
origin: aSymbol path: aPath
	(aPath isKindOf: self fsPathClass) ifFalse: [ self error: 'path should be FSGemPath or FSGciPath' ].
	^ self defaultClass new initializeWithOrigin: aSymbol path: aPath
%
run
FSLocator class setStamp: 'DaleHenrichs 10/18/2010 11:42' forMethod: #'origin:path:'.
true
%

category: '*filesystemgemstone-accessing'
classmethod: FSLocator
platformOsName

	^System gemVersionAt: 'osName'
%
run
FSLocator class setStamp: 'DaleHenrichs 10/18/2010 11:40' forMethod: #'platformOsName'.
true
%

category: '*filesystemgemstone-accessing'
classmethod: FSLocator
platformResolverInstance

	| osName |
	^(((osName := self platformOsName) beginsWith: 'Windows')
		ifTrue: [ FSWindowsResolver ]
		ifFalse: [
			(osName beginsWith: 'OSX')
				ifTrue: [ FSMacOSResolver]
				ifFalse: [ FSUnixResolver ]]) new
		
%
run
FSLocator class setStamp: 'DaleHenrichs 10/13/2010 17:05' forMethod: #'platformResolverInstance'.
true
%

category: 'accessing'
classmethod: FSLocator
resolver

	| res |
	res := SessionTemps current at: #RESOLVER_FOR_FSLocator otherwise: nil.
	res == nil 
		ifTrue: [
			res := FSInteractiveResolver new.
			res addResolver: FSTestResolver new.
			res addResolver: self platformResolverInstance.
			SessionTemps current at: #RESOLVER_FOR_FSLocator put: res].
	^res
%
run
FSLocator class setStamp: 'DaleHenrichs 10/14/2010 10:31' forMethod: #'resolver'.
true
%

category: 'accessing'
classmethod: FSLocator
supportedOrigins
	| origins current |
	origins := IdentitySet new.
	current := self resolver.
	[current notNil] whileTrue:
		[origins addAll: current supportedOrigins.
		current := current next].
	^ origins
%
run
FSLocator class setStamp: 'DaleHenrichs 10/14/2010 10:32' forMethod: #'supportedOrigins'.
true
%

category: 'origins'
classmethod: FSLocator
testDirectory
	^ self origin: #testDirectory
%
run
FSLocator class setStamp: 'DaleHenrichs 10/18/2010 11:06' forMethod: #'testDirectory'.
true
%

category: 'origins'
classmethod: FSLocator
testFile
	^ self origin: #testFile
%
run
FSLocator class setStamp: 'DaleHenrichs 10/18/2010 11:06' forMethod: #'testFile'.
true
%

category: 'navigating'
method: FSLocator
, extension
	^ self withPath: path, extension
%
run
FSLocator setStamp: 'cwp 10/25/2009 11:12' forMethod: #','.
true
%

category: 'navigating'
method: FSLocator
/ aString
	^ self withPath: (path / aString)
%
run
FSLocator setStamp: 'cwp 10/25/2009 11:03' forMethod: #'/'.
true
%

category: 'comparing'
method: FSLocator
= other
	^ self species = other species
		and: [origin = other origin
			and: [path = other path]]
%
run
FSLocator setStamp: 'cwp 10/26/2009 10:28' forMethod: #'='.
true
%

category: 'delegated'
method: FSLocator
allChildren
	^ self resolve allChildren
%
run
FSLocator setStamp: 'cwp 11/15/2009 21:23' forMethod: #'allChildren'.
true
%

category: 'delegated'
method: FSLocator
allEntries
	^ self resolve allEntries
%
run
FSLocator setStamp: 'cwp 11/16/2009 21:19' forMethod: #'allEntries'.
true
%

category: 'converting'
method: FSLocator
asAbsolute
	^ self
%
run
FSLocator setStamp: 'cwp 10/25/2009 10:30' forMethod: #'asAbsolute'.
true
%

category: 'delegated'
method: FSLocator
asPathWith: anObject
	^ self resolve asPathWith: anObject
%
run
FSLocator setStamp: 'cwp 10/26/2009 02:09' forMethod: #'asPathWith:'.
true
%

category: '*filesystemgemstone-printing'
method: FSLocator
asString

	^self printString
%
run
FSLocator setStamp: 'DaleHenrichs 10/18/2010 14:14' forMethod: #'asString'.
true
%

category: 'delegated'
method: FSLocator
basename
	^ self resolve basename
%
run
FSLocator setStamp: 'cwp 10/25/2009 11:09' forMethod: #'basename'.
true
%

category: 'delegated'
method: FSLocator
children
	^ self resolve children
%
run
FSLocator setStamp: 'cwp 11/15/2009 21:24' forMethod: #'children'.
true
%

category: 'comparing'
method: FSLocator
contains: anObject
	^ self resolve contains: anObject
%
run
FSLocator setStamp: 'cwp 10/25/2009 22:26' forMethod: #'contains:'.
true
%

category: 'delegated'
method: FSLocator
copyAllTo: aReference
	^ self resolve copyAllTo: aReference
%
run
FSLocator setStamp: 'cwp 11/15/2009 08:10' forMethod: #'copyAllTo:'.
true
%

category: 'delegated'
method: FSLocator
copyTo: aReference
	^ self resolve copyTo: aReference resolve
%
run
FSLocator setStamp: 'cwp 10/26/2009 02:02' forMethod: #'copyTo:'.
true
%

category: 'delegated'
method: FSLocator
delete
	^ self resolve delete
%
run
FSLocator setStamp: 'cwp 10/26/2009 02:03' forMethod: #'delete'.
true
%

category: 'delegated'
method: FSLocator
deleteAll
	^ self resolve deleteAll
%
run
FSLocator setStamp: 'cwp 11/15/2009 08:11' forMethod: #'deleteAll'.
true
%

category: 'delegated'
method: FSLocator
ensureDirectory
	^ self resolve ensureDirectory
%
run
FSLocator setStamp: 'cwp 10/26/2009 02:03' forMethod: #'ensureDirectory'.
true
%

category: 'delegated'
method: FSLocator
exists
	^ self resolve exists
%
run
FSLocator setStamp: 'cwp 10/26/2009 02:03' forMethod: #'exists'.
true
%

category: 'delegated'
method: FSLocator
fileStreamDo: aBlock
	^ self resolve fileStreamDo: aBlock
%
run
FSLocator setStamp: 'cwp 10/26/2009 02:04' forMethod: #'fileStreamDo:'.
true
%

category: 'delegated'
method: FSLocator
filesystem
	^ self resolve filesystem
%
run
FSLocator setStamp: 'cwp 10/25/2009 22:12' forMethod: #'filesystem'.
true
%

category: 'comparing'
method: FSLocator
hash
	^ origin hash bitXor: path hash
%
run
FSLocator setStamp: 'cwp 10/25/2009 11:05' forMethod: #'hash'.
true
%

category: '*filesystemgemstone-initialization'
method: FSLocator
initialize
%
run
FSLocator setStamp: 'DaleHenrichs 10/18/2010 15:52' forMethod: #'initialize'.
true
%

category: 'initialize-release'
method: FSLocator
initializeWithOrigin: aSymbol path: aPath
	self initialize.
	origin := aSymbol.
	path := aPath.
%
run
FSLocator setStamp: 'cwp 10/25/2009 09:56' forMethod: #'initializeWithOrigin:path:'.
true
%

category: 'testing'
method: FSLocator
isAbsolute
	^ true
%
run
FSLocator setStamp: 'cwp 10/25/2009 10:30' forMethod: #'isAbsolute'.
true
%

category: 'comparing'
method: FSLocator
isChildOf: anObject
	^ self resolve isChildOf: anObject
%
run
FSLocator setStamp: 'cwp 11/16/2009 09:07' forMethod: #'isChildOf:'.
true
%

category: 'delegated'
method: FSLocator
isContainedBy: anObject
	^ self resolve isContainedBy: anObject
%
run
FSLocator setStamp: 'cwp 10/25/2009 23:05' forMethod: #'isContainedBy:'.
true
%

category: 'delegated'
method: FSLocator
isDirectory
	^ self resolve isDirectory
%
run
FSLocator setStamp: 'cwp 10/26/2009 02:04' forMethod: #'isDirectory'.
true
%

category: 'delegated'
method: FSLocator
isFile
	^ self resolve isFile
%
run
FSLocator setStamp: 'cwp 10/26/2009 02:04' forMethod: #'isFile'.
true
%

category: 'testing'
method: FSLocator
isRelative
	^ false
%
run
FSLocator setStamp: 'cwp 10/25/2009 11:15' forMethod: #'isRelative'.
true
%

category: 'delegated'
method: FSLocator
isRoot
	^ self resolve isRoot
%
run
FSLocator setStamp: 'cwp 10/25/2009 11:22' forMethod: #'isRoot'.
true
%

category: 'accessing'
method: FSLocator
origin
	^ origin
%
run
FSLocator setStamp: 'cwp 10/25/2009 21:31' forMethod: #'origin'.
true
%

category: 'navigating'
method: FSLocator
parent
	^ self withPath: path parent
%
run
FSLocator setStamp: 'cwp 10/25/2009 11:27' forMethod: #'parent'.
true
%

category: 'accessing'
method: FSLocator
path
	^ path
%
run
FSLocator setStamp: 'cwp 10/25/2009 21:31' forMethod: #'path'.
true
%

category: 'delegated'
method: FSLocator
pathString
	^ self resolve pathString
%
run
FSLocator setStamp: 'cwp 10/26/2009 02:05' forMethod: #'pathString'.
true
%

category: 'printing'
method: FSLocator
printOn: aStream
	| fs |
	aStream
		nextPut: ${;
		nextPutAll: origin;
		nextPut: $}.
	path isWorkingDirectory
		ifTrue: [ ^ self ].
	fs := self filesystem.
	aStream nextPut: fs delimiter.
	fs printPath: path on: aStream
%
run
FSLocator setStamp: 'lr 7/13/2010 15:19' forMethod: #'printOn:'.
true
%

category: 'delegated'
method: FSLocator
readStream
	^ self resolve readStream
%
run
FSLocator setStamp: 'cwp 10/26/2009 02:05' forMethod: #'readStream'.
true
%

category: 'delegated'
method: FSLocator
readStreamDo: aBlock
	^ self resolve readStreamDo: aBlock
%
run
FSLocator setStamp: 'cwp 10/26/2009 02:05' forMethod: #'readStreamDo:'.
true
%

category: 'delegated'
method: FSLocator
readStreamDo: doBlock ifAbsent: aBlock
	^ self resolve readStreamDo: doBlock ifAbsent: aBlock
%
run
FSLocator setStamp: 'cwp 10/29/2009 11:23' forMethod: #'readStreamDo:ifAbsent:'.
true
%

category: 'delegated'
method: FSLocator
readStreamIfAbsent: aBlock
	^ self resolve readStream readStreamIfAbsent: aBlock
%
run
FSLocator setStamp: 'cwp 10/29/2009 11:24' forMethod: #'readStreamIfAbsent:'.
true
%

category: 'navigating'
method: FSLocator
resolve
	^ (self class resolver resolve: origin) resolve: path
%
run
FSLocator setStamp: 'DaleHenrichs 10/14/2010 14:54' forMethod: #'resolve'.
true
%

category: 'navigating'
method: FSLocator
resolve: anObject
	^ anObject asResolvedBy: self
%
run
FSLocator setStamp: 'cwp 10/26/2009 01:03' forMethod: #'resolve:'.
true
%

category: 'navigating'
method: FSLocator
resolvePath: aPath
	^ self withPath: (path resolvePath: aPath)
%
run
FSLocator setStamp: 'cwp 10/25/2009 21:36' forMethod: #'resolvePath:'.
true
%

category: 'navigating'
method: FSLocator
resolveReference: aReference
	^ aReference isAbsolute
		ifTrue: [aReference]
		ifFalse: [self withPath: aReference path]
%
run
FSLocator setStamp: 'cwp 10/25/2009 21:53' forMethod: #'resolveReference:'.
true
%

category: 'navigating'
method: FSLocator
resolveString: aString 
	| filesystem thePath |
	filesystem := (self class resolver resolve: origin) filesystem.
	thePath := filesystem pathFromString: aString.
	^ self withPath: (path resolvePath: thePath)
%
run
FSLocator setStamp: 'DaleHenrichs 10/14/2010 10:33' forMethod: #'resolveString:'.
true
%

category: 'navigating'
method: FSLocator
withExtension: aString
	^ self withPath: (path withExtension: aString)
%
run
FSLocator setStamp: 'cwp 11/18/2009 00:01' forMethod: #'withExtension:'.
true
%

category: 'navigating'
method: FSLocator
withPath: newPath
	^ path == newPath
		ifTrue: [self]
		ifFalse: [self class origin: origin path: newPath]
%
run
FSLocator setStamp: 'cwp 10/25/2009 11:03' forMethod: #'withPath:'.
true
%

category: 'delegated'
method: FSLocator
writeStream
	^ self resolve writeStream
%
run
FSLocator setStamp: 'cwp 10/26/2009 02:05' forMethod: #'writeStream'.
true
%

category: 'delegated'
method: FSLocator
writeStreamDo: aBlock
	^ self resolve writeStreamDo: aBlock
%
run
FSLocator setStamp: 'cwp 10/26/2009 02:06' forMethod: #'writeStreamDo:'.
true
%

category: 'delegated'
method: FSLocator
writeStreamDo: doBlock ifPresent: pBlock
	^ self resolve writeStreamDo: doBlock ifPresent: pBlock
%
run
FSLocator setStamp: 'cwp 10/29/2009 11:24' forMethod: #'writeStreamDo:ifPresent:'.
true
%

category: 'delegated'
method: FSLocator
writeStreamIfPresent: aBlock
	^ self resolve writeStreamIfPresent: aBlock
%
run
FSLocator setStamp: 'cwp 10/29/2009 11:23' forMethod: #'writeStreamIfPresent:'.
true
%

category: 'accessing'
classmethod: FSGciPath
onClient

	^true
%
run
FSGciPath class setStamp: 'DaleHenrichs 10/13/2010 16:38' forMethod: #'onClient'.
true
%

category: 'instance creation'
classmethod: FSPath
* aString
	^ self with: aString
%
run
FSPath class setStamp: 'cwp 10/28/2009 03:38' forMethod: #'*'.
true
%

category: 'instance creation'
classmethod: FSPath
/ aString
	^ self root / aString
%
run
FSPath class setStamp: 'cwp 12/23/2008 14:15' forMethod: #'/'.
true
%

category: 'private'
classmethod: FSPath
addElement: element to: result
	element = '..' ifTrue: [^ self addParentElementTo: result].
	element = '' ifTrue: [^ self addEmptyElementTo: result].
	element = '.' ifFalse: [result add: element]
%
run
FSPath class setStamp: 'cwp 10/26/2009 13:42' forMethod: #'addElement:to:'.
true
%

category: 'private'
classmethod: FSPath
addEmptyElementTo: result
	result isEmpty ifTrue: [result add: '']
		
%
run
FSPath class setStamp: 'cwp 10/26/2009 13:41' forMethod: #'addEmptyElementTo:'.
true
%

category: 'private'
classmethod: FSPath
addParentElementTo: result
	result isEmpty
		ifTrue: [result add: '..']
		ifFalse: [result removeLast]
		
%
run
FSPath class setStamp: 'cwp 10/26/2009 13:39' forMethod: #'addParentElementTo:'.
true
%

category: 'private'
classmethod: FSPath
canonicalizeElements: aCollection
	| result |
	result := OrderedCollection new.
	aCollection do: [:element | self addElement: element to: result].
	^ result
%
run
FSPath class setStamp: 'cwp 10/26/2009 13:30' forMethod: #'canonicalizeElements:'.
true
%

category: 'instance creation'
classmethod: FSPath
empty
	^ self new
%
run
FSPath class setStamp: 'cwp 10/11/2009 13:09' forMethod: #'empty'.
true
%

category: 'accessing'
classmethod: FSPath
extensionDelimiter
	^ $.
%
run
FSPath class setStamp: 'cwp 12/23/2008 11:23' forMethod: #'extensionDelimiter'.
true
%

category: '*filesystemgemstone-accessing'
classmethod: FSPath
onClient

	^false
%
run
FSPath class setStamp: 'DaleHenrichs 10/15/2010 16:18' forMethod: #'onClient'.
true
%

category: 'instance creation'
classmethod: FSPath
parent
	^ self with: '..'
%
run
FSPath class setStamp: 'cwp 10/10/2009 17:51' forMethod: #'parent'.
true
%

category: 'instance creation'
classmethod: FSPath
parents: anInteger
	| path |
	path := self new: anInteger.
	1 to: anInteger do: [:i | path at: i put: '..'].
	^ path
%
run
FSPath class setStamp: 'cwp 11/15/2009 00:11' forMethod: #'parents:'.
true
%

category: 'instance creation'
classmethod: FSPath
readFrom: aStream delimiter: aCharacter 
	| elements out ch |
	elements := OrderedCollection new.
	out := (String new: 10) writeStream.
	[ aStream atEnd ] whileFalse: 
		[ ch := aStream next.
		ch = aCharacter 
			ifFalse: [ out nextPut: ch ]
			ifTrue: 
				[ elements add: out contents.
				out := (String new: 10) writeStream ] ].
	elements add: out contents.
	^ self withAll: (self canonicalizeElements: elements)
%
run
FSPath class setStamp: 'DaleHenrichs 10/15/2010 13:43' forMethod: #'readFrom:delimiter:'.
true
%

category: 'instance creation'
classmethod: FSPath
root
	^ self with: ''
%
run
FSPath class setStamp: 'cwp 10/11/2009 13:04' forMethod: #'root'.
true
%

category: 'instance creation'
classmethod: FSPath
with: aString
	| inst |
	inst := self new: 1.
	inst at: 1 put: aString.
	^ inst
%
run
FSPath class setStamp: 'cwp 10/10/2009 17:43' forMethod: #'with:'.
true
%

category: 'instance creation'
classmethod: FSPath
withAll: aCollection
	| inst |
	inst := self new: aCollection size.
	1 to: aCollection size do: [:i | inst at: i put: (aCollection at: i)].
	^ inst
%
run
FSPath class setStamp: 'DaleHenrichs 10/18/2010 15:33' forMethod: #'withAll:'.
true
%

category: 'navigating'
method: FSPath
, extension 
	^ self withName: self basename extension: extension
%
run
FSPath setStamp: 'cwp 11/17/2009 23:52' forMethod: #','.
true
%

category: 'navigating'
method: FSPath
/ aString
	| path |
	path := self class new: self size + 1.
	path copyFrom: self.
	path at: path size put: aString.
	^ path
%
run
FSPath setStamp: 'cwp 12/13/2008 21:11' forMethod: #'/'.
true
%

category: 'comparing'
method: FSPath
= other
	^ self species = other species
		and: [self size = other size
			and: [(1 to: self size) allSatisfy: [:i | (self at: i) = (other at: i)]]]
%
run
FSPath setStamp: 'cwp 12/14/2008 17:36' forMethod: #'='.
true
%

category: 'converting'
method: FSPath
asPathWith: anObject
	^ self
%
run
FSPath setStamp: 'cwp 10/10/2009 18:04' forMethod: #'asPathWith:'.
true
%

category: 'converting'
method: FSPath
asReference
	^ FSDiskFilesystem current referenceTo: self
%
run
FSPath setStamp: 'cwp 9/21/2009 22:58' forMethod: #'asReference'.
true
%

category: 'navigating'
method: FSPath
asResolvedBy: anObject
	^ anObject resolvePath: self
%
run
FSPath setStamp: 'cwp 9/22/2009 09:08' forMethod: #'asResolvedBy:'.
true
%

category: '*filesystemgemstone-printing'
method: FSPath
asString

	^self printString
%
run
FSPath setStamp: 'DaleHenrichs 10/18/2010 14:14' forMethod: #'asString'.
true
%

category: 'accessing'
method: FSPath
basename
	^ self at: self size
%
run
FSPath setStamp: 'cwp 12/15/2008 14:02' forMethod: #'basename'.
true
%

category: 'comparing'
method: FSPath
contains: anObject
	^ anObject isContainedBy: self
%
run
FSPath setStamp: 'cwp 10/26/2009 01:03' forMethod: #'contains:'.
true
%

category: 'comparing'
method: FSPath
containsPath: aPath
	self size < aPath size ifFalse: [^ false].
	1	to: self size 
		do: [:i | (self at: i) = (aPath at: i) ifFalse: [^ false]].
	^ true
%
run
FSPath setStamp: 'cwp 10/25/2009 22:59' forMethod: #'containsPath:'.
true
%

category: 'comparing'
method: FSPath
containsReference: aReference
	^ false
%
run
FSPath setStamp: 'cwp 10/25/2009 23:05' forMethod: #'containsReference:'.
true
%

category: 'private'
method: FSPath
copyFrom: aPath
	| size |
	size := aPath size min: self size.
	1 to: size do: [:i | self at: i put: (aPath at: i)].
	
%
run
FSPath setStamp: 'cwp 12/13/2008 21:08' forMethod: #'copyFrom:'.
true
%

category: 'accessing'
method: FSPath
delimiter
	^ $/
%
run
FSPath setStamp: 'cwp 10/11/2009 11:05' forMethod: #'delimiter'.
true
%

category: 'accessing'
method: FSPath
do: aBlock 
	1 
		to: self size
		do: 
			[ :index || segment |
			segment := self at: index.
			segment isEmpty ifFalse: [ aBlock value: segment ] ]
%
run
FSPath setStamp: 'cwp 7/18/2009 01:13' forMethod: #'do:'.
true
%

category: 'accessing'
method: FSPath
extensionDelimiter
	^ self class extensionDelimiter
%
run
FSPath setStamp: 'cwp 12/23/2008 11:25' forMethod: #'extensionDelimiter'.
true
%

category: 'comparing'
method: FSPath
hash
	| hash |
	hash := self class identityHash.
	1 to: self size do:
		[:i | hash := String stringHash: (self at: i) initialHash: hash].
	^ hash
%
run
FSPath setStamp: 'cwp 12/14/2008 17:06' forMethod: #'hash'.
true
%

category: 'testing'
method: FSPath
isAbsolute
	^ self size > 0 and: [(self at: 1) = '']
%
run
FSPath setStamp: 'cwp 7/18/2009 01:03' forMethod: #'isAbsolute'.
true
%

category: 'private'
method: FSPath
isAllParents
	1 to: self size do: [:i | (self at: i) = '..' ifFalse: [^ false]].
	^ true
%
run
FSPath setStamp: 'cwp 10/25/2009 19:53' forMethod: #'isAllParents'.
true
%

category: 'comparing'
method: FSPath
isChildOf: anObject
	^ self parent = anObject
%
run
FSPath setStamp: 'cwp 11/16/2009 09:06' forMethod: #'isChildOf:'.
true
%

category: 'comparing'
method: FSPath
isContainedBy: anObject
	^ anObject containsPath: self
%
run
FSPath setStamp: 'cwp 10/25/2009 23:01' forMethod: #'isContainedBy:'.
true
%

category: 'testing'
method: FSPath
isRelative
	^ self isAbsolute not
%
run
FSPath setStamp: 'cwp 12/13/2008 21:00' forMethod: #'isRelative'.
true
%

category: 'testing'
method: FSPath
isRoot
	^ self size = 1 and: [self isAbsolute]
%
run
FSPath setStamp: 'cwp 7/18/2009 00:41' forMethod: #'isRoot'.
true
%

category: 'testing'
method: FSPath
isWorkingDirectory
	^ self size = 0
%
run
FSPath setStamp: 'cwp 7/18/2009 00:42' forMethod: #'isWorkingDirectory'.
true
%

category: 'private'
method: FSPath
lengthOfStemWith: aPath
	| limit index |
	limit := self size min: aPath size.
	index := 1.
	[index <= limit and: [(self at: index) = (aPath at: index)]] whileTrue: [index := index + 1].
	^ index - 1
%
run
FSPath setStamp: 'cwp 11/15/2009 00:19' forMethod: #'lengthOfStemWith:'.
true
%

category: 'navigating'
method: FSPath
makeRelative: anObject
	^ anObject relativeToPath: self
%
run
FSPath setStamp: 'cwp 11/15/2009 00:00' forMethod: #'makeRelative:'.
true
%

category: '*filesystemgemstone-accessing'
method: FSPath
onClient

	^self class onClient
%
run
FSPath setStamp: 'DaleHenrichs 10/14/2010 15:20' forMethod: #'onClient'.
true
%

category: 'navigating'
method: FSPath
parent
	| size parent |
	self isRoot ifTrue: [^ self].
	self isAllParents ifTrue: [^ self / '..'].
	
	size := self size - 1.
	parent := self class new: size.
	1 to: size do: [:i | parent at: i put: (self at: i)].
	^ parent
%
run
FSPath setStamp: 'cwp 10/25/2009 19:53' forMethod: #'parent'.
true
%

category: 'printing'
method: FSPath
printOn: aStream 
	self printOn: aStream delimiter: self delimiter.

%
run
FSPath setStamp: 'cwp 11/17/2009 10:22' forMethod: #'printOn:'.
true
%

category: 'printing'
method: FSPath
printOn: aStream delimiter: aCharacter
	| beforeFirst | 
	self isRoot ifTrue: [aStream nextPut: aCharacter. ^ self].
	self isWorkingDirectory ifTrue: [aStream nextPut: $.. ^ self].
	
	beforeFirst :=true.
	(1 to: self size) do: [:index |
		beforeFirst
			ifTrue: [beforeFirst := false]
			ifFalse: [ aStream nextPut: aCharacter ].
		aStream nextPutAll: (self at: index) ].

%
run
FSPath setStamp: 'DaleHenrichs 10/18/2010 15:38' forMethod: #'printOn:delimiter:'.
true
%

category: 'printing'
method: FSPath
printWithDelimiter: aCharacter
	^ String streamContents: [:out | self printOn: out delimiter: aCharacter]
%
run
FSPath setStamp: 'cwp 1/13/2009 21:27' forMethod: #'printWithDelimiter:'.
true
%

category: 'navigating'
method: FSPath
relativeTo: anObject
	^ anObject makeRelative: self
%
run
FSPath setStamp: 'cwp 11/15/2009 00:00' forMethod: #'relativeTo:'.
true
%

category: 'navigating'
method: FSPath
relativeToPath: aPath
	| prefix relative |
	aPath isRelative ifTrue: [^ aPath].
	prefix := self lengthOfStemWith: aPath.
	relative := FSPath parents: (aPath size - prefix).
	prefix + 1 to: self size do: [:i | relative := relative / (self at: i)].
	^ relative
%
run
FSPath setStamp: 'cwp 11/15/2009 00:12' forMethod: #'relativeToPath:'.
true
%

category: 'navigating'
method: FSPath
resolve
	^ self
%
run
FSPath setStamp: 'cwp 11/16/2009 10:19' forMethod: #'resolve'.
true
%

category: 'navigating'
method: FSPath
resolve: anObject
	^ anObject asResolvedBy: self
%
run
FSPath setStamp: 'cwp 10/26/2009 01:03' forMethod: #'resolve:'.
true
%

category: 'navigating'
method: FSPath
resolvePath: aPath
	| elements |
	aPath isAbsolute ifTrue: [^ aPath].
	elements := Array new: self size + aPath size.
	1 to: self size do: [:i | elements at: i put: (self at: i)].
	1 to: aPath size do: [:i | elements at: self size + i put: (aPath at: i)].
	^ self class withAll: (self class canonicalizeElements: elements)
%
run
FSPath setStamp: 'cwp 9/22/2009 09:04' forMethod: #'resolvePath:'.
true
%

category: 'navigating'
method: FSPath
resolveReference: aReference
	^ aReference
%
run
FSPath setStamp: 'cwp 9/22/2009 09:06' forMethod: #'resolveReference:'.
true
%

category: 'navigating'
method: FSPath
resolveString: aString
	^ self / aString
%
run
FSPath setStamp: 'cwp 10/25/2009 21:42' forMethod: #'resolveString:'.
true
%

category: 'navigating'
method: FSPath
withExtension: extension 
	| basename name |
	basename := self basename.
	^ (basename endsWith: extension) 
		ifTrue: [ self ]
		ifFalse: 
			[name := basename copyUpToLast: self extensionDelimiter.
			self withName: name extension: extension]
%
run
FSPath setStamp: 'cwp 11/17/2009 23:51' forMethod: #'withExtension:'.
true
%

category: 'private'
method: FSPath
withName: name extension: extension
	| basename |
	basename :=String streamContents:
		[:out |
		out nextPutAll: name.
		out nextPut: self extensionDelimiter.
		out nextPutAll: extension].
	^ self copy 
		at: self size put: basename;
		yourself
%
run
FSPath setStamp: 'cwp 11/17/2009 23:58' forMethod: #'withName:extension:'.
true
%

category: 'cross platform'
classmethod: FSReference
/ aString
	^ FSDiskFilesystem current root / aString
%
run
FSReference class setStamp: 'cwp 11/20/2009 23:00' forMethod: #'/'.
true
%

category: 'windows'
classmethod: FSReference
A
	^ self
		filesystem: (FSWindowsFilesystem disk: 'A')
		path: FSPath root

%
run
FSReference class setStamp: 'cwp 11/20/2009 21:09' forMethod: #'A'.
true
%

category: 'windows'
classmethod: FSReference
B
	^ self
		filesystem: (FSWindowsFilesystem disk: 'B')
		path: FSPath root

%
run
FSReference class setStamp: 'cwp 11/20/2009 21:09' forMethod: #'B'.
true
%

category: 'windows'
classmethod: FSReference
C
	^ self
		filesystem: (FSWindowsFilesystem disk: 'C')
		path: FSPath root

%
run
FSReference class setStamp: 'cwp 11/20/2009 21:09' forMethod: #'C'.
true
%

category: 'windows'
classmethod: FSReference
D
	^ self
		filesystem: (FSWindowsFilesystem disk: 'D')
		path: FSPath root

%
run
FSReference class setStamp: 'cwp 11/20/2009 21:09' forMethod: #'D'.
true
%

category: 'windows'
classmethod: FSReference
E
	^ self
		filesystem: (FSWindowsFilesystem disk: 'E')
		path: FSPath root

%
run
FSReference class setStamp: 'cwp 11/20/2009 21:09' forMethod: #'E'.
true
%

category: 'windows'
classmethod: FSReference
F
	^ self
		filesystem: (FSWindowsFilesystem disk: 'F')
		path: FSPath root

%
run
FSReference class setStamp: 'cwp 11/20/2009 21:09' forMethod: #'F'.
true
%

category: 'instance creation'
classmethod: FSReference
filesystem: aFilesystem path: aPath
	^ self new setFilesystem: aFilesystem path: aPath
%
run
FSReference class setStamp: 'cwp 1/13/2009 21:11' forMethod: #'filesystem:path:'.
true
%

category: 'windows'
classmethod: FSReference
G
	^ self
		filesystem: (FSWindowsFilesystem disk: 'G')
		path: FSPath root

%
run
FSReference class setStamp: 'cwp 11/20/2009 21:09' forMethod: #'G'.
true
%

category: 'windows'
classmethod: FSReference
H
	^ self
		filesystem: (FSWindowsFilesystem disk: 'H')
		path: FSPath root

%
run
FSReference class setStamp: 'cwp 11/20/2009 21:09' forMethod: #'H'.
true
%

category: 'windows'
classmethod: FSReference
I
	^ self
		filesystem: (FSWindowsFilesystem disk: 'I')
		path: FSPath root

%
run
FSReference class setStamp: 'cwp 11/20/2009 21:09' forMethod: #'I'.
true
%

category: 'windows'
classmethod: FSReference
J
	^ self
		filesystem: (FSWindowsFilesystem disk: 'J')
		path: FSPath root

%
run
FSReference class setStamp: 'cwp 11/20/2009 21:09' forMethod: #'J'.
true
%

category: 'windows'
classmethod: FSReference
K
	^ self
		filesystem: (FSWindowsFilesystem disk: 'K')
		path: FSPath root

%
run
FSReference class setStamp: 'cwp 11/20/2009 21:09' forMethod: #'K'.
true
%

category: 'windows'
classmethod: FSReference
L
	^ self
		filesystem: (FSWindowsFilesystem disk: 'L')
		path: FSPath root

%
run
FSReference class setStamp: 'cwp 11/20/2009 21:09' forMethod: #'L'.
true
%

category: 'windows'
classmethod: FSReference
M
	^ self
		filesystem: (FSWindowsFilesystem disk: 'M')
		path: FSPath root

%
run
FSReference class setStamp: 'cwp 11/20/2009 21:09' forMethod: #'M'.
true
%

category: 'windows'
classmethod: FSReference
N
	^ self
		filesystem: (FSWindowsFilesystem disk: 'N')
		path: FSPath root

%
run
FSReference class setStamp: 'cwp 11/20/2009 21:09' forMethod: #'N'.
true
%

category: 'windows'
classmethod: FSReference
O
	^ self
		filesystem: (FSWindowsFilesystem disk: 'O')
		path: FSPath root

%
run
FSReference class setStamp: 'cwp 11/20/2009 21:09' forMethod: #'O'.
true
%

category: 'windows'
classmethod: FSReference
P
	^ self
		filesystem: (FSWindowsFilesystem disk: 'P')
		path: FSPath root

%
run
FSReference class setStamp: 'cwp 11/20/2009 21:09' forMethod: #'P'.
true
%

category: 'windows'
classmethod: FSReference
Q
	^ self
		filesystem: (FSWindowsFilesystem disk: 'Q')
		path: FSPath root

%
run
FSReference class setStamp: 'cwp 11/20/2009 21:09' forMethod: #'Q'.
true
%

category: 'windows'
classmethod: FSReference
R
	^ self
		filesystem: (FSWindowsFilesystem disk: 'R')
		path: FSPath root

%
run
FSReference class setStamp: 'cwp 11/20/2009 21:09' forMethod: #'R'.
true
%

category: 'cross platform'
classmethod: FSReference
roots
	^ Array streamContents:
		[:out | FSFilesystem putAllRootsOn: out]
%
run
FSReference class setStamp: 'cwp 11/21/2009 12:19' forMethod: #'roots'.
true
%

category: 'windows'
classmethod: FSReference
S
	^ self
		filesystem: (FSWindowsFilesystem disk: 'S')
		path: FSPath root

%
run
FSReference class setStamp: 'cwp 11/20/2009 21:09' forMethod: #'S'.
true
%

category: 'windows'
classmethod: FSReference
T
	^ self
		filesystem: (FSWindowsFilesystem disk: 'T')
		path: FSPath root

%
run
FSReference class setStamp: 'cwp 11/20/2009 21:09' forMethod: #'T'.
true
%

category: 'windows'
classmethod: FSReference
U
	^ self
		filesystem: (FSWindowsFilesystem disk: 'U')
		path: FSPath root

%
run
FSReference class setStamp: 'cwp 11/20/2009 21:09' forMethod: #'U'.
true
%

category: 'windows'
classmethod: FSReference
V
	^ self
		filesystem: (FSWindowsFilesystem disk: 'V')
		path: FSPath root

%
run
FSReference class setStamp: 'cwp 11/20/2009 21:09' forMethod: #'V'.
true
%

category: 'windows'
classmethod: FSReference
W
	^ self
		filesystem: (FSWindowsFilesystem disk: 'W')
		path: FSPath root

%
run
FSReference class setStamp: 'cwp 11/20/2009 21:09' forMethod: #'W'.
true
%

category: 'windows'
classmethod: FSReference
X
	^ self
		filesystem: (FSWindowsFilesystem disk: 'X')
		path: FSPath root

%
run
FSReference class setStamp: 'cwp 11/20/2009 21:09' forMethod: #'X'.
true
%

category: 'windows'
classmethod: FSReference
Y
	^ self
		filesystem: (FSWindowsFilesystem disk: 'Y')
		path: FSPath root

%
run
FSReference class setStamp: 'cwp 11/20/2009 21:09' forMethod: #'Y'.
true
%

category: 'windows'
classmethod: FSReference
Z
	^ self
		filesystem: (FSWindowsFilesystem disk: 'Z')
		path: FSPath root

%
run
FSReference class setStamp: 'cwp 11/20/2009 21:09' forMethod: #'Z'.
true
%

category: 'navigating'
method: FSReference
, aString
	^ self navigateWith: [path, aString]
%
run
FSReference setStamp: 'cwp 7/20/2009 09:20' forMethod: #','.
true
%

category: 'navigating'
method: FSReference
/ anObject
	^ self navigateWith: [path / anObject]
%
run
FSReference setStamp: 'cwp 7/20/2009 09:36' forMethod: #'/'.
true
%

category: 'comparing'
method: FSReference
= other
	^ self species = other species
		and: [self path = other path
			and: [self filesystem = other filesystem]]
%
run
FSReference setStamp: 'cwp 7/20/2009 09:22' forMethod: #'='.
true
%

category: 'enumerating'
method: FSReference
allChildren
	^ FSCollectVisitor breadthFirst: self collect: [:ea | ea reference]
%
run
FSReference setStamp: 'cwp 11/16/2009 10:54' forMethod: #'allChildren'.
true
%

category: 'enumerating'
method: FSReference
allEntries
	^ FSCollectVisitor breadthFirst: self
%
run
FSReference setStamp: 'cwp 11/16/2009 10:40' forMethod: #'allEntries'.
true
%

category: 'converting'
method: FSReference
asAbsolute
	^ self isAbsolute
		ifTrue: [self]
		ifFalse: [filesystem referenceTo: (filesystem resolve: path)]
%
run
FSReference setStamp: 'cwp 7/22/2009 08:33' forMethod: #'asAbsolute'.
true
%

category: 'converting'
method: FSReference
asPathWith: anObject
	^ path
%
run
FSReference setStamp: 'cwp 10/10/2009 18:04' forMethod: #'asPathWith:'.
true
%

category: 'converting'
method: FSReference
asReference
	^ self
%
run
FSReference setStamp: 'cwp 7/20/2009 09:08' forMethod: #'asReference'.
true
%

category: 'navigating'
method: FSReference
asResolvedBy: anObject
	^ anObject resolveReference: self
%
run
FSReference setStamp: 'cwp 9/22/2009 09:03' forMethod: #'asResolvedBy:'.
true
%

category: '*filesystemgemstone-printing'
method: FSReference
asString

	^self printString
%
run
FSReference setStamp: 'DaleHenrichs 10/18/2010 14:14' forMethod: #'asString'.
true
%

category: 'accessing'
method: FSReference
basename
	^ path basename
%
run
FSReference setStamp: 'cwp 7/20/2009 09:17' forMethod: #'basename'.
true
%

category: 'private'
method: FSReference
basicCopyTo: aReference
	| in out buffer |
	[in := filesystem readStreamOn: (filesystem resolve: path).
	in ifNil: [filesystem fileDoesNotExist: path].
	aReference exists ifTrue: [aReference filesystem fileExists: path].
	out := aReference writeStream.
	buffer := ByteArray new: 1024.
	[in atEnd] whileFalse:
		[buffer := in nextInto: buffer.
		out nextPutAll: buffer]]
			ensure:
				[in ifNotNil: [in close].
				out ifNotNil: [out close]]
%
run
FSReference setStamp: 'cwp 9/22/2009 09:56' forMethod: #'basicCopyTo:'.
true
%

category: 'navigating'
method: FSReference
childDirectories
	^self children select: [ :each | each isDirectory ]
%
run
FSReference setStamp: 'MaxLeske 4/26/2010 20:57' forMethod: #'childDirectories'.
true
%

category: 'navigating'
method: FSReference
childFiles
	^self children select: [ :each | each isFile ]
%
run
FSReference setStamp: 'MaxLeske 4/26/2010 20:57' forMethod: #'childFiles'.
true
%

category: 'navigating'
method: FSReference
children
	^ filesystem childrenAt: path
%
run
FSReference setStamp: 'cwp 11/15/2009 21:25' forMethod: #'children'.
true
%

category: 'comparing'
method: FSReference
contains: anObject
	^ anObject isContainedBy: self
%
run
FSReference setStamp: 'cwp 10/26/2009 01:03' forMethod: #'contains:'.
true
%

category: 'comparing'
method: FSReference
containsPath: aPath
	^ self path containsPath: aPath
%
run
FSReference setStamp: 'cwp 10/26/2009 00:54' forMethod: #'containsPath:'.
true
%

category: 'comparing'
method: FSReference
containsReference: aReference
	^  aReference filesystem = filesystem and: [path contains: aReference path]
%
run
FSReference setStamp: 'cwp 10/25/2009 23:02' forMethod: #'containsReference:'.
true
%

category: 'enumerating'
method: FSReference
copyAllTo: anObject
	FSCopyVisitor copy: self asAbsolute to: anObject resolve
%
run
FSReference setStamp: 'cwp 1/26/2010 07:11' forMethod: #'copyAllTo:'.
true
%

category: 'operations'
method: FSReference
copyTo: aReference
	self isDirectory 
		ifTrue: [aReference ensureDirectory]
		ifFalse: 
			[filesystem = aReference filesystem 
				ifTrue: [filesystem copy: path to: aReference path]
				ifFalse: [self basicCopyTo: aReference]]
%
run
FSReference setStamp: 'cwp 11/15/2009 00:59' forMethod: #'copyTo:'.
true
%

category: 'operations'
method: FSReference
createDirectory
	filesystem createDirectory: path
%
run
FSReference setStamp: 'cwp 11/17/2009 21:05' forMethod: #'createDirectory'.
true
%

category: 'operations'
method: FSReference
createFile
	self parent ensureDirectory/
	filesystem createFile: path
%
run
FSReference setStamp: 'DaleHenrichs 10/20/2010 11:16' forMethod: #'createFile'.
true
%

category: 'operations'
method: FSReference
delete
	filesystem delete: path
%
run
FSReference setStamp: 'cwp 7/22/2009 07:42' forMethod: #'delete'.
true
%

category: 'enumerating'
method: FSReference
deleteAll
	FSDeleteVisitor delete: self
%
run
FSReference setStamp: 'cwp 11/15/2009 00:51' forMethod: #'deleteAll'.
true
%

category: 'operations'
method: FSReference
ensureDirectory
	filesystem ensureDirectory: path
	
%
run
FSReference setStamp: 'cwp 1/13/2009 22:04' forMethod: #'ensureDirectory'.
true
%

category: 'navigating'
method: FSReference
entries
	^ filesystem entriesAt: path
%
run
FSReference setStamp: 'cwp 11/15/2009 22:25' forMethod: #'entries'.
true
%

category: 'accessing'
method: FSReference
entry
	^ filesystem entryAt: path
%
run
FSReference setStamp: 'cwp 11/15/2009 21:34' forMethod: #'entry'.
true
%

category: 'testing'
method: FSReference
exists
	^ filesystem exists: path
%
run
FSReference setStamp: 'cwp 1/13/2009 20:52' forMethod: #'exists'.
true
%

category: 'streams'
method: FSReference
fileStreamDo: aBlock
	| stream mode |
	mode := (filesystem exists: path) ifTrue: [ 'r+' ] ifFalse: [ 'w+' ].
	stream := filesystem openFileStream: path mode: mode.
	^ [ aBlock value: stream ] ensure: [ stream flush; close ]
	
%
run
FSReference setStamp: 'lr 7/19/2010 19:31' forMethod: #'fileStreamDo:'.
true
%

category: 'accessing'
method: FSReference
filesystem
	^ filesystem
%
run
FSReference setStamp: 'cwp 7/18/2009 22:53' forMethod: #'filesystem'.
true
%

category: 'comparing'
method: FSReference
hash
	^ path hash bitXor: filesystem hash
%
run
FSReference setStamp: 'cwp 9/16/2009 23:54' forMethod: #'hash'.
true
%

category: 'testing'
method: FSReference
ifFile: fBlock ifDirectory: dBlock ifAbsent: aBlock
	^ self isFile
		ifTrue: [ fBlock value ]
		ifFalse: [
			self isDirectory
				ifTrue: [ dBlock value ]
				ifFalse: [ aBlock value ] ]
%
run
FSReference setStamp: 'lr 7/13/2010 15:36' forMethod: #'ifFile:ifDirectory:ifAbsent:'.
true
%

category: 'testing'
method: FSReference
isAbsolute
	^ path isAbsolute
%
run
FSReference setStamp: 'cwp 7/20/2009 09:24' forMethod: #'isAbsolute'.
true
%

category: 'testing'
method: FSReference
isChildOf: anObject
	^ self parent = anObject
%
run
FSReference setStamp: 'cwp 11/16/2009 09:06' forMethod: #'isChildOf:'.
true
%

category: 'comparing'
method: FSReference
isContainedBy: anObject
	^ anObject containsReference: self
%
run
FSReference setStamp: 'cwp 10/25/2009 23:03' forMethod: #'isContainedBy:'.
true
%

category: 'testing'
method: FSReference
isDirectory
	^ filesystem isDirectory: path
%
run
FSReference setStamp: 'cwp 1/13/2009 21:39' forMethod: #'isDirectory'.
true
%

category: 'testing'
method: FSReference
isFile
	^ filesystem isFile: path
%
run
FSReference setStamp: 'cwp 1/13/2009 21:57' forMethod: #'isFile'.
true
%

category: 'testing'
method: FSReference
isRelative
	^ path isRelative
%
run
FSReference setStamp: 'cwp 7/20/2009 09:25' forMethod: #'isRelative'.
true
%

category: 'testing'
method: FSReference
isRoot
	^ path isRoot
%
run
FSReference setStamp: 'cwp 7/20/2009 09:26' forMethod: #'isRoot'.
true
%

category: 'navigating'
method: FSReference
makeRelative: anObject
	^ anObject relativeToReference: self
%
run
FSReference setStamp: 'cwp 11/15/2009 00:26' forMethod: #'makeRelative:'.
true
%

category: 'navigating'
method: FSReference
navigateWith: aBlock
	| newPath |
	newPath := aBlock value.
	^ path == newPath
		ifTrue: [self]
		ifFalse: [filesystem referenceTo: newPath]
%
run
FSReference setStamp: 'cwp 7/20/2009 09:19' forMethod: #'navigateWith:'.
true
%

category: 'private'
method: FSReference
openWritable: aBoolean 
	^ filesystem open: path writable: aBoolean
%
run
FSReference setStamp: 'cwp 7/22/2009 22:05' forMethod: #'openWritable:'.
true
%

category: 'navigating'
method: FSReference
parent
	^ self navigateWith: [path parent]
%
run
FSReference setStamp: 'cwp 7/20/2009 09:28' forMethod: #'parent'.
true
%

category: 'accessing'
method: FSReference
path
	^ path
%
run
FSReference setStamp: 'cwp 7/18/2009 22:53' forMethod: #'path'.
true
%

category: 'printing'
method: FSReference
pathString
	^ filesystem stringFromPath: (filesystem resolve: path)
%
run
FSReference setStamp: 'cwp 11/21/2009 11:31' forMethod: #'pathString'.
true
%

category: 'printing'
method: FSReference
printOn: aStream
	filesystem forReferencePrintOn: aStream.
	filesystem printPath: path on: aStream
%
run
FSReference setStamp: 'cwp 10/11/2009 22:32' forMethod: #'printOn:'.
true
%

category: 'streams'
method: FSReference
readOnlyStream
	^ filesystem readOnlyStreamOn: path
%

category: 'streams'
method: FSReference
readOnlyStreamDo: aBlock
	| stream |
	stream := self readOnlyStream.
	^ [ aBlock value: stream ] ensure: [ stream close ]
%

category: 'streams'
method: FSReference
readStream
	^ filesystem readStreamOn: path
%
run
FSReference setStamp: 'cwp 9/22/2009 09:55' forMethod: #'readStream'.
true
%

category: 'streams'
method: FSReference
readStreamDo: aBlock
	| stream |
	stream := self readStream.
	^ [ aBlock value: stream ] ensure: [ stream close ]
%
run
FSReference setStamp: 'lr 7/19/2010 19:32' forMethod: #'readStreamDo:'.
true
%

category: 'streams'
method: FSReference
readStreamDo: doBlock ifAbsent: absentBlock
	^ self isFile 
		ifTrue: [ self readStreamDo: doBlock ]
		ifFalse: [ absentBlock value ]
%
run
FSReference setStamp: 'lr 7/19/2010 19:35' forMethod: #'readStreamDo:ifAbsent:'.
true
%

category: 'streams'
method: FSReference
readStreamIfAbsent: absentBlock
	^ self isFile
		ifTrue: [ self readStream ]
		ifFalse: [ absentBlock value ]
%
run
FSReference setStamp: 'lr 7/19/2010 19:35' forMethod: #'readStreamIfAbsent:'.
true
%

category: 'navigating'
method: FSReference
relativeTo: anObject
	^ anObject makeRelative: self
%
run
FSReference setStamp: 'cwp 11/15/2009 00:26' forMethod: #'relativeTo:'.
true
%

category: 'navigating'
method: FSReference
relativeToReference: aReference
	^ path relativeTo: aReference path
%
run
FSReference setStamp: 'cwp 11/15/2009 00:27' forMethod: #'relativeToReference:'.
true
%

category: 'navigating'
method: FSReference
resolve
	^ self
%
run
FSReference setStamp: 'cwp 10/26/2009 02:02' forMethod: #'resolve'.
true
%

category: 'navigating'
method: FSReference
resolve: anObject
	^ anObject asResolvedBy: self
%
run
FSReference setStamp: 'cwp 10/26/2009 01:03' forMethod: #'resolve:'.
true
%

category: 'navigating'
method: FSReference
resolvePath: anObject
	^ self navigateWith: [path resolve: anObject]
%
run
FSReference setStamp: 'cwp 9/22/2009 09:03' forMethod: #'resolvePath:'.
true
%

category: 'navigating'
method: FSReference
resolveReference: aReference
	
	^ (filesystem = aReference filesystem or: [aReference isRelative])
		ifTrue: [filesystem referenceTo: (path resolvePath: aReference path)]
		ifFalse: [aReference]
%
run
FSReference setStamp: 'cwp 9/22/2009 09:23' forMethod: #'resolveReference:'.
true
%

category: 'navigating'
method: FSReference
resolveString: aString 
	| thePath |
	thePath := filesystem pathFromString: aString.
	^ filesystem referenceTo: (path resolve: thePath)
%
run
FSReference setStamp: 'cwp 11/21/2009 11:30' forMethod: #'resolveString:'.
true
%

category: 'initialize-release'
method: FSReference
setFilesystem: aFilesystem path: aPath
	filesystem := aFilesystem.
	path := aPath
%
run
FSReference setStamp: 'cwp 1/13/2009 21:12' forMethod: #'setFilesystem:path:'.
true
%

category: 'navigating'
method: FSReference
withExtension: aString 
	^ self navigateWith: [ path withExtension: aString ]
%
run
FSReference setStamp: 'cwp 11/17/2009 23:24' forMethod: #'withExtension:'.
true
%

category: 'streams'
method: FSReference
writeStream
	^ filesystem writeStreamOn: path
%
run
FSReference setStamp: 'cwp 7/28/2009 23:01' forMethod: #'writeStream'.
true
%

category: 'streams'
method: FSReference
writeStreamDo: aBlock
	| stream |
	stream := self writeStream.
	^ [ aBlock value: stream ]
		ensure: [ stream close ]
%
run
FSReference setStamp: 'lr 7/19/2010 19:34' forMethod: #'writeStreamDo:'.
true
%

category: 'streams'
method: FSReference
writeStreamDo: doBlock ifPresent: presentBlock
	^ self isFile
		ifTrue: [ presentBlock value ]
		ifFalse: [ self writeStreamDo: doBlock ]
%
run
FSReference setStamp: 'lr 7/19/2010 19:33' forMethod: #'writeStreamDo:ifPresent:'.
true
%

category: 'streams'
method: FSReference
writeStreamIfPresent: presentBlock
	^ self isFile 
		ifTrue: [ presentBlock value ]
		ifFalse: [ self writeStream ]
%
run
FSReference setStamp: 'lr 7/19/2010 19:35' forMethod: #'writeStreamIfPresent:'.
true
%

category: 'accessing'
classmethod: FSReleaseInfo
current
	^ Current
%
run
FSReleaseInfo class setStamp: 'cwp 11/20/2009 12:01' forMethod: #'current'.
true
%

category: 'accessing'
classmethod: FSReleaseInfo
currentVersion: anArray
	Current := self version: anArray
%
run
FSReleaseInfo class setStamp: 'cwp 11/20/2009 12:00' forMethod: #'currentVersion:'.
true
%

category: 'accessing'
classmethod: FSReleaseInfo
version: anArray
	^ self new initializeWithVersion: anArray
%
run
FSReleaseInfo class setStamp: 'cwp 11/20/2009 12:00' forMethod: #'version:'.
true
%

category: 'initialization'
method: FSReleaseInfo
initializeWithVersion: anArray
	self initialize.
	version := anArray
%
run
FSReleaseInfo setStamp: 'cwp 11/20/2009 12:00' forMethod: #'initializeWithVersion:'.
true
%

category: 'accessing'
method: FSReleaseInfo
version
	^ version
%
run
FSReleaseInfo setStamp: 'cwp 11/20/2009 12:02' forMethod: #'version'.
true
%

category: 'accessing'
method: FSInteractiveResolver
flushLocalCache
	cache := IdentityDictionary new
%
run
FSInteractiveResolver setStamp: 'cwp 10/27/2009 10:29' forMethod: #'flushLocalCache'.
true
%

category: 'initialize-release'
method: FSInteractiveResolver
initialize
	self flushLocalCache
%
run
FSInteractiveResolver setStamp: 'cwp 10/27/2009 10:29' forMethod: #'initialize'.
true
%

category: 'resolving'
method: FSInteractiveResolver
resolve: origin
	^ cache at: origin ifAbsent: [self unknownOrigin: origin]
	

%
run
FSInteractiveResolver setStamp: 'cwp 10/27/2009 10:12' forMethod: #'resolve:'.
true
%

category: 'resolving'
method: FSInteractiveResolver
unknownOrigin: origin
	| reference |
	
	^ (next ifNotNil: [next resolve: origin]) ifNil: 
			[reference := FSResolutionRequest for: origin.
			reference ifNotNil: [cache at: origin put: reference]]
%
run
FSInteractiveResolver setStamp: 'cwp 10/27/2009 11:15' forMethod: #'unknownOrigin:'.
true
%

category: 'origins'
method: FSMacOSResolver
desktop
	^ self home / 'Desktop'
%
run
FSMacOSResolver setStamp: 'cwp 10/27/2009 21:45' forMethod: #'desktop'.
true
%

category: 'origins'
method: FSMacOSResolver
documents
	^ self home / 'Documents'
%
run
FSMacOSResolver setStamp: 'cwp 10/27/2009 21:50' forMethod: #'documents'.
true
%

category: '*filesystemgemstone-instance creation'
classmethod: FSPlatformResolver
forCurrentPlatform

	| osName |
	osName := System gemVersionAt: 'osName'.
	^((osName beginsWith: 'Windows')
		ifTrue: [ FSWindowsResolver ]
		ifFalse: [ 
			(osName beginsWith: 'Linux')
				ifTrue: [ FSUnixResolver ]
				ifFalse: [ FSMacOSResolver ]]) new
%
run
FSPlatformResolver class setStamp: 'DaleHenrichs 10/18/2010 12:46' forMethod: #'forCurrentPlatform'.
true
%

category: 'origins'
method: FSPlatformResolver
desktop
	^ self subclassResponsibility
%
run
FSPlatformResolver setStamp: 'lr 7/13/2010 15:35' forMethod: #'desktop'.
true
%

category: 'origins'
method: FSPlatformResolver
documents
	^ self subclassResponsibility
%
run
FSPlatformResolver setStamp: 'lr 7/13/2010 15:35' forMethod: #'documents'.
true
%

category: '*filesystemgemstone-origins'
method: FSPlatformResolver
home
	"default is the gem"
	^ (self resolveString: (GsFile _expandEnvVariable: 'HOME' isClient: false))
%
run
FSPlatformResolver setStamp: 'DaleHenrichs 10/14/2010 17:10' forMethod: #'home'.
true
%

category: 'resolving'
method: FSPlatformResolver
supportedOrigins
	^ #(home desktop documents)
%
run
FSPlatformResolver setStamp: 'cwp 10/27/2009 21:45' forMethod: #'supportedOrigins'.
true
%

category: 'origins'
method: FSUnixResolver
desktop
	^ self home / 'Desktop'
%
run
FSUnixResolver setStamp: 'pls 12/18/2009 04:52' forMethod: #'desktop'.
true
%

category: 'origins'
method: FSUnixResolver
documents
	^ self home / 'Documents'
%
run
FSUnixResolver setStamp: 'pls 12/18/2009 04:53' forMethod: #'documents'.
true

%

category: 'origins'
method: FSWindowsResolver
desktop
	^ self home / 'Desktop'
%
run
FSWindowsResolver setStamp: 'cwp 10/27/2009 21:45' forMethod: #'desktop'.
true
%

category: 'origins'
method: FSWindowsResolver
documents
	^ self home / 'My Documents'
%
run
FSWindowsResolver setStamp: 'cwp 10/27/2009 21:50' forMethod: #'documents'.
true
%

category: '*filesystemgemstone-instance creation'
classmethod: FSResolver
new

	^self basicNew initialize
%
run
FSResolver class setStamp: 'DaleHenrichs 10/18/2010 15:17' forMethod: #'new'.
true
%

category: 'accessing'
method: FSResolver
addResolver: aResolver
	next
		ifNil: [next := aResolver]
		ifNotNil: [next addResolver: aResolver]
%
run
FSResolver setStamp: 'cwp 10/26/2009 20:53' forMethod: #'addResolver:'.
true
%

category: 'resolving'
method: FSResolver
canResolve: aSymbol
	^ self supportedOrigins includes: aSymbol
%
run
FSResolver setStamp: 'cwp 10/27/2009 11:18' forMethod: #'canResolve:'.
true
%

category: 'accessing'
method: FSResolver
flushCaches
	self flushLocalCache.
	next ifNotNil: [next flushCaches]
%
run
FSResolver setStamp: 'cwp 10/27/2009 10:28' forMethod: #'flushCaches'.
true
%

category: 'accessing'
method: FSResolver
flushLocalCache
%
run
FSResolver setStamp: 'cwp 10/27/2009 10:28' forMethod: #'flushLocalCache'.
true
%

category: '*filesystemgemstone-resolving'
method: FSResolver
initialize
%
run
FSResolver setStamp: 'DaleHenrichs 10/18/2010 15:17' forMethod: #'initialize'.
true
%

category: 'accessing'
method: FSResolver
next
	^ next
%
run
FSResolver setStamp: 'cwp 10/27/2009 11:25' forMethod: #'next'.
true
%

category: 'resolving'
method: FSResolver
resolve: aSymbol
	^ (self canResolve: aSymbol)
		ifTrue: [self perform: aSymbol]
		ifFalse: [self unknownOrigin: aSymbol]
%
run
FSResolver setStamp: 'cwp 10/27/2009 11:18' forMethod: #'resolve:'.
true
%

category: '*filesystemgemstone-resolving'
method: FSResolver
resolveString: aString 
	
	^ FSDiskFilesystem current referenceFromString: aString decodeFromUTF8
%
run
FSResolver setStamp: 'DaleHenrichs 10/14/2010 17:04' forMethod: #'resolveString:'.
true
%

category: 'resolving'
method: FSResolver
supportedOrigins
	^ #()
%
run
FSResolver setStamp: 'cwp 10/26/2009 20:06' forMethod: #'supportedOrigins'.
true
%

category: 'resolving'
method: FSResolver
unknownOrigin: aSymbol
	^ next ifNotNil: [next resolve: aSymbol]
%
run
FSResolver setStamp: 'cwp 10/27/2009 09:26' forMethod: #'unknownOrigin:'.
true
%

category: 'resolving'
method: FSTestResolver
supportedOrigins
	^ #(testFile testDirectory)
%
run
FSTestResolver setStamp: 'DaleHenrichs 10/18/2010 11:12' forMethod: #'supportedOrigins'.
true
%

category: 'origins'
method: FSTestResolver
testDirectory
	^ self testFile parent
%
run
FSTestResolver setStamp: 'DaleHenrichs 10/18/2010 11:18' forMethod: #'testDirectory'.
true
%

category: '*filesystemgemstone-origins'
method: FSTestResolver
testFile

	^self resolveString: (GsFile _expandEnvVariable: 'HOME' isClient: false), '/filesystemTestFile.txt'
%
run
FSTestResolver setStamp: 'DaleHenrichs 10/18/2010 11:52' forMethod: #'testFile'.
true
%

category: 'ansi gettable'
method: FSReadStream
atEnd
	^ position = handle size
%
run
FSReadStream setStamp: 'DaleHenrichs 10/20/2010 16:26' forMethod: #'atEnd'.
true
%

category: 'ansi gettable'
method: FSReadStream
do: aBlock
	[self atEnd] whileFalse: [aBlock value: self next]
%
run
FSReadStream setStamp: 'cwp 7/29/2009 22:58' forMethod: #'do:'.
true
%

category: 'ansi gettable'
method: FSReadStream
next
	
	^handle at: (position := position + 1)
%
run
FSReadStream setStamp: 'DaleHenrichs 10/20/2010 16:27' forMethod: #'next'.
true
%

category: 'ansi gettable'
method: FSReadStream
next: count
	| result read |
	result := ByteArray new: count.
	read := handle at: position + 1 read: result startingAt: 1 count: count.
	position := position + read.
	^ result
%
run
FSReadStream setStamp: 'DaleHenrichs 10/20/2010 16:45' forMethod: #'next:'.
true
%

category: 'squeak'
method: FSReadStream
nextInto: aCollection
	| count |
	count := handle at: position + 1 read: aCollection startingAt: 1 count: aCollection size.
	position := position + count.
 	^ count < aCollection size
		ifTrue: [aCollection copyFrom: 1 to: count]
		ifFalse: [aCollection]
%
run
FSReadStream setStamp: 'DaleHenrichs 10/20/2010 16:45' forMethod: #'nextInto:'.
true
%

category: 'ansi gettable'
method: FSReadStream
nextLine
	| char |
	^ ByteArray streamContents:
		[:out |
		[self atEnd or: [#(13 10) includes: (char := self next)]] whileFalse: [out nextPut: char].
		(char = 13 and: [self peek = 10]) ifTrue: [position := position + 1]].
	
%
run
FSReadStream setStamp: 'cwp 7/29/2009 23:31' forMethod: #'nextLine'.
true
%

category: 'ansi gettable'
method: FSReadStream
nextMatchFor: anObject
	^ self next = anObject
%
run
FSReadStream setStamp: 'cwp 7/30/2009 23:03' forMethod: #'nextMatchFor:'.
true
%

category: 'ansi gettable'
method: FSReadStream
peek
	^ handle at: position + 1
%
run
FSReadStream setStamp: 'DaleHenrichs 10/20/2010 16:22' forMethod: #'peek'.
true
%

category: 'ansi gettable'
method: FSReadStream
peekFor: anObject
	^ self peek = anObject
%
run
FSReadStream setStamp: 'cwp 7/30/2009 23:06' forMethod: #'peekFor:'.
true
%

category: 'ansi gettable'
method: FSReadStream
skip: anInteger
	position := position + anInteger min: handle size
%
run
FSReadStream setStamp: 'DaleHenrichs 10/20/2010 16:21' forMethod: #'skip:'.
true
%

category: 'ansi gettable'
method: FSReadStream
skipTo: anObject
	
	| result |
	[self atEnd or: [result := (self next = anObject)]] whileFalse.
	^ result
%
run
FSReadStream setStamp: 'cwp 7/30/2009 23:27' forMethod: #'skipTo:'.
true
%

category: 'ansi gettable'
method: FSReadStream
upTo: anObject
	
	| byte |
	^ ByteArray streamContents:
		[:out |
		[self atEnd or: [(byte := self next) = anObject]] whileFalse:
			[out nextPut: byte]]
		
%
run
FSReadStream setStamp: 'cwp 7/30/2009 23:37' forMethod: #'upTo:'.
true
%

category: 'instance creation'
classmethod: FSStream
onHandle: aHandle
	^ self new setHandle: aHandle
	
%
run
FSStream class setStamp: 'cwp 7/29/2009 22:30' forMethod: #'onHandle:'.
true
%

category: 'stream compatibility'
method: FSStream
binary
	"Stream compat"
%
run
FSStream setStamp: 'DaleHenrichs 10/20/2010 15:55' forMethod: #'binary'.
true
%

category: 'public'
method: FSStream
close
	handle close
%
run
FSStream setStamp: 'cwp 7/29/2009 22:29' forMethod: #'close'.
true
%

category: 'stream compatibility'
method: FSStream
closed
	^false
%
run
FSStream setStamp: 'DaleHenrichs 10/20/2010 16:48' forMethod: #'closed'.
true
%

category: 'public'
method: FSStream
contents
	| size contents |
	size := handle size.
	contents := ByteArray new: size.
	handle at: 1 read: contents startingAt: 1 count: size.
	^ contents
%
run
FSStream setStamp: 'cwp 7/29/2009 22:29' forMethod: #'contents'.
true
%

category: 'stream compatibility'
method: FSStream
isBinary

	^true
%
run
FSStream setStamp: 'DaleHenrichs 10/20/2010 16:00' forMethod: #'isBinary'.
true
%

category: 'public'
method: FSStream
isOpen
	^ handle isOpen
%
run
FSStream setStamp: 'cwp 10/29/2009 09:47' forMethod: #'isOpen'.
true
%

category: 'stream compatibility'
method: FSStream
isStream

	^true
%
run
FSStream setStamp: 'DaleHenrichs 10/20/2010 15:58' forMethod: #'isStream'.
true
%

category: 'stream compatibility'
method: FSStream
next: n into: aCollection
	"Read n objects into the given collection.
	Return aCollection or a partial copy if less than
	n elements have been read."
	^self next: n into: aCollection startingAt: 1
%
run
FSStream setStamp: 'DaleHenrichs 10/20/2010 16:39' forMethod: #'next:into:'.
true
%

category: 'stream compatibility'
method: FSStream
next: n into: aCollection startingAt: startIndex
	"Read n objects into the given collection. 
	Return aCollection or a partial copy if less than
	n elements have been read."
	0 to: n-1 do:[:i|
		self atEnd ifTrue: [ ^aCollection copyFrom: 1 to: startIndex+i-1 ].
		aCollection at: startIndex+i put: self next].
	^aCollection
%
run
FSStream setStamp: 'DaleHenrichs 10/20/2010 16:03' forMethod: #'next:into:startingAt:'.
true
%

category: 'stream compatibility'
method: FSStream
nextInto: aCollection
	"Read the next elements of the receiver into aCollection.
	Return aCollection or a partial copy if less than aCollection
	size elements have been read."
	^self next: aCollection size into: aCollection startingAt: 1.
%
run
FSStream setStamp: 'DaleHenrichs 10/20/2010 16:38' forMethod: #'nextInto:'.
true
%

category: 'stream compatibility'
method: FSStream
nextLittleEndianNumber: n 
	"Answer the next n bytes as a positive Integer or LargePositiveInteger, where the bytes are ordered from least significant to most significant."

	| bytes s |
	bytes := self next: n.
	s := 0.
	n to: 1 by: -1 do: [:i | s := (s bitShift: 8) bitOr: (bytes at: i)].
	^ s

%
run
FSStream setStamp: 'DaleHenrichs 10/20/2010 16:40' forMethod: #'nextLittleEndianNumber:'.
true
%

category: 'stream compatibility'
method: FSStream
nextLittleEndianNumber: n put: value
	| bytes |
	bytes := ByteArray new: n.
	1 to: n do: [: i | bytes at: i put: (value digitAt: i)].
	self nextPutAll: bytes
%
run
FSStream setStamp: 'DaleHenrichs 10/20/2010 15:55' forMethod: #'nextLittleEndianNumber:put:'.
true
%

category: 'public'
method: FSStream
open
	handle open
%
run
FSStream setStamp: 'cwp 10/29/2009 09:47' forMethod: #'open'.
true
%

category: 'public'
method: FSStream
position
	^ position
%
run
FSStream setStamp: 'cwp 7/29/2009 22:32' forMethod: #'position'.
true
%

category: 'public'
method: FSStream
position: anInteger
	position := anInteger
%
run
FSStream setStamp: 'cwp 7/29/2009 22:32' forMethod: #'position:'.
true
%

category: 'public'
method: FSStream
reset

	self close; open
%
run
FSStream setStamp: 'DaleHenrichs 10/19/2010 15:55' forMethod: #'reset'.
true
%

category: 'initialize-release'
method: FSStream
setHandle: aHandle
	handle := aHandle.
	position := 0
%
run
FSStream setStamp: 'DaleHenrichs 10/20/2010 16:20' forMethod: #'setHandle:'.
true
%

category: 'stream compatibility'
method: FSStream
setToEnd

	self position: handle size
%
run
FSStream setStamp: 'DaleHenrichs 10/20/2010 16:02' forMethod: #'setToEnd'.
true
%

category: 'ansi gettable'
method: FSReadWriteStream
atEnd
	^ position = handle size
%
run
FSReadWriteStream setStamp: 'DaleHenrichs 10/20/2010 16:28' forMethod: #'atEnd'.
true
%

category: 'ansi gettable'
method: FSReadWriteStream
do: aBlock
	[self atEnd] whileFalse: [aBlock value: self next]
%
run
FSReadWriteStream setStamp: 'DaleHenrichs 10/18/2010 18:03' forMethod: #'do:'.
true
%

category: 'ansi gettable'
method: FSReadWriteStream
next
	
	^handle at: (position := position + 1)
%
run
FSReadWriteStream setStamp: 'DaleHenrichs 10/20/2010 16:28' forMethod: #'next'.
true
%

category: 'ansi gettable'
method: FSReadWriteStream
next: count
	| result read |
	result := ByteArray new: count.
	read := handle at: position + 1 read: result startingAt: 1 count: count.
	position := position + read.
	^ result
%
run
FSReadWriteStream setStamp: 'DaleHenrichs 10/20/2010 16:46' forMethod: #'next:'.
true
%

category: 'squeak'
method: FSReadWriteStream
nextInto: aCollection
	| count |
	count := handle at: position + 1 read: aCollection startingAt: 1 count: aCollection size.
	position := position + count.
 	^ count < aCollection size
		ifTrue: [aCollection copyFrom: 1 to: count]
		ifFalse: [aCollection]
%
run
FSReadWriteStream setStamp: 'DaleHenrichs 10/20/2010 16:27' forMethod: #'nextInto:'.
true
%

category: 'ansi gettable'
method: FSReadWriteStream
nextLine
	| char |
	^ ByteArray streamContents:
		[:out |
		[self atEnd or: [#(13 10) includes: (char := self next)]] whileFalse: [out nextPut: char].
		(char = 13 and: [self peek = 10]) ifTrue: [position := position + 1]].
	
%
run
FSReadWriteStream setStamp: 'DaleHenrichs 10/18/2010 18:03' forMethod: #'nextLine'.
true
%

category: 'ansi gettable'
method: FSReadWriteStream
nextMatchFor: anObject
	^ self next = anObject
%
run
FSReadWriteStream setStamp: 'DaleHenrichs 10/18/2010 18:03' forMethod: #'nextMatchFor:'.
true
%

category: 'ansi gettable'
method: FSReadWriteStream
peek
	^ handle at: position + 1
%
run
FSReadWriteStream setStamp: 'DaleHenrichs 10/20/2010 16:27' forMethod: #'peek'.
true
%

category: 'ansi gettable'
method: FSReadWriteStream
peekFor: anObject
	^ self peek = anObject
%
run
FSReadWriteStream setStamp: 'DaleHenrichs 10/18/2010 18:03' forMethod: #'peekFor:'.
true
%

category: 'ansi gettable'
method: FSReadWriteStream
skip: anInteger
	position := position + anInteger min: handle size
%
run
FSReadWriteStream setStamp: 'DaleHenrichs 10/20/2010 16:26' forMethod: #'skip:'.
true
%

category: 'ansi gettable'
method: FSReadWriteStream
skipTo: anObject
	
	| result |
	[self atEnd or: [result := (self next = anObject)]] whileFalse.
	^ result
%
run
FSReadWriteStream setStamp: 'DaleHenrichs 10/18/2010 18:03' forMethod: #'skipTo:'.
true
%

category: 'ansi gettable'
method: FSReadWriteStream
upTo: anObject
	
	| byte |
	^ ByteArray streamContents:
		[:out |
		[self atEnd or: [(byte := self next) = anObject]] whileFalse:
			[out nextPut: byte]]
		
%
run
FSReadWriteStream setStamp: 'DaleHenrichs 10/18/2010 18:03' forMethod: #'upTo:'.
true
%

category: 'ansi puttable'
method: FSWriteStream
cr
	self nextPut: 13
%
run
FSWriteStream setStamp: 'cwp 7/28/2009 22:25' forMethod: #'cr'.
true
%

category: 'ansi puttable'
method: FSWriteStream
flush
	handle flush
%
run
FSWriteStream setStamp: 'cwp 7/28/2009 22:22' forMethod: #'flush'.
true
%

category: 'ansi puttable'
method: FSWriteStream
nextPut: anObject
	| val |
	val := anObject asInteger.
	handle at: (position := position + 1) put: val.
	^ anObject
%
run
FSWriteStream setStamp: 'DaleHenrichs 10/20/2010 16:26' forMethod: #'nextPut:'.
true
%

category: 'ansi puttable'
method: FSWriteStream
nextPutAll: aCollection
	| bytes |
	bytes := aCollection asByteArray.
	handle at: position + 1 write: bytes startingAt: 1 count: bytes size.
	position := position + bytes size.
	^ aCollection
%
run
FSWriteStream setStamp: 'DaleHenrichs 10/20/2010 16:26' forMethod: #'nextPutAll:'.
true
%

category: 'public'
method: FSWriteStream
reset

	self flush.
	super reset
%
run
FSWriteStream setStamp: 'DaleHenrichs 10/19/2010 16:05' forMethod: #'reset'.
true
%

category: 'ansi puttable'
method: FSWriteStream
space
	self nextPut: 32
%
run
FSWriteStream setStamp: 'cwp 7/28/2009 22:26' forMethod: #'space'.
true
%

category: 'ansi puttable'
method: FSWriteStream
tab
	self nextPut: 9
%
run
FSWriteStream setStamp: 'cwp 7/28/2009 22:28' forMethod: #'tab'.
true
%

category: 'file'
method: FSWriteStream
truncate
	handle truncateTo: position
%
run
FSWriteStream setStamp: 'DaleHenrichs 10/20/2010 16:32' forMethod: #'truncate'.
true
%

category: 'file'
method: FSWriteStream
truncateTo: anInteger
	handle truncateTo: anInteger
%
run
FSWriteStream setStamp: 'cwp 10/15/2009 21:49' forMethod: #'truncateTo:'.
true
%

category: 'instance creation'
classmethod: FSCollectVisitor
breadthFirst: aReference
	^ self breadthFirst: aReference collect: [:entry | entry]
%
run
FSCollectVisitor class setStamp: 'cwp 11/16/2009 10:33' forMethod: #'breadthFirst:'.
true
%

category: 'instance creation'
classmethod: FSCollectVisitor
breadthFirst: aReference collect: aBlock
	^ (self collect: aBlock) breadthFirst: aReference
%
run
FSCollectVisitor class setStamp: 'cwp 11/16/2009 10:32' forMethod: #'breadthFirst:collect:'.
true
%

category: 'instance creation'
classmethod: FSCollectVisitor
collect: aBlock
	^ self basicNew initializeWithBlock: aBlock
%
run
FSCollectVisitor class setStamp: 'cwp 11/16/2009 10:39' forMethod: #'collect:'.
true
%

category: 'instance creation'
classmethod: FSCollectVisitor
postorder: aReference
	^ self postorder: aReference collect: [:entry | entry]
%
run
FSCollectVisitor class setStamp: 'cwp 11/16/2009 10:36' forMethod: #'postorder:'.
true
%

category: 'instance creation'
classmethod: FSCollectVisitor
postorder: aReference collect: aBlock
	^ (self collect: aBlock) postorder: aReference
%
run
FSCollectVisitor class setStamp: 'cwp 11/16/2009 10:35' forMethod: #'postorder:collect:'.
true
%

category: 'instance creation'
classmethod: FSCollectVisitor
preorder: aReference
	^ self preorder: aReference collect: [:entry | entry]
%
run
FSCollectVisitor class setStamp: 'cwp 11/16/2009 10:35' forMethod: #'preorder:'.
true
%

category: 'instance creation'
classmethod: FSCollectVisitor
preorder: aReference collect: aBlock
	^ (self collect: aBlock) preorder: aReference
%
run
FSCollectVisitor class setStamp: 'cwp 11/16/2009 10:36' forMethod: #'preorder:collect:'.
true
%

category: 'ordering'
method: FSCollectVisitor
breadthFirst: aReference
	^ self visit: aReference with: (FSBreadthFirstGuide for: self)
%
run
FSCollectVisitor setStamp: 'cwp 11/15/2009 07:58' forMethod: #'breadthFirst:'.
true
%

category: 'initialize-release'
method: FSCollectVisitor
initializeWithBlock: aBlock
	self initialize.
	block := aBlock
%
run
FSCollectVisitor setStamp: 'cwp 11/16/2009 10:38' forMethod: #'initializeWithBlock:'.
true
%

category: 'ordering'
method: FSCollectVisitor
postorder: aReference
	^ self visit: aReference with: (FSPostorderGuide for: self)
%
run
FSCollectVisitor setStamp: 'cwp 11/15/2009 07:58' forMethod: #'postorder:'.
true
%

category: 'ordering'
method: FSCollectVisitor
preorder: aReference
	^ self visit: aReference with: (FSPreorderGuide for: self)
%
run
FSCollectVisitor setStamp: 'cwp 11/15/2009 07:58' forMethod: #'preorder:'.
true
%

category: 'visiting'
method: FSCollectVisitor
visit: aReference with: aGuide
	out := (Array new: 10) writeStream.
	aGuide show: aReference.
	^ out contents
%
run
FSCollectVisitor setStamp: 'cwp 11/15/2009 07:59' forMethod: #'visit:with:'.
true
%

category: 'visiting'
method: FSCollectVisitor
visitReference: anEntry
	out nextPut: (block value: anEntry)
%
run
FSCollectVisitor setStamp: 'cwp 11/16/2009 10:38' forMethod: #'visitReference:'.
true
%

category: 'instance creation'
classmethod: FSCopyVisitor
copy: source to: dest
	(self from: source to: dest) visit
%
run
FSCopyVisitor class setStamp: 'cwp 10/30/2009 13:44' forMethod: #'copy:to:'.
true
%

category: 'instance creation'
classmethod: FSCopyVisitor
from: srcReference to: dstReference
	^ self basicNew
		initializeWithSource: srcReference 
		dest: dstReference
%
run
FSCopyVisitor class setStamp: 'cwp 10/30/2009 13:41' forMethod: #'from:to:'.
true
%

category: 'visiting'
method: FSCopyVisitor
copyDirectory: aReference
	| directory |
	directory := dest resolve: (aReference relativeTo: source).
	directory createDirectory
%
run
FSCopyVisitor setStamp: 'cwp 11/17/2009 21:06' forMethod: #'copyDirectory:'.
true
%

category: 'visiting'
method: FSCopyVisitor
copyFile: aReference
	| copy |
	copy := dest resolve: (aReference relativeTo: source).
	aReference copyTo: copy
%
run
FSCopyVisitor setStamp: 'cwp 11/15/2009 00:31' forMethod: #'copyFile:'.
true
%

category: 'initialize-release'
method: FSCopyVisitor
initializeWithSource: srcReference dest: dstReference
	self initialize.
	source := srcReference.
	dest := dstReference
%
run
FSCopyVisitor setStamp: 'cwp 10/30/2009 13:42' forMethod: #'initializeWithSource:dest:'.
true
%

category: 'visiting'
method: FSCopyVisitor
visit
	(FSPreorderGuide for: self) 
		show: source
%
run
FSCopyVisitor setStamp: 'cwp 10/30/2009 13:45' forMethod: #'visit'.
true
%

category: 'visiting'
method: FSCopyVisitor
visitDirectory: anEntry
	| reference |
	reference := anEntry reference.
	reference = source
		ifTrue: [dest ensureDirectory]
		ifFalse: [self copyDirectory: reference]
%
run
FSCopyVisitor setStamp: 'cwp 11/16/2009 10:51' forMethod: #'visitDirectory:'.
true
%

category: 'visiting'
method: FSCopyVisitor
visitFile: anEntry
	| reference |
	reference := anEntry reference.
	reference = source
		ifTrue: [source copyTo: dest]
		ifFalse: [self copyFile: reference]
%
run
FSCopyVisitor setStamp: 'cwp 11/16/2009 10:52' forMethod: #'visitFile:'.
true
%

category: 'instance creation'
classmethod: FSDeleteVisitor
delete: aReference
	^ self new visit: aReference
%
run
FSDeleteVisitor class setStamp: 'cwp 11/17/2009 13:02' forMethod: #'delete:'.
true
%

category: 'visiting'
method: FSDeleteVisitor
visit: aReference
	FSPostorderGuide show: aReference to: self
%
run
FSDeleteVisitor setStamp: 'cwp 11/17/2009 16:02' forMethod: #'visit:'.
true
%

category: 'visiting'
method: FSDeleteVisitor
visitReference: anEntry
	anEntry reference delete
%
run
FSDeleteVisitor setStamp: 'cwp 11/16/2009 10:53' forMethod: #'visitReference:'.
true
%

category: '*filesystemgemstone-initialization'
method: FSVisitor
initialize
%
run
FSVisitor setStamp: 'DaleHenrichs 10/18/2010 18:16' forMethod: #'initialize'.
true
%

category: 'visiting'
method: FSVisitor
visitDirectory: aReference
	^ self visitReference: aReference
%
run
FSVisitor setStamp: 'cwp 11/15/2009 00:45' forMethod: #'visitDirectory:'.
true
%

category: 'visiting'
method: FSVisitor
visitFile: aReference
	^ self visitReference: aReference
%
run
FSVisitor setStamp: 'cwp 11/15/2009 00:45' forMethod: #'visitFile:'.
true
%

category: 'visiting'
method: FSVisitor
visitReference: aReference
%
run
FSVisitor setStamp: 'cwp 11/15/2009 00:45' forMethod: #'visitReference:'.
true
%

category: 'instance creation'
classmethod: MessageSend
receiver: anObject selector: aSymbol
	^ self receiver: anObject selector: aSymbol arguments: #()
%
run
MessageSend class setStamp: 'sma 2/29/2000 20:44' forMethod: #'receiver:selector:'.
true
%

category: 'instance creation'
classmethod: MessageSend
receiver: anObject selector: aSymbol argument: aParameter
	^ self receiver: anObject selector: aSymbol arguments: (Array with: aParameter)
%
run
MessageSend class setStamp: 'sma 2/29/2000 20:44' forMethod: #'receiver:selector:argument:'.
true
%

category: 'instance creation'
classmethod: MessageSend
receiver: anObject selector: aSymbol arguments: anArray
	^ self new
		receiver: anObject;
		selector: aSymbol;
		arguments: anArray
%
run
MessageSend class setStamp: 'sma 2/29/2000 20:39' forMethod: #'receiver:selector:arguments:'.
true
%

category: 'comparing'
method: MessageSend
= anObject
	^ anObject species == self species 
		and: [receiver == anObject receiver
		and: [selector == anObject selector
		and: [arguments = anObject arguments]]]
%
run
MessageSend setStamp: 'sma 2/29/2000 20:43' forMethod: #'='.
true
%

category: 'accessing'
method: MessageSend
arguments
	^ arguments
%
run
MessageSend setStamp: 'sma 2/29/2000 20:39' forMethod: #'arguments'.
true
%

category: 'accessing'
method: MessageSend
arguments: anArray
	arguments _ anArray
%
run
MessageSend setStamp: 'sma 2/29/2000 20:40' forMethod: #'arguments:'.
true
%

category: 'converting'
method: MessageSend
asMinimalRepresentation
	^self
%
run
MessageSend setStamp: 'nk 12/20/2002 17:54' forMethod: #'asMinimalRepresentation'.
true
%

category: 'private'
method: MessageSend
collectArguments: anArgArray
	"Private"

    | staticArgs |
    staticArgs := self arguments.
    ^(anArgArray size = staticArgs size)
        ifTrue: [anArgArray]
        ifFalse:
            [(staticArgs isEmpty
                ifTrue: [ staticArgs := Array new: selector numArgs]
                ifFalse: [staticArgs copy] )
                    replaceFrom: 1
                    to: (anArgArray size min: staticArgs size)
                    with: anArgArray
                    startingAt: 1]
%
run
MessageSend setStamp: 'reThink 2/18/2001 17:33' forMethod: #'collectArguments:'.
true
%

category: 'comparing'
method: MessageSend
hash
	^ receiver hash bitXor: selector hash
%
run
MessageSend setStamp: 'sma 3/11/2000 10:35' forMethod: #'hash'.
true
%

category: 'testing'
method: MessageSend
isMessageSend
	^true
%
run
MessageSend setStamp: 'nk 4/25/2002 08:04' forMethod: #'isMessageSend'.
true
%

category: 'testing'
method: MessageSend
isValid
	^true
%
run
MessageSend setStamp: 'nk 7/21/2003 15:16' forMethod: #'isValid'.
true
%

category: 'printing'
method: MessageSend
printOn: aStream

        aStream
                nextPutAll: self class name;
                nextPut: $(.
        selector printOn: aStream.
        aStream nextPutAll: ' -> '.
        receiver printOn: aStream.
        aStream nextPut: $)
%
run
MessageSend setStamp: 'SqR 7/14/2001 11:36' forMethod: #'printOn:'.
true
%

category: 'accessing'
method: MessageSend
receiver
	^ receiver
%
run
MessageSend setStamp: 'sma 2/29/2000 20:39' forMethod: #'receiver'.
true
%

category: 'accessing'
method: MessageSend
receiver: anObject
	receiver _ anObject
%
run
MessageSend setStamp: 'sma 2/29/2000 20:39' forMethod: #'receiver:'.
true
%

category: 'accessing'
method: MessageSend
selector
	^ selector
%
run
MessageSend setStamp: 'sma 2/29/2000 20:39' forMethod: #'selector'.
true
%

category: 'accessing'
method: MessageSend
selector: aSymbol
	selector _ aSymbol
%
run
MessageSend setStamp: 'sma 2/29/2000 20:39' forMethod: #'selector:'.
true
%

category: 'evaluating'
method: MessageSend
value
	"Send the message and answer the return value"

	arguments ifNil: [^ receiver perform: selector].

	^ receiver 
		perform: selector 
		withArguments: (self collectArguments: arguments)
%
run
MessageSend setStamp: 'sw 2/20/2002 22:17' forMethod: #'value'.
true
%

category: 'evaluating'
method: MessageSend
valueWithArguments: anArray

	^ receiver 
		perform: selector 
		withArguments: (self collectArguments: anArray)
%
run
MessageSend setStamp: 'reThink 2/18/2001 16:51' forMethod: #'valueWithArguments:'.
true
%

category: 'evaluating'
method: MessageSend
valueWithEnoughArguments: anArray
	"call the selector with enough arguments from arguments and anArray"
	| args |
	args := Array new: selector numArgs.
	args replaceFrom: 1
		to: (arguments size min: args size)
		with: arguments
		startingAt: 1.
	args size > arguments size ifTrue: [
		args replaceFrom: arguments size + 1
			to: (arguments size + anArray size min: args size)
			with: anArray
			startingAt: 1.
	].
	^ receiver perform: selector withArguments: args
%
run
MessageSend setStamp: 'DaleHenrichs 01/28/2010 16:19' forMethod: #'valueWithEnoughArguments:'.
true
%

category: 'instance creation'
classmethod: FSFileStream
on: aCollection filesystem: aFilesystem path: aPath 
	^ self 
		on: aCollection
		reference: (FSReference 
				filesystem: aFilesystem
				path: aPath)
%
run
FSFileStream class setStamp: 'cwp 8/30/2009 18:28' forMethod: #'on:filesystem:path:'.
true
%

category: 'instance creation'
classmethod: FSFileStream
on: aCollection reference: aFileReference
	^ (self on: aCollection)
		reference: aFileReference
		yourself
%
run
FSFileStream class setStamp: 'cwp 8/30/2009 18:28' forMethod: #'on:reference:'.
true
%

category: 'accessing'
method: FSFileStream
reference: aFileReference
	reference := aFileReference
%
run
FSFileStream setStamp: 'cwp 8/30/2009 18:14' forMethod: #'reference:'.
true
%

category: 'file status'
method: FSMemoryFileStream
close
	reference filesystem 
		truncateFile: reference path 
		to: self position
		using: self contents.
	
%
run
FSMemoryFileStream setStamp: 'DaleHenrichs 10/19/2010 15:49' forMethod: #'close'.
true
%

category: 'accessing'
method: FSDirectoryEntryTest
entry
	^ FSDiskFilesystem testFile entry
%
run
FSDirectoryEntryTest setStamp: 'DaleHenrichs 10/15/2010 16:42' forMethod: #'entry'.
true
%

category: 'tests'
method: FSDirectoryEntryTest
testCreationTime
	| creation |
	creation := self entry creation.
	self assert: creation class = DateAndTime.
	
%
run
FSDirectoryEntryTest setStamp: 'cwp 11/15/2009 22:09' forMethod: #'testCreationTime'.
true
%

category: 'tests'
method: FSDirectoryEntryTest
testIsDirectory
	| ref entry |
	ref := FSDiskFilesystem testDirectory.
	entry := ref entry.
	self assert: entry isDirectory
%
run
FSDirectoryEntryTest setStamp: 'DaleHenrichs 10/15/2010 16:56' forMethod: #'testIsDirectory'.
true
%

category: 'tests'
method: FSDirectoryEntryTest
testIsFile
	self assert: self entry isFile
%
run
FSDirectoryEntryTest setStamp: 'cwp 11/15/2009 22:10' forMethod: #'testIsFile'.
true
%

category: 'tests'
method: FSDirectoryEntryTest
testIsNotDirectory
	self deny: self entry isDirectory
%
run
FSDirectoryEntryTest setStamp: 'cwp 11/15/2009 22:10' forMethod: #'testIsNotDirectory'.
true
%

category: 'tests'
method: FSDirectoryEntryTest
testIsNotFile
	| ref |
	ref := FSDiskFilesystem testDirectory.
	self deny: ref entry isFile
%
run
FSDirectoryEntryTest setStamp: 'DaleHenrichs 10/15/2010 16:57' forMethod: #'testIsNotFile'.
true
%

category: 'tests'
method: FSDirectoryEntryTest
testModificationTime
	| modification |
	modification := self entry modification.
	self assert: modification class = DateAndTime.
	
%
run
FSDirectoryEntryTest setStamp: 'cwp 11/15/2009 22:09' forMethod: #'testModificationTime'.
true
%

category: 'tests'
method: FSDirectoryEntryTest
testReference
	| ref entry |
	ref := FSDiskFilesystem testFile.
	entry := ref entry.
	self assert: entry reference = ref
%
run
FSDirectoryEntryTest setStamp: 'DaleHenrichs 10/15/2010 16:43' forMethod: #'testReference'.
true
%

category: 'tests'
method: FSDirectoryEntryTest
testSize
	self assert: self entry size isInteger
%
run
FSDirectoryEntryTest setStamp: 'cwp 11/15/2009 22:05' forMethod: #'testSize'.
true
%

category: 'initialize-release'
method: FSDiskFilesystemTest
createFilesystem
	^ FSDiskFilesystem currentClass createDefault
%
run
FSDiskFilesystemTest setStamp: 'cwp 10/11/2009 21:45' forMethod: #'createFilesystem'.
true
%

category: '*filesystemgemstone-tests'
method: FSDiskFilesystemTest
testDefaultWorkingDirectory
	| ref |
	ref := filesystem referenceTo: filesystem workingDirectory.
	self assert: ((GsFile _expandEnvVariable: 'HOME' isClient: false) beginsWith: ref asString)
%
run
FSDiskFilesystemTest setStamp: 'DaleHenrichs 10/15/2010 12:49' forMethod: #'testDefaultWorkingDirectory'.
true
%

category: 'tests'
method: FSDiskFilesystemTest
testEqual
	| other |
	other := self createFilesystem.
	self assert: filesystem = other
%
run
FSDiskFilesystemTest setStamp: 'cwp 7/24/2009 00:40' forMethod: #'testEqual'.
true
%

category: 'tests'
method: FSDiskFilesystemTest
testIsDirectory
	self assert: (filesystem isDirectory: FSDiskFilesystem testDirectory path)
%
run
FSDiskFilesystemTest setStamp: 'DaleHenrichs 10/15/2010 16:57' forMethod: #'testIsDirectory'.
true
%

category: 'testing'
classmethod: FSFilesystemTest
isAbstract
	^ self name = #FSFilesystemTest
%
run
FSFilesystemTest class setStamp: 'cwp 7/20/2009 08:56' forMethod: #'isAbstract'.
true
%

category: 'accessing'
classmethod: FSFilesystemTest
packageNamesUnderTest
	^ #('Filesystem')
%
run
FSFilesystemTest class setStamp: 'lr 7/13/2010 14:01' forMethod: #'packageNamesUnderTest'.
true
%

category: 'testing'
classmethod: FSFilesystemTest
shouldInheritSelectors
	^ true
	
%
run
FSFilesystemTest class setStamp: 'cwp 7/20/2009 08:56' forMethod: #'shouldInheritSelectors'.
true
%

category: 'initialize-release'
method: FSFilesystemTest
createFilesystem
	self subclassResponsibility
%
run
FSFilesystemTest setStamp: 'cwp 7/20/2009 07:31' forMethod: #'createFilesystem'.
true
%

category: 'initialize-release'
method: FSFilesystemTest
delete: anObject
	toDelete add: (filesystem resolve: anObject)
%
run
FSFilesystemTest setStamp: 'cwp 10/10/2009 17:35' forMethod: #'delete:'.
true
%

category: 'initialize-release'
method: FSFilesystemTest
setUp
	filesystem := self createFilesystem.
	toDelete := OrderedCollection new.
%
run
FSFilesystemTest setStamp: 'cwp 8/23/2009 23:10' forMethod: #'setUp'.
true
%

category: 'initialize-release'
method: FSFilesystemTest
tearDown
	toDelete do: [:path | filesystem delete: path]
%
run
FSFilesystemTest setStamp: 'cwp 8/23/2009 23:09' forMethod: #'tearDown'.
true
%

category: 'tests'
method: FSFilesystemTest
testChangeDirectory
	filesystem workingDirectory: (FSPath / 'plonk').
	filesystem changeDirectory: 'griffle'.
	self assert: (filesystem workingDirectory printWithDelimiter: $/) = '/plonk/griffle'
%
run
FSFilesystemTest setStamp: 'cwp 10/11/2009 22:15' forMethod: #'testChangeDirectory'.
true
%

category: 'tests'
method: FSFilesystemTest
testChangeDirectoryString
	filesystem workingDirectory: (FSPath / 'plonk').
	filesystem changeDirectory: 'griffle'.
	self assert: (filesystem workingDirectory printWithDelimiter: $/) = '/plonk/griffle'
%
run
FSFilesystemTest setStamp: 'cwp 10/11/2009 22:14' forMethod: #'testChangeDirectoryString'.
true
%

category: 'tests'
method: FSFilesystemTest
testChildrenAt
	| directory entries |
	directory := FSPath with: 'plonk'.
	filesystem createDirectory: directory.
	filesystem createDirectory: directory / 'griffle'.
	filesystem createDirectory: directory / 'bint'.
	self delete: directory / 'griffle'.
	self delete: directory / 'bint'.
	self delete: directory.
	entries := filesystem childrenAt: directory.
	self assert: entries size = 2.
	entries do: 
		[ :ea | 
		self assert: (ea isKindOf: FSReference).
		self assert: ea parent path = (filesystem resolve: directory).
		self assert: (#('griffle' 'bint' ) includes: ea basename) ]
%
run
FSFilesystemTest setStamp: 'cwp 11/16/2009 00:12' forMethod: #'testChildrenAt'.
true
%

category: 'tests'
method: FSFilesystemTest
testCopy
	| out in contents |
	[ 
	out := filesystem writeStreamOn: 'gooly'.
	[ out nextPutAll: 'gooly' ] ensure: [ out close ].
	filesystem copy: 'gooly' to: 'plonk'.
	in := filesystem readStreamOn: 'plonk'.
	contents := [ in contents asString ] ensure: [ in close ].
	self assert: contents = 'gooly' ]
		ensure: [ 
			filesystem
				delete: 'gooly';
				delete: 'plonk' ]
%
run
FSFilesystemTest setStamp: 'lr 7/13/2010 15:19' forMethod: #'testCopy'.
true
%

category: 'tests'
method: FSFilesystemTest
testCopyDestExists
	| out |
	
	[out := (filesystem open: 'gooly' writable: true) writeStream.
	[out nextPutAll: 'gooly'] ensure: [out close].
	out := filesystem open: 'plonk' writable: true.
	out close.
	self 
		should: [filesystem copy: 'gooly' to: 'plonk']
		raise: FSFileExists] 
			ensure: [filesystem delete: 'gooly'; delete: 'plonk']
%
run
FSFilesystemTest setStamp: 'cwp 11/14/2009 23:37' forMethod: #'testCopyDestExists'.
true
%

category: 'tests'
method: FSFilesystemTest
testCopySourceDoesntExist
	self 
		should: [filesystem copy: 'plonk' to: 'griffle']
		raise: FSFileDoesNotExist
%
run
FSFilesystemTest setStamp: 'cwp 11/14/2009 23:36' forMethod: #'testCopySourceDoesntExist'.
true
%

category: 'tests'
method: FSFilesystemTest
testCreateDirectoryExists
	| path |
	path := FSPath * 'griffle'.
	self delete: path.
	filesystem createDirectory: path.
	self 
		should: [filesystem createDirectory: path]
		raise: FSDirectoryExists.
		

	
	

%
run
FSFilesystemTest setStamp: 'cwp 11/17/2009 16:56' forMethod: #'testCreateDirectoryExists'.
true
%

category: 'tests'
method: FSFilesystemTest
testCreateDirectoryNoParent
	| path |
	path := FSPath * 'griffle' / 'nurp'.
	self 
		should: [filesystem createDirectory: path]
		raise: FSDirectoryDoesNotExist.
	
	

%
run
FSFilesystemTest setStamp: 'cwp 11/17/2009 16:53' forMethod: #'testCreateDirectoryNoParent'.
true
%

category: 'tests'
method: FSFilesystemTest
testDefaultWorkingDirectory
	self assert: filesystem workingDirectory isRoot
%
run
FSFilesystemTest setStamp: 'cwp 7/20/2009 07:30' forMethod: #'testDefaultWorkingDirectory'.
true
%

category: 'tests'
method: FSFilesystemTest
testDelimiter
	self assert: filesystem delimiter isCharacter
%
run
FSFilesystemTest setStamp: 'cwp 7/20/2009 07:30' forMethod: #'testDelimiter'.
true
%

category: 'tests'
method: FSFilesystemTest
testDirectory
	| path |
	path := FSPath with: 'plonk'.
	filesystem createDirectory: path.
	self assert: (filesystem exists: path).
	self assert: (filesystem isDirectory: path).
	self deny: (filesystem isFile: path).
	filesystem delete: path.
	self deny: (filesystem exists: path)
%
run
FSFilesystemTest setStamp: 'cwp 10/10/2009 17:43' forMethod: #'testDirectory'.
true
%

category: 'tests'
method: FSFilesystemTest
testEnsureDirectory
	| path |
	path := FSPath * 'plonk'.
	self delete: path.
	filesystem ensureDirectory: path.
	self assert: (filesystem isDirectory: path).
%
run
FSFilesystemTest setStamp: 'lr 7/13/2010 16:19' forMethod: #'testEnsureDirectory'.
true
%

category: 'tests'
method: FSFilesystemTest
testEnsureDirectoryCreatesParent
	| path |
	path := FSPath * 'plonk' / 'griffle'.
	self delete: path.
	self delete: path parent.
	self 
		shouldnt: [filesystem ensureDirectory: path]
		raise: FSFilesystemError.
	self assert: (filesystem isDirectory: (FSPath * 'plonk')).
	self assert: (filesystem isDirectory: path).
	
%
run
FSFilesystemTest setStamp: 'lr 7/13/2010 16:20' forMethod: #'testEnsureDirectoryCreatesParent'.
true
%

category: 'tests'
method: FSFilesystemTest
testEnsureDirectoryExists
	| path |
	path := FSPath * 'plonk'.
	self delete: path.
	filesystem createDirectory: path.
	self 
		shouldnt: [filesystem ensureDirectory: path]
		raise: FSFilesystemError.
	
%
run
FSFilesystemTest setStamp: 'lr 7/13/2010 16:19' forMethod: #'testEnsureDirectoryExists'.
true
%

category: 'tests'
method: FSFilesystemTest
testEntriesAt
	| directory entries |
	directory := FSPath with: 'plonk'.
	filesystem createDirectory: directory.
	filesystem createDirectory: directory / 'griffle'.
	filesystem createDirectory: directory / 'bint'.
	self delete: directory / 'griffle'.
	self delete: directory / 'bint'.
	self delete: directory.
	entries := filesystem entriesAt: directory.
	self assert: entries size = 2.
	entries do: 
		[ :ea | 
		self assert: (ea isKindOf: FSDirectoryEntry).
		self assert: ea reference parent path = (filesystem resolve: directory).
		self assert: (#('griffle' 'bint' ) includes: ea reference basename).
		self assert: ea isDirectory ]
%
run
FSFilesystemTest setStamp: 'cwp 11/16/2009 00:13' forMethod: #'testEntriesAt'.
true
%

category: 'tests'
method: FSFilesystemTest
testEntryAt
	| path entry |
	path := FSPath * 'plonk'.
	filesystem createDirectory: path.
	self delete: path.
	entry := filesystem entryAt: path.
	self assert: entry isDirectory.
	self assert: entry reference = (filesystem referenceTo: path) asAbsolute
%
run
FSFilesystemTest setStamp: 'cwp 11/16/2009 00:21' forMethod: #'testEntryAt'.
true
%

category: 'tests'
method: FSFilesystemTest
testFile
	| path out |
	path := FSPath with: 'gooly'.
	out := filesystem open: path writable: true.
	out close.
	self assert: (filesystem exists: path).
	self deny: (filesystem isDirectory: path).
	self assert: (filesystem isFile: path).
	filesystem delete: path.
	self deny: (filesystem exists: path)
%
run
FSFilesystemTest setStamp: 'cwp 10/10/2009 17:43' forMethod: #'testFile'.
true
%

category: 'tests'
method: FSFilesystemTest
testFileNames
	| reference pid hostName |
        pid := (System gemVersionReport at: 'processId') printString.
        hostName := System gemVersionReport at: 'nodeName'.
	#('test one' 'test with two' 'test-abc' 'test.abc') do: [ :each |
		| filename |
		filename := each, pid, hostName. "Bug 44752"
		reference := filesystem working / filename.
		self assert: reference basename = filename.
		self deny: reference exists.
		reference
			writeStreamDo: [ :stream | stream nextPutAll: 'gooly' ]
			ifPresent: [ 
                          self fail ].
		[	self assert: reference exists.
			self assert: (filesystem working children
				anySatisfy: [ :ref | 
                                   GsFile gciLogServer: '	', ref basename printString, '-->', (ref = reference) printString.
                                  ref = reference ])]
			ensure: [ reference delete ] ]
%
run
FSFilesystemTest setStamp: 'lr 3/21/2010 11:59' forMethod: #'testFileNames'.
true
%

category: 'tests-references'
method: FSFilesystemTest
testFileStreamDo
	| reference x |
	self delete: (reference := filesystem working / 'griffle').
	self assert: (reference fileStreamDo: [ :stream |
		stream nextPutAll: 'waffle'.
		true ]).
	self assert: (filesystem working / 'griffle') isFile.
	reference fileStreamDo: [ :stream | x := stream contents asString ].
	self assert: x = 'waffle'.

%
run
FSFilesystemTest setStamp: 'DaleHenrichs 10/19/2010 16:01' forMethod: #'testFileStreamDo'.
true
%

category: 'tests-references'
method: FSFilesystemTest
testFileStreamDoMore
	| reference x |
	self delete: (reference := filesystem working / 'griffle').
	self assert: (reference fileStreamDo: [ :stream |
		stream nextPutAll: 'waffle'.
		true ]).
	self assert: (filesystem working / 'griffle') isFile.
	reference fileStreamDo: [ :stream | 
		stream reset.
		stream nextPutAll: 'wiffle' ].
	reference fileStreamDo: [ :stream | x := stream contents asString ].
	self assert: x = 'wiffle'
%
run
FSFilesystemTest setStamp: 'DaleHenrichs 10/19/2010 16:01' forMethod: #'testFileStreamDoMore'.
true
%

category: 'tests-references'
method: FSFilesystemTest
testFileSystemOpenFileStream
	| reference stream x |
	self delete: (reference := filesystem working / 'griffle').
	stream := filesystem openFileStream: reference path mode: 'w+'. "create and open read/write"
	stream nextPutAll: 'waffle'.
	stream flush; close.
	self assert: (filesystem working / 'griffle') isFile.
	stream := filesystem openFileStream: reference path mode: 'r+'. "expected to exist and open read/write"
	stream reset.
	stream nextPutAll: 'wiffle'.
	stream flush; close.
	stream := filesystem openFileStream: reference path mode: 'r+'. "expected to exist and open read/write"
	x := stream contents asString.
	stream flush; close.
	self assert: x = 'wiffle'
%
run
FSFilesystemTest setStamp: 'DaleHenrichs 10/19/2010 16:49' forMethod: #'testFileSystemOpenFileStream'.
true
%

category: 'tests-references'
method: FSFilesystemTest
testReadStream
	| reference stream |
	self delete: (reference := filesystem working / 'griffle').
	self
		should: [ reference readStream ]
		raise: FSFileDoesNotExist.
	reference writeStreamDo: [ :ws | ws nextPutAll: 'waffle' ].
	self
		shouldnt: [ stream := reference readStream ]
		raise: FSFileDoesNotExist.
	self assert: stream contents asString = 'waffle'.
	stream close
%
run
FSFilesystemTest setStamp: 'DaleHenrichs 10/19/2010 15:25' forMethod: #'testReadStream'.
true
%

category: 'tests-references'
method: FSFilesystemTest
testReadStreamDo
	| reference |
	self delete: (reference := filesystem working / 'griffle').
	self 
		should: [ reference readStreamDo: [ :stream | self assert: false ] ] 
		raise: FSFileDoesNotExist.
	reference writeStreamDo: [ :ws | ws nextPutAll: 'waffle' ].
	self assert: (reference readStreamDo: [ :stream | stream contents asString ]) 
		= 'waffle'
%
run
FSFilesystemTest setStamp: 'DaleHenrichs 10/19/2010 15:27' forMethod: #'testReadStreamDo'.
true
%

category: 'tests-references'
method: FSFilesystemTest
testReadStreamDoIfAbsent
	| reference |
	self delete: (reference := filesystem working / 'griffle').
	self assert: (reference 
		readStreamDo: [ :stream | false ]
		ifAbsent: [ true ]).
	reference writeStreamDo: [ :ws | ws nextPutAll: 'waffle' ].
	self assert: (reference 
		readStreamDo: [ :stream | stream contents asString = 'waffle' ]
		ifAbsent: [ false ])
%
run
FSFilesystemTest setStamp: 'DaleHenrichs 10/19/2010 15:26' forMethod: #'testReadStreamDoIfAbsent'.
true
%

category: 'tests-references'
method: FSFilesystemTest
testReadStreamIfAbsent
	| reference stream |
	self delete: (reference := filesystem working / 'griffle').
	self assert: (reference readStreamIfAbsent: [ true ]).
	reference writeStreamDo: [ :ws | ws nextPutAll: 'waffle' ].
	stream := reference readStreamIfAbsent: [ false ].
	self assert: stream contents asString = 'waffle'.
	stream close
%
run
FSFilesystemTest setStamp: 'DaleHenrichs 10/19/2010 15:26' forMethod: #'testReadStreamIfAbsent'.
true
%

category: 'tests'
method: FSFilesystemTest
testRoot
	self assert: filesystem root filesystem = filesystem.
	self assert: filesystem root path = FSPath root
%
run
FSFilesystemTest setStamp: 'lr 2/14/2010 09:49' forMethod: #'testRoot'.
true
%

category: 'tests'
method: FSFilesystemTest
testRootExists
	self assert: (filesystem exists: FSPath root)
%
run
FSFilesystemTest setStamp: 'cwp 10/10/2009 00:33' forMethod: #'testRootExists'.
true
%

category: 'tests'
method: FSFilesystemTest
testRootIsDirectory
	self assert: (filesystem isDirectory: FSPath root)
%
run
FSFilesystemTest setStamp: 'cwp 10/10/2009 00:25' forMethod: #'testRootIsDirectory'.
true
%

category: 'tests'
method: FSFilesystemTest
testRootIsNotAFile
	self deny: (filesystem isFile: FSPath root)
%
run
FSFilesystemTest setStamp: 'cwp 10/10/2009 00:33' forMethod: #'testRootIsNotAFile'.
true
%

category: 'tests'
method: FSFilesystemTest
testSetRelativeWorkingDirectory
	self 
		should: [filesystem workingDirectory: (FSPath with: 'plonk')]
		raise: Error
	
%
run
FSFilesystemTest setStamp: 'cwp 10/11/2009 22:14' forMethod: #'testSetRelativeWorkingDirectory'.
true
%

category: 'tests'
method: FSFilesystemTest
testSetWorkingDirectory
	filesystem workingDirectory: (FSPath / 'plonk').
	self assert: (filesystem workingDirectory printWithDelimiter: $/) = '/plonk'.
%
run
FSFilesystemTest setStamp: 'cwp 10/11/2009 22:13' forMethod: #'testSetWorkingDirectory'.
true
%

category: 'tests'
method: FSFilesystemTest
testWorking
	self assert: filesystem working filesystem = filesystem.
	self assert: filesystem working path = filesystem workingDirectory
%
run
FSFilesystemTest setStamp: 'lr 2/14/2010 09:50' forMethod: #'testWorking'.
true
%

category: 'tests-references'
method: FSFilesystemTest
testWriteStream
	| reference stream |
	self delete: (reference := filesystem working / 'griffle').
	stream := reference writeStream.
	stream nextPutAll: 'waffle'.
	stream close.
	self assert: (filesystem working / 'griffle') isFile.
	stream := reference writeStream.
	stream close
%
run
FSFilesystemTest setStamp: 'DaleHenrichs 10/19/2010 15:27' forMethod: #'testWriteStream'.
true
%

category: 'tests-references'
method: FSFilesystemTest
testWriteStreamDo
	| reference |
	self delete: (reference := filesystem working / 'griffle').
	self assert: (reference writeStreamDo: [ :stream |
		stream nextPutAll: 'waffle'.
		true ]).
	self assert: (filesystem working / 'griffle') isFile.
	self assert: (reference writeStreamDo: [ :stream | true ])
%
run
FSFilesystemTest setStamp: 'DaleHenrichs 10/19/2010 15:27' forMethod: #'testWriteStreamDo'.
true
%

category: 'tests-references'
method: FSFilesystemTest
testWriteStreamDoIfPresent
	| reference |
	self delete: (reference := filesystem working / 'griffle').
	self assert: (reference 
		writeStreamDo: [ :stream |
			stream nextPutAll: 'waffle'.
			true ]
		ifPresent: [ false ]).
	self assert: (filesystem working / 'griffle') isFile.
	self assert: (reference 
		writeStreamDo: [ :stream | true ]
		ifPresent: [ true ])
%
run
FSFilesystemTest setStamp: 'DaleHenrichs 10/19/2010 15:27' forMethod: #'testWriteStreamDoIfPresent'.
true
%

category: 'tests-references'
method: FSFilesystemTest
testWriteStreamIfPresent
	| reference stream |
	self delete: (reference := filesystem working / 'griffle').
	stream := reference writeStreamIfPresent: [ false ].
	stream nextPutAll: 'waffle'.
	stream close.
	self assert: (filesystem working / 'griffle') isFile.
	self assert: (reference writeStreamIfPresent: [ true ])
%
run
FSFilesystemTest setStamp: 'DaleHenrichs 10/19/2010 15:27' forMethod: #'testWriteStreamIfPresent'.
true
%

category: 'initialize-release'
method: FSMemoryFilesystemTest
createFilesystem
	^ FSMemoryFilesystem new
%
run
FSMemoryFilesystemTest setStamp: 'cwp 7/20/2009 07:29' forMethod: #'createFilesystem'.
true
%

category: 'tests'
method: FSMemoryFilesystemTest
testEqual
	| other |
	other := self createFilesystem.
	self deny: filesystem = other
%
run
FSMemoryFilesystemTest setStamp: 'cwp 7/24/2009 00:41' forMethod: #'testEqual'.
true
%

category: 'initialize-release'
method: FSZipFilesystemTest
createFilesystem
	| ref |
	ref := FSMemoryFilesystem new referenceTo: 'fs.zip'. 
	^ (FSZipFilesystem atReference: ref)
		open;
		yourself
%
run
FSZipFilesystemTest setStamp: 'lr 2/20/2010 11:14' forMethod: #'createFilesystem'.
true
%

category: 'tests'
method: FSZipFilesystemTest
testOpenArchive
	| memory archive |
	memory := FSMemoryFilesystem new.
	memory root / 'fs.zip' writeStreamDo: [ :stream | stream nextPutAll: #[80 75 3 4 10 0 2 0 0 0 152 90 84 60 227 229 149 176 12 0 0 0 12 0 0 0 7 0 28 0 103 114 105 102 102 108 101 85 84 9 0 3 128 183 127 75 114 183 127 75 117 120 11 0 1 4 245 1 0 0 4 20 0 0 0 72 101 108 108 111 32 87 111 114 108 100 10 80 75 1 2 30 3 10 0 2 0 0 0 152 90 84 60 227 229 149 176 12 0 0 0 12 0 0 0 7 0 24 0 0 0 0 0 1 0 0 0 164 129 0 0 0 0 103 114 105 102 102 108 101 85 84 5 0 3 128 183 127 75 117 120 11 0 1 4 245 1 0 0 4 20 0 0 0 80 75 5 6 0 0 0 0 1 0 1 0 77 0 0 0 77 0 0 0 0 0] ].
	
	archive := FSZipFilesystem atReference: memory root / 'fs.zip'.
	archive open.
	self assert: (archive root children size = 1).
	self assert: (archive root / 'griffle') exists.
	self assert: (archive root / 'griffle') readStream contents = #[72 101 108 108 111 32 87 111 114 108 100 10]
%
run
FSZipFilesystemTest setStamp: 'lr 2/20/2010 23:14' forMethod: #'testOpenArchive'.
true
%

category: 'tests'
method: FSZipFilesystemTest
testWriteArchive
	| memory archive |
	memory := FSMemoryFilesystem new.
	archive := FSZipFilesystem atReference: memory root / 'fs.zip'.
	archive open.
	(archive root / 'griffle')
		writeStreamDo: [ :stream | stream nextPutAll: 'Hello World' ].
	archive close.
	
	self assert: (memory root / 'fs.zip') exists.
	self assert: (memory root / 'fs.zip') entry size > 0
%
run
FSZipFilesystemTest setStamp: 'lr 2/20/2010 22:45' forMethod: #'testWriteArchive'.
true
%

category: 'initialize-release'
method: FSFileHandle
setReference: aReference writable: aBoolean
	super setReference: aReference writable: aBoolean.
	mode := writable ifTrue: [ 'w+' ] ifFalse: [ 'r+' ].
%

category: 'initialize-release'
method: FSFileHandle
setReference: aReference mode: modeString
	super setReference: aReference writable: (modeString beginsWith: 'w').
	mode := modeString
%

category: 'running'
method: FSFileHandleTest
createFilesystem
	^ FSDiskFilesystem currentClass createDefault
%
run
FSFileHandleTest setStamp: 'cwp 10/11/2009 22:25' forMethod: #'createFilesystem'.
true
%

category: 'testing'
classmethod: FSHandleTest
isAbstract
	^ self name = #FSHandleTest
%
run
FSHandleTest class setStamp: 'cwp 7/26/2009 12:46' forMethod: #'isAbstract'.
true
%

category: 'testing'
classmethod: FSHandleTest
shouldInheritSelectors 
	^ true
%
run
FSHandleTest class setStamp: 'cwp 7/26/2009 12:46' forMethod: #'shouldInheritSelectors'.
true
%

category: 'running'
method: FSHandleTest
createFilesystem
	self subclassResponsibility
%
run
FSHandleTest setStamp: 'cwp 11/18/2009 10:23' forMethod: #'createFilesystem'.
true
%

category: 'running'
method: FSHandleTest
setUp
	filesystem := self createFilesystem.
	reference := filesystem referenceTo: 'plonk'.
	handle := reference openWritable: true
%
run
FSHandleTest setStamp: 'cwp 7/26/2009 12:22' forMethod: #'setUp'.
true
%

category: 'running'
method: FSHandleTest
tearDown
	handle close.
	reference delete
%
run
FSHandleTest setStamp: 'cwp 7/26/2009 12:23' forMethod: #'tearDown'.
true
%

category: 'tests'
method: FSHandleTest
testAt
	handle at: 1 write: (ByteArray with: 3) startingAt: 1 count: 1.
	self assert: (handle at: 1) = 3
%
run
FSHandleTest setStamp: 'cwp 7/29/2009 22:06' forMethod: #'testAt'.
true
%

category: 'tests'
method: FSHandleTest
testAtPut
	| in |
	handle at: 1 put: 3.
	in := ByteArray new: 1.
	handle at: 1 read: in startingAt: 1 count: 1.
	self assert: in first = 3
%
run
FSHandleTest setStamp: 'cwp 7/29/2009 22:03' forMethod: #'testAtPut'.
true
%

category: 'tests'
method: FSHandleTest
testAtPutBinaryAscii
	self shouldnt: [ handle at: 1 put: 32 ] raise: Error.
	self shouldnt: [ handle at: 1 put: Character space ] raise: Error
%
run
FSHandleTest setStamp: 'lr 4/13/2010 16:10' forMethod: #'testAtPutBinaryAscii'.
true
%

category: 'tests'
method: FSHandleTest
testAtWriteBinaryAscii
	self shouldnt: [ handle at: 1 write: #[32] startingAt: 1 count: 1 ] raise: Error.
	self shouldnt: [ handle at: 1 write: (String with: Character space) startingAt: 1 count: 1 ] raise: Error
%
run
FSHandleTest setStamp: 'lr 4/13/2010 16:07' forMethod: #'testAtWriteBinaryAscii'.
true
%

category: 'tests'
method: FSHandleTest
testClose
	handle close.
	self deny: handle isOpen
	
%
run
FSHandleTest setStamp: 'cwp 7/26/2009 12:23' forMethod: #'testClose'.
true
%

category: 'tests'
method: FSHandleTest
testCreatedOpen
	self assert: handle isOpen
%
run
FSHandleTest setStamp: 'cwp 7/26/2009 12:23' forMethod: #'testCreatedOpen'.
true
%

category: 'tests'
method: FSHandleTest
testIO
	| out in |
	out := #(1 2 3) asByteArray.
	in := ByteArray new: 3.
	handle at: 1 write: out startingAt: 1 count: 3.
	handle at: 1 read: in startingAt: 1 count: 3.
	self assert: out = in.
%
run
FSHandleTest setStamp: 'cwp 7/26/2009 14:15' forMethod: #'testIO'.
true
%

category: 'tests'
method: FSHandleTest
testReadBufferTooLarge
	| out in result |
	out := #(1 2 3) asByteArray.
	in := ByteArray new: 5.
	in atAllPut: 9.
	handle at: 1 write: out startingAt: 1 count: 3.
	result := handle at: 1 read: in startingAt: 2 count: 4.
	self assert: result = 3.
	self assert: in = #(9 1 2 3 9) asByteArray.
%
run
FSHandleTest setStamp: 'cwp 7/31/2009 00:13' forMethod: #'testReadBufferTooLarge'.
true
%

category: 'tests'
method: FSHandleTest
testReadOnly
true ifTrue: [ ^self ]. "not passing in 3.1 and not critical #expectedFailure"
	handle close.
	handle := reference openWritable: false.
	self 
		should: 
			[ handle 
				at: 1
				write: #(1 2 3 )
				startingAt: 1
				count: 3 ]
		raise: Error
%
run
FSHandleTest setStamp: 'cwp 7/26/2009 14:16' forMethod: #'testReadOnly'.
true
%

category: 'tests'
method: FSHandleTest
testReference
	self assert: handle reference = reference asAbsolute
%
run
FSHandleTest setStamp: 'cwp 7/26/2009 12:45' forMethod: #'testReference'.
true
%

category: 'tests'
method: FSHandleTest
testSizeAfterGrow
	| out |
	out := #(1 2 3) asByteArray.
	handle at: 1 write: out startingAt: 1 count: 3.
	self assert: handle size = 3
%
run
FSHandleTest setStamp: 'cwp 7/29/2009 22:11' forMethod: #'testSizeAfterGrow'.
true
%

category: 'tests'
method: FSHandleTest
testSizeNoGrow
	| bytes |
	bytes := #(1 2 3 4) asByteArray.
	handle at: 1 write: bytes startingAt: 1 count: 3.
	handle at: 4 write: bytes startingAt: 4 count: 1.
	self assert: handle size = 4
%
run
FSHandleTest setStamp: 'cwp 7/29/2009 22:13' forMethod: #'testSizeNoGrow'.
true
%

category: 'tests'
method: FSHandleTest
testTruncate
	| out |
true ifTrue: [ ^self ]. "not passing in 3.1 and not critical #expectedFailure"
	out := #(1 2 3 4 5) asByteArray.
	handle at: 1 write: out startingAt: 1 count: 5.
	handle truncateTo: 3.
	self assert: handle size = 3
%
run
FSHandleTest setStamp: 'cwp 7/26/2009 14:16' forMethod: #'testTruncate'.
true
%

category: 'tests'
method: FSHandleTest
testWriteStream
	| stream |
	stream := handle writeStream.
	self assert: (stream respondsTo: #nextPut:)
%
run
FSHandleTest setStamp: 'cwp 7/28/2009 22:40' forMethod: #'testWriteStream'.
true
%

category: 'running'
method: FSMemoryHandleTest
createFilesystem
	^ FSMemoryFilesystem new
%
run
FSMemoryHandleTest setStamp: 'cwp 7/26/2009 12:47' forMethod: #'createFilesystem'.
true
%

category: 'compatibility tests'
method: FSLocatorTest
testAsAbsolute
	locator := FSLocator testFile.
	self assert: locator asAbsolute = locator
%
run
FSLocatorTest setStamp: 'DaleHenrichs 10/18/2010 12:55' forMethod: #'testAsAbsolute'.
true
%

category: 'compatibility tests'
method: FSLocatorTest
testBasename
	locator := FSLocator testFile / 'griffle'.
	self assert: locator basename = 'griffle'
%
run
FSLocatorTest setStamp: 'DaleHenrichs 10/18/2010 12:55' forMethod: #'testBasename'.
true
%

category: 'compatibility tests'
method: FSLocatorTest
testCommaAddsExtension
	locator := FSLocator testFile / 'griffle'.
	self assert: (locator , 'plonk') basename = 'griffle.plonk'
%
run
FSLocatorTest setStamp: 'DaleHenrichs 10/18/2010 12:55' forMethod: #'testCommaAddsExtension'.
true
%

category: 'compatibility tests'
method: FSLocatorTest
testCommaAddsExtensionAgain
	locator := FSLocator testFile / 'griffle.plonk'.
	self assert: (locator , 'nurp') basename = 'griffle.plonk.nurp'
%
run
FSLocatorTest setStamp: 'DaleHenrichs 10/18/2010 12:55' forMethod: #'testCommaAddsExtensionAgain'.
true
%

category: 'compatibility tests'
method: FSLocatorTest
testContainsLocator
	locator := FSLocator testFile.
	self assert: (locator contains: locator / 'griffle').
%
run
FSLocatorTest setStamp: 'DaleHenrichs 10/18/2010 12:55' forMethod: #'testContainsLocator'.
true
%

category: 'compatibility tests'
method: FSLocatorTest
testContainsPath
	locator := FSLocator testFile.
	self assert: (locator contains: (locator resolve / 'griffle') path).
%
run
FSLocatorTest setStamp: 'DaleHenrichs 10/18/2010 12:55' forMethod: #'testContainsPath'.
true
%

category: 'compatibility tests'
method: FSLocatorTest
testContainsReference
	locator := FSLocator testFile.
	self assert: (locator contains: (locator resolve / 'griffle')).
%
run
FSLocatorTest setStamp: 'DaleHenrichs 10/18/2010 12:56' forMethod: #'testContainsReference'.
true
%

category: 'compatibility tests'
method: FSLocatorTest
testEqual
	| a b |
	a := FSLocator testFile.
	b := FSLocator testFile.
	self deny: a == b.
	self assert: a = b.
%
run
FSLocatorTest setStamp: 'DaleHenrichs 10/18/2010 12:56' forMethod: #'testEqual'.
true
%

category: 'compatibility tests'
method: FSLocatorTest
testFilesystem
	locator := FSLocator testFile.
	self assert: (locator filesystem isKindOf: FSDiskFilesystem)
%
run
FSLocatorTest setStamp: 'DaleHenrichs 10/18/2010 12:56' forMethod: #'testFilesystem'.
true
%

category: 'compatibility tests'
method: FSLocatorTest
testIsAbsolute
	locator := FSLocator testFile.
	self assert: locator isAbsolute
%
run
FSLocatorTest setStamp: 'DaleHenrichs 10/18/2010 12:50' forMethod: #'testIsAbsolute'.
true
%

category: 'compatibility tests'
method: FSLocatorTest
testIsNotRoot
	locator := FSLocator testFile.
	self deny: locator isRoot
%
run
FSLocatorTest setStamp: 'DaleHenrichs 10/18/2010 12:50' forMethod: #'testIsNotRoot'.
true
%

category: 'compatibility tests'
method: FSLocatorTest
testIsRelative
	locator := FSLocator testFile.
	self deny: locator isRelative
%
run
FSLocatorTest setStamp: 'DaleHenrichs 10/18/2010 12:50' forMethod: #'testIsRelative'.
true
%

category: 'compatibility tests'
method: FSLocatorTest
testIsRoot
	locator := FSLocator testFile.
	(locator resolve path size - 1) timesRepeat: [locator := locator / '..'].
	self assert: locator isRoot
%
run
FSLocatorTest setStamp: 'DaleHenrichs 10/18/2010 12:50' forMethod: #'testIsRoot'.
true
%

category: 'compatibility tests'
method: FSLocatorTest
testOriginBasename
	locator := FSLocator testFile.
	self assert: locator basename = (FSDiskFilesystem testFile basename)
%
run
FSLocatorTest setStamp: 'DaleHenrichs 10/18/2010 12:50' forMethod: #'testOriginBasename'.
true
%

category: 'compatibility tests'
method: FSLocatorTest
testParent
	locator := FSLocator testFile.
	self assert: locator parent resolve = FSDiskFilesystem testDirectory
%
run
FSLocatorTest setStamp: 'DaleHenrichs 10/18/2010 12:50' forMethod: #'testParent'.
true
%

category: 'resolution tests'
method: FSLocatorTest
testResolveAbsoluteReference
	| result reference |
	locator := FSLocator testFile / 'plonk'.
	reference := FSMemoryFilesystem new root / 'griffle'.
	result := locator resolve: reference.
	self assert: result == reference
%
run
FSLocatorTest setStamp: 'DaleHenrichs 10/18/2010 12:51' forMethod: #'testResolveAbsoluteReference'.
true
%

category: 'resolution tests'
method: FSLocatorTest
testResolveCompoundString
	| result compound |
	locator := FSLocator testFile / 'plonk'.
	compound := 'griffle', locator filesystem delimiter asString, 'nurp'.
	result := locator resolve: compound.
	self assert: result class = locator class.
	self assert: result origin = locator origin.
	self assert: result path = ((FSPath with: 'plonk') / 'griffle' / 'nurp')
%
run
FSLocatorTest setStamp: 'DaleHenrichs 10/18/2010 12:51' forMethod: #'testResolveCompoundString'.
true
%

category: 'resolution tests'
method: FSLocatorTest
testResolvePath
	| result path |
	locator := FSLocator testFile / 'plonk'.
	result := locator resolve: (FSPath with: 'griffle').
	path := (FSPath with: 'plonk') / 'griffle'.
	self assert: result class= locator class.
	self assert: result origin = locator origin.
	self assert: result path = path.
%
run
FSLocatorTest setStamp: 'DaleHenrichs 10/18/2010 12:51' forMethod: #'testResolvePath'.
true
%

category: 'resolution tests'
method: FSLocatorTest
testResolveRelativeReference
	| result reference |
	locator := FSLocator testFile / 'plonk'.
	reference := FSMemoryFilesystem new referenceTo: 'griffle'.
	result := locator resolve: reference.
	self assert: result class= locator class.
	self assert: result origin = locator origin.
	self assert: result path = reference path.
%
run
FSLocatorTest setStamp: 'DaleHenrichs 10/18/2010 12:51' forMethod: #'testResolveRelativeReference'.
true
%

category: 'resolution tests'
method: FSLocatorTest
testResolveString
	| result path |
	locator := FSLocator testFile / 'plonk'.
	result := locator resolve: 'griffle'.
	path := (FSPath with: 'plonk') / 'griffle'.
	self assert: result class= locator class.
	self assert: result origin = locator origin.
	self assert: result path = path.
%
run
FSLocatorTest setStamp: 'DaleHenrichs 10/18/2010 12:51' forMethod: #'testResolveString'.
true
%

category: 'compatibility tests'
method: FSLocatorTest
testSlash
	locator := FSLocator testFile / 'griffle'.
	self assert: locator = (FSLocator testFile / 'griffle')
%
run
FSLocatorTest setStamp: 'DaleHenrichs 10/18/2010 12:52' forMethod: #'testSlash'.
true
%

category: 'resolution tests'
method: FSLocatorTest
testTestFile
	locator := FSLocator testFile. 
	self assert: locator resolve = FSDiskFilesystem testFile
%
run
FSLocatorTest setStamp: 'DaleHenrichs 10/18/2010 12:51' forMethod: #'testTestFile'.
true
%

category: 'compatibility tests'
method: FSLocatorTest
testWithExtensionAddsExtension
	locator := FSLocator testFile / 'griffle'.
	self assert: (locator withExtension: 'plonk') basename = 'griffle.plonk'
%
run
FSLocatorTest setStamp: 'DaleHenrichs 10/18/2010 12:51' forMethod: #'testWithExtensionAddsExtension'.
true
%

category: 'compatibility tests'
method: FSLocatorTest
testWithExtensionReplacesExtension
	locator := FSLocator testFile / 'griffle.nurp'.
	self assert: (locator withExtension: 'plonk') basename = 'griffle.plonk'
%
run
FSLocatorTest setStamp: 'DaleHenrichs 10/18/2010 12:52' forMethod: #'testWithExtensionReplacesExtension'.
true
%

category: 'tests'
method: FSPathTest
testAsReference
	| path reference |
	path := FSPath with: 'plonk'.
	reference := path asReference.
	self assert: reference class = FSReference.
	self assert: reference path = path
%
run
FSPathTest setStamp: 'cwp 10/10/2009 18:11' forMethod: #'testAsReference'.
true
%

category: 'tests'
method: FSPathTest
testBasename
	| path |
	path := (FSPath with: 'plonk') / 'griffle'.
	self assert: path basename = 'griffle'
%
run
FSPathTest setStamp: 'cwp 10/10/2009 17:48' forMethod: #'testBasename'.
true
%

category: 'tests'
method: FSPathTest
testCommaAddsExtension
	| path result |
	path := FSPath with: 'plonk' .
	result := path, 'griffle'.
	self assert: result asString = 'plonk.griffle'
%
run
FSPathTest setStamp: 'cwp 11/17/2009 13:03' forMethod: #'testCommaAddsExtension'.
true
%

category: 'tests'
method: FSPathTest
testCommaAddsExtensionAgain
	| path result |
	path := FSPath with: 'plonk.griffle'.
	result := path, 'nurp'.
	self assert: result basename = 'plonk.griffle.nurp'
%
run
FSPathTest setStamp: 'cwp 11/17/2009 23:39' forMethod: #'testCommaAddsExtensionAgain'.
true
%

category: 'tests'
method: FSPathTest
testContains
	| ancestor descendent |
	ancestor := FSPath / 'plonk'.
	descendent := FSPath / 'plonk' / 'griffle' / 'bork'.
	self assert: (ancestor contains: descendent).
	self deny: (descendent contains: ancestor)
%
run
FSPathTest setStamp: 'cwp 8/30/2009 15:07' forMethod: #'testContains'.
true
%

category: 'tests'
method: FSPathTest
testContainsLocator
	| ancestor descendent |
	ancestor := FSDiskFilesystem testDirectory path.
	descendent := FSLocator testFile / 'griffle'.
	self deny: (ancestor contains: descendent).
	self deny: (descendent contains: ancestor)
%
run
FSPathTest setStamp: 'DaleHenrichs 10/18/2010 12:55' forMethod: #'testContainsLocator'.
true
%

category: 'tests'
method: FSPathTest
testEqual
	| a b |
	a := FSPath with: 'plonk'.
	b := FSPath with: 'plonk'.
	self deny: a == b.
	self assert: a = b.
%
run
FSPathTest setStamp: 'cwp 10/10/2009 17:49' forMethod: #'testEqual'.
true
%

category: 'tests'
method: FSPathTest
testGrandchildOfPath
	| griffle  nurb |
	griffle := FSPath / 'griffle'.
	nurb := griffle / 'plonk' / 'nurb'.
	self deny: (griffle isChildOf: nurb).
	self deny: (nurb isChildOf: griffle).
%
run
FSPathTest setStamp: 'cwp 11/16/2009 09:37' forMethod: #'testGrandchildOfPath'.
true
%

category: 'tests'
method: FSPathTest
testIsAbsolute
	self assert: (FSPath / 'plonk') isAbsolute
%
run
FSPathTest setStamp: 'cwp 10/10/2009 17:49' forMethod: #'testIsAbsolute'.
true
%

category: 'tests'
method: FSPathTest
testIsChildOfPath
	| parent child |
	parent := FSPath / 'griffle'.
	child := parent / 'nurb'.
	self assert: (child isChildOf: parent).
	self deny: (parent isChildOf: child)
%
run
FSPathTest setStamp: 'cwp 11/16/2009 09:34' forMethod: #'testIsChildOfPath'.
true
%

category: 'tests'
method: FSPathTest
testIsChildOfReference
	| parent child |
	parent := FSPath / 'griffle'.
	child := (FSMemoryFilesystem new referenceTo: parent / 'nurb').
	self deny: (child isChildOf: parent).
	self deny: (parent isChildOf: child)
%
run
FSPathTest setStamp: 'cwp 11/16/2009 09:36' forMethod: #'testIsChildOfReference'.
true
%

category: 'tests'
method: FSPathTest
testIsNotAbsolute
	self deny: (FSPath with: 'plonk') isAbsolute
%
run
FSPathTest setStamp: 'cwp 10/10/2009 17:49' forMethod: #'testIsNotAbsolute'.
true
%

category: 'tests'
method: FSPathTest
testIsNotRelative
	self deny: (FSPath / 'plonk') isRelative
%
run
FSPathTest setStamp: 'cwp 10/10/2009 17:49' forMethod: #'testIsNotRelative'.
true
%

category: 'tests'
method: FSPathTest
testIsNotRoot
	self deny: (FSPath root / 'plonk') isRoot
%
run
FSPathTest setStamp: 'cwp 7/17/2009 05:23' forMethod: #'testIsNotRoot'.
true
%

category: 'tests'
method: FSPathTest
testIsRelative
	self assert: (FSPath with: 'plonk') isRelative
%
run
FSPathTest setStamp: 'cwp 10/10/2009 17:50' forMethod: #'testIsRelative'.
true
%

category: 'tests'
method: FSPathTest
testIsRoot
	self assert: FSPath root isRoot
%
run
FSPathTest setStamp: 'cwp 7/17/2009 05:23' forMethod: #'testIsRoot'.
true
%

category: 'tests'
method: FSPathTest
testParent
	| path parent |
	path := (FSPath with: 'plonk') / 'griffle'.
	parent := path parent.
	self assert: parent class = path class.
	self assert: parent asString = 'plonk'
%
run
FSPathTest setStamp: 'cwp 11/17/2009 13:03' forMethod: #'testParent'.
true
%

category: 'tests'
method: FSPathTest
testParentParent
	| path  |
	path := (FSPath with: '..') parent.
	self assert: path size = 2.
	self assert: (path at: 1) = '..'.
	self assert: (path at: 2) = '..'.
%
run
FSPathTest setStamp: 'cwp 10/25/2009 19:49' forMethod: #'testParentParent'.
true
%

category: 'tests'
method: FSPathTest
testParentResolution
	| base relative absolute |
	base := FSPath / 'plonk' / 'pinto'.
	relative := FSPath parent / 'griffle' / 'zonk'.
	absolute := base resolve: relative.
	self assert: (absolute printWithDelimiter: $/) = '/plonk/griffle/zonk'
%
run
FSPathTest setStamp: 'cwp 10/10/2009 17:51' forMethod: #'testParentResolution'.
true
%

category: 'tests'
method: FSPathTest
testParseTrailingSlash
	| path |
	path := FSPath readFrom: 'griffle/' readStream delimiter: $/.
	self assert: path size = 1.
	self assert: (path at: 1) = 'griffle'
%
run
FSPathTest setStamp: 'cwp 10/26/2009 13:27' forMethod: #'testParseTrailingSlash'.
true
%

category: 'tests'
method: FSPathTest
testPrintWithDelimiter
	| path |
	path := (FSPath with: 'plonk') / 'griffle'.
	self assert: (path printWithDelimiter: $%) = 'plonk%griffle'
%
run
FSPathTest setStamp: 'cwp 10/10/2009 17:52' forMethod: #'testPrintWithDelimiter'.
true
%

category: 'tests'
method: FSPathTest
testRelativeTo
	| parent child relative |
	parent := FSPath / 'griffle'.
	child := FSPath / 'griffle' / 'plonk' / 'nurp'.
	relative := child relativeTo: parent.
	self assert: relative = (FSPath * 'plonk' / 'nurp')
%
run
FSPathTest setStamp: 'cwp 11/15/2009 00:20' forMethod: #'testRelativeTo'.
true
%

category: 'tests'
method: FSPathTest
testRelativeToBranch
	| parent child relative |
	parent := FSPath / 'griffle' / 'bibb'.
	child := FSPath / 'griffle' / 'plonk' / 'nurp'.
	relative := child relativeTo: parent.
	self assert: relative = (FSPath parent / 'plonk' / 'nurp')
%
run
FSPathTest setStamp: 'cwp 11/15/2009 00:21' forMethod: #'testRelativeToBranch'.
true
%

category: 'tests'
method: FSPathTest
testRelativeWithParent
	| path |
	path := FSPath withAll: #('..' 'foo').
	self assert: (path printWithDelimiter: $/) = '../foo'
%
run
FSPathTest setStamp: 'cwp 10/11/2009 13:08' forMethod: #'testRelativeWithParent'.
true
%

category: 'tests'
method: FSPathTest
testResolve
	| path |
	path := FSPath / 'griffle'.
	self assert: path resolve == path
%
run
FSPathTest setStamp: 'cwp 11/16/2009 10:18' forMethod: #'testResolve'.
true
%

category: 'tests'
method: FSPathTest
testResolveString
	| path result |
	path := FSPath with: 'plonk'.
	result := path resolve: 'griffle'.
	self assert: result class = path class.
	self assert: result size = 2.
	self assert: (result at: 1) = 'plonk'.
	self assert: (result at: 2) = 'griffle'.
%
run
FSPathTest setStamp: 'cwp 10/25/2009 21:40' forMethod: #'testResolveString'.
true
%

category: 'tests'
method: FSPathTest
testRootParent
	| root |
	root := FSPath root.
	self assert: root parent == root
%
run
FSPathTest setStamp: 'cwp 7/17/2009 23:40' forMethod: #'testRootParent'.
true
%

category: 'tests'
method: FSPathTest
testSiblingOfPath
	| griffle  nurb |
	griffle := FSPath / 'griffle'.
	nurb := FSPath / 'nurb'.
	self deny: (griffle isChildOf: nurb).
	self deny: (nurb isChildOf: griffle).
%
run
FSPathTest setStamp: 'cwp 11/16/2009 09:38' forMethod: #'testSiblingOfPath'.
true
%

category: 'tests'
method: FSPathTest
testSimpleResolution
	| base relative absolute |
	base := FSPath / 'plonk'.
	relative := (FSPath with: 'griffle') / 'zonk'.
	absolute := base resolve: relative.
	self assert: (absolute printWithDelimiter: $/) = '/plonk/griffle/zonk'
%
run
FSPathTest setStamp: 'cwp 10/10/2009 17:53' forMethod: #'testSimpleResolution'.
true
%

category: 'tests'
method: FSPathTest
testSlash
	| path actual |
	path := FSPath with: 'plonk'.
	actual := path / 'griffle'.
	self assert: actual class = FSPath.
	self assert: (actual printWithDelimiter: $/)  = 'plonk/griffle'
%
run
FSPathTest setStamp: 'cwp 10/10/2009 17:53' forMethod: #'testSlash'.
true
%

category: 'tests'
method: FSPathTest
testUnequalContent
	| a b |
	a := FSPath with: 'plonk'.
	b := FSPath with: 'griffle'.
	self deny: a = b.
%
run
FSPathTest setStamp: 'cwp 10/10/2009 17:54' forMethod: #'testUnequalContent'.
true
%

category: 'tests'
method: FSPathTest
testUnequalSize
	| a b |
	a := FSPath with: 'plonk'.
	b := (FSPath with: 'plonk') / 'griffle'.
	self deny: a = b.
%
run
FSPathTest setStamp: 'cwp 10/10/2009 17:54' forMethod: #'testUnequalSize'.
true
%

category: 'tests'
method: FSPathTest
testWithExtentionAddsExtension
	| path result |
	path := FSPath with: 'plonk'.
	result := path withExtension: 'griffle'.
	self assert: result asString = 'plonk.griffle'
%
run
FSPathTest setStamp: 'cwp 11/17/2009 23:26' forMethod: #'testWithExtentionAddsExtension'.
true
%

category: 'tests'
method: FSPathTest
testWithExtentionReplacesExtension
	| path result |
	path := FSPath with: 'plonk.griffle'.
	result := path withExtension: 'griffle'.
	self assert: result basename = 'plonk.griffle'
%
run
FSPathTest setStamp: 'cwp 11/17/2009 23:45' forMethod: #'testWithExtentionReplacesExtension'.
true
%

category: 'tests'
method: FSPathTest
testWorkingDirectoryParent
	| path |
	path := FSPath empty parent.
	self assert: path size = 1.
	self assert: (path at: 1) = '..'
%
run
FSPathTest setStamp: 'cwp 10/25/2009 19:44' forMethod: #'testWorkingDirectoryParent'.
true
%

category: 'support'
method: FSReadStreamTest
contents: aByteArray
	stream := filesystem writeStreamOn: 'griffle'.
	stream nextPutAll: aByteArray.
	stream close.
	stream := filesystem readStreamOn: 'griffle'
%
run
FSReadStreamTest setStamp: 'cwp 7/29/2009 22:43' forMethod: #'contents:'.
true
%

category: 'running'
method: FSReadStreamTest
setUp
	filesystem := FSMemoryFilesystem new.
	
%
run
FSReadStreamTest setStamp: 'cwp 7/29/2009 22:40' forMethod: #'setUp'.
true
%

category: 'tests'
method: FSReadStreamTest
testAtEnd
	self contents: #().
	self assert: stream atEnd
%
run
FSReadStreamTest setStamp: 'cwp 7/29/2009 22:38' forMethod: #'testAtEnd'.
true
%

category: 'tests'
method: FSReadStreamTest
testDo
	| contents |
	self contents: #(1 2 3).
	contents := Array streamContents:
		[:out |
		stream do: [:ea | out nextPut: ea]].
	self assert: contents = #(1 2 3)
%
run
FSReadStreamTest setStamp: 'cwp 7/29/2009 22:57' forMethod: #'testDo'.
true
%

category: 'tests'
method: FSReadStreamTest
testNext
	self contents: #(1 2 3).
	self assert: stream next = 1
%
run
FSReadStreamTest setStamp: 'cwp 7/29/2009 23:00' forMethod: #'testNext'.
true
%

category: 'tests'
method: FSReadStreamTest
testNextColon
	| result |
	self contents: #(1 2 3 4 5).
	result := stream next: 3.
	self assert: result = #(1 2 3) asByteArray.
%
run
FSReadStreamTest setStamp: 'cwp 7/29/2009 23:07' forMethod: #'testNextColon'.
true
%

category: 'tests'
method: FSReadStreamTest
testNextInto
	| result buffer |
	self contents: #(1 2 3 4 5).
	buffer := ByteArray new: 3.
	result := stream nextInto: buffer.
	self assert: result == buffer.
	self assert: result = #(1 2 3) asByteArray
%
run
FSReadStreamTest setStamp: 'cwp 7/30/2009 23:54' forMethod: #'testNextInto'.
true
%

category: 'tests'
method: FSReadStreamTest
testNextLineCR
	| result tail |
	self contents: #(97 97 97 13 98 98 98).
	result := stream nextLine.
	self assert: result = #(97 97 97) asByteArray.
	tail := stream next: 3.
	self assert: tail = #(98 98 98) asByteArray
%
run
FSReadStreamTest setStamp: 'cwp 7/29/2009 23:30' forMethod: #'testNextLineCR'.
true
%

category: 'tests'
method: FSReadStreamTest
testNextLineCRLF
	| line tail |
	self contents: #(97 97 97 13 10 98 98 98).
	line := stream nextLine.
	self assert: line = #(97 97 97) asByteArray.
	tail := stream next: 3.
	self assert: tail = #(98 98 98) asByteArray
%
run
FSReadStreamTest setStamp: 'cwp 7/29/2009 23:31' forMethod: #'testNextLineCRLF'.
true
%

category: 'tests'
method: FSReadStreamTest
testNextLineLF
	| result tail |
	self contents: #(97 97 97 10 98 98 98).
	result := stream nextLine.
	self assert: result = #(97 97 97) asByteArray.
	tail := stream next: 3.
	self assert: tail = #(98 98 98) asByteArray
%
run
FSReadStreamTest setStamp: 'cwp 7/29/2009 23:31' forMethod: #'testNextLineLF'.
true
%

category: 'tests'
method: FSReadStreamTest
testNextMatchFalse
	self contents: #(1 2 3).
	self deny: (stream nextMatchFor: 5)
%
run
FSReadStreamTest setStamp: 'cwp 7/30/2009 23:04' forMethod: #'testNextMatchFalse'.
true
%

category: 'tests'
method: FSReadStreamTest
testNextMatchTrue
	self contents: #(1 2 3).
	self assert: (stream nextMatchFor: 1)
%
run
FSReadStreamTest setStamp: 'cwp 7/30/2009 23:01' forMethod: #'testNextMatchTrue'.
true
%

category: 'tests'
method: FSReadStreamTest
testNotAtEnd
	self contents: #(1 2 3).
	self deny: stream atEnd
%
run
FSReadStreamTest setStamp: 'cwp 7/29/2009 22:46' forMethod: #'testNotAtEnd'.
true
%

category: 'tests'
method: FSReadStreamTest
testPeek
	self contents: #(1 2 3).
	self assert: stream peek = 1.
	self assert: stream next = 1.
%
run
FSReadStreamTest setStamp: 'cwp 7/30/2009 23:05' forMethod: #'testPeek'.
true
%

category: 'tests'
method: FSReadStreamTest
testPeekForFalse
	self contents: #(1 2 3).
	self deny: (stream peekFor: 5)
	
%
run
FSReadStreamTest setStamp: 'cwp 7/30/2009 23:06' forMethod: #'testPeekForFalse'.
true
%

category: 'tests'
method: FSReadStreamTest
testPeekForTrue
	self contents: #(1 2 3).
	self assert: (stream peekFor: 1)
	
%
run
FSReadStreamTest setStamp: 'cwp 7/30/2009 23:06' forMethod: #'testPeekForTrue'.
true
%

category: 'tests'
method: FSReadStreamTest
testSkip
	self contents: #(1 2 3 4 5).
	stream skip: 3.
	self assert: stream position = 3
%
run
FSReadStreamTest setStamp: 'DaleHenrichs 10/20/2010 16:35' forMethod: #'testSkip'.
true
%

category: 'tests'
method: FSReadStreamTest
testSkipPastEnd
	self contents: #(1 2 3 4 5).
	stream skip: 10.
	self assert: stream atEnd
%
run
FSReadStreamTest setStamp: 'cwp 7/30/2009 23:18' forMethod: #'testSkipPastEnd'.
true
%

category: 'tests'
method: FSReadStreamTest
testSkipTo
	self contents: #(1 2 3 4 5).
	stream skipTo: 3.
	self assert: stream position = 3
%
run
FSReadStreamTest setStamp: 'DaleHenrichs 10/20/2010 16:35' forMethod: #'testSkipTo'.
true
%

category: 'tests'
method: FSReadStreamTest
testSkipToEnd
	self contents: #(1 2 3 4 5).
	stream skipTo: 10.
	self assert: stream atEnd
%
run
FSReadStreamTest setStamp: 'cwp 7/30/2009 23:24' forMethod: #'testSkipToEnd'.
true
%

category: 'tests'
method: FSReadStreamTest
testSkipToFalse
	self contents: #(1 2 3 4 5).
	self deny: (stream skipTo: 10).
	
%
run
FSReadStreamTest setStamp: 'cwp 7/30/2009 23:27' forMethod: #'testSkipToFalse'.
true
%

category: 'tests'
method: FSReadStreamTest
testSkipToTrue
	self contents: #(1 2 3 4 5).
	self assert: (stream skipTo: 4).
	
%
run
FSReadStreamTest setStamp: 'cwp 7/30/2009 23:25' forMethod: #'testSkipToTrue'.
true
%

category: 'tests'
method: FSReadStreamTest
testUpTo
	| result |
	self contents: #(1 2 3 4 5).
	result := stream upTo: 4.
	self assert: result = #(1 2 3) asByteArray
%
run
FSReadStreamTest setStamp: 'cwp 7/30/2009 23:38' forMethod: #'testUpTo'.
true
%

category: 'tests'
method: FSReadStreamTest
testUpToEnd
	| result |
	self contents: #(1 2 3 4 5).
	result := stream upTo: 7.
	self assert: result = #(1 2 3 4 5) asByteArray
%
run
FSReadStreamTest setStamp: 'cwp 7/30/2009 23:38' forMethod: #'testUpToEnd'.
true
%

category: 'tests'
method: FSReferenceCreationTest
testCPath
	| ref |
	ref := FSReference C / 'WINDOWS'.
	self assert: (ref filesystem isKindOf: FSWindowsFilesystem).
	self assert: ref filesystem disk = 'C'.
	self assert: ref path = (FSPath / 'WINDOWS')
%
run
FSReferenceCreationTest setStamp: 'cwp 11/21/2009 11:56' forMethod: #'testCPath'.
true
%

category: 'tests'
method: FSReferenceCreationTest
testRoots
	| roots |
	roots := FSReference roots.
	self deny: roots isEmpty.
	roots do:
		[:ref |
		self assert: ref class = FSReference.
		self assert: ref path isRoot].
	self assert: (roots collect: [:ea | ea filesystem]) asSet size = roots size.
	
%
run
FSReferenceCreationTest setStamp: 'cwp 11/21/2009 12:17' forMethod: #'testRoots'.
true
%

category: 'support'
method: FSReferenceTest
createFile: aPath
	filesystem ensureDirectory: aPath parent.
	(filesystem writeStreamOn: aPath) close
%
run
FSReferenceTest setStamp: 'cwp 11/17/2009 21:23' forMethod: #'createFile:'.
true
%

category: 'running'
method: FSReferenceTest
setUp
	filesystem := FSMemoryFilesystem new.
%
run
FSReferenceTest setStamp: 'cwp 7/20/2009 09:06' forMethod: #'setUp'.
true
%

category: 'tests'
method: FSReferenceTest
testAllChildren
	| ref children |
	filesystem createDirectory: '/alpha'.
	filesystem createDirectory: '/alpha/beta'.
	filesystem createDirectory: '/alpha/beta/delta'.
	filesystem createDirectory: '/alpha/gamma'.
	
	ref := filesystem referenceTo: '/alpha'.
	children := ref allChildren.
	self assert: children size = 4.
	children do:
		[:child |
		self assert: child class = FSReference.
		self assert: (ref = child or: [ref contains: child])].
	self assert: (children collect: [:ea | ea basename]) = #('alpha' 'beta' 'gamma' 'delta')
%
run
FSReferenceTest setStamp: 'cwp 11/17/2009 16:44' forMethod: #'testAllChildren'.
true
%

category: 'tests'
method: FSReferenceTest
testAllEntries
	| ref entries |
	filesystem createDirectory: '/alpha'.
	filesystem createDirectory: '/alpha/beta'.
	filesystem createDirectory: '/alpha/beta/delta'.
	filesystem createDirectory: '/alpha/gamma'.
	
	ref := filesystem referenceTo: '/alpha'.
	entries := ref allEntries.
	self assert: entries size = 4.
	entries do:
		[:entry |
		self assert: entry class = FSDirectoryEntry.
		self assert: (ref = entry reference or: [ref contains: entry reference])].
	self assert: (entries collect: [:ea | ea basename]) = #('alpha' 'beta' 'gamma' 'delta')
%
run
FSReferenceTest setStamp: 'cwp 11/17/2009 16:44' forMethod: #'testAllEntries'.
true
%

category: 'tests'
method: FSReferenceTest
testAsAbsoluteConverted
	| ref absolute |
	ref := filesystem referenceTo: 'plonk'.
	absolute := ref asAbsolute.
	self assert: absolute isAbsolute.
	self assert: absolute asString = 'memory:/plonk'
%
run
FSReferenceTest setStamp: 'cwp 10/11/2009 22:38' forMethod: #'testAsAbsoluteConverted'.
true
%

category: 'tests'
method: FSReferenceTest
testAsAbsoluteIdentity
	| ref |
	ref := filesystem referenceTo: '/plonk'.
	self assert: ref asAbsolute == ref
%
run
FSReferenceTest setStamp: 'cwp 7/22/2009 08:30' forMethod: #'testAsAbsoluteIdentity'.
true
%

category: 'tests'
method: FSReferenceTest
testAsReference
	| ref |
	ref := filesystem referenceTo: 'plonk'.
	self assert: ref asReference == ref
%
run
FSReferenceTest setStamp: 'cwp 7/20/2009 09:08' forMethod: #'testAsReference'.
true
%

category: 'tests'
method: FSReferenceTest
testBasename
	| ref |
	ref := filesystem referenceTo: 'plonk/griffle'.
	self assert: ref basename = 'griffle'
%
run
FSReferenceTest setStamp: 'cwp 7/20/2009 09:17' forMethod: #'testBasename'.
true
%

category: 'tests'
method: FSReferenceTest
testChildDirectories
	| childDirectories |
	filesystem createDirectory: '/beta'.
	filesystem createDirectory: '/gamma'.	
	(filesystem referenceTo: '/delta')
		writeStreamDo: [ :stream | stream nextPutAll: '1' ].
	(filesystem referenceTo: '/epsilon')
		writeStreamDo: [ :stream | stream nextPutAll: '2' ].
	childDirectories := filesystem root childDirectories.
	self assert: childDirectories size = 2.
	childDirectories do: [ :each | 
		self assert: each class = FSReference.
		self assert: each isDirectory description: 'Collection should not contain references to files.' ]
%
run
FSReferenceTest setStamp: 'lr 4/26/2010 21:14' forMethod: #'testChildDirectories'.
true
%

category: 'tests'
method: FSReferenceTest
testChildFiles
	| childFiles |
	filesystem createDirectory: '/beta'.
	filesystem createDirectory: '/gamma'.	
	(filesystem referenceTo: '/delta')
		writeStreamDo: [ :stream | stream nextPutAll: '1' ].
	(filesystem referenceTo: '/epsilon')
		writeStreamDo: [ :stream | stream nextPutAll: '2' ].
	childFiles := filesystem root childFiles.
	self assert: childFiles size = 2.
	childFiles do: [ :each | 
		self assert: each class = FSReference.
		self assert: each isFile description: 'Collection should not contain references to directories.' ]
%
run
FSReferenceTest setStamp: 'lr 4/26/2010 21:14' forMethod: #'testChildFiles'.
true
%

category: 'tests'
method: FSReferenceTest
testChildOfPath
	| parent  child |
	parent := FSPath / 'griffle'.
	child := filesystem referenceTo: '/griffle/nurb'.
	self deny: (child isChildOf: parent).
	self deny: (parent isChildOf: child).
%
run
FSReferenceTest setStamp: 'cwp 11/16/2009 09:33' forMethod: #'testChildOfPath'.
true
%

category: 'tests'
method: FSReferenceTest
testChildOfReference
	| parent  child |
	parent := filesystem referenceTo: '/griffle'.
	child := filesystem referenceTo: '/griffle/nurb'.
	self assert: (child isChildOf: parent).
	self deny: (parent isChildOf: child).
%
run
FSReferenceTest setStamp: 'cwp 11/16/2009 09:31' forMethod: #'testChildOfReference'.
true
%

category: 'tests'
method: FSReferenceTest
testChildren
	| ref children |
	filesystem createDirectory: '/alpha'.
	filesystem createDirectory: '/alpha/beta'.
	filesystem createDirectory: '/alpha/gamma'.
	
	ref := filesystem referenceTo: '/alpha'.
	children := ref children.
	self assert: children size = 2.
	children do:
		[:child |
		self assert: child class = FSReference.
		self assert: (child isChildOf: ref).
		self assert: (#('beta' 'gamma') includes: child basename)]
%
run
FSReferenceTest setStamp: 'cwp 11/16/2009 09:02' forMethod: #'testChildren'.
true
%

category: 'tests'
method: FSReferenceTest
testCommaAddsExtension
	| ref result |
	ref := filesystem referenceTo: 'plonk'.
	result := ref, 'griffle'.
	self assert: result basename = 'plonk.griffle'
%
run
FSReferenceTest setStamp: 'cwp 10/25/2009 11:11' forMethod: #'testCommaAddsExtension'.
true
%

category: 'tests'
method: FSReferenceTest
testCommaAddsExtensionAgain
	| ref result |
	ref := filesystem referenceTo: 'plonk.griffle'.
	result := ref, 'nurp'.
	self assert: result basename = 'plonk.griffle.nurp'
%
run
FSReferenceTest setStamp: 'cwp 11/17/2009 23:53' forMethod: #'testCommaAddsExtensionAgain'.
true
%

category: 'tests'
method: FSReferenceTest
testContainsLocator
	| ref |
	ref := FSDiskFilesystem testDirectory parent.
	self assert: (ref contains: FSLocator testFile)
%
run
FSReferenceTest setStamp: 'DaleHenrichs 10/18/2010 11:06' forMethod: #'testContainsLocator'.
true
%

category: 'tests'
method: FSReferenceTest
testContainsPath
	| ref |
	ref := filesystem referenceTo: (FSPath with: 'griffle').
	self assert: (ref contains: (ref / 'nurp') path)
%
run
FSReferenceTest setStamp: 'cwp 10/26/2009 00:53' forMethod: #'testContainsPath'.
true
%

category: 'tests'
method: FSReferenceTest
testContainsReference
	| ref |
	ref := filesystem referenceTo: (FSPath with: 'griffle').
	self assert: (ref contains: ref / 'nurp')
%
run
FSReferenceTest setStamp: 'cwp 10/26/2009 00:50' forMethod: #'testContainsReference'.
true
%

category: 'tests'
method: FSReferenceTest
testDoesntContainLocator
	| ref |
	ref := filesystem referenceTo: 'griffle'. 
	self deny: (ref contains: FSLocator testFile)
%
run
FSReferenceTest setStamp: 'DaleHenrichs 10/18/2010 11:07' forMethod: #'testDoesntContainLocator'.
true
%

category: 'tests'
method: FSReferenceTest
testDoesntContainPath
	| ref |
	ref := filesystem referenceTo: (FSPath with: 'griffle').
	self deny: (ref contains: (FSPath with: 'nurp'))
%
run
FSReferenceTest setStamp: 'cwp 10/26/2009 00:54' forMethod: #'testDoesntContainPath'.
true
%

category: 'tests'
method: FSReferenceTest
testDoesntContainReferenceFilesystem
	| ref other |
	ref := filesystem referenceTo: (FSPath with: 'griffle').
	other := FSMemoryFilesystem new referenceTo: 'griffle/nurp'.
	self deny: (ref contains: other)
%
run
FSReferenceTest setStamp: 'cwp 10/26/2009 00:52' forMethod: #'testDoesntContainReferenceFilesystem'.
true
%

category: 'tests'
method: FSReferenceTest
testDoesntContainReferencePath
	| ref other |
	ref := filesystem referenceTo: (FSPath with: 'griffle').
	other := filesystem referenceTo: (FSPath with: 'nurp').
	self deny: (ref contains: other)
%
run
FSReferenceTest setStamp: 'cwp 10/26/2009 00:52' forMethod: #'testDoesntContainReferencePath'.
true
%

category: 'tests'
method: FSReferenceTest
testEntries
	| ref entries |
	filesystem createDirectory: '/alpha'.
	filesystem createDirectory: '/alpha/beta'.
	filesystem createDirectory: '/alpha/gamma'.
	
	ref := filesystem referenceTo: '/alpha'.
	entries := ref entries.
	self assert: entries size = 2.
	entries do:
		[:entry |
		self assert: entry class = FSDirectoryEntry.
		self assert: (entry reference isChildOf: ref).
		self assert: (#('beta' 'gamma') includes: entry reference basename)]
%
run
FSReferenceTest setStamp: 'cwp 11/16/2009 10:22' forMethod: #'testEntries'.
true
%

category: 'tests'
method: FSReferenceTest
testEqual
	| a b |
	a := filesystem referenceTo: 'plonk'.
	b := filesystem referenceTo: 'plonk'.
	self deny: a == b.
	self assert: a = b.
%
run
FSReferenceTest setStamp: 'cwp 7/20/2009 09:21' forMethod: #'testEqual'.
true
%

category: 'tests'
method: FSReferenceTest
testGrandchildOfReference
	| griffle  nurb |
	griffle := filesystem referenceTo: '/griffle'.
	nurb := filesystem referenceTo: '/griffle/plonk/nurb'.
	self deny: (griffle isChildOf: nurb).
	self deny: (nurb isChildOf: griffle).
%
run
FSReferenceTest setStamp: 'cwp 11/16/2009 09:32' forMethod: #'testGrandchildOfReference'.
true
%

category: 'tests'
method: FSReferenceTest
testIsAbsolute
	self assert: (filesystem referenceTo: '/plonk') isAbsolute
%
run
FSReferenceTest setStamp: 'cwp 7/20/2009 09:23' forMethod: #'testIsAbsolute'.
true
%

category: 'tests'
method: FSReferenceTest
testIsNotAbsolute
	self deny: (filesystem referenceTo: 'plonk') isAbsolute
%
run
FSReferenceTest setStamp: 'cwp 7/20/2009 09:24' forMethod: #'testIsNotAbsolute'.
true
%

category: 'tests'
method: FSReferenceTest
testIsNotRelative
	self deny: (filesystem referenceTo: '/plonk') isRelative
%
run
FSReferenceTest setStamp: 'cwp 7/20/2009 09:25' forMethod: #'testIsNotRelative'.
true
%

category: 'tests'
method: FSReferenceTest
testIsNotRoot
	self deny: (filesystem referenceTo: FSPath root / 'plonk') isRoot
%
run
FSReferenceTest setStamp: 'cwp 7/20/2009 09:26' forMethod: #'testIsNotRoot'.
true
%

category: 'tests'
method: FSReferenceTest
testIsRelative
	self assert: (filesystem referenceTo: 'plonk') isRelative
%
run
FSReferenceTest setStamp: 'cwp 7/20/2009 09:26' forMethod: #'testIsRelative'.
true
%

category: 'tests'
method: FSReferenceTest
testIsRoot
	self assert: (filesystem referenceTo: FSPath root) isRoot
%
run
FSReferenceTest setStamp: 'cwp 7/20/2009 09:27' forMethod: #'testIsRoot'.
true
%

category: 'tests'
method: FSReferenceTest
testParent
	| ref parent |
	ref := (filesystem referenceTo: 'plonk/griffle').
	parent := ref parent.
	self assert: parent class = ref class.
	self assert: parent asString = 'memory:plonk'
%
run
FSReferenceTest setStamp: 'cwp 7/20/2009 09:27' forMethod: #'testParent'.
true
%

category: 'tests'
method: FSReferenceTest
testParentResolutionWithAbsoluteReference
	| base relative absolute |
	base := (filesystem referenceTo: '/plonk/pinto').
	relative := (FSMemoryFilesystem new referenceTo: '/griffle/zonk').
	absolute := base resolve: relative.
	self assert: absolute filesystem == relative filesystem.
	self assert: (absolute path printWithDelimiter: $/) = '/griffle/zonk'
%
run
FSReferenceTest setStamp: 'cwp 10/11/2009 16:55' forMethod: #'testParentResolutionWithAbsoluteReference'.
true
%

category: 'tests'
method: FSReferenceTest
testParentResolutionWithPath
	| base relative absolute |
	base := filesystem referenceTo: (FSPath / 'plonk' / 'pinto').
	relative := FSPath parent / 'griffle' / 'zonk'.
	absolute := base resolve: relative.
	self assert: absolute asString = 'memory:/plonk/griffle/zonk'
%
run
FSReferenceTest setStamp: 'cwp 10/10/2009 17:55' forMethod: #'testParentResolutionWithPath'.
true
%

category: 'tests'
method: FSReferenceTest
testParentResolutionWithReference
	| base relative absolute |
	base := (filesystem referenceTo: '/plonk/pinto').
	relative := (filesystem referenceTo: '../griffle/zonk').
	absolute := base resolve: relative.
	self assert: absolute asString = 'memory:/plonk/griffle/zonk'
%
run
FSReferenceTest setStamp: 'cwp 7/20/2009 09:31' forMethod: #'testParentResolutionWithReference'.
true
%

category: 'tests'
method: FSReferenceTest
testParentResolutionWithRemoteReference
	| base relative absolute |
	base := (filesystem referenceTo: '/plonk/pinto').
	relative := (FSMemoryFilesystem new referenceTo: '../griffle/zonk').
	absolute := base resolve: relative.
	self assert: absolute asString = 'memory:/plonk/griffle/zonk'
%
run
FSReferenceTest setStamp: 'cwp 10/11/2009 16:59' forMethod: #'testParentResolutionWithRemoteReference'.
true
%

category: 'tests'
method: FSReferenceTest
testReadStream
	| ref stream path |
	path := FSPath * 'plonk'.
	filesystem createFile: path.
	ref := filesystem referenceTo: path.
	[stream := ref readStream.
	self assert: (stream class = FSReadStream)]
		ensure: [stream ifNotNil: [stream close]]
%
run
FSReferenceTest setStamp: 'cwp 10/29/2009 09:45' forMethod: #'testReadStream'.
true
%

category: 'tests'
method: FSReferenceTest
testReadStreamDo
	| ref path s |
	path := FSPath * 'plonk'.
	filesystem createFile: path.
	ref := filesystem referenceTo: path.
	ref readStreamDo: 
		[:stream | 
		self assert: stream class = FSReadStream.
		self assert: stream isOpen.
		s := stream].
	self deny: s isOpen
		
%
run
FSReferenceTest setStamp: 'cwp 10/29/2009 09:46' forMethod: #'testReadStreamDo'.
true
%

category: 'tests'
method: FSReferenceTest
testReadStreamDoifAbsent
	| ref path s |
	path := FSPath * 'plonk'.
	filesystem createFile: path.
	ref := filesystem referenceTo: path.
	ref 
		readStreamDo: 
			[:stream | 
			self assert: stream class = FSReadStream.
			self assert: stream isOpen.
			s := stream]
		ifAbsent: [self signalFailure: 'The file exists!'].
	self deny: s isOpen
		
%
run
FSReferenceTest setStamp: 'cwp 10/29/2009 09:49' forMethod: #'testReadStreamDoifAbsent'.
true
%

category: 'tests'
method: FSReferenceTest
testReadStreamDoifAbsentNot
	| ref pass |
	pass := false.
	ref := filesystem referenceTo: 'plonk'.
	ref 
		readStreamDo: [:stream | ]
		ifAbsent: [pass := true].
	self assert: pass
%
run
FSReferenceTest setStamp: 'DaleHenrichs 10/13/2010 13:24' forMethod: #'testReadStreamDoifAbsentNot'.
true
%

category: 'tests'
method: FSReferenceTest
testReadStreamDoNotFound
	| ref path |
	path := FSPath * 'plonk'.
	ref := filesystem referenceTo: path.
	self
		should: [ref readStreamDo: [:s | ]]
		raise: FSFileDoesNotExist
%
run
FSReferenceTest setStamp: 'DaleHenrichs 10/13/2010 13:25' forMethod: #'testReadStreamDoNotFound'.
true
%

category: 'tests'
method: FSReferenceTest
testReadStreamIfAbsent
	| ref stream path |
	path := FSPath * 'plonk'.
	filesystem createFile: path.
	ref := filesystem referenceTo: path.
	[stream := ref readStreamIfAbsent: [self signalFailure: 'Should not reach here.'].
	self assert: (stream class = FSReadStream)]
		ensure: [stream ifNotNil: [stream close]]
%
run
FSReferenceTest setStamp: 'cwp 10/29/2009 11:11' forMethod: #'testReadStreamIfAbsent'.
true
%

category: 'tests'
method: FSReferenceTest
testReadStreamNotFound
	| ref path |
	path := FSPath * 'plonk'.
	ref := filesystem referenceTo: path.
	self
		should: [ref readStream]
		raise: FSFileDoesNotExist
%
run
FSReferenceTest setStamp: 'cwp 11/14/2009 23:36' forMethod: #'testReadStreamNotFound'.
true
%

category: 'tests'
method: FSReferenceTest
testRelativeToReference
	| parent child relative |
	parent := filesystem referenceTo: (FSPath / 'griffle').
	child := filesystem referenceTo: (FSPath / 'griffle' / 'plonk' / 'nurb').
	relative := child relativeTo: parent.
	self assert: relative = (FSPath * 'plonk' / 'nurb')
%
run
FSReferenceTest setStamp: 'cwp 11/15/2009 00:25' forMethod: #'testRelativeToReference'.
true
%

category: 'tests'
method: FSReferenceTest
testResolve
	| ref |
	ref := filesystem referenceTo: FSPath / 'griffle'.
	self assert: ref resolve == ref
%
run
FSReferenceTest setStamp: 'cwp 11/16/2009 10:17' forMethod: #'testResolve'.
true
%

category: 'tests'
method: FSReferenceTest
testRootParent
	| root |
	root := filesystem referenceTo: FSPath root.
	self assert: root parent == root
%
run
FSReferenceTest setStamp: 'cwp 7/20/2009 09:34' forMethod: #'testRootParent'.
true
%

category: 'tests'
method: FSReferenceTest
testSiblingOfReference
	| griffle  nurb |
	griffle := filesystem referenceTo: '/griffle'.
	nurb := filesystem referenceTo: '/nurb'.
	self deny: (griffle isChildOf: nurb).
	self deny: (nurb isChildOf: griffle).
%
run
FSReferenceTest setStamp: 'cwp 11/16/2009 09:32' forMethod: #'testSiblingOfReference'.
true
%

category: 'tests'
method: FSReferenceTest
testSimpleResolution
	| base relative absolute |
	base := filesystem referenceTo: FSPath / 'plonk'.
	relative := (FSPath with: 'griffle') / 'zonk'.
	absolute := base resolve: relative.
	self assert: absolute asString = 'memory:/plonk/griffle/zonk'
%
run
FSReferenceTest setStamp: 'cwp 10/10/2009 18:06' forMethod: #'testSimpleResolution'.
true
%

category: 'tests'
method: FSReferenceTest
testSlash
	| ref result |
	ref := filesystem referenceTo: 'plonk'.
	result := ref / 'griffle'.
	self assert: result class = FSReference.
	self assert: result asString = 'memory:plonk/griffle'
%
run
FSReferenceTest setStamp: 'cwp 7/20/2009 09:36' forMethod: #'testSlash'.
true
%

category: 'tests'
method: FSReferenceTest
testUnequalContent
	| a b |
	a := filesystem referenceTo: 'plonk'.
	b := filesystem referenceTo: 'griffle'.
	self deny: a = b.
%
run
FSReferenceTest setStamp: 'cwp 7/20/2009 09:37' forMethod: #'testUnequalContent'.
true
%

category: 'tests'
method: FSReferenceTest
testUnequalSize
	| a b |
	a := filesystem referenceTo: 'plonk'.
	b := filesystem referenceTo: 'plonk/griffle'.
	self deny: a = b.
%
run
FSReferenceTest setStamp: 'cwp 7/20/2009 09:56' forMethod: #'testUnequalSize'.
true
%

category: 'tests'
method: FSReferenceTest
testWithExtentionAddsExtension
	| ref result |
	ref := filesystem referenceTo: 'plonk'.
	result := ref withExtension: 'griffle'.
	self assert: result asString = 'memory:plonk.griffle'
%
run
FSReferenceTest setStamp: 'cwp 11/17/2009 23:26' forMethod: #'testWithExtentionAddsExtension'.
true
%

category: 'tests'
method: FSReferenceTest
testWithExtentionReplacesExtension
	| ref result |
	ref := filesystem referenceTo: 'plonk.griffle'.
	result := ref withExtension: 'nurp'.
	self assert: result asString = 'memory:plonk.nurp'
%
run
FSReferenceTest setStamp: 'cwp 11/17/2009 23:55' forMethod: #'testWithExtentionReplacesExtension'.
true
%

category: 'tests'
method: FSReferenceTest
testWorkingDirectoryParent
	| wd |
	wd := filesystem referenceTo: FSPath new.
	self assert: wd parent path size = 1.
	self assert: (wd parent path at: 1) = '..'.
%
run
FSReferenceTest setStamp: 'cwp 10/25/2009 19:56' forMethod: #'testWorkingDirectoryParent'.
true
%

category: 'tests'
method: FSReferenceTest
testWriteStream
	| ref stream |
	ref := filesystem referenceTo: 'plonk'.
	[stream := ref writeStream.
	self assert: (stream class = FSWriteStream)]
		ensure: [stream ifNotNil: [stream close]]
%
run
FSReferenceTest setStamp: 'cwp 10/29/2009 09:41' forMethod: #'testWriteStream'.
true
%

category: 'tests'
method: FSReferenceTest
testWriteStreamDo
	| ref s |
	ref := filesystem referenceTo: 'plonk'.
	ref writeStreamDo:
		[:stream |
		s := stream.
		self assert: stream class = FSWriteStream.
		self assert: stream isOpen].
	self deny: s isOpen
		
%
run
FSReferenceTest setStamp: 'cwp 10/29/2009 09:53' forMethod: #'testWriteStreamDo'.
true
%

category: 'tests'
method: FSReferenceTest
testWriteStreamDoExists
	| ref s path |
	path := FSPath * 'plonk'.
	filesystem createFile: path.
	ref := filesystem referenceTo: path.
	ref writeStreamDo:
		[:stream |
		s := stream.
		self assert: stream class = FSWriteStream.
		self assert: stream isOpen].
	self deny: s isOpen
		
%
run
FSReferenceTest setStamp: 'cwp 10/29/2009 11:03' forMethod: #'testWriteStreamDoExists'.
true
%

category: 'tests'
method: FSReferenceTest
testWriteStreamDoifPresent
	| ref s |
	ref := filesystem referenceTo: 'plonk'.
	ref 
		writeStreamDo:
			[:stream |
			s := stream.
			self assert: stream class = FSWriteStream.
			self assert: stream isOpen]
		ifPresent: [self signalFailure: 'The file does not exist!'].
	self deny: s isOpen
		
%
run
FSReferenceTest setStamp: 'cwp 10/29/2009 09:54' forMethod: #'testWriteStreamDoifPresent'.
true
%

category: 'tests'
method: FSReferenceTest
testWriteStreamDoifPresentNot
	| ref pass path |
	pass := false.
	path := FSPath * 'plonk'.
	filesystem createFile: path.
	ref := filesystem referenceTo: path.
	ref 
		writeStreamDo: [:stream | ]
		ifPresent: [pass := true].
	self assert: pass
%
run
FSReferenceTest setStamp: 'DaleHenrichs 10/13/2010 13:26' forMethod: #'testWriteStreamDoifPresentNot'.
true
%

category: 'tests'
method: FSReferenceTest
testWriteStreamExists
	| ref stream path |
	path := FSPath * 'plonk'.
	filesystem createFile: path.
	ref := filesystem referenceTo: path.
	[stream := ref writeStream.
	self assert: (stream class = FSWriteStream)]
		ensure: [stream ifNotNil: [stream close]]
%
run
FSReferenceTest setStamp: 'cwp 10/29/2009 11:02' forMethod: #'testWriteStreamExists'.
true
%

category: 'tests'
method: FSReferenceTest
testWriteStreamifPresent
	| ref stream |
	ref := filesystem referenceTo: 'plonk'.
	[stream := ref writeStreamIfPresent: [self signalFailure: 'Should not reach here'].
	self assert: (stream class = FSWriteStream)]
		ensure: [stream ifNotNil: [stream close]]
%
run
FSReferenceTest setStamp: 'cwp 10/29/2009 11:05' forMethod: #'testWriteStreamifPresent'.
true
%

category: 'tests'
method: FSReferenceTest
testWriteStreamifPresentExists
	| ref pass path |
	pass := false.
	path := FSPath * 'plonk'.
	filesystem createFile: path.
	ref := filesystem referenceTo: path.
	ref writeStreamIfPresent: [pass := true].
	self assert: pass
%
run
FSReferenceTest setStamp: 'cwp 10/29/2009 11:08' forMethod: #'testWriteStreamifPresentExists'.
true
%

category: 'running'
method: FSInteractiveResolverTest
createResolver
	^ FSInteractiveResolver new
%
run
FSInteractiveResolverTest setStamp: 'cwp 10/27/2009 11:09' forMethod: #'createResolver'.
true
%

category: 'accessing'
method: FSInteractiveResolverTest
home
	^ FSDiskFilesystem testDirectory
%
run
FSInteractiveResolverTest setStamp: 'DaleHenrichs 10/18/2010 10:17' forMethod: #'home'.
true
%

category: 'tests'
method: FSInteractiveResolverTest
testCached
	[resolver resolve: #home]
		on: FSResolutionRequest
		do: [:req | req resume: self home].
	self
		shouldnt: [self assertOriginResolves: #home]
		raise: FSResolutionRequest
%
run
FSInteractiveResolverTest setStamp: 'cwp 10/27/2009 11:16' forMethod: #'testCached'.
true
%

category: 'tests'
method: FSInteractiveResolverTest
testNew
	[self assertOriginResolves: #home]
		on: FSResolutionRequest
		do: [:req | req resume: self home].
	
%
run
FSInteractiveResolverTest setStamp: 'cwp 10/27/2009 11:15' forMethod: #'testNew'.
true
%

category: 'running'
method: FSPlatformResolverTest
createResolver
	^ FSPlatformResolver forCurrentPlatform
%
run
FSPlatformResolverTest setStamp: 'cwp 10/27/2009 10:57' forMethod: #'createResolver'.
true
%

category: 'tests'
method: FSPlatformResolverTest
testDesktop
	true ifTrue: [ ^self ]. "see Bug42200"
	self assertOriginResolves: #desktop
%
run
FSPlatformResolverTest setStamp: 'cwp 10/27/2009 11:04' forMethod: #'testDesktop'.
true
%

category: 'tests'
method: FSPlatformResolverTest
testDocuments
	true ifTrue: [ ^self ]. "see Bug42200"
	self assertOriginResolves: #documents
%
run
FSPlatformResolverTest setStamp: 'cwp 10/27/2009 21:49' forMethod: #'testDocuments'.
true
%

category: 'tests'
method: FSPlatformResolverTest
testHome
	self assertOriginResolves: #home
%
run
FSPlatformResolverTest setStamp: 'cwp 10/27/2009 10:57' forMethod: #'testHome'.
true
%

category: 'testing'
classmethod: FSResolverTest
isAbstract
	^ self name = #FSResolverTest
%
run
FSResolverTest class setStamp: 'cwp 10/26/2009 21:28' forMethod: #'isAbstract'.
true
%

category: 'asserting'
method: FSResolverTest
assertOriginResolves: aSymbol
	| reference |
	reference := resolver resolve: aSymbol.
	self assert: (reference isKindOf: FSReference).
	self assert: reference isAbsolute.
	self assert: reference exists
%
run
FSResolverTest setStamp: 'cwp 10/26/2009 21:22' forMethod: #'assertOriginResolves:'.
true
%

category: 'running'
method: FSResolverTest
createResolver
	self subclassResponsibility
%
run
FSResolverTest setStamp: 'cwp 10/27/2009 11:12' forMethod: #'createResolver'.
true
%

category: 'running'
method: FSResolverTest
setUp
	resolver := self createResolver.
%
run
FSResolverTest setStamp: 'cwp 10/26/2009 21:25' forMethod: #'setUp'.
true
%

category: 'running'
method: FSTestResolverTest
createResolver
	^ FSTestResolver new
%
run
FSTestResolverTest setStamp: 'DaleHenrichs 10/18/2010 11:16' forMethod: #'createResolver'.
true
%

category: 'testing'
method: FSTestResolverTest
testTestDirectory
	self assertOriginResolves: #testDirectory
%
run
FSTestResolverTest setStamp: 'DaleHenrichs 10/18/2010 11:16' forMethod: #'testTestDirectory'.
true
%

category: 'testing'
method: FSTestResolverTest
testTestFile
	self assertOriginResolves: #testFile
%
run
FSTestResolverTest setStamp: 'DaleHenrichs 10/18/2010 11:16' forMethod: #'testTestFile'.
true
%

category: 'running'
method: FSCopyVisitorTest
createDirectory: aString 
	source createDirectory: (source pathFromString: aString)
%
run
FSCopyVisitorTest setStamp: 'cwp 11/21/2009 11:30' forMethod: #'createDirectory:'.
true
%

category: 'running'
method: FSCopyVisitorTest
createFile: aString 
	source createFile: (source pathFromString: aString)
%
run
FSCopyVisitorTest setStamp: 'cwp 11/21/2009 11:30' forMethod: #'createFile:'.
true
%

category: 'running'
method: FSCopyVisitorTest
setUp
	source := FSMemoryFilesystem new.
	dest := FSMemoryFilesystem new.
	
	
%
run
FSCopyVisitorTest setStamp: 'cwp 11/15/2009 00:32' forMethod: #'setUp'.
true
%

category: 'tests'
method: FSCopyVisitorTest
testAll
	self setUpGreek.
	FSCopyVisitor 
		copy: (source referenceTo: '/alpha') 
		to: (dest referenceTo: '/alpha').
	self assert: (dest isDirectory: '/alpha').
	self assert: (dest isFile: '/alpha/beta/gamma').
%
run
FSCopyVisitorTest setStamp: 'cwp 11/15/2009 00:33' forMethod: #'testAll'.
true
%

category: 'asserting'
method: FSCollectVisitorTest
assertEntries: references are: expected
	| strings |
	self assert: references isArray.
	references do: [ :ea | self assert: ea class = FSDirectoryEntry ].
	strings := references collect: [ :ea | ea reference pathString ].
	self assert: strings = expected
%
run
FSCollectVisitorTest setStamp: 'cwp 11/16/2009 10:56' forMethod: #'assertEntries:are:'.
true
%

category: 'accessing'
method: FSCollectVisitorTest
root
	^ filesystem referenceTo: '/alpha'
%
run
FSCollectVisitorTest setStamp: 'cwp 11/15/2009 07:47' forMethod: #'root'.
true
%

category: 'running'
method: FSCollectVisitorTest
setUp
	super setUp.
	self setUpGreek.
%
run
FSCollectVisitorTest setStamp: 'cwp 11/15/2009 08:04' forMethod: #'setUp'.
true
%

category: 'tests'
method: FSCollectVisitorTest
testBreadthFirst
	| entries |
	entries := FSCollectVisitor breadthFirst: self root.
	self 
		assertEntries: entries
		are: #(
				'/alpha'
				'/alpha/beta'
				'/alpha/epsilon'
				'/alpha/beta/delta'
				'/alpha/beta/gamma'
				'/alpha/epsilon/zeta'
			)
%
run
FSCollectVisitorTest setStamp: 'cwp 11/16/2009 10:56' forMethod: #'testBreadthFirst'.
true
%

category: 'tests'
method: FSCollectVisitorTest
testPostorder
	| entries |
	entries := FSCollectVisitor postorder: self root.
	self 
		assertEntries: entries
		are: #(
				'/alpha/beta/delta'
				'/alpha/beta/gamma'
				'/alpha/beta'
				'/alpha/epsilon/zeta'
				'/alpha/epsilon'
				'/alpha'
			)
%
run
FSCollectVisitorTest setStamp: 'cwp 11/16/2009 10:56' forMethod: #'testPostorder'.
true
%

category: 'tests'
method: FSCollectVisitorTest
testPreorder
	| entries |
	entries := FSCollectVisitor preorder: self root.
	self 
		assertEntries: entries
		are: #(
				'/alpha'
				'/alpha/beta'
				'/alpha/beta/delta'
				'/alpha/beta/gamma'
				'/alpha/epsilon'
				'/alpha/epsilon/zeta'
			)
%
run
FSCollectVisitorTest setStamp: 'cwp 11/16/2009 10:57' forMethod: #'testPreorder'.
true
%

category: 'tests'
method: FSDeleteVisitorTest
testBeta
	self setUpGreek.
	FSDeleteVisitor delete: (filesystem referenceTo: '/alpha/beta').
	self assert: (filesystem isDirectory: '/alpha').
	self assert: (filesystem isDirectory: '/alpha/epsilon').
	self deny: (filesystem exists: '/alpha/beta').
	
%
run
FSDeleteVisitorTest setStamp: 'cwp 11/15/2009 00:48' forMethod: #'testBeta'.
true
%

category: 'tests'
method: FSBreadthFirstGuideTest
testAll
	guide := FSBreadthFirstGuide for: self.
	guide show: (filesystem referenceTo: '/alpha').
	self assertVisitedIs: #(
			'alpha'
			'beta'
			'epsilon'
			'delta'
			'gamma'
			'zeta'
		)
%
run
FSBreadthFirstGuideTest setStamp: 'cwp 10/29/2009 23:39' forMethod: #'testAll'.
true
%

category: 'testing'
classmethod: FSGuideTest
isAbstract
	^ self name = #FSGuideTest
%
run
FSGuideTest class setStamp: 'cwp 10/29/2009 23:08' forMethod: #'isAbstract'.
true
%

category: 'asserting'
method: FSGuideTest
assertVisitedIs: anArray
	visited with: anArray do:
		[:entry :basename | 
		self assert: entry reference basename = basename]
%
run
FSGuideTest setStamp: 'cwp 11/16/2009 10:46' forMethod: #'assertVisitedIs:'.
true
%

category: 'running'
method: FSGuideTest
setUp
	visited := OrderedCollection new.
	filesystem := FSMemoryFilesystem new.
	self setUpGreek
%
run
FSGuideTest setStamp: 'cwp 10/30/2009 13:30' forMethod: #'setUp'.
true
%

category: 'visitor'
method: FSGuideTest
visitDirectory: aReference
	visited add: aReference.
%
run
FSGuideTest setStamp: 'cwp 10/29/2009 21:54' forMethod: #'visitDirectory:'.
true
%

category: 'visitor'
method: FSGuideTest
visitFile: aReference
	visited add: aReference.
%
run
FSGuideTest setStamp: 'cwp 10/29/2009 21:54' forMethod: #'visitFile:'.
true
%

category: 'tests'
method: FSPostorderGuideTest
testAll
	guide := FSPostorderGuide for: self.
	guide show: (filesystem referenceTo: '/alpha').
	self assertVisitedIs: #(
			'delta'
			'gamma'
			'beta'
			'zeta'
			'epsilon'
			'alpha'
		)
%
run
FSPostorderGuideTest setStamp: 'cwp 10/29/2009 23:34' forMethod: #'testAll'.
true
%

category: 'tests'
method: FSPreorderGuideTest
testAll
	guide := FSPreorderGuide for: self.
	guide show: (filesystem referenceTo: '/alpha').
	self assertVisitedIs: #(
			'alpha'
			'beta'
			'delta'
			'gamma'
			'epsilon'
			'zeta'
		)
%
run
FSPreorderGuideTest setStamp: 'cwp 10/29/2009 23:34' forMethod: #'testAll'.
true
%

category: 'testing'
classmethod: FSSingleTreeTest
isAbstract
	^ self name = #FSSingleTreeTest
%
run
FSSingleTreeTest class setStamp: 'lr 7/13/2010 13:48' forMethod: #'isAbstract'.
true
%

category: 'running'
method: FSSingleTreeTest
createDirectory: aString 
	filesystem createDirectory: (filesystem pathFromString: aString)
%
run
FSSingleTreeTest setStamp: 'cwp 11/21/2009 11:30' forMethod: #'createDirectory:'.
true
%

category: 'running'
method: FSSingleTreeTest
createFile: aString 
	filesystem createFile: (filesystem pathFromString: aString)
%
run
FSSingleTreeTest setStamp: 'cwp 11/21/2009 11:30' forMethod: #'createFile:'.
true
%

category: 'running'
method: FSSingleTreeTest
setUp
	super setUp.
	filesystem := FSMemoryFilesystem new.
	
%
run
FSSingleTreeTest setStamp: 'cwp 11/15/2009 07:42' forMethod: #'setUp'.
true
%

category: 'testing'
classmethod: FSTreeTest
isAbstract
	^ self name = #FSTreeTest
%
run
FSTreeTest class setStamp: 'cwp 10/30/2009 13:39' forMethod: #'isAbstract'.
true
%

category: 'running'
method: FSTreeTest
createDirectory: aString
	self subclassResponsibility
%
run
FSTreeTest setStamp: 'lr 7/13/2010 15:26' forMethod: #'createDirectory:'.
true
%

category: 'running'
method: FSTreeTest
createFile: aString
	self subclassResponsibility
%
run
FSTreeTest setStamp: 'lr 7/13/2010 15:26' forMethod: #'createFile:'.
true
%

category: 'running'
method: FSTreeTest
setUpGreek
	self 
		createDirectory: '/alpha';
		createDirectory: '/alpha/beta';
		createFile: '/alpha/beta/gamma';
		createFile: '/alpha/beta/delta';
		createDirectory: '/alpha/epsilon';
		createFile: '/alpha/epsilon/zeta'
%
run
FSTreeTest setStamp: 'cwp 10/30/2009 13:32' forMethod: #'setUpGreek'.
true
%

category: 'accessing'
method: FSWriteStreamTest
contents
	^ filesystem 
		nodeAt: FSPath / 'giffle'
		ifPresent: [:bytes | bytes]
		ifAbsent: [self signalFailure: 'No file!']
%
run
FSWriteStreamTest setStamp: 'cwp 11/15/2009 21:33' forMethod: #'contents'.
true
%

category: 'running'
method: FSWriteStreamTest
setUp
	filesystem := FSMemoryFilesystem new.
	stream := filesystem writeStreamOn: 'giffle'
%
run
FSWriteStreamTest setStamp: 'cwp 7/29/2009 21:57' forMethod: #'setUp'.
true
%

category: 'tests'
method: FSWriteStreamTest
testClose
	self
		shouldnt: [stream close]
		raise: Error
%
run
FSWriteStreamTest setStamp: 'cwp 7/28/2009 22:48' forMethod: #'testClose'.
true
%

category: 'tests'
method: FSWriteStreamTest
testContents
	stream nextPutAll: #(42 43 44).
	self assert: stream contents = #(42 43 44) asByteArray
%
run
FSWriteStreamTest setStamp: 'cwp 7/29/2009 21:55' forMethod: #'testContents'.
true
%

category: 'tests'
method: FSWriteStreamTest
testCr
	stream cr.
	self assert: self contents first = 13
%
run
FSWriteStreamTest setStamp: 'cwp 7/29/2009 21:55' forMethod: #'testCr'.
true
%

category: 'tests'
method: FSWriteStreamTest
testFlush
	
	self
		shouldnt: [stream flush]
		raise: Error
%
run
FSWriteStreamTest setStamp: 'cwp 7/28/2009 22:21' forMethod: #'testFlush'.
true
%

category: 'tests'
method: FSWriteStreamTest
testNextPut
	stream nextPut: 42.
	self assert: self contents first = 42
%
run
FSWriteStreamTest setStamp: 'cwp 7/29/2009 21:55' forMethod: #'testNextPut'.
true
%

category: 'tests'
method: FSWriteStreamTest
testNextPutAll
	stream nextPutAll: #(42 43 44).
	stream flush.
	self assert: self contents = #(42 43 44) asByteArray
%
run
FSWriteStreamTest setStamp: 'cwp 7/29/2009 22:23' forMethod: #'testNextPutAll'.
true
%

category: 'tests'
method: FSWriteStreamTest
testSpace
	stream space.
	self assert: self contents first = 32
%
run
FSWriteStreamTest setStamp: 'cwp 7/29/2009 21:55' forMethod: #'testSpace'.
true
%

category: 'tests'
method: FSWriteStreamTest
testTab
	stream tab.
	self assert: self contents first = 9
%
run
FSWriteStreamTest setStamp: 'cwp 7/29/2009 21:56' forMethod: #'testTab'.
true
%

category: 'tests'
method: FSWriteStreamTest
testTruncate
	stream 
		nextPutAll: #(42 43 44 45 46);
		flush;
		position: 3;
		truncate.
	self assert: self contents = #(42 43 44) asByteArray
%
run
FSWriteStreamTest setStamp: 'DaleHenrichs 10/20/2010 16:33' forMethod: #'testTruncate'.
true
%

category: 'tests'
method: FSWriteStreamTest
testTruncateTo
	stream nextPutAll: #(42 43 44 45 46).
	stream flush.
	stream truncateTo: 3.
	self assert: self contents = #(42 43 44) asByteArray
%
run
FSWriteStreamTest setStamp: 'cwp 10/15/2009 21:50' forMethod: #'testTruncateTo'.
true
%
run
FSDiskFilesystem initialize.
true
%
run
FSWindowsFilesystem initialize.
true
%
run
FSFileHandle initialize.
true
%
