category: '*gsmonticello'
classmethod: DateAndTime
epoch
    "Answer a DateAndTime representing the Squeak epoch: 1 January 1901"

    ^DateAndTime year: 1901 day: 1 hour: 0 minute: 0 second: 0 offset: Duration zero
%

category: '*gsmonticello'
classmethod: DateAndTime
fromSeconds: seconds
  "Answer a DateAndTime since the Squeak epoch: 1 January 1901"

  ^self epoch + (Duration seconds: seconds)
%

category: '*gsmonticello'
method: DateAndTime
asDate
	^ Date newDay: self dayOfMonth monthNumber: self month year: self year
%

category: '*gsmonticello'
method: DateAndTime
asTime

  ^Time fromSeconds: (self - (self class year: self year month: self month day: self dayOfMonth hour: 0 minute: 0 second: 0)) asSeconds asInteger
%

