category: '*gsmonticello'
classmethod: Date
readFrom: aStream 
	"Read a Date from the stream in any of the forms:  
	
		<day> <monthName> <year>		(5 April 1982; 5-APR-82)  
	
		<monthName> <day> <year>		(April 5, 1982)  
	
		<monthNumber> <day> <year>		(4/5/82) 
			<day><monthName><year>			(5APR82)"

	| day month year |
	aStream peek isDigit
		ifTrue: [day := Integer fromStream: aStream].
	[aStream peek isAlphaNumeric]
		whileFalse: [aStream skip: 1].
	aStream peek isLetter
		ifTrue: ["number/name... or name..."
			month := WriteStream on: (String new).
			[aStream peek isLetter]
				whileTrue: [month nextPut: aStream next].
			month := month contents.
			day isNil
				ifTrue: ["name/number..."
					[aStream peek isAlphaNumeric]
						whileFalse: [aStream skip: 1].
					day := Integer fromStream: aStream]]
		ifFalse: ["number/number..."
			month := self nameOfMonth: day.
			day := Integer fromStream: aStream].
	month := self _getMonthFrom: month.
	[aStream peek isAlphaNumeric]
		whileFalse: [aStream skip: 1].
	year := Integer fromStream: aStream.
	(year < 100 and: [year >= 0]) 
		ifTrue: [
			year < 69 
				ifTrue: [	year := 2000 + year]
				ifFalse: [year := 1900 + year]].
	^ self
        newDay: day
        monthNumber: month
        year: year
%

category: '*gsmonticello'
classmethod: Date
fromSeconds: seconds
	"Answer an instance of me which is 'seconds' seconds after January 1, 1901."

	^ (DateAndTime fromSeconds: seconds) asDate
%

