category: '*gsmonticello'
method: Behavior
compile: methodSource classified: cat
   "Returns self or signals a CompileError"
    ^self 
        compileMethod: methodSource
        dictionaries: System myUserProfile symbolList
        category: cat
%

category: '*gsmonticello'
method: Behavior
compileSilently: methodSource classified: cat
    ^self
        _compileMethodTrappingErrors: methodSource
        dictionaries: System myUserProfile symbolList
        category: cat
        environmentId: 0
%

category: '*gsmonticello'
method: Behavior
compile: methodSource classified: cat withStamp: timeStamp notifying: ignored

    | result sel |
    result := self 
        compileMethod: methodSource
        dictionaries: System myUserProfile symbolList
        category: cat.
    result ~~ nil 
        ifTrue: [ | errorString |
			 errorString := GsNMethod _sourceWithErrors: result fromString: methodSource.
			^self error: errorString]. 
    
	sel := Behavior parseSelector: methodSource for: self.
	self setStamp: timeStamp forMethod: sel.
	^nil
%

category: '*gsmonticello'
classmethod: Behavior
parseSelector: methodString for: aBehavior
	| mDict cDict meth |
	mDict := GsMethodDictionary new.
	cDict := GsMethodDictionary new.
	meth := aBehavior
		_primitiveCompileMethod: methodString
		symbolList: GsSession currentSession symbolList
		category: #xxxyyz
		oldLitVars: nil 
		intoMethodDict: mDict 
		intoCategories: cDict 
		environmentId: 0 .
	meth class ~~ GsNMethod 
		ifTrue: [ 
			"if error slot is nil, then the method wasn't compiled because of errors"
			(meth at: 2) == nil ifFalse: [ ^nil ].
			meth := (meth at: 1).
		].
    ^meth selector asString.
%

category: '*gsmonticello'
method: Behavior
typeOfClass
    "Answer a symbol uniquely describing the type of the receiver"
    self isBytes ifTrue:[^ #bytes].
    (self isIndexable _and: [superClass isIndexable not]) ifTrue:[^#variable].
    ^#normal.
%


